#!/usr/bin/perl
# based on fl2.mpg
# http://bmrc.berkeley.edu/ftp/pub/multimedia/mpeg/mpeg2/conformance-bitstreams/audio/mpeg1/compliance/

use strict;
use integer;

my $n;
use Test::More tests => ($n = 49) * 8 + 3;
BEGIN { use_ok("MPEG::Audio::Frame") };

my $i;
for (1 .. $n){
	isa_ok(my $frame = MPEG::Audio::Frame->read(*DATA), "MPEG::Audio::Frame", "frame $_");
	ok($frame->mpeg1, "frame is MPEG1");
	ok($frame->layer1, "frame is layer I");
	ok($frame->has_crc, "frame has CRC");
	ok(!$frame->broken, "frame isn't broken");
	is($frame->bitrate, 384, "bitrate");
	is($frame->sample, 44100, "sample rate");
	ok($frame->any_stereo, "frame is some kind of stereo"); # intensity stereo is oppertunistic
	$i++ if $frame->joint_stereo;
}
is(MPEG::Audio::Frame->read(*DATA), undef, "nothing else in the file");
ok($i, "at least some frames were intensity/joint stereo");

__DATA__
tvݙwwfwUfUUDD33"      4㮺<q\}u8瞺~߿}{wv ~߿}{wv   ~ ~~|߿}{wv aX
}}~@}߄wvrܷC
||p(qߌ^gv`淳ぁz"Du]afh_APR9@ll2!BVg2$KW[?Ll2LL\^Yy<}ޯ_

||Q[6멦TʢY$d%drrÂ]!vf/x)nn>7c舆t}с H$~}{wv fUUUUDDDDDD33""             0	<$L,זZk^J1RWv[ox4QI$ic!c#gyT@<uauآ!
kavfQ}"EiLqia
RswtW$lgϲǞFۄ:cwv^`zD`DIeqs׽y$WUWrҩX}$Ha{ֹJ1s	fRZ_gcǦemakZ9΄wt\/_ݻeqĒ1s&hX:΁h]:Gm$ka9iFgvSDnѴ_aHV9svi^@x&@ackcvP DwfeC!     4Mo#n  )_hrd#FG H ]/9
$y
Q2e#~E+Y!c:.?#4i,Z5\41eSlc
Hyz*sjՀԺġ08/"&u,Y<x@[_kV:1<nsy4i_%>JQ_dnٺ42he;$o_zӹuVa
oߜ*hTؾq|֪ve4|FfQCI|I8=0+ɎG?q١;Bwc*>l]d%pJrK#>8UҒKmʐ T<dgfffeUTC"     }M<4mho%hȑ~"+EN2p7't^9x:u7Y,,RFs2G aaÚfͤ+Zj9Md״i?>~wWp"4h#mh_F=sMqBvFhm?vuL8N'u*O8jX[fF,?eY[޵b$ApfmdIJ>r|	B`iRСuH_gϠiJ^<hٳNF\q' MQΣl`
(V_+ygt] D .
\Eٶghϟ@l&'o dfwfVUUUUUDC"     0]=|܍>CAUg%|=XzJhD3<GJ-fqmD @c;M$<N-V:%@H]W.}2sYRv幥QJ	?\\eˊ,8䲾R220-HZ.>,UTq">ҶJ٢h-Bir֭ZM3xFؚ&i__cmL1͔~,KvͤdZ44Atf|p뎺Pp榡Bm,MI%)Fԝ'~"G<3@gaa`u(mEgzkKw֖.~4ӮogteHfUDUUUUUDDDD33!      0oﾉ?`e 
JiuמJ{9fwLaP9A﨣MCZҗUnF䭍[%q+y)}c9{Uɓz LE,99ь̪ٓ 	8Kpc`Ί)$vm1i	0dDȍnBm4%+]*%G~˄
T7{YaiЈř-ZS+OV.> ̲2INs[9,ͩRJC!yUX cwxk X@sӒ81[3]9TՆG8I}s[,=Vz7q5DrHBs[
'qU̙33DUUDDDD333"            QC]QH[r,"X$81svfiXaDa i8u{җ9""@Z(}	H~Hfs1fmU,zPPwZacU'|E}{'xV_}j&pswwxB&R{罚"eW]z_?71}sy!ŌwUi#X+k[m21"Uqz>ƱZykvh"nvYvss1UU*|ݭfJfIUE$R( fwv8Akc*.U DUhwfT2    SM0,|>c>~|5*ِ骨\I3&jzߍˤR&'da=dZɽzV~DpUHCu:Rj0Pܡ3P`@2E7l\(}Ǐ*Ryb!<bwx0[ Yó]żCɒQ:'{XzFxjai/r5;bRcfi=,ʽ]cfufiS}3zFgS(Q%8]Oȓv1Va	w;+y{iGqG/!xOWޫNEQX(TCwD#5gwfUC!     ]0~~O'9.\epHJQeIbbT<yc@ng}
uuf3vlێw?snOawhNNE4ƍ(QҾ1HɄni$͢D6\jhvõo,fdn	uur9KIo ^1nHKX_c1:}VH`Cklҫw`|h͗"TTܳB
yCRnCki}gff5F{ fo`<-ޭk59 pޡK]naf%
yyf|YҊUJ]pX턄at.ݡC,d?f-+ dJff̈"3DUfeT3!     }QC}tT}sQIjlрVׯX܉Ȉ&i2j	,W{vO}mLы~7ZׯaÚc?F־EsWa
2DcFdgǽ>YS6qn YM	4i@" F2̉XBf͛9L^5n{q}B{*
PB[͜H8E.2*HImPTT*K$CԄr#ޑhq! @r9gDUJAm~L)N[
mqs>tΨ[.4[6]`7 a?>lM tffw޻3"3DUUUT3!     ﾢ88ﾥJdYW%]v;CI#j"=/	x\!p"!Uw:bIeJzJJ"~.hF1E]l06l
G'I^ayhwJe'͡á{r0CWo{̒AFy?~ļ=b})mv[wsuUbǳ\N'8̴J$ )ݬټy6,
jɫ&*bu	eH.1z96 '/̪)K,QO=tlLٿ?4M:A!U9Js`@pqYf`dJ=3Lz29Uqێ4U Mfffw̻"3DDD33"           U0.`@t?Fo_UV*1metL&65
&nU[f9!hPxO٢!UUnek{Gv,W0%*TfgUUw:sR"Yrܹb	nns EUV9fn1,9:%/{g{U[BřEt\L؈>hUUIV{gygϩa0w|yUU%WsْVTڤ~3WWUYBRIdɅ	&k6nn0	M۟U[f{ԩ͙%nǯ`0	@I&j)ZUmݭɘD0W.{[` .nUUQRP Dϰt4VwwvS!    4Mﾐ$k`
Y---,>B?V#+Juwb/Dի]mep?Ro4\tΚ	}v	,&fl
D(
aLR+"B4DaMm~,0+b,E;Ib(-Z"z,\V(q+`JO?Xw7Dh
&FDd&t{5ȏϰ+^zrFHX	s,䗨hX8Dl|_MC2RJ1r#5MQV*8DY^{Y6|bρͲ>TYh725׌8HMe H@i6* TAaww"4UUT2     mMAﾄX,O)^4e*T?Ɩ-ykPI A}z\e[R/o5|(Pg#"H!rrjcS(sV
ن[jZYdYr9#!l(-jQa#kuff`b0!{'g]RBAlX,vGA@v[n2ool
nFc8\eXRl6LZ	<+qLQ1\6x\ShxFr'#a_\x$
r9,loG橷3;QtaFss V,#ח{ d{wwfw"#DD2     Q4 ݎȌEj\~d EeAw	XT8))JR&V2jƬrNRQW.K~~Nr@gՍ%ͤDBfX@p#r+|3*No6FI4[gu< UWO;Zc>HI Ob{@@Hpꪝ.^S)6gL1w||mXllZY-1f3/ڭZmmJaaXjŎ^9}66Ec>vFc/1=m4/m~VK&1vv@6NaxJb0jA63ϯ.!q
mtwwfݻ3 "331     4Ԓ矾76FHqϖKh {wUVU!GGQ(c1tg~WuUn%W7:G,˪`|wU^dkkW'sk5#'ЕX7uUnۛ&'I$bVK#]`wUᡔb_YtN;AGuZmZY	ij	@ p=7;#ZV-mmx\߇dQ^euUmȘKF p6I&1fUT^!{{_orV)H(UmںBAq8qqŠUPV~~::b1 0ylIA% UdwwxwUUw   """"          I#MqϾklr8hX4ӎ{3J7"K
99fZv,CO}X:UnX]ΗMR?>㎻*Z#m23cjDI$d[mE!8}}UTm%ggDD15:{M/#m퍒t:g3ffe*4fUdm&ս

^A ͶW^GG*";11aǫɶ  nIW79nqJE@D$6܊[-I))$WURn&0x<κX/x
r,tt\[w;n7  # =UVҒE DB4EUT!    34ۮm-װYE*p4%+6O2kzO:'DoÂp2_ڥPfZsWvNʹU\xgekX(p5DTÌ8wG|ۉQ*-"dq0>̥9g,Rm]ՂOՓ͠.d6Zgd yYd܅ &ʙRݛ@5
Bwrf)dLW`!zZjYrNA#HԌ/
;m['Y]${c}zU~g<qX΢%&TLV9-}cV.㲼g~Gz9Tڈfm2"#2    Y0Qyq=2]DP']Q\)%;LiӶ¼^(PaboS;YL2}ya,"\K2Eʇ
UyKvvey}!`&KRsJ[lcŝgZ[PIĸSY.~ڶ|JRKIh$ə1Ӈ`Bjm1X`X^Kɻy:n0Z>-klf1C'[nyHO~Ѷj6g>
A_d,]: чm,mᴪT)
7ʙNݷV]ȑJdlt+TԬ,b$+%V+%S(vɨfhl[FzO;7fٴ-_
b dwfDUQ     }I#oTTf!	`BL3QUVZYa0A_nRU'}UY	
Y}_V]r$IH\UZ!p-i\Wha ?K]WU{{GN'}uIcw($h̾eUVEr9%~E]WV_/,hE:IҁUYUҍ#H.^׷s$G(yG<bU]]W> vR$2ZZc-`@ @ZmQw;|>f&IR*1y\?Uywb؎cA9Ia}h3U\M
om4R(zLfΕU t
2wwxfDD"        ﾎ3M4<ooww||Tj5_9^qgE?-ϫDk9!JdH+Xl7[nVTՕ#H$2r]-۹rm闦O~{j[-g5ؾI[+(9!	<(!!ڭssrX{&{= b>V&%"#.7tNݺք?D<ȫhZ-\.+5c P&
7dU==YY7uL1C
S:L[ztW.Rkɯ1ÎYf`m&lKɓ9c9|՚J03I{4ːJQ.aeP :wwwwD3D̈                 0ƚwx.rg3('9{ێ_ccrrA⚚sY]l)XhfUWkڍHHG!)Q]``eekk}>gSrr{ꔠG)9J V憊e1{/U'bv(FfT
#||R<S1	wwC%IHxg=PllqqN!0<S)s#S
Yggbg2ȌTzzSS[-aװ-Ѧ
2q8Wۥ@+&1dc"URRee_ޯVIllsg~͙J%P Dˇhc!""!    04/ﾆpxֈh'D6
͌l`m1>o{ӔXv3CC?,	lmE"_`
#8˅E.oGl<,sCuV#a-o
eL?tOnC=/9nS ˢqi-An'CVǂ4O0a.Vh^١]Fq{<vmƹ>ikE-*h5}cicv-=O|l 3"4>۫uolNVq 5
km[` f]XB|)b~{9ĜALQx5Rûq̷ TD     mI/3x]z	Q0]Zֹ_aWꅡl{y͹=G^9QSv;Xqo!vq4=7({dYs~srnA;"k[m:{ ZJ'BL)V9=`v	YXAp$w[F^{ܱl4.XAuE|5:GMC]sk$JY-[l[K	`+:|_(X~fB_5Ƹߛ%k{;X<p6^3R\9D[/BiTlp!7-%)d {UYP_強!<?ũ&hmM d08U33^       4٦-˄Wk*
eX:}=؎6f`d8_/eXR8DTQwf$2iN%ےr{uvjܢNUUWql9r\8>J#wUtWoanvݷiځgpM-v% GwǕۭמw}]XoEцCL,EFv]C"E"]vj#Gar`r\@r6Yfw/ftFjx^乜U*mHeE{~3ih#dYbSwfExЖ}Ivɲ"K
u:)bKsykT*C!zJjbGfw3
PtfwwwfD""f̻       0ѝ߯5̛M{Vŋ(_))HfO\_YT
4IYӥe\\ju7ՋLZVׯo^׏ࠛ
;t^:R[cFI2INp9C$sVFJW	ѥe\zF{=h4"ńV߿W:H{ܜT/IzhYVVbbYl3geJsYұ+j⢞ޏIo7ӄT~Xb].^	?sV߿Wؽ!\__/RsTx7wwJ՟bb;Dڵk[V߿Ul6fwwwxwfU3"U               I#M}p䤦f);~mY'%QEޔvnô;_~8xxq|:ǎJYZfM;qS$fU=ǲ wv푑VUj:]11062k}FlA55.Yhhz[s716kk~~zzU*v
nmVn8eiI#RGuY!D(ur !"V+>|~rڄڍImUa4ы8554:Wûv*@ 1
Zƺϵ5'SS*YfZ pw D'ڻuD~!    ﾪM4ka7Gtwf{0XUs&}+%[*eKZkNL/ӳPD:Ks5UZ
AGad5}ryPi.U*qNG|w\=
GM'ꡑcY%XnQba){v	`D ҊN2dg[i~jIB
݄"yo`j14^̳%\#5*p5OBxvB	)bׂ	gfl#zt.7pĘ-*04Tռ%DT
VZwN!byEBf[St?a&d,3ųڛhٰIPT興u2;       0afbػ76(;'! W<Jڶ@=P=Qt"-gnH*zu؆"-rH>k
\VrLд=n[OzƊp4CK(:fa-K෕YV˶ob|<ʲ0	yCT)H[vt3[⁠^GocK]C$\4OTյmIRGYɥa0JRv桨Cx?1'U"L@T)-KR4lf9m+}ޏIx"幢hmx@`nqN˒uEQA/H dwwU3!@      8<M'(G#].!ĢOwQ*-0,{p;]&uAPaUkt+⢤r6B-r9	92!vJTf2r<}iXaݪQC!P,#q8c 93Wv(^:@LV+I8iss	>rrUh4"gܢmf6##
ZG{eq:MFr8S"g#ggS?}c2Q()XQLyu)zPd.@ufjV'wccشXz1vp25E"{tbvOݫݬ
 t0=wwwU3" |      0mmaŒjuyafJQ7}LI$=srIL}_h( p8k5T&K%QRUO^/^,HY :
e;:4*x;^o8((N^TW	[[~~HՎILF$,+%cX,V*v)L]s2J0~j{=.
w;ᅙ_*33cAuجHol3#P;yŠЇgsm~eRw13kh\\6`Qi[1}i4LUХ1-}thN*G;ffwwwwwwffU3   U            I#MyP8\\eerrv4fUZbY_~	Ӣ%\`뫜Yz~ߕ**ϦL8^=X**VVrqbayW|{o}Fuuxi$DUrq_~dR'"ba榣#ѣvYYkJ}'ߗ.TPǊ'uDuv4gϮU~ݣ},bbppttSS4hfUx .jD ``##cY8A^+y1ظ
	ih8663F2GuW~-ZrferqneV1@ DSd27Q     (0Î_mehuzC$e7an%$Rg =H|HsY3:`Yq{˽wh)N:5㡣=.-#HѴgtr3*sJ'0)}f3E|D㓗8u	#3.`E76>c?Gd!j	<
tL>w&ŒQ62Ls~/Ǹ_|-S>_ߛo9qc˖Xkb {Ƨ@hI<1ҴޒḀ~4MԤ:M?fb;&D9,m^ȵJ&3yPPά8޷ 5'xatn T}OwvB     0U[g3"]W+$%~(bד]x<)Eo$i cjiHn=u[Wa<hT$b"N(6M[wvy}H'wZGdV5oTg]qSTՈb%IRo7gĎwwP(:7p\j6p<HF45nPdv$YrҾTMVT)Vzt']אn9:iAp$xcZZ^/wۆK%^?ag/y^UiZQBI7V"-~Hc啵1gz d\wwwwfUB <     8Myy<
PL&/bb~^՟3ij&&K"q6yv;#XcFWʼW|gSdiϦQrIhll`p7
F/bqqsdfk*{kil6;
qq^!..""K%fezY8U%Ԇ~~u:-lǘLn47c	t!oU*u:aa]s]w<
FhA``)eu&&%'D"q8mΛMࠢYgReL啗n}xFY)[.SAc2.-˘m^$~yt>ffwwwwwwwgfU3"      qM<&4i6:JHxx(':ꬊC l8n88DD@@?E330trVZPT

彽ÌXڭ \@K.[S3,POͭ_yjWnl\||ffffA*Tq6ӱLa"D냄CE6gb!`Έ__afjY^F4ͫs+̱=zܸ͝i$IWb^Vy쬩	n`+j1x˳35577QQḺȑbU$~^]Ã6p@"<KDy脕WUfffffgffffD3"    3         }QCM6RfDl,2$9rɕ("i]*&6m2dٰte6Z
e=^Uի^Æd{z12JszK4i2eJ&OݫY:1UWQGwq.[G;6l|XB̹>{,/^㷆<r$G:e^3RibDr)R6
5k9qB[;8rI>}Qbn<y\vh/~(^b0XT;FD,Xv

ȐE˙R,Ux f\$Hzͭ۾}T;Ǐ*U,:tv<xšAwmU}:Y D~e2^    ﾢ8lgL}?kt
5>\%^Pbܷ.˲_fk+-h.e%/%|xs#SjmH"Y<@0tae@Lٶq<NDJ;v'Dµ[vz&#ܛJɷbɩ*y+b2cɲk+ruw2;_W66.eOzzv#!j&RѴl]F^FгUNt7yEm[AY+) p.]͙ZgdD,,l9N5.~ms.o>f}NSwf~B@/6ͺ&<1Jh0##qShKTwT" +    M3MmJwV~{4L4M\,,q,<ovT@`2b9Iv]wbHu[$QZ^sM'&td14M[Vy.'~ښ}?DRdimۘ&SAG&f/o4<qY-
g@]߃cyaj"bl6s:o9wEQ/R9<i"b]FStܬ+$z8CX2igvyr\_2d2!N(EI	dlBYȄ98
	}}`(	|7T)5$[\?'2*:'b1u-{ d]fwwwwwwwwwfT!      M406i4__rr.&4 j?<w秩ZZNMmm`ץ#[bZXSUUXHIrRc-Duue2%߿yn7G˅
iibbpp%EwN	wy)'xz
Lֺ9ࠕࠝxxhh'&L\̸2rrvvq!*"5mn
;pő"!--ttzڵOdɩWYjjJIh2IY]"ᡮW&WSsx$c[.CCll}}ii_/hhyqh t!fwwwwwwwwwfVD3   {   iMYfUUd#Zj*""$̪Ϥd[++hgST94eۛgaa^^ddj*P%i[`%⢘eП[`_QYaa]*y 
#%ٙ"#8iZΛbb` ]Z쬞חaDi,a%'' )i] :| ̫Ȅp! &ca3̫aX[##訨(!aWB;̪`ᡖVY`]6sZ̪-ٳWWbb^  #gaBJ̪ UfffffgffffU3"        "      0㢈p>pÇ2Ȑf^j-"/_"DhTR~6$eg|pݻO@9ڔ0fl*L7n̉ LfIN9ǈUz*t[vb;"C;%$&mѣ+ƍ%2j.Um)jzjTn˗2FelHi6p9rōСd)eVrX[eNׯ^=1c"D:k*THZ>ǯXaݵЛ{oiarR,r3fʔٴO=1p@8p 'O2cfǯbŗ.Dm`,8'  D3ÙvC" &   ﾚcMA<(8u]Y8oqaރ-+QFJfm۳9vl\:!bR|.g=^%[!52uгwLx9$=	;k,w9qIs0&S6*of4̇oC4˂SMLNxZ45-:\{24f^2c[MR5=t#гrnV✔tr6R[C`=Ϛ\Z֏E&*?\~mPMt*..&~ߔ[_ gfa]7Nh_IOZz
Y55	2̳żG TM~pخ<SKrO T8wwuC!  p  0YwwlerYւZ
)[z|3}ZpK,'_jbbfGaWӐ&i]5nCC	,5ágN%+(yu:xv+IemtHȰ^,PiG#ӅkYsO4j5zyҍF	y<vj7#XsBϩ	LQI:U*(FrbŢW.AՅfD:mlÛ,,h\Ba)Tq@08,t$*TNI$j5'{=jo;V%W=^hPf_4̩ dcfwwwwwwwfT2     04'^%Rd1yyzDo
W䤜U(D"
jjPPvg;j") 	mm"U.Wb[o7'xxlCtݗn榝j@ggxQU`Z4g3ll`Rꖭ\IOcc{{vRYӤ$q7+	\\~~dd"S2``Sߟ.*nnkkJJtU㣚\c{{nnkk
׳V(XRXet7ŉrrwwrW.3Xa!N')ttddWdPtUffwwwwwwffffU3"     4U\d'&VVIG.[D^aO^I8ϺtСG̊`)j..66:9hp>vY]W2dX11ꪯ/2R*OڱgRRpprrT.dHu؆p20`Ņ33$$MҤ,6<vL驫+%֭t*WNy%^
.Ohh2dM1	*$]˙YZxxHHϣE&DW""ձ"A6*TGǽzŌٮK,̊)Ň

4]:4Uw,NQqqBѣ3MpgUfffffgffffUD3"             8MvnDٳhTRdy,LP,IRKrCRձ<w۷F%m]v4gϧzD.oŊD%GmCRJt(x9uz͜8lǓf[ڤwĪ)ŐR$ @pGߥ[
umU_~jˢDt|3&Cst[:СA|ٳvљemeU׍7ϣFp7nﵳ2+E\ŋJˌXt2L.cF1U@(Z[mbT:~<x2$@vM)36X/+Рhӧ0aBpر锕e DֈT3!  \ 0QM*ggQڦmbxKM_qt:nfr1u͊<v1/4=X5&XRnu4cvja\1!(JecyD]׆-Q(gɂ$VΚk eYz=N+>)kQ_WHbA:+(fB׃c%$&n;*xjz]NrsO;ң#Wk6N&bW8j$Cpj5s9s+k0-}=~Ed'{=̳*ԵDՏ%`!+wJC>l	lԁFD׆@TĚwxuC!   
 0]{{p862Y6K$`sӬŌƇCI\mHawB\Icyc2	d 2RО9~[-xa"IvFrWmhhxZm,C~C)$vq //B$erC!}>
	ؕ[6q^]13&A 9yW+cP	W	n3!i'
_#EwwRSD"8&z'w>cvG@k9#с@/]+uX%c_bx6[(T+{b
ZA//{;@%RӶpٴyO 
