@rem = '--*-Perl-*--
@set "ErrorLevel="
@if "%OS%" == "Windows_NT" @goto WinNT
@perl -x -S "%0" %1 %2 %3 %4 %5 %6 %7 %8 %9
@set ErrorLevel=%ErrorLevel%
@goto endofperl
:WinNT
@perl -x -S %0 %*
@set ErrorLevel=%ErrorLevel%
@if NOT "%COMSPEC%" == "%SystemRoot%\system32\cmd.exe" @goto endofperl
@if %ErrorLevel% == 9009 @echo You do not have Perl in your PATH.
@goto endofperl
@rem ';
#!/usr/bin/perl
#line 16
use 5.008001;
use strict;
use warnings;

our $VERSION = '1.27';

use Pod::Spell;

# Try to get the encoding from the locale
my $encoding = eval {
    require POSIX;
    POSIX::setlocale(POSIX::LC_CTYPE(), '');
    require I18N::Langinfo;
    I18N::Langinfo::langinfo(I18N::Langinfo::CODESET())
};

if ($encoding) {
    binmode(STDOUT, ":encoding($encoding)");
}

if(@ARGV) {  # iterate over files, sending to STDOUT
    foreach my $x (@ARGV) {
        Pod::Spell->new->parse_from_file($x, '-');
    }
} else {     # take from STDIN, send to STDOUT
    Pod::Spell->new->parse_from_filehandle();
}

__END__

=pod

=encoding UTF-8

=for :stopwords Sean M. Burke Caleb Cushing Olivier Mengué

=head1 NAME

podspell - pod spell checking command line interface

=head1 VERSION

version 1.27

=head1 SYNOPSIS

    % podspell Thing.pm | ispell

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website
L<https://rt.cpan.org/Public/Dist/Display.html?Name=Pod-Spell> or by email
to L<bug-Pod-Spell@rt.cpan.org|mailto:bug-Pod-Spell@rt.cpan.org>.

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHORS

=over 4

=item *

Sean M. Burke <sburke@cpan.org>

=item *

Caleb Cushing <xenoterracide@gmail.com>

=back

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2024 by Olivier Mengué.

This is free software, licensed under:

  The Artistic License 2.0 (GPL Compatible)

=cut
__END__
:endofperl
@set "ErrorLevel=" & @goto _undefined_label_ 2>NUL || @"%COMSPEC%" /d/c @exit %ErrorLevel%
