#!/usr/bin/perl

use autobless;

sub ok {
  my ($num, $ok) = @_;
  $ok or print "not ";
  print STDOUT "ok $num\n";
  $ok or die("not ok $num\n");
} 

print STDOUT "1..4\n";

package ARRAY;
sub size { int @{$_[0]} }
::ok 1, [1 .. 10]->size == 10;

use overload '+' => sub { [map @$_, @_] };
::ok 2, ([1 .. 3] + [a .. c])->size == 6;

use overload '""' => sub { join '', @{$_[0]} }, fallback => 1;
::ok 3, [1 .. 9] eq '123456789';

package HASH;
use overload '+' => sub { +{map %$_, @_} };
my $hash0 = { 1 .. 4 };
my $hash1 = { 1 .. 8 };
::ok 4, [sort keys %{$hash0 + $hash1}] eq '1357';

exit 0;
