/*
 * lsof.h - common header file for lsof
 */


/*
 * Copyright 1994 Purdue Research Foundation, West Lafayette, Indiana
 * 47907.  All rights reserved.
 *
 * Written by Victor A. Abell
 *
 * This software is not subject to any license of the American Telephone
 * and Telegraph Company or the Regents of the University of California.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. Neither the authors nor Purdue University are responsible for any
 *    consequences of the use of this software.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Credit to the authors and Purdue
 *    University must appear in documentation and sources.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 * 4. This notice may not be removed or altered.
 */


#if	!defined(LSOF_H)
#define	LSOF_H	1

#include "machine.h"
#include "lsof_fields.h"

#include <ctype.h>
#include <errno.h>
#include <netdb.h>
#include <pwd.h>
#include <stdio.h>

#include <sys/stat.h>

#include "dlsof.h"

extern int errno;
extern char *optarg;
extern int optind;

#define	ACCESSERRFMT	"%s: WARNING: access %s: %s\n"
#define	CMDL		10		/* command character length */

# if	defined(HASDCACHE)
#define CRC_POLY	0120001 	/* CRC-16 polynomial */
#define	CRC_TBLL	256		/* crc table length for software */
#define	CRC_BITS	8		/* number of bits contributing */
# endif	/* defined(HASDCACHE) */

#define	CWD		" cwd"		/* current working directory fd name */
#define	FDLEN		8		/* fd printing array length */
#define IDINCR		10		/* PID/PGRP table malloc() increment */
#define IPROTOL		6		/* Internet protocol length */
#define LOGINML		9		/* login name length */
#define LPROCINCR	128		/* Lproc[] allocation increment */
#define	MAXDCPATH	4		/* paths in DCpath[] */
#define N_REGLR		0		/* node on regular file system */
#define N_BLK		1		/* node on block device */
#define	N_CACHE		2		/* node on cached file system */
#define	N_CDFS		3		/* node on CD-ROM */
#define	N_CHR		4		/* node on character device */
#define	N_COM		5		/* node on streams common device */
#define	N_DOOR		6		/* DOOR node */
#define N_FIFO		7		/* node on FIFO */
#define N_HSFS		8		/* node on High Sierra file system */
#define N_LOFS		9		/* node on loopback file system */
#define N_MPC		10		/* node on multiplexed device */
#define N_NFS		11		/* node on NFS file system */
#define N_NM		12		/* node on named file system */
#define N_PCFS		13		/* node on PC file system */
#define N_PIPE		14		/* node on pipe device */
#define	N_PROC		15		/* node on /proc */
#define	N_SPEC		16		/* node served by spec_vnodeops */
#define N_STREAM	17		/* node is stream */
#define N_TMP		18		/* node on tmpfs */
#define	N_UFS		19		/* node is Unix file system type */
#define	N_VXFS		20		/* node is Veritas file system type */
#define	RPTTM		15		/* default repeat seconds */
#define	RTD		" rtd"		/* root directory fd name */
#define TMLIMIT		15		/* readlink() & stat() timeout sec */
#define TMLIMMIN	2		/* minimum timeout */
#define	TYPEL		8		/* type character length */
#define UIDINCR		10		/* UID table malloc() increment */
#define USERPRTL	8		/* login/UID print length */


/*
 * Selection flags
 */

#define PS_PRI		1		/* primary process selection -- e.g.,
					 * by PID or UID */
#define PS_SEC		2		/* secondary process selection -- e.g.,
					 * by directory or file */
#define	SELCMD		0x001		/* select process by command name */
#define	SELFD		0x002		/* select file by descriptor name */
#define	SELNA		0x004		/* select socket by address (-i) */
#define	SELNET		0x008		/* select Internet socket files (-n) */
#define	SELNFS		0x010		/* select NFS files (-N) */
#define	SELNM		0x020		/* select by name */
#define	SELPGRP		0x040		/* select process group IDs (-g) */
#define	SELPID		0x080		/* select PIDs (-p) */
#define	SELUID		0x100		/* select UIDs (-u) */
#define	SELUNX		0x200		/* select Unix socket (-U) */
#define SELALL		(SELCMD|SELFD|SELNA|SELNET|SELNM|SELNFS|SELPID|SELUID|SELUNX)


/*
 * Global storage definitions (including their structure definitions)
 */

struct str_lst {
	char *str;			/* string */
	struct str_lst *next;		/* next list entry */
};
extern struct str_lst *Cmdl;

# if	defined(HASDCACHE)
extern unsigned DCcksum;
extern int DCfd;
extern FILE *DCfs;
extern char *DCpathArg;
extern char *DCpath[];
extern int DCpathX;
extern int DCstate;
# endif	/* defined(HASDCACHE) */

struct l_dev {
	dev_t rdev;			/* device */
	ino_t inode;			/* inode number */
	char *name;			/* name */

};
extern struct l_dev *Devtp;

extern int Fand;
extern int Fblock;
extern int Ffield;
extern int Fhelp;
extern int Fhost;

# if	defined(HASNCACHE)
extern int Fncache;
# endif	/* defined(HASNCACHE) */

extern int Fnet;
extern int Fnfs;
extern int Foffset;
extern int Fovhd;
extern int Fport;
extern int Fpgrp;
extern int Fsize;
extern int Fterse;
extern int Funix;
extern int Futol;
extern int Fwarn;

# if	defined(HASXOPT_VALUE)
extern int Fxopt;
# endif	/* defined(HASXOPT_VALUE) */

extern struct str_lst *Fdl;

struct fieldsel {
	char id;			/* field ID character */
	unsigned char n;		/* field ID index */
	char *nm;			/* field name */
};
extern struct fieldsel FieldSel[];

extern int Hdr;

enum IDType {PGRP, PID};

struct lfile {
	char access;
	char lock;
	unsigned char dev_def;		/* device number definition status */
	unsigned char inp_ty;		/* inode/iproto type
					 *	0: neither inode nor iproto
					 *	1: inode contains number
					 *	2: iproto contains string */
	unsigned char is_chr_dev;	/* character device status */
	unsigned char is_com;		/* common stream status */
	unsigned char is_nfs;		/* NFS file status */
	unsigned char is_stream;	/* stream device status */
	unsigned char off_def;		/* offset definition status */
	unsigned char sz_def;		/* size definition status */
	char fd[FDLEN];
	char iproto[IPROTOL];
	char type[TYPEL];
	short sf;			/* select flags -- SEL* symbols */
	int ch;				/* VMPC channel: -1 = none */
	int off;
	int sz;
	dev_t dev;
	unsigned long inode;
	char *dev_ch;
	char *fsdir;			/* file system directory */
	char *fsdev;			/* file system device */
	char *nm;
	char *nma;			/* NAME column addition */

# if	defined(HASNCACHE)
	unsigned long na;		/* name cache lookup node address */
#  if	defined(HASNCAPID)
	unsigned long id;		/* capability ID */
#  endif	/* defined(HASNCAPID) */
# endif	/* defined(HASNCACHE) */

# if	defined(HASLFILEADD)
	HASLFILEADD
# endif	/* defined(HASLFILEADD) */

	struct lfile *next;
};
extern struct lfile *Lf, *Plf;


struct lproc {
	char cmd[CMDL];
	short sf;			/* select flags -- SEL* symbols */
	short pss;			/* state: 0 = not selected
				 	 *	  1 = wholly selected
				 	 *	  2 = partially selected */
	int pid;
	int pgrp;			/* process group ID */
	uid_t uid;
	struct lfile *file;
};
extern struct lproc *Lp, *Lproc;

extern char *Memory;
extern struct mounts *Mtab;

# if	defined(HASPROCFS)
extern struct mounts *Mtprocfs;
# endif

extern int Mxpgrp;
extern int Mxpid;
extern int Mxuid;
extern gid_t Mygid;
extern int Mypid;
extern uid_t Myuid;
extern char *Namech;
extern int Ndev;

# if	defined(HASNLIST)
#  if	defined(NLIST_TYPE)
extern struct NLIST_TYPE Nl[];
#  else	/* !defined(NLIST_TYPE) */
extern struct nlist Nl[];
#  endif	/* defined(NLIST_TYPE) */
# endif

extern int Nlproc;
extern char *Nmlst;
extern int Npgrp;
extern int Npid;
extern int Npuns;
extern int Ntype;
extern int Nuid;

struct nwad {
	char *proto;				/* protocol */
	unsigned char a[4];			/* address */
	int port;
	struct nwad *next;			/* forward link */
};
extern struct nwad *Nwad;

extern char *Pn;

# if	defined(HASPROCFS)
struct procfsid {
	pid_t pid;			/* search PID */

#  if	defined(HASPINFO)
	unsigned char type;		/* type: 0 if one PID file in HASPROCFS
					 *       1 if one PID file in HASPINFO
					 *	 2 if all files in HASPINFO */
#  endif	/* defined(HASPINFO) */

#  if	defined(HASPINODEN)
	unsigned long inode;		/* search inode number */
#  endif	/* defined(HASPINODEN) */

	struct procfsid *next;		/* forward link */
};

extern struct procfsid *Procfsid;
extern int Procsrch;
# endif	/* defined(HASPROCFS) */

extern int RptTm;
extern struct l_dev **Sdev;
extern int Selall;
extern int Selflags;
extern int Setgid;
extern int Setuidroot;
extern struct sfile *Sfile;
extern int *Spgrp;
extern int *Spid;
extern uid_t *Suid;
extern char Terminator;
extern int TmLimit;

#include "proto.h"
#include "dproto.h"

#endif	/* LSOF_H */
