/*
 * dstore.c - SunOS (Solaris 1.x and 2.x) global storage for lsof
 */


/*
 * Copyright 1994 Purdue Research Foundation, West Lafayette, Indiana
 * 47907.  All rights reserved.
 *
 * Written by Victor A. Abell
 *
 * This software is not subject to any license of the American Telephone
 * and Telegraph Company or the Regents of the University of California.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. Neither the authors nor Purdue University are responsible for any
 *    consequences of the use of this software.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Credit to the authors and Purdue
 *    University must appear in documentation and sources.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 * 4. This notice may not be removed or altered.
 */

#ifndef lint
static char copyright[] =
"@(#) Copyright 1994 Purdue Research Foundation.\nAll rights reserved.\n";
static char *rcsid = "$Id: dstore.c,v 1.9 95/08/22 13:30:24 abe Exp $";
#endif


#include "lsof.h"


/*
 * Global storage definitions
 */

struct clone *Clone = NULL;		/* clone list */

#if	defined(solaris)
int CloneMaj;				/* clone major device number */
#endif	/* defined(solaris) */

#if	!defined(solaris)
char *Cwd = NULL;			/* cwd path name buffer */
#endif

#if	defined(solaris)
char **Fsinfo = NULL;			/* file system information */
int Fsinfomax = 0;			/* maximum file system type */
#endif

#if	defined(solaris)
int HaveCloneMaj = 0;			/* clone major device number has
					 * been identified and is in
					 * CloneMaj */
#endif	/* defined(solaris) */

kvm_t *Kd = NULL;			/* kvm descriptor */
struct l_vfs *Lvfs = NULL;		/* local vfs structure table */

# if	defined(solaris)
struct netclone *Netclone = NULL;	/* net clone devices from
					 * /devices/pseudo */
# endif

struct nlist Nl[] = {

# if	defined(solaris)
	{ "cachefs_vnodeops"	},
	{ "clonemaj"		},
	{ "fifo_vnodeops"	},
	{ "hsfs_vnodeops"	},
	{ "lo_vnodeops"		},
	{ "ncache"		},
	{ "ncsize"		},
	{ "nfs_vnodeops"	},
	{ "nm_vnodeops"		},
        { "nproc"		},
	{ "pcfs_dvnodeops"	},
	{ "pcfs_fvnodeops"	},
	{ "prvnodeops"		},
	{ "segvn_ops"		},
	{ "spec_vnodeops"	},
	{ "tmp_vnodeops"	},

# if	solaris>=20500
	{ "door_vnodeops"	},
	{ "_kernelbase"		},
# endif	/* solaris>=20500 */

# else	/* !defined(solaris) */
	{ "_fifo_vnodeops"	},
        { "_hsfs_vnodeops"	},
	{ "_ncache"		},
	{ "_ncsize"		},
        { "_nfs_vnodeops"	},
        { "_nproc"		},
	{ "_pcfs_dvnodeops"	},
	{ "_pcfs_fvnodeops"	},
	{ "_segvn_ops"		},
	{ "_spec_vnodeops"	},
	{ "_tmp_vnodeops"	},
# endif	/* defined(solaris) */

	{ "" }
};

#if	defined(solaris)
struct pseudo *Pseudo = NULL;		/* non-clone devices from
					 * /devices/pseudo */
#else
char *Rtd = NULL;			/* root directory path name buffer */
#endif
