/*
 * dsock.c - Novell UnixWare socket processing functions for lsof
 */


/*
 * Copyright 1994 Purdue Research Foundation, West Lafayette, Indiana
 * 47907.  All rights reserved.
 *
 * Written by Victor A. Abell
 *
 * This software is not subject to any license of the American Telephone
 * and Telegraph Company or the Regents of the University of California.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. Neither the authors nor Purdue University are responsible for any
 *    consequences of the use of this software.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Credit to the authors and Purdue
 *    University must appear in documentation and sources.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 * 4. This notice may not be removed or altered.
 */

#ifndef lint
static char copyright[] =
"@(#) Copyright 1994 Purdue Research Foundation.\nAll rights reserved.\n";
static char *rcsid = "$Id: dsock.c,v 1.3 95/01/04 08:24:22 abe Exp $";
#endif


#include "lsof.h"


/*
 * process_socket() - process socket
 */

void
process_socket(pr, q)
	char *pr;			/* protocol name */
	struct queue *q;		/* queue at end of stream */
{
	char dev_ch[32];
	struct inpcb inp;

        (void) strcpy(Lf->type, "inet");
	Lf->inp_ty = 2;
	Lf->is_stream = 0;
	(void) strcpy(Lf->iproto, pr);
	if (Fnet)
		Lf->sf |= SELNET;
/*
 * The PCB address is found in the private data structure at the end
 * of the queue.
 */
	if (q->q_ptr) {
		(void) sprintf(dev_ch, "0x%08x", q->q_ptr);
		enter_dev_ch(dev_ch);
		if (kread((KA_T)q->q_ptr, (char *)&inp, sizeof(inp))) {
			(void) sprintf(Namech,
				"can't read inpcb from %x", q->q_ptr);
			enter_nm(Namech);
			return;
		}
		printinaddr(&inp.inp_laddr, (int)ntohs(inp.inp_lport));
		if (inp.inp_faddr.s_addr != INADDR_ANY || inp.inp_fport != 0) {
			(void) strcat(endnm(), "->");
			printinaddr(&inp.inp_faddr, (int)ntohs(inp.inp_fport));
		}
	} else
		enter_nm("no address");
/*
 * Set size, based on access type.
 */
	if (Fsize) {
		Lf->sz = q->q_count;
		Lf->sz_def = 1;
	} else
		Lf->off_def = 1;
	enter_nm(Namech);
	return;
}
