/*
 * dsock.c - Motorola V/88 socket processing functions for lsof
 */


/*
 * Copyright 1994 Purdue Research Foundation, West Lafayette, Indiana
 * 47907.  All rights reserved.
 *
 * Written by Victor A. Abell
 *
 * This software is not subject to any license of the American Telephone
 * and Telegraph Company or the Regents of the University of California.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. Neither the authors nor Purdue University are responsible for any
 *    consequences of the use of this software.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Credit to the authors and Purdue
 *    University must appear in documentation and sources.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 * 4. This notice may not be removed or altered.
 */

#ifndef lint
static char copyright[] =
"@(#) Copyright 1994 Purdue Research Foundation.\nAll rights reserved.\n";
static char *rcsid = "$Id: dsock.c,v 1.5 95/09/19 10:50:54 abe Exp $";
#endif


#include "lsof.h"


#if	V88<40401
/*
 * process_socket() - process socket
 *
 * Handle sockets for V/88 versions below R40V42.
 */

void
process_socket(sa)
	caddr_t sa;			/* socket address in kernel */
{
	struct sockaddr_in ab;
	char dev_ch[32];
	struct inode i;
	int is;
	struct sck_proto p;
	struct sock s;
/*
 * Read the socket, then the protocol switch structure, then the
 * domain structure.
 */
	if (kread(sa, (char *)&s, sizeof(s))) {
		(void) sprintf(Namech, "can't read socket structure at %#x",
			sa);
		enter_nm(Namech);
		return;
	}
	if (s.proto == NULL
	||  kread((KA_T)s.proto, (char *)&p, sizeof(p))) {
		(void) sprintf(Namech,
			"can't read sck_proto (%#x) for socket %#x",
			sa, s.proto);
		enter_nm(Namech);
		return;
	}
/*
 * Process Internet domain socket.
 */
	if (Fnet)
		Lf->sf |= SELNET;
	(void) strcpy(Lf->type, "inet");
	printiproto((int)p.proto);
	Lf->inp_ty = 2;
	(void) sprintf(dev_ch, "0x%08x", s.inode);
	enter_dev_ch(dev_ch);
/*
 * Print Internet socket information.
 */
	if (p.proto == IPPROTO_TCP || p.proto == IPPROTO_UDP) {
		if (s.src.inet != NULL
		&&  kread((KA_T)s.src.inet, (char *)&ab, sizeof(ab)) == 0)
			printinaddr(&ab.sin_addr, (int)ntohs(ab.sin_port));
		if (s.dst.inet != NULL
		&&  kread((KA_T)s.dst.inet, (char *)&ab, sizeof(ab)) == 0) {
			if (ab.sin_addr.s_addr != INADDR_ANY
			||  ab.sin_port != 0) {
				(void) strcat(endnm(), "->");
				printinaddr(&ab.sin_addr,
					(int)ntohs(ab.sin_port));
			}
		}
	}
	if (Namech[0])
		enter_nm(Namech);
}
#endif	/* V88<40401 */


#if	V88>=40401
/*
 * process_socket() - process socket
 *
 * Handle sockets for V/88 versions R40V42 and above.
 */

void
process_socket(pr, q)
	char *pr;			/* protocol name */
	struct queue *q;		/* queue at end of stream */
{
	char dev_ch[32];

# if	V88<40403
	struct inpcb inp;
# else	/* V88>=40403 */
	struct in_addr *ap;
	struct ipc_s {			/* should come from <netinet/ip_mps.h>
					 * but #include'ing it causes conflicts
					 * that can't be resolved */

		struct ipc_s *d1[2];
		queue_t *d2[2];
		union {
			struct {
				unsigned short ipcu_udp_port;
				unsigned long ipcu_udp_addr;
			} ipcu_udp;
			unsigned short ipcu_tcp_addr[6];
		} ipc_ipcu;
#define ipc_udp_port    ipc_ipcu.ipcu_udp.ipcu_udp_port
#define ipc_udp_addr    ipc_ipcu.ipcu_udp.ipcu_udp_addr
#define ipc_tcp_addr    ipc_ipcu.ipcu_tcp_addr

	} ic;
	short p;
	int rq, sq;
	struct queue qs;
	u_short *s;
	struct tcphdr_s {		/* should come from <netinet/tcp_mps.h>
					 * but #include'ing it causes conflicts
					 * that can't be resolved */
		u_char th_lport[2];	/* local port */
	} th;
	struct tcp_s {			/* should come from <netinet/tcp_mps.h>
					 * but #include'ing it causes conflicts
					 * that can't be resolved */
		int d1;
		unsigned long d2[7];
		unsigned long tcp_snxt;	/* sender's next sequence number */
		unsigned long tcp_suna;	/* sender unacknowledged */
		unsigned long d3[6];
		int tcp_hdr_len;	/* TCP header length */
		struct tcphdr_s *tcp_tcph;
					/* TCP header pointer */
		int d4[3];
		unsigned long d5[5];
		int d6;
		unsigned long tcp_rnxt;	/* next receive sequence number */
		unsigned long d7[18];
		unsigned long tcp_rack;	/* acknowledged receive sequence */
	} tc;
	int tcs;
	struct ud_s {			/* should come from <netinet/udp_mps.h>
					 * but #include'ing it causes conflicts
					 * that can't be resolved */
		unsigned int d1;
		unsigned char d2[2];
		unsigned char udp_port[2];
					/* port number */
	} uc;
# endif	/* V88<40403 */

        (void) strcpy(Lf->type, "inet");
	Lf->inp_ty = 2;
	Lf->is_stream = 0;
	(void) strcpy(Lf->iproto, pr);
	if (Fnet)
		Lf->sf |= SELNET;
/*
 * Set size, based on access type.
 */
	if (Fsize) {
		Lf->sz = q->q_count;
		Lf->sz_def = 1;
	} else
		Lf->off_def = 1;
/*
 * Use q_ptr as the PCB address.
 */
	if (q->q_ptr) {
		(void) sprintf(dev_ch, "0x%08x", q->q_ptr);
		enter_dev_ch(dev_ch);
	} else {
		enter_nm("no PCB address");
		return;
	}

# if	V88<40403
/*
 * Read and process the R40V4.2 inpcb.
 */
	if (kread((KA_T)q->q_ptr, (char *)&inp, sizeof(inp))) {
		(void) sprintf(Namech, "can't read inpcb from %x", q->q_ptr);
		enter_nm(Namech);
		return;
	}
	printinaddr(&inp.inp_laddr, (int)ntohs(inp.inp_lport));
	if (inp.inp_faddr.s_addr != INADDR_ANY || inp.inp_fport != 0) {
		(void) strcat(endnm(), "->");
		printinaddr(&inp.inp_faddr, (int)ntohs(inp.inp_fport));
	}
	enter_nm(Namech);
	return;
# else	/* V88>=40403 */
/*
 * Read the R40V4.3 IP client structure.
 */
	if (kread((KA_T)q->q_ptr, (char *)&ic, sizeof(ic))) {
		(void) sprintf(Namech, "can't read IP client structure: %#x",
			q->q_ptr);
		enter_nm(Namech);
		return;
	}
	if (strcmp(pr, "UDP") == 0) {

	/*
	 * Save UDP address.
	 */
		ap = (struct in_addr *)&ic.ipc_udp_addr;
		p = (u_short)ic.ipc_udp_port;
		if (ap->s_addr == INADDR_ANY && p == 0 && q->q_bfcp) {

		/*
		 * If the ipc_s structure has no local address, read
		 * the ud_s structure for the stream one back.
		 */
			if (!kread((KA_T)q->q_bfcp, (char *)&qs, sizeof(qs))
			&&  qs.q_ptr
			&&  !kread((KA_T)qs.q_ptr, (char *)&uc, sizeof(uc))) {
				s = (u_short *)&uc.udp_port[0];
				p = *s;
			}
		}
		printinaddr(ap, (int)ntohs(p));
	}
	else if (strcmp(pr, "TCP") == 0) {

	/*
	 * Save TCP address.
	 */
		ap = (struct in_addr *)&ic.ipc_tcp_addr[0];
		p = (u_short)ic.ipc_tcp_addr[5];
		if (q->q_bfcp) {

		/*
		 * Read the tcp_s structure.
		 */
			if (!kread((KA_T)q->q_bfcp, (char *)&qs, sizeof(qs))
			&&  qs.q_ptr
			&&  !kread((KA_T)qs.q_ptr, (char *)&tc, sizeof(tc)))
				tcs = 1;
			else
				tcs = 0;
		}
		if (ap->s_addr == INADDR_ANY && p == 0 && tcs) {

		/*
		 * If the ipc_s structure has no local address, use
		 * the addresses in the tcp_s' tcph structure.
		 */
			if (tc.tcp_hdr_len && tc.tcp_tcph
			&&  kread((KA_T)tc.tcp_tcph, (char *)&th, sizeof(th))
			== 0) {
				s = (u_short *)&th.th_lport[0];
				p = *s;
			}
		}
		printinaddr(ap, (int)ntohs(p));
		if ((int)ic.ipc_tcp_addr[2] != INADDR_ANY
		|| ic.ipc_tcp_addr[4] != 0) {
			(void) strcat(endnm(), "->");
			printinaddr((struct in_addr *)&ic.ipc_tcp_addr[2],
				(int)ntohs(ic.ipc_tcp_addr[4]));
		}
	/*
	 * Save TCP size information.
	 */
		if (tcs && Fsize) {
			if ((rq = (int)tc.tcp_rnxt - (int)tc.tcp_rack) < 0)
				rq = 0;
			if ((sq = (int)tc.tcp_snxt - (int)tc.tcp_suna - 1) < 0)
				sq = 0;
			if (Lf->access == 'r')
				Lf->sz = rq;
			else if (Lf->access == 'w')
				Lf->sz = sq;
			else
				Lf->sz = rq + sq;
			Lf->sz_def = 1;
		} else
			Lf->off_def = 1;
	}
/*
 * Enter name characters if there are any.
 */
	if (Namech[0])
		enter_nm(Namech);
# endif	/* V88<40403 */

}
#endif	/* V88>=40401 */
