/*
 * dlsof.h - Motorola V/88 header file for lsof
 */


/*
 * Copyright 1994 Purdue Research Foundation, West Lafayette, Indiana
 * 47907.  All rights reserved.
 *
 * Written by Victor A. Abell
 *
 * This software is not subject to any license of the American Telephone
 * and Telegraph Company or the Regents of the University of California.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. Neither the authors nor Purdue University are responsible for any
 *    consequences of the use of this software.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Credit to the authors and Purdue
 *    University must appear in documentation and sources.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 * 4. This notice may not be removed or altered.
 */


#if	!defined(V88_LSOF_H)
#define	V88_LSOF_H	1

# if	V88>=40401
#define	_KMEMUSER	1
# endif	/* V88>=40401 */

#include <dirent.h>
#include <fcntl.h>
#include <malloc.h>
#include <stdlib.h>
#include <unistd.h>

# if	V88<40401
#include <bsd_port.h>
#include <mnttab.h>
# else	/* V88>=40401 */
#include <sys/mntent.h>
#include <sys/mnttab.h>
#include <netdb.h>
# endif	/* V88<40401 */

#include <string.h>
#include <nlist.h>

#if	V88<40401
#include <sys/conf.h>
# endif	/* V88<40401 */

#include <sys/file.h>
#include <sys/flock.h>
#include <sys/immu.h>

# if	V88<40401
#include <sys/inode.h>
#include <sys/region.h>
#include <sys/syslocal.h>
# else	/* V88>=40401 */
#include <sys/fstyp.h>
#include <sys/fsid.h>
#include <sys/vfs.h>
#include <sys/vnode.h>
#include <sys/fs/ufs_inode.h>
#include <sys/fs/fifonode.h>
#include <sys/fs/pipenode.h>
#include <sys/fs/snode.h>
# endif	/* V88<40401 */

#include <sys/mount.h>
#include <sys/stream.h>
#include <sys/sysmacros.h>

# if	V88>=40401
#include <sys/strsubr.h>
# endif	/* V88>=40401 */

#include <sys/time.h>
#include <sys/fs/s5dir.h>
#include <signal.h>
#include <sys/proc.h>
#include <sys/user.h>
#include <sys/var.h>

# if	V88<40401
#include <sys/fs/nfs/types.h>
#include <sys/fs/nfs/ucred.h>
#include <sys/fs/nfs/nfs.h>
#include <sys/fs/nfs/rnode.h>
# else	/* V88>=40401 */
#include <sys/procfs.h>
#include <sys/priocntl.h>
struct uio {};
#include <sys/ddi.h>
#include <nfs/nfs.h>
#include <nfs/rnode.h>
# endif	/* V88<40401 */

#include <netinet/in.h>
#include <sys/socket.h>

# if	V88<40401
#include <sys/sock_var.h>
# else	/* V88>=40401 */
#include <net/route.h>

#  if	!defined(STRNET)
#define	STRNET	1
#  endif	/* !defined(STRNET) */

#   if	V88<40403
#include <netinet/in_pcb.h>
#   endif	/* V88<40403 */

#include <sys/protosw.h>
#include <sys/socketvar.h>
# endif	/* V88<40401 */

# if	V88>=40401
#include <vm/hat.h>
#include <vm/as.h>
#include <vm/seg.h>
#include <vm/seg_dev.h>
#include <vm/seg_map.h>
#include <vm/seg_vn.h>
# endif	/* V88>=40401 */

# if	defined(HASPROCFS)
#undef	max
#undef	min
#include <fs/proc/prdata.h>
# endif	/* defined(HASPROCFS) */


# if    V88<40401
extern char *sys_errlist[];
#define strerror(errno) sys_errlist[errno]
# endif	/* V88<40401 */


# if	V88<40401
#define	COMP_P		char
#else	/* V88>=40401 */
#define	COMP_P		const void
# endif	/* V88<40401 */

#define DEVINCR		1024	/* device table malloc() increment */
#define	FSNAMEL		4
#define	KA_T		off_t
#define	KMEM		"/dev/kmem"
#define N_UNIX		"/unix"
#define MALLOC_P	char
#define FREE_P		MALLOC_P
#define MALLOC_S	unsigned

# if	V88<40401
#define	MNTTAB		"/etc/mnttab"
#else	/* V88>=40401 */
#define MAXSEGS		100	/* maximum text segments */
# endif	/* V88<40401 */

# if	defined(HASPROCFS)
#define	PR_ROOTINO	2
# endif

#define	PROCSIZE	sizeof(struct proc)
#define QSORT_P		char
#define	READLEN_T	unsigned
#define STRNCPY_L	size_t
#define	STRNML		32
#define U_SIZE		sizeof(struct user)

# if	V88>=40401
#define get_major(d)			(((d)>>L_BITSMINOR) & L_MAXMAJ)
#define get_minor(d)			((d) & L_MAXMIN)
#endif	/* V88>=40401 */


/*
 * Global storage definitions (including their structure definitions)
 */

# if	V88>=40403
struct clone {
	int dx;				/* index of device entry in Devtp[] */
	struct clone *next;		/* forward link */
};
extern struct clone *Clone;
extern int CloneMajor;
extern int HaveCloneMajor;
# endif	/* V88>=40403 */

# if	V88<40401
extern struct fsinfo *Fsinfo;
# else	/* V88>=40401 */
extern char **Fsinfo;
extern int Fsinfomax;
# endif	/* V88<40401 */

extern int Kmem;

struct l_vfs {
	struct vfs *addr;		/* kernel address */
	char *dir;			/* mounted directory */
	char *fsname;			/* file system name */
	struct l_vfs *next;		/* forward link */
};
extern struct l_vfs *Lvfs;

struct mounts {
        dev_t dev;              	/* st_dev */
        char *dir;              	/* directory */
        char *fsname;           	/* file system */
	ino_t inode;			/* st_ino */
	mode_t mode;			/* st_mode */
        struct mounts *next;    	/* forward link */
	dev_t rdev;			/* st_rdev */

# if	defined(HASFSTYPE)
	char *fstype;			/* st_fstype */
# endif

};

extern short Nfstyp;

# if	V88<40401
#define	X_FSINFO	0
#define	X_NFSTYP	1
#define	X_PREGPP	2
#define	X_PROC		3
#define X_VAR		4
# else	/* V88>=40401 */
#define	X_NCACHE	0
#define	X_NCSIZE	1
#define	X_SEGVN		2
#define X_VAR		3
#  if	V88>=40403
#define	X_CLONEMAJ	4
#  endif	/* V88>=40403 */
# endif	/* V88<40401 */

struct sfile {
	char *aname;			/* argument file name */
	char *name;			/* file name (after readlink()) */
	char *devnm;			/* device name (optional) */
	dev_t dev;			/* device */
	u_short mode;			/* S_IFMT mode bits from stat() */
	int type;			/* file type: 0 = file system
				 	 *	      1 = regular file */
	ino_t i;			/* inode number */
	int f;				/* file found flag */
	struct sfile *next;		/* forward link */
};

#include <setjmp.h>

#endif	/* V88_LSOF_H	*/
