/*
 * dnode1.c - HP-UX node functions for lsof
 *
 * This module must be separate to keep separate the multiple kernel inode
 * structure definitions.
 */


/*
 * Copyright 1995 Purdue Research Foundation, West Lafayette, Indiana
 * 47907.  All rights reserved.
 *
 * Written by Victor A. Abell
 *
 * This software is not subject to any license of the American Telephone
 * and Telegraph Company or the Regents of the University of California.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. Neither the authors nor Purdue University are responsible for any
 *    consequences of the use of this software.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Credit to the authors and Purdue
 *    University must appear in documentation and sources.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 * 4. This notice may not be removed or altered.
 */

#ifndef lint
static char copyright[] =
"@(#) Copyright 1994 Purdue Research Foundation.\nAll rights reserved.\n";
static char *rcsid = "$Id: dnode1.c,v 1.1 95/09/17 08:49:17 abe Exp $";
#endif


#include "lsof.h"

#if	defined(HASVXFS)
/*
 * The pool_id_t type does not seem to be defined in the header  files
 * distributed by HP.  However, <sys/fs/vx_hpux.h> requires  it when
 * _KERNEL is defined.  So we fake the pool_id_t definition.
 *
 * <sys/fs/vx_hpux.h> also requires sv_sema_t.  It's defined in
 * <sys/sem_alpha.h> when _KERNEL is defined, but some other header file has
 * already include <sys/sem_alpha.h> with _KERNEL undefined.  So we fake the
 * sv_sema_t definition.
 */

#define	pool_id_t	caddr_t
#define	sv_sema_t	caddr_t

#define	_KERNEL
#include <sys/fs/vx_hpux.h>
#include <sys/fs/vx_inode.h>
#undef	_KERNEL


/*
 * read_vxnode() - read Veritas file system inode information
 */

int
read_vxnode(v, vfs, dev)
	struct vnode *v;		/* containing vnode */
	struct l_vfs *vfs;		/* local vfs structure */
	dev_t *dev;			/* device number receiver */
{
	struct vx_inode i;

	if (!v->v_data || kread((KA_T)v->v_data, (char *)&i, sizeof(i)))
		return(1);
/*
 * Return device number.
 */
	if (v->v_type == VCHR)
		*dev = v->v_rdev;
	else if (vfs && vfs->fsname)
		*dev = vfs->dev;
	else
		*dev = i.i_dev;
/*
 * Record inode number.
 */
	Lf->inode = (unsigned long)i.i_number;
	Lf->inp_ty = 1;
/*
 * Record size.
 */
	if (!Foffset) {
		Lf->sz = i.i_size;
		Lf->sz_def = 1;
	}
	return(0);
}
#endif	/* defined(HASVXFS) */
