/*
 * dnode2.c - Pyramid DC/OSx node functions for lsof
 *
 * This module must be separate to keep separate the multiple kernel inode
 * structure definitions.
 */

/*
 * Copied from dialects/dcosx/dnode1.c and modified for RxFS.
 * Robert Vernon 16th November, 1994.
 */

/*
 * Copyright 1994 Purdue Research Foundation, West Lafayette, Indiana
 * 47907.  All rights reserved.
 *
 * Written by Victor A. Abell
 *
 * This software is not subject to any license of the American Telephone
 * and Telegraph Company or the Regents of the University of California.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. Neither the authors nor Purdue University are responsible for any
 *    consequences of the use of this software.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Credit to the authors and Purdue
 *    University must appear in documentation and sources.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 * 4. This notice may not be removed or altered.
 */

#ifndef lint
static char copyright[] =
"@(#) Copyright 1994 Purdue Research Foundation.\nAll rights reserved.\n";
static char *rcsid = "$Id: dnode2.c,v 1.3 95/09/12 08:13:40 abe Exp $";
#endif


#include "lsof.h"

#if	defined(HASRXFS)

# if	defined(fs_bsize)
/* fs_bsize is defined in both nfs.h and vx_fs.h.
 * We only care about the vs_fs.h version of fs_bsize here.
 */
#undef	fs_bsize
# endif

#include <sys/fs/vx_fs.h>
#include <sys/fs/vx_inode.h>
#endif	/* defined(HASRXFS) */


/*
 * readrxlino() - read rxfs inode's local inode information
 */

int
readrxlino(v, i)
	struct vnode *v;		/* containing vnode */
	struct l_ino *i;		/* local inode information */
{

#if	defined(HASRXFS)
	struct inode rxi;

	if (kread((KA_T)v->v_data, (char *)&rxi, sizeof(rxi)))
		return(1);
	i->dev = rxi.i_dev;
	i->rdev = rxi.i_rdev;
	i->number = rxi.i_number;
	i->size = rxi.i_size;
	return(0);
#else	/* !defined(HASRXFS) */
	return(1);
#endif	/* defined(HASRXFS) */

}
