

/*
 * print_file() - print file
 */

void
print_file()
{
	char buf[16];

	if (Hdr == 0) {
	    (void) printf("COMMAND     PID%s     USER   FD   TYPE     DEVICE ",
		Fpgrp ? "   PGRP" : "");
	    (void) printf("%10s", Foffset ? "OFFSET"
					  : Fsize ? "SIZE"
						  : "SIZE/OFF");
	    (void) puts("  INODE NAME");
	    Hdr++;
	}
	(void) printf("%-9.9s%6d", Lp->cmd, Lp->pid);
	if (Fpgrp)
	    printf(" %6d", Lp->pgrp);
	(void) printf(" %8.8s %4s%c%c %4.4s ",
			printuid((UID_ARG)Lp->uid, NULL),
			Lf->fd,
			Lf->access,
			Lf->lock,
			Lf->type
		);
	if (Lf->dev_def)
		(void) printf(" %4d,%4d ", major(Lf->dev), minor(Lf->dev));
	else {
		if (Lf->dev_ch) {
			(void) fputs(Lf->dev_ch, stdout);
			putchar(' ');
		} else
			(void) fputs("           ", stdout);
	}
	if (Lf->sz_def)
		(void) printf("%10u", Lf->sz);
	else if (Lf->off_def) {
		if ((unsigned int)Lf->off < 100000000) {
			(void) sprintf(buf, "0t%d", Lf->off);
			(void) printf("%10.10s", buf);
		} else
			(void) printf("%#10x", (Lf->off & 0xffffffff));
	} else
		(void) fputs("          ", stdout);
	switch (Lf->inp_ty) {
	case 1:
		if (Lf->inode < 1000000l)
			(void) printf(" %6lu ", Lf->inode);
		else
			(void) printf(" *%05lu ", Lf->inode % 100000l);
		break;
	case 2:
		if (Lf->iproto[0] == '\0')
			(void) fputs("        ", stdout);
		else
			(void) printf(" %6.6s ", Lf->iproto);
		break;
	default:
		(void) fputs("        ", stdout);
	}
	printname(1);
}
