

/*
 * find_ch_ino() - find the inode number for a character device file
 */

void
find_ch_ino()
{
	dev_t ldev, tdev;
	int low, hi, mid;

	readdev();
	low = mid = 0;
	hi = Ndev - 1;
	ldev = Lf->dev;
	while (low <= hi) {
		mid = (low + hi) / 2;
		tdev = Sdev[mid]->rdev;
		if (ldev < tdev)
			hi = mid - 1;
		else if (ldev > tdev)
			low = mid + 1;
		else {
			Lf->inode = (unsigned long)Sdev[mid]->inode;
			if (Lf->inp_ty == 0)
				Lf->inp_ty = 1;
			return;
		}
	}
}
