;;; xwem-compat.el --- GNU Emacs compatibility layer.

;; Copyright (C) 2003 by Free Software Foundation, Inc.

;; Author: Zajcev Evgeny <zevlg@yandex.ru>
;; Created: Fri Dec 12 15:51:10 MSK 2003
;; Keywords: xwem, xlib
;; X-CVS: $Id: xwem-compat.el,v 1.3 2004/07/14 08:38:55 youngs Exp $

;; This file is part of XWEM.

;; XWEM is free software; you can redistribute it and/or modify it
;; under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; XWEM is distributed in the hope that it will be useful, but WITHOUT
;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
;; or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
;; License for more details.

;; You should have received a copy of the GNU General Public License
;; along with XEmacs; see the file COPYING.  If not, write to the Free
;; Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
;; 02111-1307, USA.

;;; Synched up with: Not in FSF

;;; Commentary:

;; Compatibility layer betwean XEmacs and GNU Emacs.  However xwem
;; still can't run on GNU Emacs.

;;; Code:

;;;###autoload
(defvar xwem-gnuemacs-p (string-match "GNU Emacs" emacs-version)
  "Non-nil when running under GNU Emacs.")

;;;###autoload
(defun xwem-define-prefix-command (name &optional mapvar)
  "Compat version for `define-prefix-command'."
  (if xwem-gnuemacs-p
      (define-prefix-command name)
    (define-prefix-command name t)))

(unless (fboundp 'set-keymap-default-binding)
  (fset 'set-keymap-default-binding
	(lambda (keym cmd) (define-key keym [t] cmd))))

(unless (fboundp 'events-to-keys)
  (defalias 'events-to-keys 'identity))


(provide 'xwem-compat)

;;; xwem-compat.el ends here
