/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BshClassManager;
import bsh.BshMethod;
import bsh.CallStack;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.InterpreterError;
import bsh.LHS;
import bsh.NameSpace;
import bsh.Primitive;
import bsh.Reflect;
import bsh.ReflectError;
import bsh.SimpleNode;
import bsh.TargetError;
import bsh.This;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;

class Name
implements Serializable {
    public NameSpace namespace;
    String value = null;
    private String evalName;
    private Object evalBaseObject;
    private int callstackDepth;
    private boolean literalThisReference;
    private boolean literalCallerReference;
    static /* synthetic */ Class class$bsh$Interpreter;

    private void reset() {
        this.evalName = this.value;
        this.evalBaseObject = null;
        this.callstackDepth = 0;
        this.literalThisReference = false;
        this.literalCallerReference = false;
    }

    public Name(NameSpace nameSpace, String string) {
        this.namespace = nameSpace;
        this.value = string;
    }

    public Object toObject(CallStack callStack, Interpreter interpreter) throws EvalError {
        return this.toObject(callStack, interpreter, false);
    }

    public synchronized Object toObject(CallStack callStack, Interpreter interpreter, boolean bl) throws EvalError {
        this.reset();
        Object object = null;
        while (this.evalName != null) {
            object = this.consumeNextObjectField(callStack, interpreter, bl);
        }
        if (object == null) {
            throw new InterpreterError("null value in toObject()");
        }
        return object;
    }

    private Object consumeNextObjectField(CallStack callStack, Interpreter interpreter, boolean bl) throws EvalError {
        Object object;
        if (this.evalBaseObject == null && !Name.isCompound(this.evalName) && !bl && (object = this.resolveThisFieldReference(callStack, this.namespace, interpreter, this.evalName, false)) != Primitive.VOID) {
            this.evalName = null;
            this.evalBaseObject = object;
            return this.evalBaseObject;
        }
        if ((this.evalBaseObject == null || this.evalBaseObject instanceof This) && !bl) {
            Object object2;
            object = Name.prefix(this.evalName, 1);
            if (Interpreter.DEBUG) {
                Interpreter.debug("trying to resolve variable: " + (String)object);
            }
            if ((object2 = this.evalBaseObject == null ? this.resolveThisFieldReference(callStack, this.namespace, interpreter, (String)object, false) : this.resolveThisFieldReference(callStack, ((This)this.evalBaseObject).namespace, interpreter, (String)object, true)) != Primitive.VOID) {
                if (Interpreter.DEBUG) {
                    Interpreter.debug("resolved variable: " + (String)object + " in namespace: " + this.namespace);
                }
                this.evalName = Name.suffix(this.evalName);
                this.evalBaseObject = object2;
                return this.evalBaseObject;
            }
        }
        if (this.evalBaseObject == null) {
            if (Interpreter.DEBUG) {
                Interpreter.debug("trying class: " + this.evalName);
            }
            object = null;
            int n = 1;
            while (n <= Name.countParts(this.evalName)) {
                object = this.namespace.getClass(Name.prefix(this.evalName, n));
                if (object != null) break;
                ++n;
            }
            if (object != null) {
                this.evalName = Name.suffix(this.evalName, Name.countParts(this.evalName) - n);
                this.evalBaseObject = new ClassIdentifier((Class)object);
                return this.evalBaseObject;
            }
            if (Interpreter.DEBUG) {
                Interpreter.debug("not a class, trying var prefix " + this.evalName);
            }
        }
        if (this.evalBaseObject == null) {
            if (!Name.isCompound(this.evalName)) {
                this.evalName = null;
                this.evalBaseObject = Primitive.VOID;
                return this.evalBaseObject;
            }
            throw new EvalError("Class or variable not found:" + this.evalName);
        }
        if (this.evalBaseObject == Primitive.NULL) {
            throw new TargetError("Null Pointer while evaluating: " + this.value, new NullPointerException());
        }
        if (this.evalBaseObject == Primitive.VOID) {
            throw new EvalError("Undefined variable or class name while evaluating: " + this.value);
        }
        if (this.evalBaseObject instanceof Primitive) {
            throw new EvalError("Can't treat primitive like an object. Error while evaluating: " + this.value);
        }
        if (this.evalBaseObject instanceof ClassIdentifier) {
            String string;
            Class clazz;
            Object object3;
            String string2;
            block25: {
                object = ((ClassIdentifier)this.evalBaseObject).getTargetClass();
                string2 = Name.prefix(this.evalName, 1);
                object3 = null;
                try {
                    if (Interpreter.DEBUG) {
                        Interpreter.debug("Name call to getStaticField, class: " + object + ", field:" + string2);
                    }
                    object3 = Reflect.getStaticField((Class)object, string2);
                }
                catch (ReflectError reflectError) {
                    if (!Interpreter.DEBUG) break block25;
                    Interpreter.debug("field reflect error: " + reflectError);
                }
            }
            if (object3 == null && (clazz = this.namespace.getClass(string = ((Class)object).getName() + "$" + string2)) != null) {
                object3 = new ClassIdentifier(clazz);
            }
            if (object3 == null) {
                throw new EvalError("No static field or inner class: " + string2 + " of " + object);
            }
            this.evalName = Name.suffix(this.evalName);
            this.evalBaseObject = object3;
            return this.evalBaseObject;
        }
        if (bl) {
            throw new EvalError(this.value + " does not resolve to a class name.");
        }
        object = Name.prefix(this.evalName, 1);
        if (((String)object).equals("length") && this.evalBaseObject.getClass().isArray()) {
            Primitive primitive = new Primitive(Array.getLength(this.evalBaseObject));
            this.evalName = Name.suffix(this.evalName);
            this.evalBaseObject = primitive;
            return this.evalBaseObject;
        }
        try {
            Object object4 = Reflect.getObjectField(this.evalBaseObject, (String)object);
            this.evalName = Name.suffix(this.evalName);
            this.evalBaseObject = object4;
            return this.evalBaseObject;
        }
        catch (ReflectError reflectError) {
            throw new EvalError("Cannot access field: " + (String)object + ", on object: " + this.evalBaseObject);
        }
    }

    Object resolveThisFieldReference(CallStack callStack, NameSpace nameSpace, Interpreter interpreter, String string, boolean bl) throws EvalError {
        Object object = null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (string.equals("this")) {
            if (bl) {
                throw new EvalError("Redundant to call .this on This type");
            }
            object = nameSpace.getThis(interpreter);
            bl2 = true;
        }
        if (object == null) {
            if (string.equals("super")) {
                object = nameSpace.getSuper().getThis(interpreter);
            } else if (string.equals("global")) {
                object = nameSpace.getGlobal().getThis(interpreter);
            }
        }
        if (object == null && bl) {
            if (string.equals("namespace")) {
                object = nameSpace;
            } else if (string.equals("variables")) {
                object = nameSpace.getVariableNames();
            } else if (string.equals("methods")) {
                object = nameSpace.getMethodNames();
            } else if (string.equals("interpreter")) {
                if (this.literalThisReference) {
                    object = interpreter;
                } else {
                    throw new EvalError("Can only call .interpreter on literal 'this'");
                }
            }
        }
        if (object == null && bl && string.equals("caller")) {
            if (this.literalThisReference || this.literalCallerReference) {
                if (callStack == null) {
                    throw new InterpreterError("no callstack");
                }
            } else {
                throw new EvalError("Can only call .caller on literal 'this' or literal '.caller'");
            }
            object = callStack.get(++this.callstackDepth).getThis(interpreter);
            bl3 = true;
        }
        if (object == null && bl && string.equals("callstack")) {
            if (this.literalThisReference) {
                if (callStack == null) {
                    throw new InterpreterError("no callstack");
                }
                object = callStack;
            } else {
                throw new EvalError("Can only call .callstack on literal 'this'");
            }
        }
        if (object == null) {
            object = nameSpace.getVariable(string);
        }
        this.literalThisReference = bl2;
        this.literalCallerReference = bl3;
        return object;
    }

    public synchronized Class toClass() throws EvalError {
        this.reset();
        Class clazz = this.namespace.getClass(this.evalName);
        if (clazz == null) {
            Object object = null;
            try {
                object = this.toObject(null, null, true);
            }
            catch (EvalError evalError) {
                // empty catch block
            }
            if (object instanceof ClassIdentifier) {
                clazz = ((ClassIdentifier)object).getTargetClass();
            }
        }
        if (clazz == null) {
            throw new EvalError("Class: " + this.value + " not found in namespace");
        }
        return clazz;
    }

    public synchronized LHS toLHS(CallStack callStack, Interpreter interpreter) throws EvalError {
        this.reset();
        if (!Name.isCompound(this.evalName)) {
            return new LHS(this.namespace, this.evalName);
        }
        Object object = null;
        try {
            while (Name.isCompound(this.evalName)) {
                object = this.consumeNextObjectField(callStack, interpreter, false);
            }
        }
        catch (EvalError evalError) {
            throw new EvalError("LHS evaluation: " + evalError);
        }
        if (object == null) {
            throw new InterpreterError("internal error 2893749283");
        }
        if (object instanceof This) {
            Interpreter.debug("found This reference evaluating LHS");
            return new LHS(((This)object).namespace, this.evalName);
        }
        if (this.evalName != null) {
            try {
                if (object instanceof ClassIdentifier) {
                    Class clazz = ((ClassIdentifier)object).getTargetClass();
                    return Reflect.getLHSStaticField(clazz, this.evalName);
                }
                return Reflect.getLHSObjectField(object, this.evalName);
            }
            catch (ReflectError reflectError) {
                throw new EvalError("Field access: " + reflectError);
            }
        }
        throw new InterpreterError("Internal error in lhs...");
    }

    private BshMethod toLocalMethod(Object[] objectArray) {
        Class[] classArray = Reflect.getTypes(objectArray);
        return this.namespace.getMethod(this.value, classArray);
    }

    public Object invokeMethod(Interpreter interpreter, Object[] objectArray, CallStack callStack, SimpleNode simpleNode) throws EvalError, ReflectError, InvocationTargetException {
        Class clazz;
        if (!Name.isCompound(this.value)) {
            return this.invokeLocalMethod(interpreter, objectArray, callStack, simpleNode);
        }
        Name name = this.namespace.getNameResolver(Name.prefix(this.value));
        String string = Name.suffix(this.value, 1);
        Object object = name.toObject(callStack, interpreter);
        if (object == Primitive.VOID) {
            throw new EvalError("Attempt to invoke method: " + string + "() on undefined variable or class name: " + name);
        }
        if (!(object instanceof ClassIdentifier)) {
            if (object instanceof Primitive) {
                if (object == Primitive.NULL) {
                    throw new TargetError("Null Pointer in Method Invocation", new NullPointerException());
                }
                interpreter.error("Attempt to access method on primitive... allowing bsh.Primitive to peek through for debugging");
            }
            return Reflect.invokeObjectMethod(interpreter, object, string, objectArray, simpleNode);
        }
        if (Interpreter.DEBUG) {
            Interpreter.debug("invokeMethod: trying static - " + name);
        }
        if ((clazz = ((ClassIdentifier)object).getTargetClass()) != null) {
            return Reflect.invokeStaticMethod(clazz, string, objectArray);
        }
        throw new EvalError("unknown target: " + name);
    }

    public Object invokeLocalMethod(Interpreter interpreter, Object[] objectArray, CallStack callStack, SimpleNode simpleNode) throws EvalError, ReflectError, InvocationTargetException {
        String string;
        InputStream inputStream;
        BshMethod bshMethod;
        if (Interpreter.DEBUG) {
            Interpreter.debug("invoke local method: " + this.value);
        }
        if ((bshMethod = this.toLocalMethod(objectArray)) != null) {
            return bshMethod.invokeDeclaredMethod(objectArray, interpreter, callStack, simpleNode);
        }
        if (Interpreter.DEBUG) {
            Interpreter.debug("no locally declared method: " + this.value);
        }
        if ((inputStream = (class$bsh$Interpreter == null ? (class$bsh$Interpreter = Name.class$("bsh.Interpreter")) : class$bsh$Interpreter).getResourceAsStream(string = "commands/" + this.value + ".bsh")) != null) {
            if (Interpreter.DEBUG) {
                Interpreter.debug("loading resource: " + string);
            }
            if (interpreter == null) {
                throw new InterpreterError("2234432 interpreter = null");
            }
            interpreter.eval(new InputStreamReader(inputStream), this.namespace, string);
            bshMethod = this.toLocalMethod(objectArray);
            if (bshMethod != null) {
                return bshMethod.invokeDeclaredMethod(objectArray, interpreter, callStack, simpleNode);
            }
            throw new EvalError("Loaded resource: " + string + "had an error or did not contain the correct method");
        }
        string = "bsh.commands." + this.value;
        Class clazz = BshClassManager.classForName(string);
        if (clazz == null) {
            throw new EvalError("Command not found: " + this.value);
        }
        Object[] objectArray2 = new Object[objectArray.length + 2];
        objectArray2[0] = interpreter;
        objectArray2[1] = this.namespace;
        System.arraycopy(objectArray, 0, objectArray2, 2, objectArray.length);
        try {
            return Reflect.invokeStaticMethod(clazz, "invoke", objectArray2);
        }
        catch (ReflectError reflectError) {
            if (Interpreter.DEBUG) {
                Interpreter.debug("invoke command args error:" + reflectError);
            }
            try {
                String string2 = (String)Reflect.invokeStaticMethod(clazz, "usage", null);
                interpreter.println(string2);
                return Primitive.VOID;
            }
            catch (ReflectError reflectError2) {
                if (Interpreter.DEBUG) {
                    Interpreter.debug("usage threw: " + reflectError2);
                }
                throw new EvalError("Wrong number or type of args for command");
            }
        }
    }

    static boolean isCompound(String string) {
        return Name.countParts(string) > 1;
    }

    static int countParts(String string) {
        if (string == null) {
            return 0;
        }
        int n = 0;
        int n2 = -1;
        while ((n2 = string.indexOf(46, n2 + 1)) != -1) {
            ++n;
        }
        return n + 1;
    }

    static String prefix(String string) {
        if (!Name.isCompound(string)) {
            return null;
        }
        return Name.prefix(string, Name.countParts(string) - 1);
    }

    static String prefix(String string, int n) {
        if (n < 1) {
            return null;
        }
        int n2 = 0;
        int n3 = -1;
        while ((n3 = string.indexOf(46, n3 + 1)) != -1 && ++n2 < n) {
        }
        return n3 == -1 ? string : string.substring(0, n3);
    }

    static String suffix(String string) {
        if (!Name.isCompound(string)) {
            return null;
        }
        return Name.suffix(string, Name.countParts(string) - 1);
    }

    public static String suffix(String string, int n) {
        if (n < 1) {
            return null;
        }
        int n2 = 0;
        int n3 = string.length() + 1;
        while ((n3 = string.lastIndexOf(46, n3 - 1)) != -1 && ++n2 < n) {
        }
        return n3 == -1 ? string : string.substring(n3 + 1);
    }

    public String toString() {
        return this.value;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class ClassIdentifier {
        Class clas;

        public ClassIdentifier(Class clazz) {
            this.clas = clazz;
        }

        public Class getTargetClass() {
            return this.clas;
        }

        public String toString() {
            return "Class Identifier: " + this.clas.getName();
        }
    }
}

