;;;  -*- emacs-lisp -*-
;;;
;;;  $Id: irchat-version.el,v 3.89 1998/06/25 06:52:48 tri Exp $
;;;
;;; see file irchat-copyright.el for change log and copyright info

;;;
;;; Version number constants
;;;

(defconst irchat-client-version-major "3"
  "*Major version number. Major functional changes change this number.")

(defconst irchat-client-version-minor "04"
  "*Minor version number. Server Protocol changes and bug fixes change this number.")

(defconst irchat-client-version-beta-p t
  "*Is this version a beta version?")

(defconst irchat-client-version-alpha-p t
  "*Is this version an alpha version?")

(defconst irchat-client-version-rcs-snap nil
  "*If a `current' release, what's the date?")

(defconst irchat-client-version-release "$Date: 1998/06/25 06:52:48 $"
  "*Version release date")

(defconst irchat-client-name "Irchat"
  "*Name of this program.")

(defconst irchat-emacs-version (let ((e-v-s (if (boundp 'emacs-version) 
						emacs-version
					      nil))
				     (e-v-l (if (fboundp 'emacs-version) 
						(emacs-version)
					      nil)))
				 (cond ((and (boundp 'emacs-major-version)
					     (integerp emacs-major-version))
					emacs-major-version)
				       ((and (stringp e-v-l)
					     (string-match 
					      "\\([1-9][0-9]*\\)\.[0-9][0-9]*"
					      e-v-l))
					(string-to-int
					 (substring e-v-l
						    (match-beginning 1)
						    (match-end 1))))
				       ((and (stringp e-v-s)
					     (string-match 
					      "\\([1-9][0-9]*\\)\.[0-9][0-9]*"
					      e-v-s))
					(string-to-int
					 (substring e-v-s
						    (match-beginning 1)
						    (match-end 1))))
				       (t 0)))
  "*Major number of emacs running this irchat.")


(defconst irchat-emacs-version-name
  (let ((e-v (emacs-version))
	(case-fold-search t)
	irchat-emacs-subtype
	irchat-emacs-version-number)
    (setq irchat-emacs-subtype
	(cond ((string-match "xemacs" e-v) "XEmacs")
	      ((string-match "lucid" e-v) "Lucid Emacs")
	      ((string-match "epoch" e-v) "Epoch")
	      ((or (string-match "gnu.emacs" e-v)
		   (string-match "gnuemacs" e-v)) "GNU Emacs")
	      ((string-match "mule" e-v) "Mule")
	      ((string-match "emacs" e-v) "Emacs")
	      (t "?????")))
    (setq irchat-emacs-version-number
	  (if (and (boundp 'emacs-major-version)
		   (boundp 'emacs-minor-version))
	      (format "%d.%d" emacs-major-version emacs-minor-version)
	    (if (string-match "[1-9][0-9]*\.[0-9][0-9]*" e-v)
		(substring e-v (match-beginning 0) (match-end 0))
	      "##.##")))
    (concat irchat-emacs-subtype " " irchat-emacs-version-number))
  "*Version of Emacs running this Irchat")

(defconst irchat-version
  (format "%s %s.%s%s %s" 
	  irchat-client-name 
	  irchat-client-version-major
	  irchat-client-version-minor
	  (cond (irchat-client-version-rcs-snap "current")
		(irchat-client-version-alpha-p  "alpha")
		(irchat-client-version-beta-p   "beta")
		(t ""))
	  (cond ((stringp irchat-client-version-rcs-snap)
		 (concat "(" irchat-client-version-rcs-snap ")"))
		(irchat-client-version-rcs-snap
		 "(unknown date)")
		(t
		 (if (string-match ".*: \\([^ ]*\\) .*"
				   irchat-client-version-release)
		     (concat "("
			     (substring irchat-client-version-release 
					(match-beginning 1)
					(match-end 1))
			     ")")
		   ""))))
  "*The version of irchat you are using.")

(defun irchat-version (&optional int)
  "Irchat version identifier string."
  (interactive '(t))
  (if int
      (message irchat-version))
  irchat-version)

(provide 'irchat-version)
;;;
;;; eof
;;;
