// -*- mode: c++ -*- 
/* 

    GIFT, a flexible content based image retrieval system.
    Copyright (C) 1998, 1999, 2000 CUI, University of Geneva

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
/**
 *
 * Do we print the initialisation?
 *
 */

#define _NO_PRINT_INIT
#include "mrml_const.h"
#include "CAcURL2FTS.h"
#include "CXMLElement.h" // constructor

CAcURL2FTS::CAcURL2FTS(const CXMLElement& inCollectionElement):
  mURLToFeatureFileName(inCollectionElement.stringReadAttribute(mrml_const::cui_base_dir).second
			+inCollectionElement.stringReadAttribute(mrml_const::cui_feature_file_location).second),
  mURLToFeatureFile((inCollectionElement.stringReadAttribute(mrml_const::cui_base_dir).second
                     +inCollectionElement.stringReadAttribute(mrml_const::cui_feature_file_location).second).c_str())
{
  cout << endl
       << "Opening "
       << mURLToFeatureFileName;
  if(!mURLToFeatureFile)
    cout <<" ...FAILED!";
  else
    cout << " ...success." 
	 << endl;
  
  mWellConstructed=mURLToFeatureFile;
  
  mURLToFFN.clear();
  mURLToID.clear();
  mIDToFFN.clear();
  mIDToAccessorElement.clear();
  
  
  int lID=0;
  {
    
    /* as long as there is no end of file */
    while(mURLToFeatureFile){
      string lURL;
      string lThumbnailURL;
      string lFeatureFileName;
      
      /* read in the URLs of all the images with the corresponding feature file */



      mURLToFeatureFile >> lURL
			>> lThumbnailURL
			>> lFeatureFileName;
      

      if(lURL.size()>4){
#ifndef _NO_PRINT_INIT
	cout << lID 
	     << ": URL            " << lURL << flush << endl
	     << " Thumbnail       " << lThumbnailURL << flush << endl
	     << " FeatureFileName " << lThumbnailURL << flush << endl;
#endif

	mURLToFFN.insert(make_pair(lURL,lFeatureFileName));
	mIDToFFN.insert(make_pair(lID,lFeatureFileName));
	mURLToID.insert(make_pair(lURL,lID));
	mIDToAccessorElement.insert(make_pair(lID,CAccessorElement(lID,
								   lURL,
								   lThumbnailURL,
								   lFeatureFileName)));
	lID++;
      }
    }
  }


  cout << "URLFile " 
       << mURLToFeatureFileName 
       << " processed."
       << endl;
  mURLToFeatureFile.close();
};
CAcURL2FTS::operator bool()const{
  return mWellConstructed;
}
  /** gives back the content of mURLToFeatureFileName */
const string& CAcURL2FTS::getURLToFeatureFileName()const{
  return mURLToFeatureFileName;
};


int CAcURL2FTS::size()const{
  return mIDToFFN.size();
};


pair<bool,string> CAcURL2FTS::URLToFFN(const string& inURL)const{
  string_string_map::const_iterator lFound=mURLToFFN.find(inURL);

  if(lFound != mURLToFFN.end()){
    return make_pair(true,lFound->second);
  }else{
    return make_pair(true,string(inURL+"does not exsist"));
  }
};

pair<bool,string> CAcURL2FTS::IDToFFN(TID inID)const{
  TID_string_map::const_iterator lFound=mIDToFFN.find(inID);

  if(lFound != mURLToFFN.end()){
    return make_pair(true,lFound->second);
  }else{
    return make_pair(true,string("the requested id does not exsist"));
  }
};
