/* List of HTML 5 entities.
   Copyright (C) 2025-2026 Free Software Foundation, Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <https://www.gnu.org/licenses/>.  */

/* Written by Bruno Haible.  */
/* Data extracted from
   <https://html.spec.whatwg.org/multipage/named-characters.html>  */

/* Table of HTML5 named character entities.
   Split into two tables, one for name lengths <= 15, one for name lengths > 15,
   in order to reduze the binary size of the tables.
   Each of the tables is sorted by name in ascending order.  */
static const struct { const char name[15 + 1]; const char value[6 + 1]; } html5short[] =
{
  { "AElig", "Æ" }, /* U+00C6 */
  { "AMP", "&" }, /* U+0026 */
  { "Aacute", "Á" }, /* U+00C1 */
  { "Abreve", "Ă" }, /* U+0102 */
  { "Acirc", "Â" }, /* U+00C2 */
  { "Acy", "А" }, /* U+0410 */
  { "Afr", "𝔄" }, /* U+1D504 */
  { "Agrave", "À" }, /* U+00C0 */
  { "Alpha", "Α" }, /* U+0391 */
  { "Amacr", "Ā" }, /* U+0100 */
  { "And", "⩓" }, /* U+2A53 */
  { "Aogon", "Ą" }, /* U+0104 */
  { "Aopf", "𝔸" }, /* U+1D538 */
  { "ApplyFunction", "⁡" }, /* U+2061 */
  { "Aring", "Å" }, /* U+00C5 */
  { "Ascr", "𝒜" }, /* U+1D49C */
  { "Assign", "≔" }, /* U+2254 */
  { "Atilde", "Ã" }, /* U+00C3 */
  { "Auml", "Ä" }, /* U+00C4 */
  { "Backslash", "∖" }, /* U+2216 */
  { "Barv", "⫧" }, /* U+2AE7 */
  { "Barwed", "⌆" }, /* U+2306 */
  { "Bcy", "Б" }, /* U+0411 */
  { "Because", "∵" }, /* U+2235 */
  { "Bernoullis", "ℬ" }, /* U+212C */
  { "Beta", "Β" }, /* U+0392 */
  { "Bfr", "𝔅" }, /* U+1D505 */
  { "Bopf", "𝔹" }, /* U+1D539 */
  { "Breve", "˘" }, /* U+02D8 */
  { "Bscr", "ℬ" }, /* U+212C */
  { "Bumpeq", "≎" }, /* U+224E */
  { "CHcy", "Ч" }, /* U+0427 */
  { "COPY", "©" }, /* U+00A9 */
  { "Cacute", "Ć" }, /* U+0106 */
  { "Cap", "⋒" }, /* U+22D2 */
  { "Cayleys", "ℭ" }, /* U+212D */
  { "Ccaron", "Č" }, /* U+010C */
  { "Ccedil", "Ç" }, /* U+00C7 */
  { "Ccirc", "Ĉ" }, /* U+0108 */
  { "Cconint", "∰" }, /* U+2230 */
  { "Cdot", "Ċ" }, /* U+010A */
  { "Cedilla", "¸" }, /* U+00B8 */
  { "CenterDot", "·" }, /* U+00B7 */
  { "Cfr", "ℭ" }, /* U+212D */
  { "Chi", "Χ" }, /* U+03A7 */
  { "CircleDot", "⊙" }, /* U+2299 */
  { "CircleMinus", "⊖" }, /* U+2296 */
  { "CirclePlus", "⊕" }, /* U+2295 */
  { "CircleTimes", "⊗" }, /* U+2297 */
  { "CloseCurlyQuote", "’" }, /* U+2019 */
  { "Colon", "∷" }, /* U+2237 */
  { "Colone", "⩴" }, /* U+2A74 */
  { "Congruent", "≡" }, /* U+2261 */
  { "Conint", "∯" }, /* U+222F */
  { "ContourIntegral", "∮" }, /* U+222E */
  { "Copf", "ℂ" }, /* U+2102 */
  { "Coproduct", "∐" }, /* U+2210 */
  { "Cross", "⨯" }, /* U+2A2F */
  { "Cscr", "𝒞" }, /* U+1D49E */
  { "Cup", "⋓" }, /* U+22D3 */
  { "CupCap", "≍" }, /* U+224D */
  { "DD", "ⅅ" }, /* U+2145 */
  { "DDotrahd", "⤑" }, /* U+2911 */
  { "DJcy", "Ђ" }, /* U+0402 */
  { "DScy", "Ѕ" }, /* U+0405 */
  { "DZcy", "Џ" }, /* U+040F */
  { "Dagger", "‡" }, /* U+2021 */
  { "Darr", "↡" }, /* U+21A1 */
  { "Dashv", "⫤" }, /* U+2AE4 */
  { "Dcaron", "Ď" }, /* U+010E */
  { "Dcy", "Д" }, /* U+0414 */
  { "Del", "∇" }, /* U+2207 */
  { "Delta", "Δ" }, /* U+0394 */
  { "Dfr", "𝔇" }, /* U+1D507 */
  { "DiacriticalDot", "˙" }, /* U+02D9 */
  { "Diamond", "⋄" }, /* U+22C4 */
  { "DifferentialD", "ⅆ" }, /* U+2146 */
  { "Dopf", "𝔻" }, /* U+1D53B */
  { "Dot", "¨" }, /* U+00A8 */
  { "DotDot", "⃜" }, /* U+20DC */
  { "DotEqual", "≐" }, /* U+2250 */
  { "DoubleDot", "¨" }, /* U+00A8 */
  { "DoubleDownArrow", "⇓" }, /* U+21D3 */
  { "DoubleLeftArrow", "⇐" }, /* U+21D0 */
  { "DoubleLeftTee", "⫤" }, /* U+2AE4 */
  { "DoubleRightTee", "⊨" }, /* U+22A8 */
  { "DoubleUpArrow", "⇑" }, /* U+21D1 */
  { "DownArrow", "↓" }, /* U+2193 */
  { "DownArrowBar", "⤓" }, /* U+2913 */
  { "DownBreve", "̑" }, /* U+0311 */
  { "DownLeftVector", "↽" }, /* U+21BD */
  { "DownRightVector", "⇁" }, /* U+21C1 */
  { "DownTee", "⊤" }, /* U+22A4 */
  { "DownTeeArrow", "↧" }, /* U+21A7 */
  { "Downarrow", "⇓" }, /* U+21D3 */
  { "Dscr", "𝒟" }, /* U+1D49F */
  { "Dstrok", "Đ" }, /* U+0110 */
  { "ENG", "Ŋ" }, /* U+014A */
  { "ETH", "Ð" }, /* U+00D0 */
  { "Eacute", "É" }, /* U+00C9 */
  { "Ecaron", "Ě" }, /* U+011A */
  { "Ecirc", "Ê" }, /* U+00CA */
  { "Ecy", "Э" }, /* U+042D */
  { "Edot", "Ė" }, /* U+0116 */
  { "Efr", "𝔈" }, /* U+1D508 */
  { "Egrave", "È" }, /* U+00C8 */
  { "Element", "∈" }, /* U+2208 */
  { "Emacr", "Ē" }, /* U+0112 */
  { "Eogon", "Ę" }, /* U+0118 */
  { "Eopf", "𝔼" }, /* U+1D53C */
  { "Epsilon", "Ε" }, /* U+0395 */
  { "Equal", "⩵" }, /* U+2A75 */
  { "EqualTilde", "≂" }, /* U+2242 */
  { "Equilibrium", "⇌" }, /* U+21CC */
  { "Escr", "ℰ" }, /* U+2130 */
  { "Esim", "⩳" }, /* U+2A73 */
  { "Eta", "Η" }, /* U+0397 */
  { "Euml", "Ë" }, /* U+00CB */
  { "Exists", "∃" }, /* U+2203 */
  { "ExponentialE", "ⅇ" }, /* U+2147 */
  { "Fcy", "Ф" }, /* U+0424 */
  { "Ffr", "𝔉" }, /* U+1D509 */
  { "Fopf", "𝔽" }, /* U+1D53D */
  { "ForAll", "∀" }, /* U+2200 */
  { "Fouriertrf", "ℱ" }, /* U+2131 */
  { "Fscr", "ℱ" }, /* U+2131 */
  { "GJcy", "Ѓ" }, /* U+0403 */
  { "GT", ">" }, /* U+003E */
  { "Gamma", "Γ" }, /* U+0393 */
  { "Gammad", "Ϝ" }, /* U+03DC */
  { "Gbreve", "Ğ" }, /* U+011E */
  { "Gcedil", "Ģ" }, /* U+0122 */
  { "Gcirc", "Ĝ" }, /* U+011C */
  { "Gcy", "Г" }, /* U+0413 */
  { "Gdot", "Ġ" }, /* U+0120 */
  { "Gfr", "𝔊" }, /* U+1D50A */
  { "Gg", "⋙" }, /* U+22D9 */
  { "Gopf", "𝔾" }, /* U+1D53E */
  { "GreaterEqual", "≥" }, /* U+2265 */
  { "GreaterGreater", "⪢" }, /* U+2AA2 */
  { "GreaterLess", "≷" }, /* U+2277 */
  { "GreaterTilde", "≳" }, /* U+2273 */
  { "Gscr", "𝒢" }, /* U+1D4A2 */
  { "Gt", "≫" }, /* U+226B */
  { "HARDcy", "Ъ" }, /* U+042A */
  { "Hacek", "ˇ" }, /* U+02C7 */
  { "Hat", "^" }, /* U+005E */
  { "Hcirc", "Ĥ" }, /* U+0124 */
  { "Hfr", "ℌ" }, /* U+210C */
  { "HilbertSpace", "ℋ" }, /* U+210B */
  { "Hopf", "ℍ" }, /* U+210D */
  { "HorizontalLine", "─" }, /* U+2500 */
  { "Hscr", "ℋ" }, /* U+210B */
  { "Hstrok", "Ħ" }, /* U+0126 */
  { "HumpDownHump", "≎" }, /* U+224E */
  { "HumpEqual", "≏" }, /* U+224F */
  { "IEcy", "Е" }, /* U+0415 */
  { "IJlig", "Ĳ" }, /* U+0132 */
  { "IOcy", "Ё" }, /* U+0401 */
  { "Iacute", "Í" }, /* U+00CD */
  { "Icirc", "Î" }, /* U+00CE */
  { "Icy", "И" }, /* U+0418 */
  { "Idot", "İ" }, /* U+0130 */
  { "Ifr", "ℑ" }, /* U+2111 */
  { "Igrave", "Ì" }, /* U+00CC */
  { "Im", "ℑ" }, /* U+2111 */
  { "Imacr", "Ī" }, /* U+012A */
  { "ImaginaryI", "ⅈ" }, /* U+2148 */
  { "Implies", "⇒" }, /* U+21D2 */
  { "Int", "∬" }, /* U+222C */
  { "Integral", "∫" }, /* U+222B */
  { "Intersection", "⋂" }, /* U+22C2 */
  { "InvisibleComma", "⁣" }, /* U+2063 */
  { "InvisibleTimes", "⁢" }, /* U+2062 */
  { "Iogon", "Į" }, /* U+012E */
  { "Iopf", "𝕀" }, /* U+1D540 */
  { "Iota", "Ι" }, /* U+0399 */
  { "Iscr", "ℐ" }, /* U+2110 */
  { "Itilde", "Ĩ" }, /* U+0128 */
  { "Iukcy", "І" }, /* U+0406 */
  { "Iuml", "Ï" }, /* U+00CF */
  { "Jcirc", "Ĵ" }, /* U+0134 */
  { "Jcy", "Й" }, /* U+0419 */
  { "Jfr", "𝔍" }, /* U+1D50D */
  { "Jopf", "𝕁" }, /* U+1D541 */
  { "Jscr", "𝒥" }, /* U+1D4A5 */
  { "Jsercy", "Ј" }, /* U+0408 */
  { "Jukcy", "Є" }, /* U+0404 */
  { "KHcy", "Х" }, /* U+0425 */
  { "KJcy", "Ќ" }, /* U+040C */
  { "Kappa", "Κ" }, /* U+039A */
  { "Kcedil", "Ķ" }, /* U+0136 */
  { "Kcy", "К" }, /* U+041A */
  { "Kfr", "𝔎" }, /* U+1D50E */
  { "Kopf", "𝕂" }, /* U+1D542 */
  { "Kscr", "𝒦" }, /* U+1D4A6 */
  { "LJcy", "Љ" }, /* U+0409 */
  { "LT", "<" }, /* U+003C */
  { "Lacute", "Ĺ" }, /* U+0139 */
  { "Lambda", "Λ" }, /* U+039B */
  { "Lang", "⟪" }, /* U+27EA */
  { "Laplacetrf", "ℒ" }, /* U+2112 */
  { "Larr", "↞" }, /* U+219E */
  { "Lcaron", "Ľ" }, /* U+013D */
  { "Lcedil", "Ļ" }, /* U+013B */
  { "Lcy", "Л" }, /* U+041B */
  { "LeftArrow", "←" }, /* U+2190 */
  { "LeftArrowBar", "⇤" }, /* U+21E4 */
  { "LeftCeiling", "⌈" }, /* U+2308 */
  { "LeftDownVector", "⇃" }, /* U+21C3 */
  { "LeftFloor", "⌊" }, /* U+230A */
  { "LeftRightArrow", "↔" }, /* U+2194 */
  { "LeftRightVector", "⥎" }, /* U+294E */
  { "LeftTee", "⊣" }, /* U+22A3 */
  { "LeftTeeArrow", "↤" }, /* U+21A4 */
  { "LeftTeeVector", "⥚" }, /* U+295A */
  { "LeftTriangle", "⊲" }, /* U+22B2 */
  { "LeftTriangleBar", "⧏" }, /* U+29CF */
  { "LeftUpTeeVector", "⥠" }, /* U+2960 */
  { "LeftUpVector", "↿" }, /* U+21BF */
  { "LeftUpVectorBar", "⥘" }, /* U+2958 */
  { "LeftVector", "↼" }, /* U+21BC */
  { "LeftVectorBar", "⥒" }, /* U+2952 */
  { "Leftarrow", "⇐" }, /* U+21D0 */
  { "Leftrightarrow", "⇔" }, /* U+21D4 */
  { "LessFullEqual", "≦" }, /* U+2266 */
  { "LessGreater", "≶" }, /* U+2276 */
  { "LessLess", "⪡" }, /* U+2AA1 */
  { "LessSlantEqual", "⩽" }, /* U+2A7D */
  { "LessTilde", "≲" }, /* U+2272 */
  { "Lfr", "𝔏" }, /* U+1D50F */
  { "Ll", "⋘" }, /* U+22D8 */
  { "Lleftarrow", "⇚" }, /* U+21DA */
  { "Lmidot", "Ŀ" }, /* U+013F */
  { "LongLeftArrow", "⟵" }, /* U+27F5 */
  { "LongRightArrow", "⟶" }, /* U+27F6 */
  { "Longleftarrow", "⟸" }, /* U+27F8 */
  { "Longrightarrow", "⟹" }, /* U+27F9 */
  { "Lopf", "𝕃" }, /* U+1D543 */
  { "LowerLeftArrow", "↙" }, /* U+2199 */
  { "LowerRightArrow", "↘" }, /* U+2198 */
  { "Lscr", "ℒ" }, /* U+2112 */
  { "Lsh", "↰" }, /* U+21B0 */
  { "Lstrok", "Ł" }, /* U+0141 */
  { "Lt", "≪" }, /* U+226A */
  { "Map", "⤅" }, /* U+2905 */
  { "Mcy", "М" }, /* U+041C */
  { "MediumSpace", " " }, /* U+205F */
  { "Mellintrf", "ℳ" }, /* U+2133 */
  { "Mfr", "𝔐" }, /* U+1D510 */
  { "MinusPlus", "∓" }, /* U+2213 */
  { "Mopf", "𝕄" }, /* U+1D544 */
  { "Mscr", "ℳ" }, /* U+2133 */
  { "Mu", "Μ" }, /* U+039C */
  { "NJcy", "Њ" }, /* U+040A */
  { "Nacute", "Ń" }, /* U+0143 */
  { "Ncaron", "Ň" }, /* U+0147 */
  { "Ncedil", "Ņ" }, /* U+0145 */
  { "Ncy", "Н" }, /* U+041D */
  { "NestedLessLess", "≪" }, /* U+226A */
  { "NewLine", "\n" }, /* U+000A */
  { "Nfr", "𝔑" }, /* U+1D511 */
  { "NoBreak", "⁠" }, /* U+2060 */
  { "Nopf", "ℕ" }, /* U+2115 */
  { "Not", "⫬" }, /* U+2AEC */
  { "NotCongruent", "≢" }, /* U+2262 */
  { "NotCupCap", "≭" }, /* U+226D */
  { "NotElement", "∉" }, /* U+2209 */
  { "NotEqual", "≠" }, /* U+2260 */
  { "NotEqualTilde", "≂̸" }, /* U+2242 U+0338 */
  { "NotExists", "∄" }, /* U+2204 */
  { "NotGreater", "≯" }, /* U+226F */
  { "NotGreaterEqual", "≱" }, /* U+2271 */
  { "NotGreaterLess", "≹" }, /* U+2279 */
  { "NotGreaterTilde", "≵" }, /* U+2275 */
  { "NotHumpDownHump", "≎̸" }, /* U+224E U+0338 */
  { "NotHumpEqual", "≏̸" }, /* U+224F U+0338 */
  { "NotLeftTriangle", "⋪" }, /* U+22EA */
  { "NotLess", "≮" }, /* U+226E */
  { "NotLessEqual", "≰" }, /* U+2270 */
  { "NotLessGreater", "≸" }, /* U+2278 */
  { "NotLessLess", "≪̸" }, /* U+226A U+0338 */
  { "NotLessTilde", "≴" }, /* U+2274 */
  { "NotPrecedes", "⊀" }, /* U+2280 */
  { "NotSquareSubset", "⊏̸" }, /* U+228F U+0338 */
  { "NotSubset", "⊂⃒" }, /* U+2282 U+20D2 */
  { "NotSubsetEqual", "⊈" }, /* U+2288 */
  { "NotSucceeds", "⊁" }, /* U+2281 */
  { "NotSuperset", "⊃⃒" }, /* U+2283 U+20D2 */
  { "NotTilde", "≁" }, /* U+2241 */
  { "NotTildeEqual", "≄" }, /* U+2244 */
  { "NotTildeTilde", "≉" }, /* U+2249 */
  { "NotVerticalBar", "∤" }, /* U+2224 */
  { "Nscr", "𝒩" }, /* U+1D4A9 */
  { "Ntilde", "Ñ" }, /* U+00D1 */
  { "Nu", "Ν" }, /* U+039D */
  { "OElig", "Œ" }, /* U+0152 */
  { "Oacute", "Ó" }, /* U+00D3 */
  { "Ocirc", "Ô" }, /* U+00D4 */
  { "Ocy", "О" }, /* U+041E */
  { "Odblac", "Ő" }, /* U+0150 */
  { "Ofr", "𝔒" }, /* U+1D512 */
  { "Ograve", "Ò" }, /* U+00D2 */
  { "Omacr", "Ō" }, /* U+014C */
  { "Omega", "Ω" }, /* U+03A9 */
  { "Omicron", "Ο" }, /* U+039F */
  { "Oopf", "𝕆" }, /* U+1D546 */
  { "OpenCurlyQuote", "‘" }, /* U+2018 */
  { "Or", "⩔" }, /* U+2A54 */
  { "Oscr", "𝒪" }, /* U+1D4AA */
  { "Oslash", "Ø" }, /* U+00D8 */
  { "Otilde", "Õ" }, /* U+00D5 */
  { "Otimes", "⨷" }, /* U+2A37 */
  { "Ouml", "Ö" }, /* U+00D6 */
  { "OverBar", "‾" }, /* U+203E */
  { "OverBrace", "⏞" }, /* U+23DE */
  { "OverBracket", "⎴" }, /* U+23B4 */
  { "OverParenthesis", "⏜" }, /* U+23DC */
  { "PartialD", "∂" }, /* U+2202 */
  { "Pcy", "П" }, /* U+041F */
  { "Pfr", "𝔓" }, /* U+1D513 */
  { "Phi", "Φ" }, /* U+03A6 */
  { "Pi", "Π" }, /* U+03A0 */
  { "PlusMinus", "±" }, /* U+00B1 */
  { "Poincareplane", "ℌ" }, /* U+210C */
  { "Popf", "ℙ" }, /* U+2119 */
  { "Pr", "⪻" }, /* U+2ABB */
  { "Precedes", "≺" }, /* U+227A */
  { "PrecedesEqual", "⪯" }, /* U+2AAF */
  { "PrecedesTilde", "≾" }, /* U+227E */
  { "Prime", "″" }, /* U+2033 */
  { "Product", "∏" }, /* U+220F */
  { "Proportion", "∷" }, /* U+2237 */
  { "Proportional", "∝" }, /* U+221D */
  { "Pscr", "𝒫" }, /* U+1D4AB */
  { "Psi", "Ψ" }, /* U+03A8 */
  { "QUOT", "\"" }, /* U+0022 */
  { "Qfr", "𝔔" }, /* U+1D514 */
  { "Qopf", "ℚ" }, /* U+211A */
  { "Qscr", "𝒬" }, /* U+1D4AC */
  { "RBarr", "⤐" }, /* U+2910 */
  { "REG", "®" }, /* U+00AE */
  { "Racute", "Ŕ" }, /* U+0154 */
  { "Rang", "⟫" }, /* U+27EB */
  { "Rarr", "↠" }, /* U+21A0 */
  { "Rarrtl", "⤖" }, /* U+2916 */
  { "Rcaron", "Ř" }, /* U+0158 */
  { "Rcedil", "Ŗ" }, /* U+0156 */
  { "Rcy", "Р" }, /* U+0420 */
  { "Re", "ℜ" }, /* U+211C */
  { "ReverseElement", "∋" }, /* U+220B */
  { "Rfr", "ℜ" }, /* U+211C */
  { "Rho", "Ρ" }, /* U+03A1 */
  { "RightArrow", "→" }, /* U+2192 */
  { "RightArrowBar", "⇥" }, /* U+21E5 */
  { "RightCeiling", "⌉" }, /* U+2309 */
  { "RightDownVector", "⇂" }, /* U+21C2 */
  { "RightFloor", "⌋" }, /* U+230B */
  { "RightTee", "⊢" }, /* U+22A2 */
  { "RightTeeArrow", "↦" }, /* U+21A6 */
  { "RightTeeVector", "⥛" }, /* U+295B */
  { "RightTriangle", "⊳" }, /* U+22B3 */
  { "RightUpVector", "↾" }, /* U+21BE */
  { "RightVector", "⇀" }, /* U+21C0 */
  { "RightVectorBar", "⥓" }, /* U+2953 */
  { "Rightarrow", "⇒" }, /* U+21D2 */
  { "Ropf", "ℝ" }, /* U+211D */
  { "RoundImplies", "⥰" }, /* U+2970 */
  { "Rrightarrow", "⇛" }, /* U+21DB */
  { "Rscr", "ℛ" }, /* U+211B */
  { "Rsh", "↱" }, /* U+21B1 */
  { "RuleDelayed", "⧴" }, /* U+29F4 */
  { "SHCHcy", "Щ" }, /* U+0429 */
  { "SHcy", "Ш" }, /* U+0428 */
  { "SOFTcy", "Ь" }, /* U+042C */
  { "Sacute", "Ś" }, /* U+015A */
  { "Sc", "⪼" }, /* U+2ABC */
  { "Scaron", "Š" }, /* U+0160 */
  { "Scedil", "Ş" }, /* U+015E */
  { "Scirc", "Ŝ" }, /* U+015C */
  { "Scy", "С" }, /* U+0421 */
  { "Sfr", "𝔖" }, /* U+1D516 */
  { "ShortDownArrow", "↓" }, /* U+2193 */
  { "ShortLeftArrow", "←" }, /* U+2190 */
  { "ShortRightArrow", "→" }, /* U+2192 */
  { "ShortUpArrow", "↑" }, /* U+2191 */
  { "Sigma", "Σ" }, /* U+03A3 */
  { "SmallCircle", "∘" }, /* U+2218 */
  { "Sopf", "𝕊" }, /* U+1D54A */
  { "Sqrt", "√" }, /* U+221A */
  { "Square", "□" }, /* U+25A1 */
  { "SquareSubset", "⊏" }, /* U+228F */
  { "SquareSuperset", "⊐" }, /* U+2290 */
  { "SquareUnion", "⊔" }, /* U+2294 */
  { "Sscr", "𝒮" }, /* U+1D4AE */
  { "Star", "⋆" }, /* U+22C6 */
  { "Sub", "⋐" }, /* U+22D0 */
  { "Subset", "⋐" }, /* U+22D0 */
  { "SubsetEqual", "⊆" }, /* U+2286 */
  { "Succeeds", "≻" }, /* U+227B */
  { "SucceedsEqual", "⪰" }, /* U+2AB0 */
  { "SucceedsTilde", "≿" }, /* U+227F */
  { "SuchThat", "∋" }, /* U+220B */
  { "Sum", "∑" }, /* U+2211 */
  { "Sup", "⋑" }, /* U+22D1 */
  { "Superset", "⊃" }, /* U+2283 */
  { "SupersetEqual", "⊇" }, /* U+2287 */
  { "Supset", "⋑" }, /* U+22D1 */
  { "THORN", "Þ" }, /* U+00DE */
  { "TRADE", "™" }, /* U+2122 */
  { "TSHcy", "Ћ" }, /* U+040B */
  { "TScy", "Ц" }, /* U+0426 */
  { "Tab", "	" }, /* U+0009 */
  { "Tau", "Τ" }, /* U+03A4 */
  { "Tcaron", "Ť" }, /* U+0164 */
  { "Tcedil", "Ţ" }, /* U+0162 */
  { "Tcy", "Т" }, /* U+0422 */
  { "Tfr", "𝔗" }, /* U+1D517 */
  { "Therefore", "∴" }, /* U+2234 */
  { "Theta", "Θ" }, /* U+0398 */
  { "ThickSpace", "  " }, /* U+205F U+200A */
  { "ThinSpace", " " }, /* U+2009 */
  { "Tilde", "∼" }, /* U+223C */
  { "TildeEqual", "≃" }, /* U+2243 */
  { "TildeFullEqual", "≅" }, /* U+2245 */
  { "TildeTilde", "≈" }, /* U+2248 */
  { "Topf", "𝕋" }, /* U+1D54B */
  { "TripleDot", "⃛" }, /* U+20DB */
  { "Tscr", "𝒯" }, /* U+1D4AF */
  { "Tstrok", "Ŧ" }, /* U+0166 */
  { "Uacute", "Ú" }, /* U+00DA */
  { "Uarr", "↟" }, /* U+219F */
  { "Uarrocir", "⥉" }, /* U+2949 */
  { "Ubrcy", "Ў" }, /* U+040E */
  { "Ubreve", "Ŭ" }, /* U+016C */
  { "Ucirc", "Û" }, /* U+00DB */
  { "Ucy", "У" }, /* U+0423 */
  { "Udblac", "Ű" }, /* U+0170 */
  { "Ufr", "𝔘" }, /* U+1D518 */
  { "Ugrave", "Ù" }, /* U+00D9 */
  { "Umacr", "Ū" }, /* U+016A */
  { "UnderBar", "_" }, /* U+005F */
  { "UnderBrace", "⏟" }, /* U+23DF */
  { "UnderBracket", "⎵" }, /* U+23B5 */
  { "Union", "⋃" }, /* U+22C3 */
  { "UnionPlus", "⊎" }, /* U+228E */
  { "Uogon", "Ų" }, /* U+0172 */
  { "Uopf", "𝕌" }, /* U+1D54C */
  { "UpArrow", "↑" }, /* U+2191 */
  { "UpArrowBar", "⤒" }, /* U+2912 */
  { "UpDownArrow", "↕" }, /* U+2195 */
  { "UpEquilibrium", "⥮" }, /* U+296E */
  { "UpTee", "⊥" }, /* U+22A5 */
  { "UpTeeArrow", "↥" }, /* U+21A5 */
  { "Uparrow", "⇑" }, /* U+21D1 */
  { "Updownarrow", "⇕" }, /* U+21D5 */
  { "UpperLeftArrow", "↖" }, /* U+2196 */
  { "UpperRightArrow", "↗" }, /* U+2197 */
  { "Upsi", "ϒ" }, /* U+03D2 */
  { "Upsilon", "Υ" }, /* U+03A5 */
  { "Uring", "Ů" }, /* U+016E */
  { "Uscr", "𝒰" }, /* U+1D4B0 */
  { "Utilde", "Ũ" }, /* U+0168 */
  { "Uuml", "Ü" }, /* U+00DC */
  { "VDash", "⊫" }, /* U+22AB */
  { "Vbar", "⫫" }, /* U+2AEB */
  { "Vcy", "В" }, /* U+0412 */
  { "Vdash", "⊩" }, /* U+22A9 */
  { "Vdashl", "⫦" }, /* U+2AE6 */
  { "Vee", "⋁" }, /* U+22C1 */
  { "Verbar", "‖" }, /* U+2016 */
  { "Vert", "‖" }, /* U+2016 */
  { "VerticalBar", "∣" }, /* U+2223 */
  { "VerticalLine", "|" }, /* U+007C */
  { "VerticalTilde", "≀" }, /* U+2240 */
  { "VeryThinSpace", " " }, /* U+200A */
  { "Vfr", "𝔙" }, /* U+1D519 */
  { "Vopf", "𝕍" }, /* U+1D54D */
  { "Vscr", "𝒱" }, /* U+1D4B1 */
  { "Vvdash", "⊪" }, /* U+22AA */
  { "Wcirc", "Ŵ" }, /* U+0174 */
  { "Wedge", "⋀" }, /* U+22C0 */
  { "Wfr", "𝔚" }, /* U+1D51A */
  { "Wopf", "𝕎" }, /* U+1D54E */
  { "Wscr", "𝒲" }, /* U+1D4B2 */
  { "Xfr", "𝔛" }, /* U+1D51B */
  { "Xi", "Ξ" }, /* U+039E */
  { "Xopf", "𝕏" }, /* U+1D54F */
  { "Xscr", "𝒳" }, /* U+1D4B3 */
  { "YAcy", "Я" }, /* U+042F */
  { "YIcy", "Ї" }, /* U+0407 */
  { "YUcy", "Ю" }, /* U+042E */
  { "Yacute", "Ý" }, /* U+00DD */
  { "Ycirc", "Ŷ" }, /* U+0176 */
  { "Ycy", "Ы" }, /* U+042B */
  { "Yfr", "𝔜" }, /* U+1D51C */
  { "Yopf", "𝕐" }, /* U+1D550 */
  { "Yscr", "𝒴" }, /* U+1D4B4 */
  { "Yuml", "Ÿ" }, /* U+0178 */
  { "ZHcy", "Ж" }, /* U+0416 */
  { "Zacute", "Ź" }, /* U+0179 */
  { "Zcaron", "Ž" }, /* U+017D */
  { "Zcy", "З" }, /* U+0417 */
  { "Zdot", "Ż" }, /* U+017B */
  { "ZeroWidthSpace", "​" }, /* U+200B */
  { "Zeta", "Ζ" }, /* U+0396 */
  { "Zfr", "ℨ" }, /* U+2128 */
  { "Zopf", "ℤ" }, /* U+2124 */
  { "Zscr", "𝒵" }, /* U+1D4B5 */
  { "aacute", "á" }, /* U+00E1 */
  { "abreve", "ă" }, /* U+0103 */
  { "ac", "∾" }, /* U+223E */
  { "acE", "∾̳" }, /* U+223E U+0333 */
  { "acd", "∿" }, /* U+223F */
  { "acirc", "â" }, /* U+00E2 */
  { "acute", "´" }, /* U+00B4 */
  { "acy", "а" }, /* U+0430 */
  { "aelig", "æ" }, /* U+00E6 */
  { "af", "⁡" }, /* U+2061 */
  { "afr", "𝔞" }, /* U+1D51E */
  { "agrave", "à" }, /* U+00E0 */
  { "alefsym", "ℵ" }, /* U+2135 */
  { "aleph", "ℵ" }, /* U+2135 */
  { "alpha", "α" }, /* U+03B1 */
  { "amacr", "ā" }, /* U+0101 */
  { "amalg", "⨿" }, /* U+2A3F */
  { "amp", "&" }, /* U+0026 */
  { "and", "∧" }, /* U+2227 */
  { "andand", "⩕" }, /* U+2A55 */
  { "andd", "⩜" }, /* U+2A5C */
  { "andslope", "⩘" }, /* U+2A58 */
  { "andv", "⩚" }, /* U+2A5A */
  { "ang", "∠" }, /* U+2220 */
  { "ange", "⦤" }, /* U+29A4 */
  { "angle", "∠" }, /* U+2220 */
  { "angmsd", "∡" }, /* U+2221 */
  { "angmsdaa", "⦨" }, /* U+29A8 */
  { "angmsdab", "⦩" }, /* U+29A9 */
  { "angmsdac", "⦪" }, /* U+29AA */
  { "angmsdad", "⦫" }, /* U+29AB */
  { "angmsdae", "⦬" }, /* U+29AC */
  { "angmsdaf", "⦭" }, /* U+29AD */
  { "angmsdag", "⦮" }, /* U+29AE */
  { "angmsdah", "⦯" }, /* U+29AF */
  { "angrt", "∟" }, /* U+221F */
  { "angrtvb", "⊾" }, /* U+22BE */
  { "angrtvbd", "⦝" }, /* U+299D */
  { "angsph", "∢" }, /* U+2222 */
  { "angst", "Å" }, /* U+00C5 */
  { "angzarr", "⍼" }, /* U+237C */
  { "aogon", "ą" }, /* U+0105 */
  { "aopf", "𝕒" }, /* U+1D552 */
  { "ap", "≈" }, /* U+2248 */
  { "apE", "⩰" }, /* U+2A70 */
  { "apacir", "⩯" }, /* U+2A6F */
  { "ape", "≊" }, /* U+224A */
  { "apid", "≋" }, /* U+224B */
  { "apos", "'" }, /* U+0027 */
  { "approx", "≈" }, /* U+2248 */
  { "approxeq", "≊" }, /* U+224A */
  { "aring", "å" }, /* U+00E5 */
  { "ascr", "𝒶" }, /* U+1D4B6 */
  { "ast", "*" }, /* U+002A */
  { "asymp", "≈" }, /* U+2248 */
  { "asympeq", "≍" }, /* U+224D */
  { "atilde", "ã" }, /* U+00E3 */
  { "auml", "ä" }, /* U+00E4 */
  { "awconint", "∳" }, /* U+2233 */
  { "awint", "⨑" }, /* U+2A11 */
  { "bNot", "⫭" }, /* U+2AED */
  { "backcong", "≌" }, /* U+224C */
  { "backepsilon", "϶" }, /* U+03F6 */
  { "backprime", "‵" }, /* U+2035 */
  { "backsim", "∽" }, /* U+223D */
  { "backsimeq", "⋍" }, /* U+22CD */
  { "barvee", "⊽" }, /* U+22BD */
  { "barwed", "⌅" }, /* U+2305 */
  { "barwedge", "⌅" }, /* U+2305 */
  { "bbrk", "⎵" }, /* U+23B5 */
  { "bbrktbrk", "⎶" }, /* U+23B6 */
  { "bcong", "≌" }, /* U+224C */
  { "bcy", "б" }, /* U+0431 */
  { "bdquo", "„" }, /* U+201E */
  { "becaus", "∵" }, /* U+2235 */
  { "because", "∵" }, /* U+2235 */
  { "bemptyv", "⦰" }, /* U+29B0 */
  { "bepsi", "϶" }, /* U+03F6 */
  { "bernou", "ℬ" }, /* U+212C */
  { "beta", "β" }, /* U+03B2 */
  { "beth", "ℶ" }, /* U+2136 */
  { "between", "≬" }, /* U+226C */
  { "bfr", "𝔟" }, /* U+1D51F */
  { "bigcap", "⋂" }, /* U+22C2 */
  { "bigcirc", "◯" }, /* U+25EF */
  { "bigcup", "⋃" }, /* U+22C3 */
  { "bigodot", "⨀" }, /* U+2A00 */
  { "bigoplus", "⨁" }, /* U+2A01 */
  { "bigotimes", "⨂" }, /* U+2A02 */
  { "bigsqcup", "⨆" }, /* U+2A06 */
  { "bigstar", "★" }, /* U+2605 */
  { "bigtriangledown", "▽" }, /* U+25BD */
  { "bigtriangleup", "△" }, /* U+25B3 */
  { "biguplus", "⨄" }, /* U+2A04 */
  { "bigvee", "⋁" }, /* U+22C1 */
  { "bigwedge", "⋀" }, /* U+22C0 */
  { "bkarow", "⤍" }, /* U+290D */
  { "blacklozenge", "⧫" }, /* U+29EB */
  { "blacksquare", "▪" }, /* U+25AA */
  { "blacktriangle", "▴" }, /* U+25B4 */
  { "blank", "␣" }, /* U+2423 */
  { "blk12", "▒" }, /* U+2592 */
  { "blk14", "░" }, /* U+2591 */
  { "blk34", "▓" }, /* U+2593 */
  { "block", "█" }, /* U+2588 */
  { "bne", "=⃥" }, /* U+003D U+20E5 */
  { "bnequiv", "≡⃥" }, /* U+2261 U+20E5 */
  { "bnot", "⌐" }, /* U+2310 */
  { "bopf", "𝕓" }, /* U+1D553 */
  { "bot", "⊥" }, /* U+22A5 */
  { "bottom", "⊥" }, /* U+22A5 */
  { "bowtie", "⋈" }, /* U+22C8 */
  { "boxDL", "╗" }, /* U+2557 */
  { "boxDR", "╔" }, /* U+2554 */
  { "boxDl", "╖" }, /* U+2556 */
  { "boxDr", "╓" }, /* U+2553 */
  { "boxH", "═" }, /* U+2550 */
  { "boxHD", "╦" }, /* U+2566 */
  { "boxHU", "╩" }, /* U+2569 */
  { "boxHd", "╤" }, /* U+2564 */
  { "boxHu", "╧" }, /* U+2567 */
  { "boxUL", "╝" }, /* U+255D */
  { "boxUR", "╚" }, /* U+255A */
  { "boxUl", "╜" }, /* U+255C */
  { "boxUr", "╙" }, /* U+2559 */
  { "boxV", "║" }, /* U+2551 */
  { "boxVH", "╬" }, /* U+256C */
  { "boxVL", "╣" }, /* U+2563 */
  { "boxVR", "╠" }, /* U+2560 */
  { "boxVh", "╫" }, /* U+256B */
  { "boxVl", "╢" }, /* U+2562 */
  { "boxVr", "╟" }, /* U+255F */
  { "boxbox", "⧉" }, /* U+29C9 */
  { "boxdL", "╕" }, /* U+2555 */
  { "boxdR", "╒" }, /* U+2552 */
  { "boxdl", "┐" }, /* U+2510 */
  { "boxdr", "┌" }, /* U+250C */
  { "boxh", "─" }, /* U+2500 */
  { "boxhD", "╥" }, /* U+2565 */
  { "boxhU", "╨" }, /* U+2568 */
  { "boxhd", "┬" }, /* U+252C */
  { "boxhu", "┴" }, /* U+2534 */
  { "boxminus", "⊟" }, /* U+229F */
  { "boxplus", "⊞" }, /* U+229E */
  { "boxtimes", "⊠" }, /* U+22A0 */
  { "boxuL", "╛" }, /* U+255B */
  { "boxuR", "╘" }, /* U+2558 */
  { "boxul", "┘" }, /* U+2518 */
  { "boxur", "└" }, /* U+2514 */
  { "boxv", "│" }, /* U+2502 */
  { "boxvH", "╪" }, /* U+256A */
  { "boxvL", "╡" }, /* U+2561 */
  { "boxvR", "╞" }, /* U+255E */
  { "boxvh", "┼" }, /* U+253C */
  { "boxvl", "┤" }, /* U+2524 */
  { "boxvr", "├" }, /* U+251C */
  { "bprime", "‵" }, /* U+2035 */
  { "breve", "˘" }, /* U+02D8 */
  { "brvbar", "¦" }, /* U+00A6 */
  { "bscr", "𝒷" }, /* U+1D4B7 */
  { "bsemi", "⁏" }, /* U+204F */
  { "bsim", "∽" }, /* U+223D */
  { "bsime", "⋍" }, /* U+22CD */
  { "bsol", "\\" }, /* U+005C */
  { "bsolb", "⧅" }, /* U+29C5 */
  { "bsolhsub", "⟈" }, /* U+27C8 */
  { "bull", "•" }, /* U+2022 */
  { "bullet", "•" }, /* U+2022 */
  { "bump", "≎" }, /* U+224E */
  { "bumpE", "⪮" }, /* U+2AAE */
  { "bumpe", "≏" }, /* U+224F */
  { "bumpeq", "≏" }, /* U+224F */
  { "cacute", "ć" }, /* U+0107 */
  { "cap", "∩" }, /* U+2229 */
  { "capand", "⩄" }, /* U+2A44 */
  { "capbrcup", "⩉" }, /* U+2A49 */
  { "capcap", "⩋" }, /* U+2A4B */
  { "capcup", "⩇" }, /* U+2A47 */
  { "capdot", "⩀" }, /* U+2A40 */
  { "caps", "∩︀" }, /* U+2229 U+FE00 */
  { "caret", "⁁" }, /* U+2041 */
  { "caron", "ˇ" }, /* U+02C7 */
  { "ccaps", "⩍" }, /* U+2A4D */
  { "ccaron", "č" }, /* U+010D */
  { "ccedil", "ç" }, /* U+00E7 */
  { "ccirc", "ĉ" }, /* U+0109 */
  { "ccups", "⩌" }, /* U+2A4C */
  { "ccupssm", "⩐" }, /* U+2A50 */
  { "cdot", "ċ" }, /* U+010B */
  { "cedil", "¸" }, /* U+00B8 */
  { "cemptyv", "⦲" }, /* U+29B2 */
  { "cent", "¢" }, /* U+00A2 */
  { "centerdot", "·" }, /* U+00B7 */
  { "cfr", "𝔠" }, /* U+1D520 */
  { "chcy", "ч" }, /* U+0447 */
  { "check", "✓" }, /* U+2713 */
  { "checkmark", "✓" }, /* U+2713 */
  { "chi", "χ" }, /* U+03C7 */
  { "cir", "○" }, /* U+25CB */
  { "cirE", "⧃" }, /* U+29C3 */
  { "circ", "ˆ" }, /* U+02C6 */
  { "circeq", "≗" }, /* U+2257 */
  { "circlearrowleft", "↺" }, /* U+21BA */
  { "circledR", "®" }, /* U+00AE */
  { "circledS", "Ⓢ" }, /* U+24C8 */
  { "circledast", "⊛" }, /* U+229B */
  { "circledcirc", "⊚" }, /* U+229A */
  { "circleddash", "⊝" }, /* U+229D */
  { "cire", "≗" }, /* U+2257 */
  { "cirfnint", "⨐" }, /* U+2A10 */
  { "cirmid", "⫯" }, /* U+2AEF */
  { "cirscir", "⧂" }, /* U+29C2 */
  { "clubs", "♣" }, /* U+2663 */
  { "clubsuit", "♣" }, /* U+2663 */
  { "colon", ":" }, /* U+003A */
  { "colone", "≔" }, /* U+2254 */
  { "coloneq", "≔" }, /* U+2254 */
  { "comma", "," }, /* U+002C */
  { "commat", "@" }, /* U+0040 */
  { "comp", "∁" }, /* U+2201 */
  { "compfn", "∘" }, /* U+2218 */
  { "complement", "∁" }, /* U+2201 */
  { "complexes", "ℂ" }, /* U+2102 */
  { "cong", "≅" }, /* U+2245 */
  { "congdot", "⩭" }, /* U+2A6D */
  { "conint", "∮" }, /* U+222E */
  { "copf", "𝕔" }, /* U+1D554 */
  { "coprod", "∐" }, /* U+2210 */
  { "copy", "©" }, /* U+00A9 */
  { "copysr", "℗" }, /* U+2117 */
  { "crarr", "↵" }, /* U+21B5 */
  { "cross", "✗" }, /* U+2717 */
  { "cscr", "𝒸" }, /* U+1D4B8 */
  { "csub", "⫏" }, /* U+2ACF */
  { "csube", "⫑" }, /* U+2AD1 */
  { "csup", "⫐" }, /* U+2AD0 */
  { "csupe", "⫒" }, /* U+2AD2 */
  { "ctdot", "⋯" }, /* U+22EF */
  { "cudarrl", "⤸" }, /* U+2938 */
  { "cudarrr", "⤵" }, /* U+2935 */
  { "cuepr", "⋞" }, /* U+22DE */
  { "cuesc", "⋟" }, /* U+22DF */
  { "cularr", "↶" }, /* U+21B6 */
  { "cularrp", "⤽" }, /* U+293D */
  { "cup", "∪" }, /* U+222A */
  { "cupbrcap", "⩈" }, /* U+2A48 */
  { "cupcap", "⩆" }, /* U+2A46 */
  { "cupcup", "⩊" }, /* U+2A4A */
  { "cupdot", "⊍" }, /* U+228D */
  { "cupor", "⩅" }, /* U+2A45 */
  { "cups", "∪︀" }, /* U+222A U+FE00 */
  { "curarr", "↷" }, /* U+21B7 */
  { "curarrm", "⤼" }, /* U+293C */
  { "curlyeqprec", "⋞" }, /* U+22DE */
  { "curlyeqsucc", "⋟" }, /* U+22DF */
  { "curlyvee", "⋎" }, /* U+22CE */
  { "curlywedge", "⋏" }, /* U+22CF */
  { "curren", "¤" }, /* U+00A4 */
  { "curvearrowleft", "↶" }, /* U+21B6 */
  { "curvearrowright", "↷" }, /* U+21B7 */
  { "cuvee", "⋎" }, /* U+22CE */
  { "cuwed", "⋏" }, /* U+22CF */
  { "cwconint", "∲" }, /* U+2232 */
  { "cwint", "∱" }, /* U+2231 */
  { "cylcty", "⌭" }, /* U+232D */
  { "dArr", "⇓" }, /* U+21D3 */
  { "dHar", "⥥" }, /* U+2965 */
  { "dagger", "†" }, /* U+2020 */
  { "daleth", "ℸ" }, /* U+2138 */
  { "darr", "↓" }, /* U+2193 */
  { "dash", "‐" }, /* U+2010 */
  { "dashv", "⊣" }, /* U+22A3 */
  { "dbkarow", "⤏" }, /* U+290F */
  { "dblac", "˝" }, /* U+02DD */
  { "dcaron", "ď" }, /* U+010F */
  { "dcy", "д" }, /* U+0434 */
  { "dd", "ⅆ" }, /* U+2146 */
  { "ddagger", "‡" }, /* U+2021 */
  { "ddarr", "⇊" }, /* U+21CA */
  { "ddotseq", "⩷" }, /* U+2A77 */
  { "deg", "°" }, /* U+00B0 */
  { "delta", "δ" }, /* U+03B4 */
  { "demptyv", "⦱" }, /* U+29B1 */
  { "dfisht", "⥿" }, /* U+297F */
  { "dfr", "𝔡" }, /* U+1D521 */
  { "dharl", "⇃" }, /* U+21C3 */
  { "dharr", "⇂" }, /* U+21C2 */
  { "diam", "⋄" }, /* U+22C4 */
  { "diamond", "⋄" }, /* U+22C4 */
  { "diamondsuit", "♦" }, /* U+2666 */
  { "diams", "♦" }, /* U+2666 */
  { "die", "¨" }, /* U+00A8 */
  { "digamma", "ϝ" }, /* U+03DD */
  { "disin", "⋲" }, /* U+22F2 */
  { "div", "÷" }, /* U+00F7 */
  { "divide", "÷" }, /* U+00F7 */
  { "divideontimes", "⋇" }, /* U+22C7 */
  { "divonx", "⋇" }, /* U+22C7 */
  { "djcy", "ђ" }, /* U+0452 */
  { "dlcorn", "⌞" }, /* U+231E */
  { "dlcrop", "⌍" }, /* U+230D */
  { "dollar", "$" }, /* U+0024 */
  { "dopf", "𝕕" }, /* U+1D555 */
  { "dot", "˙" }, /* U+02D9 */
  { "doteq", "≐" }, /* U+2250 */
  { "doteqdot", "≑" }, /* U+2251 */
  { "dotminus", "∸" }, /* U+2238 */
  { "dotplus", "∔" }, /* U+2214 */
  { "dotsquare", "⊡" }, /* U+22A1 */
  { "doublebarwedge", "⌆" }, /* U+2306 */
  { "downarrow", "↓" }, /* U+2193 */
  { "downdownarrows", "⇊" }, /* U+21CA */
  { "downharpoonleft", "⇃" }, /* U+21C3 */
  { "drbkarow", "⤐" }, /* U+2910 */
  { "drcorn", "⌟" }, /* U+231F */
  { "drcrop", "⌌" }, /* U+230C */
  { "dscr", "𝒹" }, /* U+1D4B9 */
  { "dscy", "ѕ" }, /* U+0455 */
  { "dsol", "⧶" }, /* U+29F6 */
  { "dstrok", "đ" }, /* U+0111 */
  { "dtdot", "⋱" }, /* U+22F1 */
  { "dtri", "▿" }, /* U+25BF */
  { "dtrif", "▾" }, /* U+25BE */
  { "duarr", "⇵" }, /* U+21F5 */
  { "duhar", "⥯" }, /* U+296F */
  { "dwangle", "⦦" }, /* U+29A6 */
  { "dzcy", "џ" }, /* U+045F */
  { "dzigrarr", "⟿" }, /* U+27FF */
  { "eDDot", "⩷" }, /* U+2A77 */
  { "eDot", "≑" }, /* U+2251 */
  { "eacute", "é" }, /* U+00E9 */
  { "easter", "⩮" }, /* U+2A6E */
  { "ecaron", "ě" }, /* U+011B */
  { "ecir", "≖" }, /* U+2256 */
  { "ecirc", "ê" }, /* U+00EA */
  { "ecolon", "≕" }, /* U+2255 */
  { "ecy", "э" }, /* U+044D */
  { "edot", "ė" }, /* U+0117 */
  { "ee", "ⅇ" }, /* U+2147 */
  { "efDot", "≒" }, /* U+2252 */
  { "efr", "𝔢" }, /* U+1D522 */
  { "eg", "⪚" }, /* U+2A9A */
  { "egrave", "è" }, /* U+00E8 */
  { "egs", "⪖" }, /* U+2A96 */
  { "egsdot", "⪘" }, /* U+2A98 */
  { "el", "⪙" }, /* U+2A99 */
  { "elinters", "⏧" }, /* U+23E7 */
  { "ell", "ℓ" }, /* U+2113 */
  { "els", "⪕" }, /* U+2A95 */
  { "elsdot", "⪗" }, /* U+2A97 */
  { "emacr", "ē" }, /* U+0113 */
  { "empty", "∅" }, /* U+2205 */
  { "emptyset", "∅" }, /* U+2205 */
  { "emptyv", "∅" }, /* U+2205 */
  { "emsp", " " }, /* U+2003 */
  { "emsp13", " " }, /* U+2004 */
  { "emsp14", " " }, /* U+2005 */
  { "eng", "ŋ" }, /* U+014B */
  { "ensp", " " }, /* U+2002 */
  { "eogon", "ę" }, /* U+0119 */
  { "eopf", "𝕖" }, /* U+1D556 */
  { "epar", "⋕" }, /* U+22D5 */
  { "eparsl", "⧣" }, /* U+29E3 */
  { "eplus", "⩱" }, /* U+2A71 */
  { "epsi", "ε" }, /* U+03B5 */
  { "epsilon", "ε" }, /* U+03B5 */
  { "epsiv", "ϵ" }, /* U+03F5 */
  { "eqcirc", "≖" }, /* U+2256 */
  { "eqcolon", "≕" }, /* U+2255 */
  { "eqsim", "≂" }, /* U+2242 */
  { "eqslantgtr", "⪖" }, /* U+2A96 */
  { "eqslantless", "⪕" }, /* U+2A95 */
  { "equals", "=" }, /* U+003D */
  { "equest", "≟" }, /* U+225F */
  { "equiv", "≡" }, /* U+2261 */
  { "equivDD", "⩸" }, /* U+2A78 */
  { "eqvparsl", "⧥" }, /* U+29E5 */
  { "erDot", "≓" }, /* U+2253 */
  { "erarr", "⥱" }, /* U+2971 */
  { "escr", "ℯ" }, /* U+212F */
  { "esdot", "≐" }, /* U+2250 */
  { "esim", "≂" }, /* U+2242 */
  { "eta", "η" }, /* U+03B7 */
  { "eth", "ð" }, /* U+00F0 */
  { "euml", "ë" }, /* U+00EB */
  { "euro", "€" }, /* U+20AC */
  { "excl", "!" }, /* U+0021 */
  { "exist", "∃" }, /* U+2203 */
  { "expectation", "ℰ" }, /* U+2130 */
  { "exponentiale", "ⅇ" }, /* U+2147 */
  { "fallingdotseq", "≒" }, /* U+2252 */
  { "fcy", "ф" }, /* U+0444 */
  { "female", "♀" }, /* U+2640 */
  { "ffilig", "ﬃ" }, /* U+FB03 */
  { "fflig", "ﬀ" }, /* U+FB00 */
  { "ffllig", "ﬄ" }, /* U+FB04 */
  { "ffr", "𝔣" }, /* U+1D523 */
  { "filig", "ﬁ" }, /* U+FB01 */
  { "fjlig", "fj" }, /* U+0066 U+006A */
  { "flat", "♭" }, /* U+266D */
  { "fllig", "ﬂ" }, /* U+FB02 */
  { "fltns", "▱" }, /* U+25B1 */
  { "fnof", "ƒ" }, /* U+0192 */
  { "fopf", "𝕗" }, /* U+1D557 */
  { "forall", "∀" }, /* U+2200 */
  { "fork", "⋔" }, /* U+22D4 */
  { "forkv", "⫙" }, /* U+2AD9 */
  { "fpartint", "⨍" }, /* U+2A0D */
  { "frac12", "½" }, /* U+00BD */
  { "frac13", "⅓" }, /* U+2153 */
  { "frac14", "¼" }, /* U+00BC */
  { "frac15", "⅕" }, /* U+2155 */
  { "frac16", "⅙" }, /* U+2159 */
  { "frac18", "⅛" }, /* U+215B */
  { "frac23", "⅔" }, /* U+2154 */
  { "frac25", "⅖" }, /* U+2156 */
  { "frac34", "¾" }, /* U+00BE */
  { "frac35", "⅗" }, /* U+2157 */
  { "frac38", "⅜" }, /* U+215C */
  { "frac45", "⅘" }, /* U+2158 */
  { "frac56", "⅚" }, /* U+215A */
  { "frac58", "⅝" }, /* U+215D */
  { "frac78", "⅞" }, /* U+215E */
  { "frasl", "⁄" }, /* U+2044 */
  { "frown", "⌢" }, /* U+2322 */
  { "fscr", "𝒻" }, /* U+1D4BB */
  { "gE", "≧" }, /* U+2267 */
  { "gEl", "⪌" }, /* U+2A8C */
  { "gacute", "ǵ" }, /* U+01F5 */
  { "gamma", "γ" }, /* U+03B3 */
  { "gammad", "ϝ" }, /* U+03DD */
  { "gap", "⪆" }, /* U+2A86 */
  { "gbreve", "ğ" }, /* U+011F */
  { "gcirc", "ĝ" }, /* U+011D */
  { "gcy", "г" }, /* U+0433 */
  { "gdot", "ġ" }, /* U+0121 */
  { "ge", "≥" }, /* U+2265 */
  { "gel", "⋛" }, /* U+22DB */
  { "geq", "≥" }, /* U+2265 */
  { "geqq", "≧" }, /* U+2267 */
  { "geqslant", "⩾" }, /* U+2A7E */
  { "ges", "⩾" }, /* U+2A7E */
  { "gescc", "⪩" }, /* U+2AA9 */
  { "gesdot", "⪀" }, /* U+2A80 */
  { "gesdoto", "⪂" }, /* U+2A82 */
  { "gesdotol", "⪄" }, /* U+2A84 */
  { "gesl", "⋛︀" }, /* U+22DB U+FE00 */
  { "gesles", "⪔" }, /* U+2A94 */
  { "gfr", "𝔤" }, /* U+1D524 */
  { "gg", "≫" }, /* U+226B */
  { "ggg", "⋙" }, /* U+22D9 */
  { "gimel", "ℷ" }, /* U+2137 */
  { "gjcy", "ѓ" }, /* U+0453 */
  { "gl", "≷" }, /* U+2277 */
  { "glE", "⪒" }, /* U+2A92 */
  { "gla", "⪥" }, /* U+2AA5 */
  { "glj", "⪤" }, /* U+2AA4 */
  { "gnE", "≩" }, /* U+2269 */
  { "gnap", "⪊" }, /* U+2A8A */
  { "gnapprox", "⪊" }, /* U+2A8A */
  { "gne", "⪈" }, /* U+2A88 */
  { "gneq", "⪈" }, /* U+2A88 */
  { "gneqq", "≩" }, /* U+2269 */
  { "gnsim", "⋧" }, /* U+22E7 */
  { "gopf", "𝕘" }, /* U+1D558 */
  { "grave", "`" }, /* U+0060 */
  { "gscr", "ℊ" }, /* U+210A */
  { "gsim", "≳" }, /* U+2273 */
  { "gsime", "⪎" }, /* U+2A8E */
  { "gsiml", "⪐" }, /* U+2A90 */
  { "gt", ">" }, /* U+003E */
  { "gtcc", "⪧" }, /* U+2AA7 */
  { "gtcir", "⩺" }, /* U+2A7A */
  { "gtdot", "⋗" }, /* U+22D7 */
  { "gtlPar", "⦕" }, /* U+2995 */
  { "gtquest", "⩼" }, /* U+2A7C */
  { "gtrapprox", "⪆" }, /* U+2A86 */
  { "gtrarr", "⥸" }, /* U+2978 */
  { "gtrdot", "⋗" }, /* U+22D7 */
  { "gtreqless", "⋛" }, /* U+22DB */
  { "gtreqqless", "⪌" }, /* U+2A8C */
  { "gtrless", "≷" }, /* U+2277 */
  { "gtrsim", "≳" }, /* U+2273 */
  { "gvertneqq", "≩︀" }, /* U+2269 U+FE00 */
  { "gvnE", "≩︀" }, /* U+2269 U+FE00 */
  { "hArr", "⇔" }, /* U+21D4 */
  { "hairsp", " " }, /* U+200A */
  { "half", "½" }, /* U+00BD */
  { "hamilt", "ℋ" }, /* U+210B */
  { "hardcy", "ъ" }, /* U+044A */
  { "harr", "↔" }, /* U+2194 */
  { "harrcir", "⥈" }, /* U+2948 */
  { "harrw", "↭" }, /* U+21AD */
  { "hbar", "ℏ" }, /* U+210F */
  { "hcirc", "ĥ" }, /* U+0125 */
  { "hearts", "♥" }, /* U+2665 */
  { "heartsuit", "♥" }, /* U+2665 */
  { "hellip", "…" }, /* U+2026 */
  { "hercon", "⊹" }, /* U+22B9 */
  { "hfr", "𝔥" }, /* U+1D525 */
  { "hksearow", "⤥" }, /* U+2925 */
  { "hkswarow", "⤦" }, /* U+2926 */
  { "hoarr", "⇿" }, /* U+21FF */
  { "homtht", "∻" }, /* U+223B */
  { "hookleftarrow", "↩" }, /* U+21A9 */
  { "hookrightarrow", "↪" }, /* U+21AA */
  { "hopf", "𝕙" }, /* U+1D559 */
  { "horbar", "―" }, /* U+2015 */
  { "hscr", "𝒽" }, /* U+1D4BD */
  { "hslash", "ℏ" }, /* U+210F */
  { "hstrok", "ħ" }, /* U+0127 */
  { "hybull", "⁃" }, /* U+2043 */
  { "hyphen", "‐" }, /* U+2010 */
  { "iacute", "í" }, /* U+00ED */
  { "ic", "⁣" }, /* U+2063 */
  { "icirc", "î" }, /* U+00EE */
  { "icy", "и" }, /* U+0438 */
  { "iecy", "е" }, /* U+0435 */
  { "iexcl", "¡" }, /* U+00A1 */
  { "iff", "⇔" }, /* U+21D4 */
  { "ifr", "𝔦" }, /* U+1D526 */
  { "igrave", "ì" }, /* U+00EC */
  { "ii", "ⅈ" }, /* U+2148 */
  { "iiiint", "⨌" }, /* U+2A0C */
  { "iiint", "∭" }, /* U+222D */
  { "iinfin", "⧜" }, /* U+29DC */
  { "iiota", "℩" }, /* U+2129 */
  { "ijlig", "ĳ" }, /* U+0133 */
  { "imacr", "ī" }, /* U+012B */
  { "image", "ℑ" }, /* U+2111 */
  { "imagline", "ℐ" }, /* U+2110 */
  { "imagpart", "ℑ" }, /* U+2111 */
  { "imath", "ı" }, /* U+0131 */
  { "imof", "⊷" }, /* U+22B7 */
  { "imped", "Ƶ" }, /* U+01B5 */
  { "in", "∈" }, /* U+2208 */
  { "incare", "℅" }, /* U+2105 */
  { "infin", "∞" }, /* U+221E */
  { "infintie", "⧝" }, /* U+29DD */
  { "inodot", "ı" }, /* U+0131 */
  { "int", "∫" }, /* U+222B */
  { "intcal", "⊺" }, /* U+22BA */
  { "integers", "ℤ" }, /* U+2124 */
  { "intercal", "⊺" }, /* U+22BA */
  { "intlarhk", "⨗" }, /* U+2A17 */
  { "intprod", "⨼" }, /* U+2A3C */
  { "iocy", "ё" }, /* U+0451 */
  { "iogon", "į" }, /* U+012F */
  { "iopf", "𝕚" }, /* U+1D55A */
  { "iota", "ι" }, /* U+03B9 */
  { "iprod", "⨼" }, /* U+2A3C */
  { "iquest", "¿" }, /* U+00BF */
  { "iscr", "𝒾" }, /* U+1D4BE */
  { "isin", "∈" }, /* U+2208 */
  { "isinE", "⋹" }, /* U+22F9 */
  { "isindot", "⋵" }, /* U+22F5 */
  { "isins", "⋴" }, /* U+22F4 */
  { "isinsv", "⋳" }, /* U+22F3 */
  { "isinv", "∈" }, /* U+2208 */
  { "it", "⁢" }, /* U+2062 */
  { "itilde", "ĩ" }, /* U+0129 */
  { "iukcy", "і" }, /* U+0456 */
  { "iuml", "ï" }, /* U+00EF */
  { "jcirc", "ĵ" }, /* U+0135 */
  { "jcy", "й" }, /* U+0439 */
  { "jfr", "𝔧" }, /* U+1D527 */
  { "jmath", "ȷ" }, /* U+0237 */
  { "jopf", "𝕛" }, /* U+1D55B */
  { "jscr", "𝒿" }, /* U+1D4BF */
  { "jsercy", "ј" }, /* U+0458 */
  { "jukcy", "є" }, /* U+0454 */
  { "kappa", "κ" }, /* U+03BA */
  { "kappav", "ϰ" }, /* U+03F0 */
  { "kcedil", "ķ" }, /* U+0137 */
  { "kcy", "к" }, /* U+043A */
  { "kfr", "𝔨" }, /* U+1D528 */
  { "kgreen", "ĸ" }, /* U+0138 */
  { "khcy", "х" }, /* U+0445 */
  { "kjcy", "ќ" }, /* U+045C */
  { "kopf", "𝕜" }, /* U+1D55C */
  { "kscr", "𝓀" }, /* U+1D4C0 */
  { "lAarr", "⇚" }, /* U+21DA */
  { "lArr", "⇐" }, /* U+21D0 */
  { "lAtail", "⤛" }, /* U+291B */
  { "lBarr", "⤎" }, /* U+290E */
  { "lE", "≦" }, /* U+2266 */
  { "lEg", "⪋" }, /* U+2A8B */
  { "lHar", "⥢" }, /* U+2962 */
  { "lacute", "ĺ" }, /* U+013A */
  { "laemptyv", "⦴" }, /* U+29B4 */
  { "lagran", "ℒ" }, /* U+2112 */
  { "lambda", "λ" }, /* U+03BB */
  { "lang", "⟨" }, /* U+27E8 */
  { "langd", "⦑" }, /* U+2991 */
  { "langle", "⟨" }, /* U+27E8 */
  { "lap", "⪅" }, /* U+2A85 */
  { "laquo", "«" }, /* U+00AB */
  { "larr", "←" }, /* U+2190 */
  { "larrb", "⇤" }, /* U+21E4 */
  { "larrbfs", "⤟" }, /* U+291F */
  { "larrfs", "⤝" }, /* U+291D */
  { "larrhk", "↩" }, /* U+21A9 */
  { "larrlp", "↫" }, /* U+21AB */
  { "larrpl", "⤹" }, /* U+2939 */
  { "larrsim", "⥳" }, /* U+2973 */
  { "larrtl", "↢" }, /* U+21A2 */
  { "lat", "⪫" }, /* U+2AAB */
  { "latail", "⤙" }, /* U+2919 */
  { "late", "⪭" }, /* U+2AAD */
  { "lates", "⪭︀" }, /* U+2AAD U+FE00 */
  { "lbarr", "⤌" }, /* U+290C */
  { "lbbrk", "❲" }, /* U+2772 */
  { "lbrace", "{" }, /* U+007B */
  { "lbrack", "[" }, /* U+005B */
  { "lbrke", "⦋" }, /* U+298B */
  { "lbrksld", "⦏" }, /* U+298F */
  { "lbrkslu", "⦍" }, /* U+298D */
  { "lcaron", "ľ" }, /* U+013E */
  { "lcedil", "ļ" }, /* U+013C */
  { "lceil", "⌈" }, /* U+2308 */
  { "lcub", "{" }, /* U+007B */
  { "lcy", "л" }, /* U+043B */
  { "ldca", "⤶" }, /* U+2936 */
  { "ldquo", "“" }, /* U+201C */
  { "ldquor", "„" }, /* U+201E */
  { "ldrdhar", "⥧" }, /* U+2967 */
  { "ldrushar", "⥋" }, /* U+294B */
  { "ldsh", "↲" }, /* U+21B2 */
  { "le", "≤" }, /* U+2264 */
  { "leftarrow", "←" }, /* U+2190 */
  { "leftarrowtail", "↢" }, /* U+21A2 */
  { "leftharpoondown", "↽" }, /* U+21BD */
  { "leftharpoonup", "↼" }, /* U+21BC */
  { "leftleftarrows", "⇇" }, /* U+21C7 */
  { "leftrightarrow", "↔" }, /* U+2194 */
  { "leftrightarrows", "⇆" }, /* U+21C6 */
  { "leftthreetimes", "⋋" }, /* U+22CB */
  { "leg", "⋚" }, /* U+22DA */
  { "leq", "≤" }, /* U+2264 */
  { "leqq", "≦" }, /* U+2266 */
  { "leqslant", "⩽" }, /* U+2A7D */
  { "les", "⩽" }, /* U+2A7D */
  { "lescc", "⪨" }, /* U+2AA8 */
  { "lesdot", "⩿" }, /* U+2A7F */
  { "lesdoto", "⪁" }, /* U+2A81 */
  { "lesdotor", "⪃" }, /* U+2A83 */
  { "lesg", "⋚︀" }, /* U+22DA U+FE00 */
  { "lesges", "⪓" }, /* U+2A93 */
  { "lessapprox", "⪅" }, /* U+2A85 */
  { "lessdot", "⋖" }, /* U+22D6 */
  { "lesseqgtr", "⋚" }, /* U+22DA */
  { "lesseqqgtr", "⪋" }, /* U+2A8B */
  { "lessgtr", "≶" }, /* U+2276 */
  { "lesssim", "≲" }, /* U+2272 */
  { "lfisht", "⥼" }, /* U+297C */
  { "lfloor", "⌊" }, /* U+230A */
  { "lfr", "𝔩" }, /* U+1D529 */
  { "lg", "≶" }, /* U+2276 */
  { "lgE", "⪑" }, /* U+2A91 */
  { "lhard", "↽" }, /* U+21BD */
  { "lharu", "↼" }, /* U+21BC */
  { "lharul", "⥪" }, /* U+296A */
  { "lhblk", "▄" }, /* U+2584 */
  { "ljcy", "љ" }, /* U+0459 */
  { "ll", "≪" }, /* U+226A */
  { "llarr", "⇇" }, /* U+21C7 */
  { "llcorner", "⌞" }, /* U+231E */
  { "llhard", "⥫" }, /* U+296B */
  { "lltri", "◺" }, /* U+25FA */
  { "lmidot", "ŀ" }, /* U+0140 */
  { "lmoust", "⎰" }, /* U+23B0 */
  { "lmoustache", "⎰" }, /* U+23B0 */
  { "lnE", "≨" }, /* U+2268 */
  { "lnap", "⪉" }, /* U+2A89 */
  { "lnapprox", "⪉" }, /* U+2A89 */
  { "lne", "⪇" }, /* U+2A87 */
  { "lneq", "⪇" }, /* U+2A87 */
  { "lneqq", "≨" }, /* U+2268 */
  { "lnsim", "⋦" }, /* U+22E6 */
  { "loang", "⟬" }, /* U+27EC */
  { "loarr", "⇽" }, /* U+21FD */
  { "lobrk", "⟦" }, /* U+27E6 */
  { "longleftarrow", "⟵" }, /* U+27F5 */
  { "longmapsto", "⟼" }, /* U+27FC */
  { "longrightarrow", "⟶" }, /* U+27F6 */
  { "looparrowleft", "↫" }, /* U+21AB */
  { "looparrowright", "↬" }, /* U+21AC */
  { "lopar", "⦅" }, /* U+2985 */
  { "lopf", "𝕝" }, /* U+1D55D */
  { "loplus", "⨭" }, /* U+2A2D */
  { "lotimes", "⨴" }, /* U+2A34 */
  { "lowast", "∗" }, /* U+2217 */
  { "lowbar", "_" }, /* U+005F */
  { "loz", "◊" }, /* U+25CA */
  { "lozenge", "◊" }, /* U+25CA */
  { "lozf", "⧫" }, /* U+29EB */
  { "lpar", "(" }, /* U+0028 */
  { "lparlt", "⦓" }, /* U+2993 */
  { "lrarr", "⇆" }, /* U+21C6 */
  { "lrcorner", "⌟" }, /* U+231F */
  { "lrhar", "⇋" }, /* U+21CB */
  { "lrhard", "⥭" }, /* U+296D */
  { "lrm", "\342\200\216" }, /* U+200E */
  { "lrtri", "⊿" }, /* U+22BF */
  { "lsaquo", "‹" }, /* U+2039 */
  { "lscr", "𝓁" }, /* U+1D4C1 */
  { "lsh", "↰" }, /* U+21B0 */
  { "lsim", "≲" }, /* U+2272 */
  { "lsime", "⪍" }, /* U+2A8D */
  { "lsimg", "⪏" }, /* U+2A8F */
  { "lsqb", "[" }, /* U+005B */
  { "lsquo", "‘" }, /* U+2018 */
  { "lsquor", "‚" }, /* U+201A */
  { "lstrok", "ł" }, /* U+0142 */
  { "lt", "<" }, /* U+003C */
  { "ltcc", "⪦" }, /* U+2AA6 */
  { "ltcir", "⩹" }, /* U+2A79 */
  { "ltdot", "⋖" }, /* U+22D6 */
  { "lthree", "⋋" }, /* U+22CB */
  { "ltimes", "⋉" }, /* U+22C9 */
  { "ltlarr", "⥶" }, /* U+2976 */
  { "ltquest", "⩻" }, /* U+2A7B */
  { "ltrPar", "⦖" }, /* U+2996 */
  { "ltri", "◃" }, /* U+25C3 */
  { "ltrie", "⊴" }, /* U+22B4 */
  { "ltrif", "◂" }, /* U+25C2 */
  { "lurdshar", "⥊" }, /* U+294A */
  { "luruhar", "⥦" }, /* U+2966 */
  { "lvertneqq", "≨︀" }, /* U+2268 U+FE00 */
  { "lvnE", "≨︀" }, /* U+2268 U+FE00 */
  { "mDDot", "∺" }, /* U+223A */
  { "macr", "¯" }, /* U+00AF */
  { "male", "♂" }, /* U+2642 */
  { "malt", "✠" }, /* U+2720 */
  { "maltese", "✠" }, /* U+2720 */
  { "map", "↦" }, /* U+21A6 */
  { "mapsto", "↦" }, /* U+21A6 */
  { "mapstodown", "↧" }, /* U+21A7 */
  { "mapstoleft", "↤" }, /* U+21A4 */
  { "mapstoup", "↥" }, /* U+21A5 */
  { "marker", "▮" }, /* U+25AE */
  { "mcomma", "⨩" }, /* U+2A29 */
  { "mcy", "м" }, /* U+043C */
  { "mdash", "—" }, /* U+2014 */
  { "measuredangle", "∡" }, /* U+2221 */
  { "mfr", "𝔪" }, /* U+1D52A */
  { "mho", "℧" }, /* U+2127 */
  { "micro", "µ" }, /* U+00B5 */
  { "mid", "∣" }, /* U+2223 */
  { "midast", "*" }, /* U+002A */
  { "midcir", "⫰" }, /* U+2AF0 */
  { "middot", "·" }, /* U+00B7 */
  { "minus", "−" }, /* U+2212 */
  { "minusb", "⊟" }, /* U+229F */
  { "minusd", "∸" }, /* U+2238 */
  { "minusdu", "⨪" }, /* U+2A2A */
  { "mlcp", "⫛" }, /* U+2ADB */
  { "mldr", "…" }, /* U+2026 */
  { "mnplus", "∓" }, /* U+2213 */
  { "models", "⊧" }, /* U+22A7 */
  { "mopf", "𝕞" }, /* U+1D55E */
  { "mp", "∓" }, /* U+2213 */
  { "mscr", "𝓂" }, /* U+1D4C2 */
  { "mstpos", "∾" }, /* U+223E */
  { "mu", "μ" }, /* U+03BC */
  { "multimap", "⊸" }, /* U+22B8 */
  { "mumap", "⊸" }, /* U+22B8 */
  { "nGg", "⋙̸" }, /* U+22D9 U+0338 */
  { "nGt", "≫⃒" }, /* U+226B U+20D2 */
  { "nGtv", "≫̸" }, /* U+226B U+0338 */
  { "nLeftarrow", "⇍" }, /* U+21CD */
  { "nLeftrightarrow", "⇎" }, /* U+21CE */
  { "nLl", "⋘̸" }, /* U+22D8 U+0338 */
  { "nLt", "≪⃒" }, /* U+226A U+20D2 */
  { "nLtv", "≪̸" }, /* U+226A U+0338 */
  { "nRightarrow", "⇏" }, /* U+21CF */
  { "nVDash", "⊯" }, /* U+22AF */
  { "nVdash", "⊮" }, /* U+22AE */
  { "nabla", "∇" }, /* U+2207 */
  { "nacute", "ń" }, /* U+0144 */
  { "nang", "∠⃒" }, /* U+2220 U+20D2 */
  { "nap", "≉" }, /* U+2249 */
  { "napE", "⩰̸" }, /* U+2A70 U+0338 */
  { "napid", "≋̸" }, /* U+224B U+0338 */
  { "napos", "ŉ" }, /* U+0149 */
  { "napprox", "≉" }, /* U+2249 */
  { "natur", "♮" }, /* U+266E */
  { "natural", "♮" }, /* U+266E */
  { "naturals", "ℕ" }, /* U+2115 */
  { "nbsp", " " }, /* U+00A0 */
  { "nbump", "≎̸" }, /* U+224E U+0338 */
  { "nbumpe", "≏̸" }, /* U+224F U+0338 */
  { "ncap", "⩃" }, /* U+2A43 */
  { "ncaron", "ň" }, /* U+0148 */
  { "ncedil", "ņ" }, /* U+0146 */
  { "ncong", "≇" }, /* U+2247 */
  { "ncongdot", "⩭̸" }, /* U+2A6D U+0338 */
  { "ncup", "⩂" }, /* U+2A42 */
  { "ncy", "н" }, /* U+043D */
  { "ndash", "–" }, /* U+2013 */
  { "ne", "≠" }, /* U+2260 */
  { "neArr", "⇗" }, /* U+21D7 */
  { "nearhk", "⤤" }, /* U+2924 */
  { "nearr", "↗" }, /* U+2197 */
  { "nearrow", "↗" }, /* U+2197 */
  { "nedot", "≐̸" }, /* U+2250 U+0338 */
  { "nequiv", "≢" }, /* U+2262 */
  { "nesear", "⤨" }, /* U+2928 */
  { "nesim", "≂̸" }, /* U+2242 U+0338 */
  { "nexist", "∄" }, /* U+2204 */
  { "nexists", "∄" }, /* U+2204 */
  { "nfr", "𝔫" }, /* U+1D52B */
  { "ngE", "≧̸" }, /* U+2267 U+0338 */
  { "nge", "≱" }, /* U+2271 */
  { "ngeq", "≱" }, /* U+2271 */
  { "ngeqq", "≧̸" }, /* U+2267 U+0338 */
  { "ngeqslant", "⩾̸" }, /* U+2A7E U+0338 */
  { "nges", "⩾̸" }, /* U+2A7E U+0338 */
  { "ngsim", "≵" }, /* U+2275 */
  { "ngt", "≯" }, /* U+226F */
  { "ngtr", "≯" }, /* U+226F */
  { "nhArr", "⇎" }, /* U+21CE */
  { "nharr", "↮" }, /* U+21AE */
  { "nhpar", "⫲" }, /* U+2AF2 */
  { "ni", "∋" }, /* U+220B */
  { "nis", "⋼" }, /* U+22FC */
  { "nisd", "⋺" }, /* U+22FA */
  { "niv", "∋" }, /* U+220B */
  { "njcy", "њ" }, /* U+045A */
  { "nlArr", "⇍" }, /* U+21CD */
  { "nlE", "≦̸" }, /* U+2266 U+0338 */
  { "nlarr", "↚" }, /* U+219A */
  { "nldr", "‥" }, /* U+2025 */
  { "nle", "≰" }, /* U+2270 */
  { "nleftarrow", "↚" }, /* U+219A */
  { "nleftrightarrow", "↮" }, /* U+21AE */
  { "nleq", "≰" }, /* U+2270 */
  { "nleqq", "≦̸" }, /* U+2266 U+0338 */
  { "nleqslant", "⩽̸" }, /* U+2A7D U+0338 */
  { "nles", "⩽̸" }, /* U+2A7D U+0338 */
  { "nless", "≮" }, /* U+226E */
  { "nlsim", "≴" }, /* U+2274 */
  { "nlt", "≮" }, /* U+226E */
  { "nltri", "⋪" }, /* U+22EA */
  { "nltrie", "⋬" }, /* U+22EC */
  { "nmid", "∤" }, /* U+2224 */
  { "nopf", "𝕟" }, /* U+1D55F */
  { "not", "¬" }, /* U+00AC */
  { "notin", "∉" }, /* U+2209 */
  { "notinE", "⋹̸" }, /* U+22F9 U+0338 */
  { "notindot", "⋵̸" }, /* U+22F5 U+0338 */
  { "notinva", "∉" }, /* U+2209 */
  { "notinvb", "⋷" }, /* U+22F7 */
  { "notinvc", "⋶" }, /* U+22F6 */
  { "notni", "∌" }, /* U+220C */
  { "notniva", "∌" }, /* U+220C */
  { "notnivb", "⋾" }, /* U+22FE */
  { "notnivc", "⋽" }, /* U+22FD */
  { "npar", "∦" }, /* U+2226 */
  { "nparallel", "∦" }, /* U+2226 */
  { "nparsl", "⫽⃥" }, /* U+2AFD U+20E5 */
  { "npart", "∂̸" }, /* U+2202 U+0338 */
  { "npolint", "⨔" }, /* U+2A14 */
  { "npr", "⊀" }, /* U+2280 */
  { "nprcue", "⋠" }, /* U+22E0 */
  { "npre", "⪯̸" }, /* U+2AAF U+0338 */
  { "nprec", "⊀" }, /* U+2280 */
  { "npreceq", "⪯̸" }, /* U+2AAF U+0338 */
  { "nrArr", "⇏" }, /* U+21CF */
  { "nrarr", "↛" }, /* U+219B */
  { "nrarrc", "⤳̸" }, /* U+2933 U+0338 */
  { "nrarrw", "↝̸" }, /* U+219D U+0338 */
  { "nrightarrow", "↛" }, /* U+219B */
  { "nrtri", "⋫" }, /* U+22EB */
  { "nrtrie", "⋭" }, /* U+22ED */
  { "nsc", "⊁" }, /* U+2281 */
  { "nsccue", "⋡" }, /* U+22E1 */
  { "nsce", "⪰̸" }, /* U+2AB0 U+0338 */
  { "nscr", "𝓃" }, /* U+1D4C3 */
  { "nshortmid", "∤" }, /* U+2224 */
  { "nshortparallel", "∦" }, /* U+2226 */
  { "nsim", "≁" }, /* U+2241 */
  { "nsime", "≄" }, /* U+2244 */
  { "nsimeq", "≄" }, /* U+2244 */
  { "nsmid", "∤" }, /* U+2224 */
  { "nspar", "∦" }, /* U+2226 */
  { "nsqsube", "⋢" }, /* U+22E2 */
  { "nsqsupe", "⋣" }, /* U+22E3 */
  { "nsub", "⊄" }, /* U+2284 */
  { "nsubE", "⫅̸" }, /* U+2AC5 U+0338 */
  { "nsube", "⊈" }, /* U+2288 */
  { "nsubset", "⊂⃒" }, /* U+2282 U+20D2 */
  { "nsubseteq", "⊈" }, /* U+2288 */
  { "nsubseteqq", "⫅̸" }, /* U+2AC5 U+0338 */
  { "nsucc", "⊁" }, /* U+2281 */
  { "nsucceq", "⪰̸" }, /* U+2AB0 U+0338 */
  { "nsup", "⊅" }, /* U+2285 */
  { "nsupE", "⫆̸" }, /* U+2AC6 U+0338 */
  { "nsupe", "⊉" }, /* U+2289 */
  { "nsupset", "⊃⃒" }, /* U+2283 U+20D2 */
  { "nsupseteq", "⊉" }, /* U+2289 */
  { "nsupseteqq", "⫆̸" }, /* U+2AC6 U+0338 */
  { "ntgl", "≹" }, /* U+2279 */
  { "ntilde", "ñ" }, /* U+00F1 */
  { "ntlg", "≸" }, /* U+2278 */
  { "ntriangleleft", "⋪" }, /* U+22EA */
  { "ntrianglelefteq", "⋬" }, /* U+22EC */
  { "ntriangleright", "⋫" }, /* U+22EB */
  { "nu", "ν" }, /* U+03BD */
  { "num", "#" }, /* U+0023 */
  { "numero", "№" }, /* U+2116 */
  { "numsp", " " }, /* U+2007 */
  { "nvDash", "⊭" }, /* U+22AD */
  { "nvHarr", "⤄" }, /* U+2904 */
  { "nvap", "≍⃒" }, /* U+224D U+20D2 */
  { "nvdash", "⊬" }, /* U+22AC */
  { "nvge", "≥⃒" }, /* U+2265 U+20D2 */
  { "nvgt", ">⃒" }, /* U+003E U+20D2 */
  { "nvinfin", "⧞" }, /* U+29DE */
  { "nvlArr", "⤂" }, /* U+2902 */
  { "nvle", "≤⃒" }, /* U+2264 U+20D2 */
  { "nvlt", "<⃒" }, /* U+003C U+20D2 */
  { "nvltrie", "⊴⃒" }, /* U+22B4 U+20D2 */
  { "nvrArr", "⤃" }, /* U+2903 */
  { "nvrtrie", "⊵⃒" }, /* U+22B5 U+20D2 */
  { "nvsim", "∼⃒" }, /* U+223C U+20D2 */
  { "nwArr", "⇖" }, /* U+21D6 */
  { "nwarhk", "⤣" }, /* U+2923 */
  { "nwarr", "↖" }, /* U+2196 */
  { "nwarrow", "↖" }, /* U+2196 */
  { "nwnear", "⤧" }, /* U+2927 */
  { "oS", "Ⓢ" }, /* U+24C8 */
  { "oacute", "ó" }, /* U+00F3 */
  { "oast", "⊛" }, /* U+229B */
  { "ocir", "⊚" }, /* U+229A */
  { "ocirc", "ô" }, /* U+00F4 */
  { "ocy", "о" }, /* U+043E */
  { "odash", "⊝" }, /* U+229D */
  { "odblac", "ő" }, /* U+0151 */
  { "odiv", "⨸" }, /* U+2A38 */
  { "odot", "⊙" }, /* U+2299 */
  { "odsold", "⦼" }, /* U+29BC */
  { "oelig", "œ" }, /* U+0153 */
  { "ofcir", "⦿" }, /* U+29BF */
  { "ofr", "𝔬" }, /* U+1D52C */
  { "ogon", "˛" }, /* U+02DB */
  { "ograve", "ò" }, /* U+00F2 */
  { "ogt", "⧁" }, /* U+29C1 */
  { "ohbar", "⦵" }, /* U+29B5 */
  { "ohm", "Ω" }, /* U+03A9 */
  { "oint", "∮" }, /* U+222E */
  { "olarr", "↺" }, /* U+21BA */
  { "olcir", "⦾" }, /* U+29BE */
  { "olcross", "⦻" }, /* U+29BB */
  { "oline", "‾" }, /* U+203E */
  { "olt", "⧀" }, /* U+29C0 */
  { "omacr", "ō" }, /* U+014D */
  { "omega", "ω" }, /* U+03C9 */
  { "omicron", "ο" }, /* U+03BF */
  { "omid", "⦶" }, /* U+29B6 */
  { "ominus", "⊖" }, /* U+2296 */
  { "oopf", "𝕠" }, /* U+1D560 */
  { "opar", "⦷" }, /* U+29B7 */
  { "operp", "⦹" }, /* U+29B9 */
  { "oplus", "⊕" }, /* U+2295 */
  { "or", "∨" }, /* U+2228 */
  { "orarr", "↻" }, /* U+21BB */
  { "ord", "⩝" }, /* U+2A5D */
  { "order", "ℴ" }, /* U+2134 */
  { "orderof", "ℴ" }, /* U+2134 */
  { "ordf", "ª" }, /* U+00AA */
  { "ordm", "º" }, /* U+00BA */
  { "origof", "⊶" }, /* U+22B6 */
  { "oror", "⩖" }, /* U+2A56 */
  { "orslope", "⩗" }, /* U+2A57 */
  { "orv", "⩛" }, /* U+2A5B */
  { "oscr", "ℴ" }, /* U+2134 */
  { "oslash", "ø" }, /* U+00F8 */
  { "osol", "⊘" }, /* U+2298 */
  { "otilde", "õ" }, /* U+00F5 */
  { "otimes", "⊗" }, /* U+2297 */
  { "otimesas", "⨶" }, /* U+2A36 */
  { "ouml", "ö" }, /* U+00F6 */
  { "ovbar", "⌽" }, /* U+233D */
  { "par", "∥" }, /* U+2225 */
  { "para", "¶" }, /* U+00B6 */
  { "parallel", "∥" }, /* U+2225 */
  { "parsim", "⫳" }, /* U+2AF3 */
  { "parsl", "⫽" }, /* U+2AFD */
  { "part", "∂" }, /* U+2202 */
  { "pcy", "п" }, /* U+043F */
  { "percnt", "%" }, /* U+0025 */
  { "period", "." }, /* U+002E */
  { "permil", "‰" }, /* U+2030 */
  { "perp", "⊥" }, /* U+22A5 */
  { "pertenk", "‱" }, /* U+2031 */
  { "pfr", "𝔭" }, /* U+1D52D */
  { "phi", "φ" }, /* U+03C6 */
  { "phiv", "ϕ" }, /* U+03D5 */
  { "phmmat", "ℳ" }, /* U+2133 */
  { "phone", "☎" }, /* U+260E */
  { "pi", "π" }, /* U+03C0 */
  { "pitchfork", "⋔" }, /* U+22D4 */
  { "piv", "ϖ" }, /* U+03D6 */
  { "planck", "ℏ" }, /* U+210F */
  { "planckh", "ℎ" }, /* U+210E */
  { "plankv", "ℏ" }, /* U+210F */
  { "plus", "+" }, /* U+002B */
  { "plusacir", "⨣" }, /* U+2A23 */
  { "plusb", "⊞" }, /* U+229E */
  { "pluscir", "⨢" }, /* U+2A22 */
  { "plusdo", "∔" }, /* U+2214 */
  { "plusdu", "⨥" }, /* U+2A25 */
  { "pluse", "⩲" }, /* U+2A72 */
  { "plusmn", "±" }, /* U+00B1 */
  { "plussim", "⨦" }, /* U+2A26 */
  { "plustwo", "⨧" }, /* U+2A27 */
  { "pm", "±" }, /* U+00B1 */
  { "pointint", "⨕" }, /* U+2A15 */
  { "popf", "𝕡" }, /* U+1D561 */
  { "pound", "£" }, /* U+00A3 */
  { "pr", "≺" }, /* U+227A */
  { "prE", "⪳" }, /* U+2AB3 */
  { "prap", "⪷" }, /* U+2AB7 */
  { "prcue", "≼" }, /* U+227C */
  { "pre", "⪯" }, /* U+2AAF */
  { "prec", "≺" }, /* U+227A */
  { "precapprox", "⪷" }, /* U+2AB7 */
  { "preccurlyeq", "≼" }, /* U+227C */
  { "preceq", "⪯" }, /* U+2AAF */
  { "precnapprox", "⪹" }, /* U+2AB9 */
  { "precneqq", "⪵" }, /* U+2AB5 */
  { "precnsim", "⋨" }, /* U+22E8 */
  { "precsim", "≾" }, /* U+227E */
  { "prime", "′" }, /* U+2032 */
  { "primes", "ℙ" }, /* U+2119 */
  { "prnE", "⪵" }, /* U+2AB5 */
  { "prnap", "⪹" }, /* U+2AB9 */
  { "prnsim", "⋨" }, /* U+22E8 */
  { "prod", "∏" }, /* U+220F */
  { "profalar", "⌮" }, /* U+232E */
  { "profline", "⌒" }, /* U+2312 */
  { "profsurf", "⌓" }, /* U+2313 */
  { "prop", "∝" }, /* U+221D */
  { "propto", "∝" }, /* U+221D */
  { "prsim", "≾" }, /* U+227E */
  { "prurel", "⊰" }, /* U+22B0 */
  { "pscr", "𝓅" }, /* U+1D4C5 */
  { "psi", "ψ" }, /* U+03C8 */
  { "puncsp", " " }, /* U+2008 */
  { "qfr", "𝔮" }, /* U+1D52E */
  { "qint", "⨌" }, /* U+2A0C */
  { "qopf", "𝕢" }, /* U+1D562 */
  { "qprime", "⁗" }, /* U+2057 */
  { "qscr", "𝓆" }, /* U+1D4C6 */
  { "quaternions", "ℍ" }, /* U+210D */
  { "quatint", "⨖" }, /* U+2A16 */
  { "quest", "?" }, /* U+003F */
  { "questeq", "≟" }, /* U+225F */
  { "quot", "\"" }, /* U+0022 */
  { "rAarr", "⇛" }, /* U+21DB */
  { "rArr", "⇒" }, /* U+21D2 */
  { "rAtail", "⤜" }, /* U+291C */
  { "rBarr", "⤏" }, /* U+290F */
  { "rHar", "⥤" }, /* U+2964 */
  { "race", "∽̱" }, /* U+223D U+0331 */
  { "racute", "ŕ" }, /* U+0155 */
  { "radic", "√" }, /* U+221A */
  { "raemptyv", "⦳" }, /* U+29B3 */
  { "rang", "⟩" }, /* U+27E9 */
  { "rangd", "⦒" }, /* U+2992 */
  { "range", "⦥" }, /* U+29A5 */
  { "rangle", "⟩" }, /* U+27E9 */
  { "raquo", "»" }, /* U+00BB */
  { "rarr", "→" }, /* U+2192 */
  { "rarrap", "⥵" }, /* U+2975 */
  { "rarrb", "⇥" }, /* U+21E5 */
  { "rarrbfs", "⤠" }, /* U+2920 */
  { "rarrc", "⤳" }, /* U+2933 */
  { "rarrfs", "⤞" }, /* U+291E */
  { "rarrhk", "↪" }, /* U+21AA */
  { "rarrlp", "↬" }, /* U+21AC */
  { "rarrpl", "⥅" }, /* U+2945 */
  { "rarrsim", "⥴" }, /* U+2974 */
  { "rarrtl", "↣" }, /* U+21A3 */
  { "rarrw", "↝" }, /* U+219D */
  { "ratail", "⤚" }, /* U+291A */
  { "ratio", "∶" }, /* U+2236 */
  { "rationals", "ℚ" }, /* U+211A */
  { "rbarr", "⤍" }, /* U+290D */
  { "rbbrk", "❳" }, /* U+2773 */
  { "rbrace", "}" }, /* U+007D */
  { "rbrack", "]" }, /* U+005D */
  { "rbrke", "⦌" }, /* U+298C */
  { "rbrksld", "⦎" }, /* U+298E */
  { "rbrkslu", "⦐" }, /* U+2990 */
  { "rcaron", "ř" }, /* U+0159 */
  { "rcedil", "ŗ" }, /* U+0157 */
  { "rceil", "⌉" }, /* U+2309 */
  { "rcub", "}" }, /* U+007D */
  { "rcy", "р" }, /* U+0440 */
  { "rdca", "⤷" }, /* U+2937 */
  { "rdldhar", "⥩" }, /* U+2969 */
  { "rdquo", "”" }, /* U+201D */
  { "rdquor", "”" }, /* U+201D */
  { "rdsh", "↳" }, /* U+21B3 */
  { "real", "ℜ" }, /* U+211C */
  { "realine", "ℛ" }, /* U+211B */
  { "realpart", "ℜ" }, /* U+211C */
  { "reals", "ℝ" }, /* U+211D */
  { "rect", "▭" }, /* U+25AD */
  { "reg", "®" }, /* U+00AE */
  { "rfisht", "⥽" }, /* U+297D */
  { "rfloor", "⌋" }, /* U+230B */
  { "rfr", "𝔯" }, /* U+1D52F */
  { "rhard", "⇁" }, /* U+21C1 */
  { "rharu", "⇀" }, /* U+21C0 */
  { "rharul", "⥬" }, /* U+296C */
  { "rho", "ρ" }, /* U+03C1 */
  { "rhov", "ϱ" }, /* U+03F1 */
  { "rightarrow", "→" }, /* U+2192 */
  { "rightarrowtail", "↣" }, /* U+21A3 */
  { "rightharpoonup", "⇀" }, /* U+21C0 */
  { "rightleftarrows", "⇄" }, /* U+21C4 */
  { "rightsquigarrow", "↝" }, /* U+219D */
  { "rightthreetimes", "⋌" }, /* U+22CC */
  { "ring", "˚" }, /* U+02DA */
  { "risingdotseq", "≓" }, /* U+2253 */
  { "rlarr", "⇄" }, /* U+21C4 */
  { "rlhar", "⇌" }, /* U+21CC */
  { "rlm", "\342\200\217" }, /* U+200F */
  { "rmoust", "⎱" }, /* U+23B1 */
  { "rmoustache", "⎱" }, /* U+23B1 */
  { "rnmid", "⫮" }, /* U+2AEE */
  { "roang", "⟭" }, /* U+27ED */
  { "roarr", "⇾" }, /* U+21FE */
  { "robrk", "⟧" }, /* U+27E7 */
  { "ropar", "⦆" }, /* U+2986 */
  { "ropf", "𝕣" }, /* U+1D563 */
  { "roplus", "⨮" }, /* U+2A2E */
  { "rotimes", "⨵" }, /* U+2A35 */
  { "rpar", ")" }, /* U+0029 */
  { "rpargt", "⦔" }, /* U+2994 */
  { "rppolint", "⨒" }, /* U+2A12 */
  { "rrarr", "⇉" }, /* U+21C9 */
  { "rsaquo", "›" }, /* U+203A */
  { "rscr", "𝓇" }, /* U+1D4C7 */
  { "rsh", "↱" }, /* U+21B1 */
  { "rsqb", "]" }, /* U+005D */
  { "rsquo", "’" }, /* U+2019 */
  { "rsquor", "’" }, /* U+2019 */
  { "rthree", "⋌" }, /* U+22CC */
  { "rtimes", "⋊" }, /* U+22CA */
  { "rtri", "▹" }, /* U+25B9 */
  { "rtrie", "⊵" }, /* U+22B5 */
  { "rtrif", "▸" }, /* U+25B8 */
  { "rtriltri", "⧎" }, /* U+29CE */
  { "ruluhar", "⥨" }, /* U+2968 */
  { "rx", "℞" }, /* U+211E */
  { "sacute", "ś" }, /* U+015B */
  { "sbquo", "‚" }, /* U+201A */
  { "sc", "≻" }, /* U+227B */
  { "scE", "⪴" }, /* U+2AB4 */
  { "scap", "⪸" }, /* U+2AB8 */
  { "scaron", "š" }, /* U+0161 */
  { "sccue", "≽" }, /* U+227D */
  { "sce", "⪰" }, /* U+2AB0 */
  { "scedil", "ş" }, /* U+015F */
  { "scirc", "ŝ" }, /* U+015D */
  { "scnE", "⪶" }, /* U+2AB6 */
  { "scnap", "⪺" }, /* U+2ABA */
  { "scnsim", "⋩" }, /* U+22E9 */
  { "scpolint", "⨓" }, /* U+2A13 */
  { "scsim", "≿" }, /* U+227F */
  { "scy", "с" }, /* U+0441 */
  { "sdot", "⋅" }, /* U+22C5 */
  { "sdotb", "⊡" }, /* U+22A1 */
  { "sdote", "⩦" }, /* U+2A66 */
  { "seArr", "⇘" }, /* U+21D8 */
  { "searhk", "⤥" }, /* U+2925 */
  { "searr", "↘" }, /* U+2198 */
  { "searrow", "↘" }, /* U+2198 */
  { "sect", "§" }, /* U+00A7 */
  { "semi", ";" }, /* U+003B */
  { "seswar", "⤩" }, /* U+2929 */
  { "setminus", "∖" }, /* U+2216 */
  { "setmn", "∖" }, /* U+2216 */
  { "sext", "✶" }, /* U+2736 */
  { "sfr", "𝔰" }, /* U+1D530 */
  { "sfrown", "⌢" }, /* U+2322 */
  { "sharp", "♯" }, /* U+266F */
  { "shchcy", "щ" }, /* U+0449 */
  { "shcy", "ш" }, /* U+0448 */
  { "shortmid", "∣" }, /* U+2223 */
  { "shortparallel", "∥" }, /* U+2225 */
  { "shy", "­" }, /* U+00AD */
  { "sigma", "σ" }, /* U+03C3 */
  { "sigmaf", "ς" }, /* U+03C2 */
  { "sigmav", "ς" }, /* U+03C2 */
  { "sim", "∼" }, /* U+223C */
  { "simdot", "⩪" }, /* U+2A6A */
  { "sime", "≃" }, /* U+2243 */
  { "simeq", "≃" }, /* U+2243 */
  { "simg", "⪞" }, /* U+2A9E */
  { "simgE", "⪠" }, /* U+2AA0 */
  { "siml", "⪝" }, /* U+2A9D */
  { "simlE", "⪟" }, /* U+2A9F */
  { "simne", "≆" }, /* U+2246 */
  { "simplus", "⨤" }, /* U+2A24 */
  { "simrarr", "⥲" }, /* U+2972 */
  { "slarr", "←" }, /* U+2190 */
  { "smallsetminus", "∖" }, /* U+2216 */
  { "smashp", "⨳" }, /* U+2A33 */
  { "smeparsl", "⧤" }, /* U+29E4 */
  { "smid", "∣" }, /* U+2223 */
  { "smile", "⌣" }, /* U+2323 */
  { "smt", "⪪" }, /* U+2AAA */
  { "smte", "⪬" }, /* U+2AAC */
  { "smtes", "⪬︀" }, /* U+2AAC U+FE00 */
  { "softcy", "ь" }, /* U+044C */
  { "sol", "/" }, /* U+002F */
  { "solb", "⧄" }, /* U+29C4 */
  { "solbar", "⌿" }, /* U+233F */
  { "sopf", "𝕤" }, /* U+1D564 */
  { "spades", "♠" }, /* U+2660 */
  { "spadesuit", "♠" }, /* U+2660 */
  { "spar", "∥" }, /* U+2225 */
  { "sqcap", "⊓" }, /* U+2293 */
  { "sqcaps", "⊓︀" }, /* U+2293 U+FE00 */
  { "sqcup", "⊔" }, /* U+2294 */
  { "sqcups", "⊔︀" }, /* U+2294 U+FE00 */
  { "sqsub", "⊏" }, /* U+228F */
  { "sqsube", "⊑" }, /* U+2291 */
  { "sqsubset", "⊏" }, /* U+228F */
  { "sqsubseteq", "⊑" }, /* U+2291 */
  { "sqsup", "⊐" }, /* U+2290 */
  { "sqsupe", "⊒" }, /* U+2292 */
  { "sqsupset", "⊐" }, /* U+2290 */
  { "sqsupseteq", "⊒" }, /* U+2292 */
  { "squ", "□" }, /* U+25A1 */
  { "square", "□" }, /* U+25A1 */
  { "squarf", "▪" }, /* U+25AA */
  { "squf", "▪" }, /* U+25AA */
  { "srarr", "→" }, /* U+2192 */
  { "sscr", "𝓈" }, /* U+1D4C8 */
  { "ssetmn", "∖" }, /* U+2216 */
  { "ssmile", "⌣" }, /* U+2323 */
  { "sstarf", "⋆" }, /* U+22C6 */
  { "star", "☆" }, /* U+2606 */
  { "starf", "★" }, /* U+2605 */
  { "straightepsilon", "ϵ" }, /* U+03F5 */
  { "straightphi", "ϕ" }, /* U+03D5 */
  { "strns", "¯" }, /* U+00AF */
  { "sub", "⊂" }, /* U+2282 */
  { "subE", "⫅" }, /* U+2AC5 */
  { "subdot", "⪽" }, /* U+2ABD */
  { "sube", "⊆" }, /* U+2286 */
  { "subedot", "⫃" }, /* U+2AC3 */
  { "submult", "⫁" }, /* U+2AC1 */
  { "subnE", "⫋" }, /* U+2ACB */
  { "subne", "⊊" }, /* U+228A */
  { "subplus", "⪿" }, /* U+2ABF */
  { "subrarr", "⥹" }, /* U+2979 */
  { "subset", "⊂" }, /* U+2282 */
  { "subseteq", "⊆" }, /* U+2286 */
  { "subseteqq", "⫅" }, /* U+2AC5 */
  { "subsetneq", "⊊" }, /* U+228A */
  { "subsetneqq", "⫋" }, /* U+2ACB */
  { "subsim", "⫇" }, /* U+2AC7 */
  { "subsub", "⫕" }, /* U+2AD5 */
  { "subsup", "⫓" }, /* U+2AD3 */
  { "succ", "≻" }, /* U+227B */
  { "succapprox", "⪸" }, /* U+2AB8 */
  { "succcurlyeq", "≽" }, /* U+227D */
  { "succeq", "⪰" }, /* U+2AB0 */
  { "succnapprox", "⪺" }, /* U+2ABA */
  { "succneqq", "⪶" }, /* U+2AB6 */
  { "succnsim", "⋩" }, /* U+22E9 */
  { "succsim", "≿" }, /* U+227F */
  { "sum", "∑" }, /* U+2211 */
  { "sung", "♪" }, /* U+266A */
  { "sup", "⊃" }, /* U+2283 */
  { "sup1", "¹" }, /* U+00B9 */
  { "sup2", "²" }, /* U+00B2 */
  { "sup3", "³" }, /* U+00B3 */
  { "supE", "⫆" }, /* U+2AC6 */
  { "supdot", "⪾" }, /* U+2ABE */
  { "supdsub", "⫘" }, /* U+2AD8 */
  { "supe", "⊇" }, /* U+2287 */
  { "supedot", "⫄" }, /* U+2AC4 */
  { "suphsol", "⟉" }, /* U+27C9 */
  { "suphsub", "⫗" }, /* U+2AD7 */
  { "suplarr", "⥻" }, /* U+297B */
  { "supmult", "⫂" }, /* U+2AC2 */
  { "supnE", "⫌" }, /* U+2ACC */
  { "supne", "⊋" }, /* U+228B */
  { "supplus", "⫀" }, /* U+2AC0 */
  { "supset", "⊃" }, /* U+2283 */
  { "supseteq", "⊇" }, /* U+2287 */
  { "supseteqq", "⫆" }, /* U+2AC6 */
  { "supsetneq", "⊋" }, /* U+228B */
  { "supsetneqq", "⫌" }, /* U+2ACC */
  { "supsim", "⫈" }, /* U+2AC8 */
  { "supsub", "⫔" }, /* U+2AD4 */
  { "supsup", "⫖" }, /* U+2AD6 */
  { "swArr", "⇙" }, /* U+21D9 */
  { "swarhk", "⤦" }, /* U+2926 */
  { "swarr", "↙" }, /* U+2199 */
  { "swarrow", "↙" }, /* U+2199 */
  { "swnwar", "⤪" }, /* U+292A */
  { "szlig", "ß" }, /* U+00DF */
  { "target", "⌖" }, /* U+2316 */
  { "tau", "τ" }, /* U+03C4 */
  { "tbrk", "⎴" }, /* U+23B4 */
  { "tcaron", "ť" }, /* U+0165 */
  { "tcedil", "ţ" }, /* U+0163 */
  { "tcy", "т" }, /* U+0442 */
  { "tdot", "⃛" }, /* U+20DB */
  { "telrec", "⌕" }, /* U+2315 */
  { "tfr", "𝔱" }, /* U+1D531 */
  { "there4", "∴" }, /* U+2234 */
  { "therefore", "∴" }, /* U+2234 */
  { "theta", "θ" }, /* U+03B8 */
  { "thetasym", "ϑ" }, /* U+03D1 */
  { "thetav", "ϑ" }, /* U+03D1 */
  { "thickapprox", "≈" }, /* U+2248 */
  { "thicksim", "∼" }, /* U+223C */
  { "thinsp", " " }, /* U+2009 */
  { "thkap", "≈" }, /* U+2248 */
  { "thksim", "∼" }, /* U+223C */
  { "thorn", "þ" }, /* U+00FE */
  { "tilde", "˜" }, /* U+02DC */
  { "times", "×" }, /* U+00D7 */
  { "timesb", "⊠" }, /* U+22A0 */
  { "timesbar", "⨱" }, /* U+2A31 */
  { "timesd", "⨰" }, /* U+2A30 */
  { "tint", "∭" }, /* U+222D */
  { "toea", "⤨" }, /* U+2928 */
  { "top", "⊤" }, /* U+22A4 */
  { "topbot", "⌶" }, /* U+2336 */
  { "topcir", "⫱" }, /* U+2AF1 */
  { "topf", "𝕥" }, /* U+1D565 */
  { "topfork", "⫚" }, /* U+2ADA */
  { "tosa", "⤩" }, /* U+2929 */
  { "tprime", "‴" }, /* U+2034 */
  { "trade", "™" }, /* U+2122 */
  { "triangle", "▵" }, /* U+25B5 */
  { "triangledown", "▿" }, /* U+25BF */
  { "triangleleft", "◃" }, /* U+25C3 */
  { "trianglelefteq", "⊴" }, /* U+22B4 */
  { "triangleq", "≜" }, /* U+225C */
  { "triangleright", "▹" }, /* U+25B9 */
  { "trianglerighteq", "⊵" }, /* U+22B5 */
  { "tridot", "◬" }, /* U+25EC */
  { "trie", "≜" }, /* U+225C */
  { "triminus", "⨺" }, /* U+2A3A */
  { "triplus", "⨹" }, /* U+2A39 */
  { "trisb", "⧍" }, /* U+29CD */
  { "tritime", "⨻" }, /* U+2A3B */
  { "trpezium", "⏢" }, /* U+23E2 */
  { "tscr", "𝓉" }, /* U+1D4C9 */
  { "tscy", "ц" }, /* U+0446 */
  { "tshcy", "ћ" }, /* U+045B */
  { "tstrok", "ŧ" }, /* U+0167 */
  { "twixt", "≬" }, /* U+226C */
  { "uArr", "⇑" }, /* U+21D1 */
  { "uHar", "⥣" }, /* U+2963 */
  { "uacute", "ú" }, /* U+00FA */
  { "uarr", "↑" }, /* U+2191 */
  { "ubrcy", "ў" }, /* U+045E */
  { "ubreve", "ŭ" }, /* U+016D */
  { "ucirc", "û" }, /* U+00FB */
  { "ucy", "у" }, /* U+0443 */
  { "udarr", "⇅" }, /* U+21C5 */
  { "udblac", "ű" }, /* U+0171 */
  { "udhar", "⥮" }, /* U+296E */
  { "ufisht", "⥾" }, /* U+297E */
  { "ufr", "𝔲" }, /* U+1D532 */
  { "ugrave", "ù" }, /* U+00F9 */
  { "uharl", "↿" }, /* U+21BF */
  { "uharr", "↾" }, /* U+21BE */
  { "uhblk", "▀" }, /* U+2580 */
  { "ulcorn", "⌜" }, /* U+231C */
  { "ulcorner", "⌜" }, /* U+231C */
  { "ulcrop", "⌏" }, /* U+230F */
  { "ultri", "◸" }, /* U+25F8 */
  { "umacr", "ū" }, /* U+016B */
  { "uml", "¨" }, /* U+00A8 */
  { "uogon", "ų" }, /* U+0173 */
  { "uopf", "𝕦" }, /* U+1D566 */
  { "uparrow", "↑" }, /* U+2191 */
  { "updownarrow", "↕" }, /* U+2195 */
  { "upharpoonleft", "↿" }, /* U+21BF */
  { "upharpoonright", "↾" }, /* U+21BE */
  { "uplus", "⊎" }, /* U+228E */
  { "upsi", "υ" }, /* U+03C5 */
  { "upsih", "ϒ" }, /* U+03D2 */
  { "upsilon", "υ" }, /* U+03C5 */
  { "upuparrows", "⇈" }, /* U+21C8 */
  { "urcorn", "⌝" }, /* U+231D */
  { "urcorner", "⌝" }, /* U+231D */
  { "urcrop", "⌎" }, /* U+230E */
  { "uring", "ů" }, /* U+016F */
  { "urtri", "◹" }, /* U+25F9 */
  { "uscr", "𝓊" }, /* U+1D4CA */
  { "utdot", "⋰" }, /* U+22F0 */
  { "utilde", "ũ" }, /* U+0169 */
  { "utri", "▵" }, /* U+25B5 */
  { "utrif", "▴" }, /* U+25B4 */
  { "uuarr", "⇈" }, /* U+21C8 */
  { "uuml", "ü" }, /* U+00FC */
  { "uwangle", "⦧" }, /* U+29A7 */
  { "vArr", "⇕" }, /* U+21D5 */
  { "vBar", "⫨" }, /* U+2AE8 */
  { "vBarv", "⫩" }, /* U+2AE9 */
  { "vDash", "⊨" }, /* U+22A8 */
  { "vangrt", "⦜" }, /* U+299C */
  { "varepsilon", "ϵ" }, /* U+03F5 */
  { "varkappa", "ϰ" }, /* U+03F0 */
  { "varnothing", "∅" }, /* U+2205 */
  { "varphi", "ϕ" }, /* U+03D5 */
  { "varpi", "ϖ" }, /* U+03D6 */
  { "varpropto", "∝" }, /* U+221D */
  { "varr", "↕" }, /* U+2195 */
  { "varrho", "ϱ" }, /* U+03F1 */
  { "varsigma", "ς" }, /* U+03C2 */
  { "varsubsetneq", "⊊︀" }, /* U+228A U+FE00 */
  { "varsubsetneqq", "⫋︀" }, /* U+2ACB U+FE00 */
  { "varsupsetneq", "⊋︀" }, /* U+228B U+FE00 */
  { "varsupsetneqq", "⫌︀" }, /* U+2ACC U+FE00 */
  { "vartheta", "ϑ" }, /* U+03D1 */
  { "vartriangleleft", "⊲" }, /* U+22B2 */
  { "vcy", "в" }, /* U+0432 */
  { "vdash", "⊢" }, /* U+22A2 */
  { "vee", "∨" }, /* U+2228 */
  { "veebar", "⊻" }, /* U+22BB */
  { "veeeq", "≚" }, /* U+225A */
  { "vellip", "⋮" }, /* U+22EE */
  { "verbar", "|" }, /* U+007C */
  { "vert", "|" }, /* U+007C */
  { "vfr", "𝔳" }, /* U+1D533 */
  { "vltri", "⊲" }, /* U+22B2 */
  { "vnsub", "⊂⃒" }, /* U+2282 U+20D2 */
  { "vnsup", "⊃⃒" }, /* U+2283 U+20D2 */
  { "vopf", "𝕧" }, /* U+1D567 */
  { "vprop", "∝" }, /* U+221D */
  { "vrtri", "⊳" }, /* U+22B3 */
  { "vscr", "𝓋" }, /* U+1D4CB */
  { "vsubnE", "⫋︀" }, /* U+2ACB U+FE00 */
  { "vsubne", "⊊︀" }, /* U+228A U+FE00 */
  { "vsupnE", "⫌︀" }, /* U+2ACC U+FE00 */
  { "vsupne", "⊋︀" }, /* U+228B U+FE00 */
  { "vzigzag", "⦚" }, /* U+299A */
  { "wcirc", "ŵ" }, /* U+0175 */
  { "wedbar", "⩟" }, /* U+2A5F */
  { "wedge", "∧" }, /* U+2227 */
  { "wedgeq", "≙" }, /* U+2259 */
  { "weierp", "℘" }, /* U+2118 */
  { "wfr", "𝔴" }, /* U+1D534 */
  { "wopf", "𝕨" }, /* U+1D568 */
  { "wp", "℘" }, /* U+2118 */
  { "wr", "≀" }, /* U+2240 */
  { "wreath", "≀" }, /* U+2240 */
  { "wscr", "𝓌" }, /* U+1D4CC */
  { "xcap", "⋂" }, /* U+22C2 */
  { "xcirc", "◯" }, /* U+25EF */
  { "xcup", "⋃" }, /* U+22C3 */
  { "xdtri", "▽" }, /* U+25BD */
  { "xfr", "𝔵" }, /* U+1D535 */
  { "xhArr", "⟺" }, /* U+27FA */
  { "xharr", "⟷" }, /* U+27F7 */
  { "xi", "ξ" }, /* U+03BE */
  { "xlArr", "⟸" }, /* U+27F8 */
  { "xlarr", "⟵" }, /* U+27F5 */
  { "xmap", "⟼" }, /* U+27FC */
  { "xnis", "⋻" }, /* U+22FB */
  { "xodot", "⨀" }, /* U+2A00 */
  { "xopf", "𝕩" }, /* U+1D569 */
  { "xoplus", "⨁" }, /* U+2A01 */
  { "xotime", "⨂" }, /* U+2A02 */
  { "xrArr", "⟹" }, /* U+27F9 */
  { "xrarr", "⟶" }, /* U+27F6 */
  { "xscr", "𝓍" }, /* U+1D4CD */
  { "xsqcup", "⨆" }, /* U+2A06 */
  { "xuplus", "⨄" }, /* U+2A04 */
  { "xutri", "△" }, /* U+25B3 */
  { "xvee", "⋁" }, /* U+22C1 */
  { "xwedge", "⋀" }, /* U+22C0 */
  { "yacute", "ý" }, /* U+00FD */
  { "yacy", "я" }, /* U+044F */
  { "ycirc", "ŷ" }, /* U+0177 */
  { "ycy", "ы" }, /* U+044B */
  { "yen", "¥" }, /* U+00A5 */
  { "yfr", "𝔶" }, /* U+1D536 */
  { "yicy", "ї" }, /* U+0457 */
  { "yopf", "𝕪" }, /* U+1D56A */
  { "yscr", "𝓎" }, /* U+1D4CE */
  { "yucy", "ю" }, /* U+044E */
  { "yuml", "ÿ" }, /* U+00FF */
  { "zacute", "ź" }, /* U+017A */
  { "zcaron", "ž" }, /* U+017E */
  { "zcy", "з" }, /* U+0437 */
  { "zdot", "ż" }, /* U+017C */
  { "zeetrf", "ℨ" }, /* U+2128 */
  { "zeta", "ζ" }, /* U+03B6 */
  { "zfr", "𝔷" }, /* U+1D537 */
  { "zhcy", "ж" }, /* U+0436 */
  { "zigrarr", "⇝" }, /* U+21DD */
  { "zopf", "𝕫" }, /* U+1D56B */
  { "zscr", "𝓏" }, /* U+1D4CF */
  { "zwj", "‍" }, /* U+200D */
  { "zwnj", "‌" } /* U+200C */
};
static const struct { const char name[31 + 1]; const char value[6 + 1]; } html5long[] =
{
  { "CapitalDifferentialD", "ⅅ" }, /* U+2145 */
  { "ClockwiseContourIntegral", "∲" }, /* U+2232 */
  { "CloseCurlyDoubleQuote", "”" }, /* U+201D */
  { "CounterClockwiseContourIntegral", "∳" }, /* U+2233 */
  { "DiacriticalAcute", "´" }, /* U+00B4 */
  { "DiacriticalDoubleAcute", "˝" }, /* U+02DD */
  { "DiacriticalGrave", "`" }, /* U+0060 */
  { "DiacriticalTilde", "˜" }, /* U+02DC */
  { "DoubleContourIntegral", "∯" }, /* U+222F */
  { "DoubleLeftRightArrow", "⇔" }, /* U+21D4 */
  { "DoubleLongLeftArrow", "⟸" }, /* U+27F8 */
  { "DoubleLongLeftRightArrow", "⟺" }, /* U+27FA */
  { "DoubleLongRightArrow", "⟹" }, /* U+27F9 */
  { "DoubleRightArrow", "⇒" }, /* U+21D2 */
  { "DoubleUpDownArrow", "⇕" }, /* U+21D5 */
  { "DoubleVerticalBar", "∥" }, /* U+2225 */
  { "DownArrowUpArrow", "⇵" }, /* U+21F5 */
  { "DownLeftRightVector", "⥐" }, /* U+2950 */
  { "DownLeftTeeVector", "⥞" }, /* U+295E */
  { "DownLeftVectorBar", "⥖" }, /* U+2956 */
  { "DownRightTeeVector", "⥟" }, /* U+295F */
  { "DownRightVectorBar", "⥗" }, /* U+2957 */
  { "EmptySmallSquare", "◻" }, /* U+25FB */
  { "EmptyVerySmallSquare", "▫" }, /* U+25AB */
  { "FilledSmallSquare", "◼" }, /* U+25FC */
  { "FilledVerySmallSquare", "▪" }, /* U+25AA */
  { "GreaterEqualLess", "⋛" }, /* U+22DB */
  { "GreaterFullEqual", "≧" }, /* U+2267 */
  { "GreaterSlantEqual", "⩾" }, /* U+2A7E */
  { "LeftAngleBracket", "⟨" }, /* U+27E8 */
  { "LeftArrowRightArrow", "⇆" }, /* U+21C6 */
  { "LeftDoubleBracket", "⟦" }, /* U+27E6 */
  { "LeftDownTeeVector", "⥡" }, /* U+2961 */
  { "LeftDownVectorBar", "⥙" }, /* U+2959 */
  { "LeftTriangleEqual", "⊴" }, /* U+22B4 */
  { "LeftUpDownVector", "⥑" }, /* U+2951 */
  { "LessEqualGreater", "⋚" }, /* U+22DA */
  { "LongLeftRightArrow", "⟷" }, /* U+27F7 */
  { "Longleftrightarrow", "⟺" }, /* U+27FA */
  { "NegativeMediumSpace", "​" }, /* U+200B */
  { "NegativeThickSpace", "​" }, /* U+200B */
  { "NegativeThinSpace", "​" }, /* U+200B */
  { "NegativeVeryThinSpace", "​" }, /* U+200B */
  { "NestedGreaterGreater", "≫" }, /* U+226B */
  { "NonBreakingSpace", " " }, /* U+00A0 */
  { "NotDoubleVerticalBar", "∦" }, /* U+2226 */
  { "NotGreaterFullEqual", "≧̸" }, /* U+2267 U+0338 */
  { "NotGreaterGreater", "≫̸" }, /* U+226B U+0338 */
  { "NotGreaterSlantEqual", "⩾̸" }, /* U+2A7E U+0338 */
  { "NotLeftTriangleBar", "⧏̸" }, /* U+29CF U+0338 */
  { "NotLeftTriangleEqual", "⋬" }, /* U+22EC */
  { "NotLessSlantEqual", "⩽̸" }, /* U+2A7D U+0338 */
  { "NotNestedGreaterGreater", "⪢̸" }, /* U+2AA2 U+0338 */
  { "NotNestedLessLess", "⪡̸" }, /* U+2AA1 U+0338 */
  { "NotPrecedesEqual", "⪯̸" }, /* U+2AAF U+0338 */
  { "NotPrecedesSlantEqual", "⋠" }, /* U+22E0 */
  { "NotReverseElement", "∌" }, /* U+220C */
  { "NotRightTriangle", "⋫" }, /* U+22EB */
  { "NotRightTriangleBar", "⧐̸" }, /* U+29D0 U+0338 */
  { "NotRightTriangleEqual", "⋭" }, /* U+22ED */
  { "NotSquareSubsetEqual", "⋢" }, /* U+22E2 */
  { "NotSquareSuperset", "⊐̸" }, /* U+2290 U+0338 */
  { "NotSquareSupersetEqual", "⋣" }, /* U+22E3 */
  { "NotSucceedsEqual", "⪰̸" }, /* U+2AB0 U+0338 */
  { "NotSucceedsSlantEqual", "⋡" }, /* U+22E1 */
  { "NotSucceedsTilde", "≿̸" }, /* U+227F U+0338 */
  { "NotSupersetEqual", "⊉" }, /* U+2289 */
  { "NotTildeFullEqual", "≇" }, /* U+2247 */
  { "OpenCurlyDoubleQuote", "“" }, /* U+201C */
  { "PrecedesSlantEqual", "≼" }, /* U+227C */
  { "ReverseEquilibrium", "⇋" }, /* U+21CB */
  { "ReverseUpEquilibrium", "⥯" }, /* U+296F */
  { "RightAngleBracket", "⟩" }, /* U+27E9 */
  { "RightArrowLeftArrow", "⇄" }, /* U+21C4 */
  { "RightDoubleBracket", "⟧" }, /* U+27E7 */
  { "RightDownTeeVector", "⥝" }, /* U+295D */
  { "RightDownVectorBar", "⥕" }, /* U+2955 */
  { "RightTriangleBar", "⧐" }, /* U+29D0 */
  { "RightTriangleEqual", "⊵" }, /* U+22B5 */
  { "RightUpDownVector", "⥏" }, /* U+294F */
  { "RightUpTeeVector", "⥜" }, /* U+295C */
  { "RightUpVectorBar", "⥔" }, /* U+2954 */
  { "SquareIntersection", "⊓" }, /* U+2293 */
  { "SquareSubsetEqual", "⊑" }, /* U+2291 */
  { "SquareSupersetEqual", "⊒" }, /* U+2292 */
  { "SucceedsSlantEqual", "≽" }, /* U+227D */
  { "UnderParenthesis", "⏝" }, /* U+23DD */
  { "UpArrowDownArrow", "⇅" }, /* U+21C5 */
  { "VerticalSeparator", "❘" }, /* U+2758 */
  { "blacktriangledown", "▾" }, /* U+25BE */
  { "blacktriangleleft", "◂" }, /* U+25C2 */
  { "blacktriangleright", "▸" }, /* U+25B8 */
  { "circlearrowright", "↻" }, /* U+21BB */
  { "downharpoonright", "⇂" }, /* U+21C2 */
  { "leftrightharpoons", "⇋" }, /* U+21CB */
  { "leftrightsquigarrow", "↭" }, /* U+21AD */
  { "longleftrightarrow", "⟷" }, /* U+27F7 */
  { "ntrianglerighteq", "⋭" }, /* U+22ED */
  { "rightharpoondown", "⇁" }, /* U+21C1 */
  { "rightleftharpoons", "⇌" }, /* U+21CC */
  { "rightrightarrows", "⇉" }, /* U+21C9 */
  { "twoheadleftarrow", "↞" }, /* U+219E */
  { "twoheadrightarrow", "↠" }, /* U+21A0 */
  { "vartriangleright", "⊳" } /* U+22B3 */
};
/* Lookup of a HTML5 named character entity.  */
static const char *
html5_lookup (string_desc_t name)
{
  if (sd_length (name) <= 15)
    {
      /* Binary search.  */
      size_t lo = 0;
      size_t hi = sizeof (html5short) / sizeof (html5short[0]);
      while (lo < hi)
        {
          size_t mid = (lo + hi) / 2;
          int cmp = sd_cmp (name, sd_from_c (html5short[mid].name));
          if (cmp == 0)
            return html5short[mid].value;
          if (cmp < 0)
            hi = mid;
          else /* cmp > 0 */
            lo = mid + 1;
        }
    }
  else
    {
      /* Binary search.  */
      size_t lo = 0;
      size_t hi = sizeof (html5long) / sizeof (html5long[0]);
      while (lo < hi)
        {
          size_t mid = (lo + hi) / 2;
          int cmp = sd_cmp (name, sd_from_c (html5long[mid].name));
          if (cmp == 0)
            return html5long[mid].value;
          if (cmp < 0)
            hi = mid;
          else /* cmp > 0 */
            lo = mid + 1;
        }
    }
  return NULL;
}
