# Copyright 2014-2021 Free Software Foundation, Inc.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License,
# or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

BEGIN {
    if (srcdir == "") {
        srcdir = "."
    }
    ETH = srcdir "/element_types.h"
    ETC = srcdir "/element_types.c"

    print "/* This file automatically generated by element_types.awk */" > ETH
    print "#ifndef ELEMENT_TYPES_H"                                      > ETH
    print "#define ELEMENT_TYPES_H"                                      > ETH
    print "enum element_type {"                                          > ETH
    print "ET_NONE,"                                                     > ETH
}

!/^$/ && !/^#/ {
    print "ET_" $1 ","                                                > ETH
    array = array "\"" $1 "\",\n"
}

END {
    print "};"                                                        > ETH     
    print                                                             > ETH 
    print "extern char *element_type_names[];"                        > ETH
    print "#endif"                                                    > ETH

    print "char *element_type_names[] = {"                            > ETC
    print "0,"                                                        > ETC     
    print array                                                       > ETC     
    print "};"                                                        > ETC     
}

function output_array (string)
{
    print string > ETC
}
