--
-- This file is part of TALER
-- Copyright (C) 2023 Taler Systems SA
--
-- TALER is free software; you can redistribute it and/or modify it under the
-- terms of the GNU General Public License as published by the Free Software
-- Foundation; either version 3, or (at your option) any later version.
--
-- TALER is distributed in the hope that it will be useful, but WITHOUT ANY
-- WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
-- A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License along with
-- TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
--

CREATE TABLE charities
  (charity_id BIGINT GENERATED BY DEFAULT AS IDENTITY UNIQUE
  ,charity_pub BYTEA PRIMARY KEY CHECK (LENGTH(charity_pub)=32)
  ,charity_name TEXT NOT NULL
  ,charity_url TEXT NOT NULL
  ,max_per_year taler_amount NOT NULL
  ,receipts_to_date taler_amount NOT NULL DEFAULT (0,0)
  ,current_year INT4 NOT NULL
  );
COMMENT ON TABLE charities
  IS 'Table with public keys of all recognized charities.';
COMMENT ON COLUMN charities.charity_pub
  IS 'Charity EdDSA public key.';
COMMENT ON COLUMN charities.max_per_year
  IS 'The annual donation limit according to local law.';
COMMENT ON COLUMN charities.receipts_to_date
  IS 'The current amount of donations in the current year. Reset to 0 when incrementing the current_year (but remember historic values in history table when doing so).';
