// MainFrm.cpp : implementation of the CMainFrame class
//

#include "stdafx.h"
#include "GUICons.h"
#include "GUIConsDoc.h"
#include "GUIConsView.h"
#include "RestartExitDlg.h"
#include "StackSizeDlg.h"

#define MAINFRM_FILE
#include "MainFrm.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif



/*---------------------------------*
 * Constants                       *
 *---------------------------------*/

/*---------------------------------*
 * Type Definitions                *
 *---------------------------------*/

/*---------------------------------*
 * Global Variables                *
 *---------------------------------*/

static BOOL m_bInsert=TRUE;


/*---------------------------------*
 * Function Prototypes             *
 *---------------------------------*/


/*-------------------------------------------------------------------------*
 * W32GC_EMIT_BEEP                                                         *
 *                                                                         *
 *-------------------------------------------------------------------------*/
extern "C" void
W32GC_Emit_Beep(int fd_out)

{
  MessageBeep(MB_ICONEXCLAMATION);
}




/*-------------------------------------------------------------------------*
 * W32GC_PUT_CHAR                                                          *
 *                                                                         *
 *-------------------------------------------------------------------------*/
extern "C" void
W32GC_Put_Char(int c, int fd_out)

{
  theView->Put_Char(c);
}
	



/*-------------------------------------------------------------------------*
 * W32GC_GET_CHAR0                                                         *
 *                                                                         *
 *-------------------------------------------------------------------------*/
extern "C" int
W32GC_Get_Char0(int fd_in)
{
  int c;

  WaitForSingleObject(kbd_event,INFINITE);

  EnterCriticalSection(&cs);

  c = kbd_buff[kbd_begin];
  Inc_Buff_Index(kbd_begin);
  if (kbd_begin == kbd_end)
    {
      kbd_begin = kbd_end = 0;
      ResetEvent(kbd_event);
    }

  LeaveCriticalSection(&cs);

  return c;
}




/*-------------------------------------------------------------------------*
 * W32GC_INS_MODE                                                          *
 *                                                                         *
 *-------------------------------------------------------------------------*/
extern "C" void
W32GC_Ins_Mode(int ins_mode)
{
  m_bInsert = ins_mode;	
  ((CMainFrame*)(theApp.m_pMainWnd))->m_wndStatusBar.UpdateWindow();
}




/*-------------------------------------------------------------------------*
 * W32GC_SCREEN_SIZE                                                       *
 *                                                                         *
 *-------------------------------------------------------------------------*/
extern "C" void
W32GC_Screen_Size(int fd_out, int *row, int *col)
{
 *row = theView->win_size_row;
 *col = theView->win_size_col - 1;
}




/*-------------------------------------------------------------------------*
 * W32GC_KBD_IS_NOT_EMPTY                                                  *
 *                                                                         *
 *-------------------------------------------------------------------------*/
extern "C" int
W32GC_Kbd_Is_Not_Empty(int fd_in)

{
  return kbd_begin != kbd_end;
}



/*-------------------------------------------------------------------------*
 * W32GC_BACKD                                                             *
 *                                                                         *
 *-------------------------------------------------------------------------*/
extern "C" void
W32GC_Backd(int fd_out, int n)
{
  theView->Backd(n);
}




/*-------------------------------------------------------------------------*
 * W32GC_FORWD                                                             *
 *                                                                         *
 *-------------------------------------------------------------------------*/
extern "C" void
W32GC_Forwd(int fd_out, int n)
{
  theView->Forwd(n);
}




/*-------------------------------------------------------------------------*
 * W32GC_DISPL                                                             *
 *                                                                         *
 *-------------------------------------------------------------------------*/
extern "C" void
W32GC_Displ(int fd_out, int n, char *str)
{
  theView->Displ(n, str);
}




/*-------------------------------------------------------------------------*
 * W32GC_DISPL_STR                                                         *
 *                                                                         *
 *-------------------------------------------------------------------------*/
extern "C" void
W32GC_Displ_Str(int fd_out, char *str)
{
  theView->Displ_Str(str);
}




/*-------------------------------------------------------------------------*
 * W32GC_ERASE                                                             *
 *                                                                         *
 *-------------------------------------------------------------------------*/
extern "C" void
W32GC_Erase(int fd_out, int n)

{
  theView->Erase(n);
}
	



/*-------------------------------------------------------------------------*
 * W32GC_MSG                                                               *
 *                                                                         *
 *-------------------------------------------------------------------------*/
extern "C" void
W32GC_Msg(char *s)
{
  AfxMessageBox(s);
}




/*-------------------------------------------------------------------------*
 * W32GC_SET_TITLE                                                         *
 *                                                                         *
 *-------------------------------------------------------------------------*/
extern "C" void
W32GC_Set_Title(char *s)
{
  theApp.m_pMainWnd->SetWindowText(s);
}




/*-------------------------------------------------------------------------*
 * W32GC_ADJUST_STACK_SIZES                                                *
 *                                                                         *
 *-------------------------------------------------------------------------*/

CStackSizeDlg adjustStackSizesDlg;

extern "C" void
W32GC_Adjust_Stack_Sizes(int *s1, int *s2, int *s3, int *s4)
{
  adjustStackSizesDlg.m_val1 = *s1;
  adjustStackSizesDlg.m_val2 = *s2;
  adjustStackSizesDlg.m_val3 = *s3;
	
  if (s4 != NULL) {
    adjustStackSizesDlg.m_noCstr = false;
    adjustStackSizesDlg.m_val4 = *s4;
  }
  else
    adjustStackSizesDlg.m_noCstr = true;
	
  adjustStackSizesDlg.DoModal();

  *s1 = adjustStackSizesDlg.m_val1;
  *s2 = adjustStackSizesDlg.m_val2;
  *s3 = adjustStackSizesDlg.m_val3;
  if (s4 != NULL)
    *s4 = adjustStackSizesDlg.m_val4;
}



/*-------------------------------------------------------------------------*
 * W32GC_RESTART                                                           *
 *                                                                         *
 *-------------------------------------------------------------------------*/
UINT ThreadProc(LPVOID pParam);

extern "C" void
W32GC_Restart()
{
  AfxMessageBox("Are you sure you want to restart the toplevel ?");
  TerminateThread(theThread->m_hThread,0);
  theThread = AfxBeginThread(ThreadProc, NULL);
}




/*-------------------------------------------------------------------------*
 * W32GC_RESTART_EXIT_MSG                                                  *
 *                                                                         *
 *-------------------------------------------------------------------------*/
CRestartExitDlg d;

extern "C" void
W32GC_Restart_Exit_Msg(char *s)
{
  d.m_message = s;
  if (d.DoModal()) // 1 --> restart, 0 --> exit
    W32GC_Restart();
  else
    theApp.m_pMainWnd->PostMessage(WM_CLOSE);
}



/*-------------------------------------------------------------------------*/


/////////////////////////////////////////////////////////////////////////////
// CMainFrame

IMPLEMENT_DYNCREATE(CMainFrame, CFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CFrameWnd)
	//{{AFX_MSG_MAP(CMainFrame)
	ON_WM_CREATE()
	ON_WM_DESTROY()
	ON_UPDATE_COMMAND_UI(ID_INDICATOR_OVR, OnUpdateInsert)
	ON_COMMAND(ID_TOGGLE_INSERT, OnToggleInsert)
	ON_WM_SHOWWINDOW()
	ON_WM_CLOSE()
	ON_UPDATE_COMMAND_UI(ID_TOGGLE_INSERT, OnUpdateInsert)
	ON_COMMAND(ID_KILLRESTART, OnKillrestart)
	//}}AFX_MSG_MAP
	// Global help commands
	ON_COMMAND(ID_HELP_FINDER, CFrameWnd::OnHelpFinder)
	ON_COMMAND(ID_HELP, CFrameWnd::OnHelp)
	ON_COMMAND(ID_CONTEXT_HELP, CFrameWnd::OnContextHelp)
	ON_COMMAND(ID_DEFAULT_HELP, CFrameWnd::OnHelpFinder)
END_MESSAGE_MAP()

static UINT indicators[] =
{
	ID_SEPARATOR,           // status line indicator
	ID_INDICATOR_OVR,
	ID_INDICATOR_CAPS,
	ID_INDICATOR_NUM,
	ID_INDICATOR_SCRL,
};

/////////////////////////////////////////////////////////////////////////////
// CMainFrame construction/destruction

CMainFrame::CMainFrame()
{
	m_bInsert = TRUE;      // default to over-stroke mode
}

CMainFrame::~CMainFrame()
{
}

int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CFrameWnd::OnCreate(lpCreateStruct) == -1)
			return -1;
	
	if (!m_wndToolBar.CreateEx(this) ||
		!m_wndToolBar.LoadToolBar(IDR_MAINFRAME))
	{
		TRACE0("Failed to create toolbar\n");
		return -1;      // fail to create
	}
	m_wndToolBar.SetBarStyle(m_wndToolBar.GetBarStyle() & ~CBRS_HIDE_INPLACE);
	if (!m_wndDlgBar.Create(this, IDR_MAINFRAME,
		CBRS_ALIGN_TOP, AFX_IDW_DIALOGBAR))
	{
		TRACE0("Failed to create dialogbar\n");
		return -1;		// fail to create
	}

	if (!m_wndReBar.Create(this) ||
		!m_wndReBar.AddBar(&m_wndToolBar) ||
		!m_wndReBar.AddBar(&m_wndDlgBar))
	{
		TRACE0("Failed to create rebar\n");
		return -1;      // fail to create
	}
	m_wndReBar.SetBarStyle(m_wndReBar.GetBarStyle() & ~CBRS_HIDE_INPLACE);

	if (!m_wndStatusBar.Create(this) ||
		!m_wndStatusBar.SetIndicators(indicators,
		  sizeof(indicators)/sizeof(UINT)))
	{
		TRACE0("Failed to create status bar\n");
		return -1;      // fail to create
	}

	// TODO: Remove this if you don't want tool tips
	m_wndToolBar.SetBarStyle(m_wndToolBar.GetBarStyle() |
		CBRS_TOOLTIPS | CBRS_FLYBY);

	InitializeCriticalSection(&cs);


	return 0;

}

BOOL CMainFrame::PreCreateWindow(CREATESTRUCT& cs)
{
	if( !CFrameWnd::PreCreateWindow(cs) )
		return FALSE;
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CMainFrame diagnostics

#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
	CFrameWnd::AssertValid();
}

void CMainFrame::Dump(CDumpContext& dc) const
{
	CFrameWnd::Dump(dc);
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMainFrame message handlers


void CMainFrame::OnDestroy()
{
	CFrameWnd::OnDestroy();	
	
}

void CMainFrame::OnUpdateInsert(CCmdUI* pCmdUI)
{
    pCmdUI->SetText((m_bInsert) ? "" : "OVR");
}


void CMainFrame::OnToggleInsert()
{
    m_bInsert = !m_bInsert;	
    theView->ToggleInsert();
}

void CMainFrame::OnShowWindow(BOOL bShow, UINT nStatus)
{
	CFrameWnd::OnShowWindow(bShow, nStatus);
	SetEvent(thread_event);
}


void CMainFrame::OnClose()
{
	(theView->GetDocument())->SetModifiedFlag(FALSE);
    DeleteCriticalSection(&cs);
	
	CFrameWnd::OnClose();
}


UINT ThreadProc( LPVOID pParam );

void CMainFrame::OnKillrestart() 
{
	::W32GC_Restart();
}

