set -eu

ARCH=$(dpkg --print-architecture)

function step() {
    echo -e "\n$@" >&2
}

USERS="libeufin-bank libeufin-nexus"

step "Install"
dpkg -i ../*.deb

step "Install again"
dpkg -i ../*.deb

step "Start postgres cluster"
sudo -u postgres pg_ctlcluster 17 main start

step "versions version"
libeufin-bank --version
libeufin-nexus --version

for USER in $USERS; do
    step "$USER user:"
    id $USER
done

step "Check man pages"
man libeufin-bank > /dev/null
man libeufin-bank.conf > /dev/null
man libeufin-nexus > /dev/null
man libeufin-nexus.conf > /dev/null

step "Remove"
dpkg --remove libeufin-bank libeufin-nexus

step "Reinstall"
dpkg -i ../*.deb

step "Purge:"
dpkg --purge libeufin-bank libeufin-nexus

step "Reinstall"
dpkg -i ../*.deb