/*
 This file is part of GNU Taler
 (C) 2022 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

/**
 * Welcome page, shown on first installs.
 *
 * @author sebasjm
 */

import { WalletDiagnostics } from "@gnu-taler/taler-util";
import { Fragment, h, VNode } from "preact";
import { Checkbox } from "../components/Checkbox.js";
import { SubTitle, Title } from "../components/styled/index.js";
import { useTranslationContext } from "@gnu-taler/web-util/browser";
import { useSettings } from "../hooks/useSettings.js";
import { ToggleHandler } from "../mui/handlers.js";
import { platform } from "../platform/foreground.js";
import { useAlertContext } from "../context/alert.js";

export function WelcomePage(): VNode {
  const [settings, updateSettings] = useSettings();
  const { safely } = useAlertContext();
  return (
    <View
      permissionToggle={{
        value: settings.injectTalerSupport,
        button: {
          onClick: safely("update support injection", async () =>
            updateSettings("injectTalerSupport", !settings.injectTalerSupport),
          ),
        },
      }}
    />
  );
}

export interface ViewProps {
  permissionToggle: ToggleHandler;
}
export function View({
  permissionToggle,
}: ViewProps): VNode {
  const { i18n } = useTranslationContext();
  return (
    <Fragment>
      <Title>
        <i18n.Translate>GNU Taler Wallet installed!</i18n.Translate>
      </Title>
      <div>
        <p>
          <i18n.Translate>
            You can open the wallet using the combination{" "}
            <pre style="font-weight: bold; display: inline;">&lt;ALT+W&gt;</pre>
            .
          </i18n.Translate>
        </p>
        <Fragment>
          <p>
            <i18n.Translate>
              Also pinning the GNU Taler Wallet to your browser allows
              you to quick access without keyboard:
            </i18n.Translate>
          </p>
          <ol style={{ paddingLeft: 40 }}>
            <li>
              <i18n.Translate>Click the puzzle icon</i18n.Translate>
            </li>
            <li>
              <i18n.Translate>Search for GNU Taler Wallet</i18n.Translate>
            </li>
            <li>
              <i18n.Translate>Click the pin icon</i18n.Translate>
            </li>
          </ol>
        </Fragment>
        <SubTitle>
          <i18n.Translate>Next Steps</i18n.Translate>
        </SubTitle>
        <a href="https://demo.taler.net/" style={{ display: "block" }}>
          <i18n.Translate>Try the demo</i18n.Translate> »
        </a>
      </div>
    </Fragment>
  );
}
