/*
 * Decompiled with CFR 0.152.
 */
package org.domterm.util;

import java.io.Reader;
import java.io.Writer;
import org.domterm.util.DomTermErrorWriter;

public final class Util {
    public static final int ESCAPE = 27;
    public static final char[] EOF_MARKER = new char[]{'\u001b', '[', '9', '9', ';', '9', '9', 'u'};

    private Util() {
    }

    public static void copyThread(Reader reader, boolean bl, Writer writer) {
        if (bl) {
            writer = new DomTermErrorWriter(writer);
        }
        Util.copyThread(reader, writer);
    }

    public static void copyThread(final Reader reader, final Writer writer) {
        Thread thread = new Thread(){
            char[] buffer = new char[1024];

            @Override
            public void run() {
                block2: while (true) {
                    try {
                        while (true) {
                            int n;
                            if ((n = reader.read(this.buffer)) < 0) {
                                writer.write(EOF_MARKER, 0, EOF_MARKER.length);
                                break block2;
                            }
                            writer.write(this.buffer, 0, n);
                        }
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                        System.exit(-1);
                        continue;
                    }
                    break;
                }
            }
        };
        thread.start();
    }

    public static String toJson(String string) {
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('\"');
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '\n') {
                stringBuilder.append("\\n");
                continue;
            }
            if (c == '\r') {
                stringBuilder.append("\\r");
                continue;
            }
            if (c == '\t') {
                stringBuilder.append("\\t");
                continue;
            }
            if (c == '\b') {
                stringBuilder.append("\\b");
                continue;
            }
            if (c < ' ' || c >= '\u007f') {
                String string2 = Integer.toHexString(c);
                int n2 = string2.length();
                if (n2 == 1) {
                    string2 = "000" + string2;
                } else if (n2 == 2) {
                    string2 = "00" + string2;
                } else if (n2 == 3) {
                    string2 = "0" + string2;
                }
                stringBuilder.append("\\u");
                stringBuilder.append(string2);
                continue;
            }
            if (c == '\"' || c == '\\') {
                stringBuilder.append('\\');
            }
            stringBuilder.append(c);
        }
        stringBuilder.append('\"');
        return stringBuilder.toString();
    }

    public static String parseSimpleJsonString(String string, int n, int n2) {
        return Util.parseSimpleJsonString(string, n, n2, null);
    }

    public static String parseSimpleJsonString(String string, int n, int n2, int[] nArray) {
        int n3;
        char c;
        StringBuilder stringBuilder;
        block18: {
            stringBuilder = new StringBuilder();
            c = '\u0000';
            n3 = n;
            do {
                if (n3 >= n2) {
                    return null;
                }
                if ((c = string.charAt(n3++)) == '\"' || c == '\'') break block18;
            } while (Character.isWhitespace(c));
            return null;
        }
        while (n3 < n2) {
            char c2;
            if ((c2 = string.charAt(n3++)) == c) {
                if (nArray == null) break;
                nArray[0] = n3;
                break;
            }
            if (c2 == '\\') {
                if (n3 == n2) {
                    return null;
                }
                c2 = string.charAt(n3++);
                switch (c2) {
                    case 'b': {
                        c2 = '\b';
                        break;
                    }
                    case 'f': {
                        c2 = '\f';
                        break;
                    }
                    case 't': {
                        c2 = '\t';
                        break;
                    }
                    case 'n': {
                        c2 = '\n';
                        break;
                    }
                    case 'r': {
                        c2 = '\r';
                        break;
                    }
                    case '\"': 
                    case '\'': 
                    case '\\': {
                        break;
                    }
                    case 'u': {
                        if (n3 + 4 > n2) {
                            return null;
                        }
                        c2 = '\u0000';
                        for (int i = 0; i < 4; ++i) {
                            int n4;
                            if ((n4 = Character.digit(string.charAt(n3++), 16)) < 0) {
                                return null;
                            }
                            c2 = (char)((c2 << 4) + n4);
                        }
                        break;
                    }
                }
            }
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }
}

