
;;; search-for-constants.el

;; Copyright (C) 2014-2015 Davin Pearson

;; Emacs Lisp Archive Entry
;; Filename: search-for-constants.el
;; Author/Maintainer: Davin Pearson <http://davin.50webs.com>
;; Keywords:
;; Version: 1.0

;;; Commentary:

;; This file is not part of GNU Emacs.

;;; Limitation of Warranty

;; This program is free software: you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation, either version 3 of the License, or (at
;; your option) any later version.
;;
;; This program is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs, see the file COPYING.  If not, see:
;;
;; <http://www.gnu.org/licenses/gpl-3.0.txt>.


;;; Known Bugs:

;; None so far!

;;; Code:

(setq s4c-buf "*constants*")

(defun s4c--log-message (string)
  (save-excursion
    (set-buffer s4c-buf)
    (goto-char (point-max))
    (insert string "\n")))

;;; (s4c--find-constants-in-current-buffer)
(defun s4c--find-constants-in-current-buffer ()
  (interactive)
  (assert (eq major-mode 'c++-mode))
  (goto-char (point-min))
  (let (p number)
    (while (setq p (re-search-forward "\\<[0-9]+\\(\\.[0-9]+\\)?" nil t))
      (when (save-excursion
              (beginning-of-line)
              (not (looking-at "^[ \t]*const[ \t]")))
        (while (d-delta-looking-at "[0-9]" -1)
          (forward-char -1))
        (if (d-delta-looking-at "\\." -1)
            (forward-char -1))
        (while (d-delta-looking-at "[0-9]" -1)
          (forward-char -1))
        (setq number (buffer-substring-no-properties (point)  p))
        (if (and (not (string= number "0")) (not (string= number "1")))
            (s4c--log-message  (format "%s:%d: %s" (buffer-file-name) (d-what-line) (d-current-line-as-string))))
      (goto-char p)))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
    (goto-char (point-min))
    (while (setq p (re-search-forward "\\<0[xX][0-9a-fA-F]+" nil t))
      (while (d-delta-looking-at "[0-9xXa-fA-F]" -1)
        (forward-char -1))
      ;;(setq number (buffer-substring-no-properties (point) p))
      (s4c--log-message (format "%s:%d: %s" (buffer-file-name) (d-what-line) (d-current-line-as-string)))
      (goto-char p))
    ;;(save-excursion
    ;;  (set-buffer s4c-buf)
    ;;  (d-sort-buffer))
    ))

;;; (s4c--find-constants-in-file-list '("~/dlisp/search-for-constants.cc"))
(defun s4c--find-constants-in-file-list (list)
  ;;(debug)
  (save-excursion
    (if (get-buffer s4c-buf)
        (kill-buffer s4c-buf))
    (generate-new-buffer s4c-buf)
    (setq ptr list)
    (while (car ptr)
      (find-file (car ptr))
      (s4c--find-constants-in-current-buffer)
      (kill-buffer nil)
      (setq ptr (cdr ptr))))
  (switch-to-buffer s4c-buf)
  ;;(d-sort-buffer)
  ;;(goto-char (point-min)) (flush-lines ": [01]$")
  (goto-char (point-min)) (flush-lines "r4/gfx-")
  (goto-char (point-min)) (flush-lines ": 200[67]$")
  (goto-char (point-min)) (insert "\n\n") ;;; NOTE: needed for enter key to work
  (compilation-mode)
  (read-only-mode -1)
  )

;;;
;;; TODO: remove declared constants from smegs
;;;

;;; (setq dir "~/3-autogc-nosplit/2007/r4")
;;; (s4c--find-constants-in-dir dir)
(defun s4c--find-constants-in-dir (dir)
  (interactive "Denter dir: ")
  ;;(debug)
  (setq list (directory-files-no-dotdotdot dir t))
  ;;(string-match "\\.blu$" "sex.blu")
  (setq list (mapcar (function (lambda (x) (if (string-match "\\.\\(cc\\|ch\\|hh\\)$" x) x nil))) list))
  (setq list (delete nil list))
  (s4c--find-constants-in-file-list list)
  ;;(debug)
  )

