/*
 * Decompiled with CFR 0.152.
 */
package gnu.jel;

import gnu.jel.ClassFile;
import gnu.jel.OP;
import gnu.jel.OPfunction;
import gnu.jel.debug.Debug;

public class OPlist
extends OP {
    protected int size = 0;

    public int size() {
        return this.size;
    }

    public OP getFirst() {
        Debug.assert(this.size > 0, "First in empty list.");
        return this.next;
    }

    public OP getLast() {
        Debug.assert(this.size > 0, "Last in empty list.");
        return this.prev;
    }

    public void addFirst(OP o) {
        o.prev = null;
        o.next = null;
        if (this.next != null) {
            o.next = this.next;
            this.next.prev = o;
        }
        this.next = o;
        if (this.prev == null) {
            this.prev = o;
        }
        ++this.size;
    }

    public void addLast(OP o) {
        o.prev = null;
        o.next = null;
        if (this.prev != null) {
            o.prev = this.prev;
            this.prev.next = o;
        }
        this.prev = o;
        if (this.next == null) {
            this.next = o;
        }
        ++this.size;
    }

    public void addBefore(OP e, OP ne) {
        if (e == this.next) {
            this.addFirst(ne);
            return;
        }
        ne.prev = e.prev;
        ne.next = e;
        e.prev.next = ne;
        e.prev = ne;
        ++this.size;
    }

    public void addAfter(OP e, OP ne) {
        if (e.next != null) {
            this.addBefore(e.next, ne);
        } else {
            this.addLast(ne);
        }
    }

    public void remove(OP o) {
        if (o.prev != null) {
            o.prev.next = o.next;
        } else {
            this.next = o.next;
        }
        if (o.next != null) {
            o.next.prev = o.prev;
        } else {
            this.prev = o.prev;
        }
        o.next = null;
        o.prev = null;
        --this.size;
    }

    public void performCF() {
        OP curr = this.next;
        while (curr != null) {
            OP ncurr = curr.next;
            if (curr instanceof OPfunction) {
                ((OPfunction)curr).eval(this);
            }
            curr = ncurr;
        }
    }

    private static OP skip(OP op) {
        if (op instanceof OPfunction) {
            OP cop = op.prev;
            int nparams = ((OPfunction)op).getNParams();
            int i = 0;
            while (i < nparams) {
                cop = OPlist.skip(cop);
                ++i;
            }
            return cop;
        }
        return op.prev;
    }

    private static void compileFunc(ClassFile cf, OPfunction opf) {
        opf.compile_pre(cf);
        OPlist.compileParams(cf, opf, opf.prev, opf.getNParams());
        opf.compile(cf);
    }

    private static void compileParams(ClassFile cf, OPfunction opf, OP op, int nparams) {
        if (nparams == 0) {
            return;
        }
        OPlist.compileParams(cf, opf, OPlist.skip(op), nparams - 1);
        if (op instanceof OPfunction) {
            OPlist.compileFunc(cf, (OPfunction)op);
        } else {
            op.compile(cf);
        }
        opf.compile_par(cf);
    }

    public void compile(ClassFile cf) {
        if (this.prev instanceof OPfunction) {
            OPlist.compileFunc(cf, (OPfunction)this.prev);
        } else {
            Debug.assert(this.size() == 1);
            this.prev.compile(cf);
        }
    }

    public String toString() {
        OP curr = this.next;
        StringBuffer res = new StringBuffer();
        while (curr != null) {
            res.append(curr.toString());
            curr = curr.next;
            if (curr == null) continue;
            res.append(' ');
        }
        return res.toString();
    }
}

