/* 
 *    Programmed By: Mohammed Isam Mohammed [mohammed_isam1984@yahoo.com]
 *    Copyright 2014 (c)
 * 
 *    file: dialogs.h
 *    This file is part of the GnuDOS project.
 *
 *    GnuDOS is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    GnuDOS is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with GnuDOS.  If not, see <http://www.gnu.org/licenses/>.
 */    

#include <signal.h>
#include <stdio.h>
#include "kbd.h"
#include "screen.h"

#ifndef __DIALOGS_H
#define __DIALOGS_H

typedef int bool;
typedef struct { int row; int col; } point;

//buttons used in message boxes//
#define OK	1	//00000001
#define YES	2	//00000010
#define CANCEL	4	//00000100
#define NO	8	//00001000
#define ALL	16	//00010000
#define ABORT	32	//00100000
//button combinations-->  00000101	OK/CANCEL = 5
			//00001010	YES/NO = 10
			//00011010	YES/ALL/NO = 26

//types of message displayed in message boxes//
typedef enum msgt { INFO, ERROR, CONFIRM } msgtype;

int MAX_MSG_BOX_W;
int MAX_MSG_BOX_H;
#define MAX_INPUT_MSG_LEN 100

//Function prototypes//
//clearArea is a flag to indicate whether to clear the window with spaces
void drawBox(int x1, int y1, int x2, int y2, char *title, int clearArea);
void drawBoxP(point p1, point p2, char *title, int clearArea);

//void init();
//void exit_gracefully(int exit_code);

int msgBox(char *msg, int buttons, msgtype tmsg);
char *inputBox(char *msg, char *title);
char *inputBoxI(char *msg, char *inputValue, char *title);
char input[MAX_INPUT_MSG_LEN+1];//input string returned by inputBox() function

int x, y, w, h;

int catchSignals();
int catchAllSignals();
static sig_atomic_t end = 0;
struct sigaction sa;

void sighandler(int signo);
#endif