/* term_curses.c generated by valac 0.50.1.42-81856-dirty, the Vala compiler
 * generated from term_curses.vala, do not modify */

/* Curses terminal

   Copyright (c) 1997-2020 Free Software Foundation, Inc.

   This file is part of GNU Zile.

   GNU Zile is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   GNU Zile is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, see <https://www.gnu.org/licenses/>.  */

#include <gee.h>
#include <glib-object.h>
#include <glib.h>
#include <curses.h>
#include <term.h>
#include <stdlib.h>
#include <string.h>

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

extern GeeList* key_buf;
GeeList* key_buf = NULL;
extern guint backspace_code;
guint backspace_code = (guint) 0177;

guint term_buf_len (void);
void term_move (gsize y,
                gsize x);
void term_clrtoeol (void);
void term_refresh (void);
void term_clear (void);
void term_addch (gchar c);
void term_addstr (const gchar* s);
void term_attrset (gsize attr);
#define FONT_REVERSE 0001
#define FONT_UNDERLINE 0002
void term_beep (void);
gsize term_width (void);
gsize term_height (void);
void term_init (void);
void term_close (void);
guint codetokey (guint c);
#define KBD_CTRL 01000
#define KBD_TAB 00402
#define KBD_RET 00403
#define KBD_META 02000
#define KBD_PGUP 00404
#define KBD_PGDN 00405
#define KBD_HOME 00406
#define KBD_END 00407
#define KBD_DEL 00410
#define KBD_BS 00411
#define KBD_INS 00412
#define KBD_LEFT 00413
#define KBD_RIGHT 00414
#define KBD_UP 00415
#define KBD_DOWN 00416
#define KBD_F1 00420
#define KBD_F2 00421
#define KBD_F3 00422
#define KBD_F4 00423
#define KBD_F5 00424
#define KBD_F6 00425
#define KBD_F7 00426
#define KBD_F8 00427
#define KBD_F9 00430
#define KBD_F10 00431
#define KBD_F11 00432
#define KBD_F12 00433
#define KBD_NOKEY G_MAXINT
GeeList* keytocodes (guint key);
guint get_char (gint delay);
void resize_windows (void);
guint term_getkey (gint delay);
#define GETKEY_DEFAULT -1
guint term_getkey_unfiltered (gint delay);
void term_ungetkey (guint key);

guint
term_buf_len (void)
{
	GeeList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	guint result = 0U;
#line 29 "src/term_curses.vala"
	_tmp0_ = key_buf;
#line 29 "src/term_curses.vala"
	_tmp1_ = gee_collection_get_size ((GeeCollection*) _tmp0_);
#line 29 "src/term_curses.vala"
	_tmp2_ = _tmp1_;
#line 29 "src/term_curses.vala"
	result = (guint) _tmp2_;
#line 29 "src/term_curses.vala"
	return result;
#line 109 "term_curses.c"
}

void
term_move (gsize y,
           gsize x)
{
#line 33 "src/term_curses.vala"
	move ((gint) y, (gint) x);
#line 118 "term_curses.c"
}

void
term_clrtoeol (void)
{
#line 37 "src/term_curses.vala"
	clrtoeol ();
#line 126 "term_curses.c"
}

void
term_refresh (void)
{
#line 41 "src/term_curses.vala"
	refresh ();
#line 134 "term_curses.c"
}

void
term_clear (void)
{
#line 45 "src/term_curses.vala"
	clear ();
#line 142 "term_curses.c"
}

void
term_addch (gchar c)
{
#line 49 "src/term_curses.vala"
	addch ((gulong) c);
#line 150 "term_curses.c"
}

void
term_addstr (const gchar* s)
{
#line 52 "src/term_curses.vala"
	g_return_if_fail (s != NULL);
#line 53 "src/term_curses.vala"
	addstr (s);
#line 160 "term_curses.c"
}

void
term_attrset (gsize attr)
{
	gint attrs = 0;
#line 57 "src/term_curses.vala"
	attrs = 0;
#line 58 "src/term_curses.vala"
	if ((attr & FONT_REVERSE) != ((gsize) 0)) {
#line 59 "src/term_curses.vala"
		attrs |= (gint) A_REVERSE;
#line 173 "term_curses.c"
	}
#line 60 "src/term_curses.vala"
	if ((attr & FONT_UNDERLINE) != ((gsize) 0)) {
#line 61 "src/term_curses.vala"
		attrs |= (gint) A_UNDERLINE;
#line 179 "term_curses.c"
	}
#line 62 "src/term_curses.vala"
	attrset ((gulong) attrs);
#line 183 "term_curses.c"
}

void
term_beep (void)
{
#line 66 "src/term_curses.vala"
	beep ();
#line 191 "term_curses.c"
}

gsize
term_width (void)
{
	gsize result = 0UL;
#line 70 "src/term_curses.vala"
	result = (gsize) COLS;
#line 70 "src/term_curses.vala"
	return result;
#line 202 "term_curses.c"
}

gsize
term_height (void)
{
	gsize result = 0UL;
#line 74 "src/term_curses.vala"
	result = (gsize) LINES;
#line 74 "src/term_curses.vala"
	return result;
#line 213 "term_curses.c"
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result = '\0';
#line 1232 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, '\0');
#line 1233 "glib-2.0.vapi"
	_tmp0_ = ((gchar*) self)[index];
#line 1233 "glib-2.0.vapi"
	result = _tmp0_;
#line 1233 "glib-2.0.vapi"
	return result;
#line 230 "term_curses.c"
}

void
term_init (void)
{
	WINDOW* _tmp0_;
	WINDOW* _tmp1_;
	WINDOW* _tmp2_;
	GeeArrayList* _tmp3_;
	const gchar* kbs = NULL;
	const gchar* _tmp4_;
	gboolean _tmp5_ = FALSE;
	const gchar* _tmp6_;
#line 78 "src/term_curses.vala"
	initscr ();
#line 79 "src/term_curses.vala"
	noecho ();
#line 80 "src/term_curses.vala"
	nonl ();
#line 81 "src/term_curses.vala"
	raw ();
#line 82 "src/term_curses.vala"
	_tmp0_ = stdscr;
#line 82 "src/term_curses.vala"
	meta (_tmp0_, TRUE);
#line 83 "src/term_curses.vala"
	_tmp1_ = stdscr;
#line 83 "src/term_curses.vala"
	intrflush (_tmp1_, FALSE);
#line 84 "src/term_curses.vala"
	_tmp2_ = stdscr;
#line 84 "src/term_curses.vala"
	keypad (_tmp2_, TRUE);
#line 85 "src/term_curses.vala"
	_tmp3_ = gee_array_list_new (G_TYPE_UINT, NULL, NULL, NULL, NULL, NULL);
#line 85 "src/term_curses.vala"
	_g_object_unref0 (key_buf);
#line 85 "src/term_curses.vala"
	key_buf = (GeeList*) _tmp3_;
#line 86 "src/term_curses.vala"
	_tmp4_ = tigetstr ("kbs");
#line 86 "src/term_curses.vala"
	kbs = _tmp4_;
#line 87 "src/term_curses.vala"
	_tmp6_ = kbs;
#line 87 "src/term_curses.vala"
	if (_tmp6_ != NULL) {
#line 278 "term_curses.c"
		const gchar* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
#line 87 "src/term_curses.vala"
		_tmp7_ = kbs;
#line 87 "src/term_curses.vala"
		_tmp8_ = strlen (_tmp7_);
#line 87 "src/term_curses.vala"
		_tmp9_ = _tmp8_;
#line 87 "src/term_curses.vala"
		_tmp5_ = _tmp9_ == 1;
#line 290 "term_curses.c"
	} else {
#line 87 "src/term_curses.vala"
		_tmp5_ = FALSE;
#line 294 "term_curses.c"
	}
#line 87 "src/term_curses.vala"
	if (_tmp5_) {
#line 298 "term_curses.c"
		const gchar* _tmp10_;
#line 88 "src/term_curses.vala"
		_tmp10_ = kbs;
#line 88 "src/term_curses.vala"
		backspace_code = (guint) string_get (_tmp10_, (glong) 0);
#line 304 "term_curses.c"
	}
}

void
term_close (void)
{
#line 93 "src/term_curses.vala"
	endwin ();
#line 313 "term_curses.c"
}

static gint
key_F (gint n)
{
	gint result = 0;
#line 503 "curses.vapi"
	result = (gint) (KEY_F0 + n);
#line 503 "curses.vapi"
	return result;
#line 324 "term_curses.c"
}

guint
codetokey (guint c)
{
	guint result = 0U;
#line 97 "src/term_curses.vala"
	switch (c) {
#line 97 "src/term_curses.vala"
		case '\0':
#line 335 "term_curses.c"
		{
#line 99 "src/term_curses.vala"
			result = (guint) (KBD_CTRL | '@');
#line 99 "src/term_curses.vala"
			return result;
#line 341 "term_curses.c"
		}
#line 97 "src/term_curses.vala"
		case 01:
#line 97 "src/term_curses.vala"
		case 02:
#line 97 "src/term_curses.vala"
		case 03:
#line 97 "src/term_curses.vala"
		case 04:
#line 97 "src/term_curses.vala"
		case 05:
#line 97 "src/term_curses.vala"
		case 06:
#line 97 "src/term_curses.vala"
		case 07:
#line 97 "src/term_curses.vala"
		case 010:
#line 97 "src/term_curses.vala"
		case 012:
#line 97 "src/term_curses.vala"
		case 013:
#line 97 "src/term_curses.vala"
		case 014:
#line 97 "src/term_curses.vala"
		case 016:
#line 97 "src/term_curses.vala"
		case 017:
#line 97 "src/term_curses.vala"
		case 020:
#line 97 "src/term_curses.vala"
		case 021:
#line 97 "src/term_curses.vala"
		case 022:
#line 97 "src/term_curses.vala"
		case 023:
#line 97 "src/term_curses.vala"
		case 024:
#line 97 "src/term_curses.vala"
		case 025:
#line 97 "src/term_curses.vala"
		case 026:
#line 97 "src/term_curses.vala"
		case 027:
#line 97 "src/term_curses.vala"
		case 030:
#line 97 "src/term_curses.vala"
		case 031:
#line 97 "src/term_curses.vala"
		case 032:
#line 391 "term_curses.c"
		{
#line 124 "src/term_curses.vala"
			result = (guint) (KBD_CTRL | (('a' + c) - 1));
#line 124 "src/term_curses.vala"
			return result;
#line 397 "term_curses.c"
		}
#line 97 "src/term_curses.vala"
		case 011:
#line 401 "term_curses.c"
		{
#line 126 "src/term_curses.vala"
			result = (guint) KBD_TAB;
#line 126 "src/term_curses.vala"
			return result;
#line 407 "term_curses.c"
		}
#line 97 "src/term_curses.vala"
		case 015:
#line 411 "term_curses.c"
		{
#line 128 "src/term_curses.vala"
			result = (guint) KBD_RET;
#line 128 "src/term_curses.vala"
			return result;
#line 417 "term_curses.c"
		}
#line 97 "src/term_curses.vala"
		case 037:
#line 421 "term_curses.c"
		{
#line 130 "src/term_curses.vala"
			result = (guint) (KBD_CTRL | '_');
#line 130 "src/term_curses.vala"
			return result;
#line 427 "term_curses.c"
		}
#line 97 "src/term_curses.vala"
		case KEY_SUSPEND:
#line 431 "term_curses.c"
		{
#line 132 "src/term_curses.vala"
			result = (guint) (KBD_CTRL | 'z');
#line 132 "src/term_curses.vala"
			return result;
#line 437 "term_curses.c"
		}
#line 97 "src/term_curses.vala"
		case 033:
#line 441 "term_curses.c"
		{
#line 134 "src/term_curses.vala"
			result = (guint) KBD_META;
#line 134 "src/term_curses.vala"
			return result;
#line 447 "term_curses.c"
		}
#line 97 "src/term_curses.vala"
		case KEY_PPAGE:
#line 451 "term_curses.c"
		{
#line 136 "src/term_curses.vala"
			result = (guint) KBD_PGUP;
#line 136 "src/term_curses.vala"
			return result;
#line 457 "term_curses.c"
		}
#line 97 "src/term_curses.vala"
		case KEY_NPAGE:
#line 461 "term_curses.c"
		{
#line 138 "src/term_curses.vala"
			result = (guint) KBD_PGDN;
#line 138 "src/term_curses.vala"
			return result;
#line 467 "term_curses.c"
		}
#line 97 "src/term_curses.vala"
		case KEY_HOME:
#line 471 "term_curses.c"
		{
#line 140 "src/term_curses.vala"
			result = (guint) KBD_HOME;
#line 140 "src/term_curses.vala"
			return result;
#line 477 "term_curses.c"
		}
#line 97 "src/term_curses.vala"
		case KEY_END:
#line 481 "term_curses.c"
		{
#line 142 "src/term_curses.vala"
			result = (guint) KBD_END;
#line 142 "src/term_curses.vala"
			return result;
#line 487 "term_curses.c"
		}
#line 97 "src/term_curses.vala"
		case KEY_DC:
#line 491 "term_curses.c"
		{
#line 144 "src/term_curses.vala"
			result = (guint) KBD_DEL;
#line 144 "src/term_curses.vala"
			return result;
#line 497 "term_curses.c"
		}
#line 97 "src/term_curses.vala"
		case KEY_BACKSPACE:
#line 501 "term_curses.c"
		{
#line 146 "src/term_curses.vala"
			result = codetokey (backspace_code);
#line 146 "src/term_curses.vala"
			return result;
#line 507 "term_curses.c"
		}
#line 97 "src/term_curses.vala"
		case 0177:
#line 511 "term_curses.c"
		{
#line 148 "src/term_curses.vala"
			result = (guint) KBD_BS;
#line 148 "src/term_curses.vala"
			return result;
#line 517 "term_curses.c"
		}
#line 97 "src/term_curses.vala"
		case KEY_IC:
#line 521 "term_curses.c"
		{
#line 150 "src/term_curses.vala"
			result = (guint) KBD_INS;
#line 150 "src/term_curses.vala"
			return result;
#line 527 "term_curses.c"
		}
#line 97 "src/term_curses.vala"
		case KEY_LEFT:
#line 531 "term_curses.c"
		{
#line 152 "src/term_curses.vala"
			result = (guint) KBD_LEFT;
#line 152 "src/term_curses.vala"
			return result;
#line 537 "term_curses.c"
		}
#line 97 "src/term_curses.vala"
		case KEY_RIGHT:
#line 541 "term_curses.c"
		{
#line 154 "src/term_curses.vala"
			result = (guint) KBD_RIGHT;
#line 154 "src/term_curses.vala"
			return result;
#line 547 "term_curses.c"
		}
#line 97 "src/term_curses.vala"
		case KEY_UP:
#line 551 "term_curses.c"
		{
#line 156 "src/term_curses.vala"
			result = (guint) KBD_UP;
#line 156 "src/term_curses.vala"
			return result;
#line 557 "term_curses.c"
		}
#line 97 "src/term_curses.vala"
		case KEY_DOWN:
#line 561 "term_curses.c"
		{
#line 158 "src/term_curses.vala"
			result = (guint) KBD_DOWN;
#line 158 "src/term_curses.vala"
			return result;
#line 567 "term_curses.c"
		}
		default:
		{
#line 160 "src/term_curses.vala"
			if (c == ((guint) key_F (1))) {
#line 161 "src/term_curses.vala"
				result = (guint) KBD_F1;
#line 161 "src/term_curses.vala"
				return result;
#line 577 "term_curses.c"
			} else {
#line 162 "src/term_curses.vala"
				if (c == ((guint) key_F (2))) {
#line 163 "src/term_curses.vala"
					result = (guint) KBD_F2;
#line 163 "src/term_curses.vala"
					return result;
#line 585 "term_curses.c"
				} else {
#line 164 "src/term_curses.vala"
					if (c == ((guint) key_F (3))) {
#line 165 "src/term_curses.vala"
						result = (guint) KBD_F3;
#line 165 "src/term_curses.vala"
						return result;
#line 593 "term_curses.c"
					} else {
#line 166 "src/term_curses.vala"
						if (c == ((guint) key_F (4))) {
#line 167 "src/term_curses.vala"
							result = (guint) KBD_F4;
#line 167 "src/term_curses.vala"
							return result;
#line 601 "term_curses.c"
						} else {
#line 168 "src/term_curses.vala"
							if (c == ((guint) key_F (5))) {
#line 169 "src/term_curses.vala"
								result = (guint) KBD_F5;
#line 169 "src/term_curses.vala"
								return result;
#line 609 "term_curses.c"
							} else {
#line 170 "src/term_curses.vala"
								if (c == ((guint) key_F (6))) {
#line 171 "src/term_curses.vala"
									result = (guint) KBD_F6;
#line 171 "src/term_curses.vala"
									return result;
#line 617 "term_curses.c"
								} else {
#line 172 "src/term_curses.vala"
									if (c == ((guint) key_F (7))) {
#line 173 "src/term_curses.vala"
										result = (guint) KBD_F7;
#line 173 "src/term_curses.vala"
										return result;
#line 625 "term_curses.c"
									} else {
#line 174 "src/term_curses.vala"
										if (c == ((guint) key_F (8))) {
#line 175 "src/term_curses.vala"
											result = (guint) KBD_F8;
#line 175 "src/term_curses.vala"
											return result;
#line 633 "term_curses.c"
										} else {
#line 176 "src/term_curses.vala"
											if (c == ((guint) key_F (9))) {
#line 177 "src/term_curses.vala"
												result = (guint) KBD_F9;
#line 177 "src/term_curses.vala"
												return result;
#line 641 "term_curses.c"
											} else {
#line 178 "src/term_curses.vala"
												if (c == ((guint) key_F (10))) {
#line 179 "src/term_curses.vala"
													result = (guint) KBD_F10;
#line 179 "src/term_curses.vala"
													return result;
#line 649 "term_curses.c"
												} else {
#line 180 "src/term_curses.vala"
													if (c == ((guint) key_F (11))) {
#line 181 "src/term_curses.vala"
														result = (guint) KBD_F11;
#line 181 "src/term_curses.vala"
														return result;
#line 657 "term_curses.c"
													} else {
#line 182 "src/term_curses.vala"
														if (c == ((guint) key_F (12))) {
#line 183 "src/term_curses.vala"
															result = (guint) KBD_F12;
#line 183 "src/term_curses.vala"
															return result;
#line 665 "term_curses.c"
														} else {
#line 184 "src/term_curses.vala"
															if (c > ((guint) 0xff)) {
#line 185 "src/term_curses.vala"
																result = (guint) KBD_NOKEY;
#line 185 "src/term_curses.vala"
																return result;
#line 673 "term_curses.c"
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
#line 186 "src/term_curses.vala"
			result = c;
#line 186 "src/term_curses.vala"
			return result;
#line 691 "term_curses.c"
		}
	}
}

GeeList*
keytocodes (guint key)
{
	GeeArrayList* codevec = NULL;
	GeeArrayList* _tmp0_;
	GeeList* result = NULL;
#line 191 "src/term_curses.vala"
	_tmp0_ = gee_array_list_new (G_TYPE_UINT, NULL, NULL, NULL, NULL, NULL);
#line 191 "src/term_curses.vala"
	codevec = _tmp0_;
#line 193 "src/term_curses.vala"
	if (key == ((guint) KBD_NOKEY)) {
#line 194 "src/term_curses.vala"
		result = (GeeList*) codevec;
#line 194 "src/term_curses.vala"
		return result;
#line 712 "term_curses.c"
	}
#line 196 "src/term_curses.vala"
	if ((key & KBD_META) != ((guint) 0)) {
#line 716 "term_curses.c"
		GeeArrayList* _tmp1_;
#line 197 "src/term_curses.vala"
		_tmp1_ = codevec;
#line 197 "src/term_curses.vala"
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp1_, (gpointer) ((guintptr) ((guint) 033)));
#line 722 "term_curses.c"
	}
#line 198 "src/term_curses.vala"
	key = key & (~KBD_META);
#line 200 "src/term_curses.vala"
	switch (key) {
#line 200 "src/term_curses.vala"
		case KBD_CTRL | '@':
#line 730 "term_curses.c"
		{
			GeeArrayList* _tmp2_;
#line 202 "src/term_curses.vala"
			_tmp2_ = codevec;
#line 202 "src/term_curses.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp2_, (gpointer) ((guintptr) ((guint) '\0')));
#line 203 "src/term_curses.vala"
			break;
#line 739 "term_curses.c"
		}
#line 200 "src/term_curses.vala"
		case KBD_CTRL | 'a':
#line 200 "src/term_curses.vala"
		case KBD_CTRL | 'b':
#line 200 "src/term_curses.vala"
		case KBD_CTRL | 'c':
#line 200 "src/term_curses.vala"
		case KBD_CTRL | 'd':
#line 200 "src/term_curses.vala"
		case KBD_CTRL | 'e':
#line 200 "src/term_curses.vala"
		case KBD_CTRL | 'f':
#line 200 "src/term_curses.vala"
		case KBD_CTRL | 'g':
#line 200 "src/term_curses.vala"
		case KBD_CTRL | 'h':
#line 200 "src/term_curses.vala"
		case KBD_CTRL | 'j':
#line 200 "src/term_curses.vala"
		case KBD_CTRL | 'k':
#line 200 "src/term_curses.vala"
		case KBD_CTRL | 'l':
#line 200 "src/term_curses.vala"
		case KBD_CTRL | 'n':
#line 200 "src/term_curses.vala"
		case KBD_CTRL | 'o':
#line 200 "src/term_curses.vala"
		case KBD_CTRL | 'p':
#line 200 "src/term_curses.vala"
		case KBD_CTRL | 'q':
#line 200 "src/term_curses.vala"
		case KBD_CTRL | 'r':
#line 200 "src/term_curses.vala"
		case KBD_CTRL | 's':
#line 200 "src/term_curses.vala"
		case KBD_CTRL | 't':
#line 200 "src/term_curses.vala"
		case KBD_CTRL | 'u':
#line 200 "src/term_curses.vala"
		case KBD_CTRL | 'v':
#line 200 "src/term_curses.vala"
		case KBD_CTRL | 'w':
#line 200 "src/term_curses.vala"
		case KBD_CTRL | 'x':
#line 200 "src/term_curses.vala"
		case KBD_CTRL | 'y':
#line 200 "src/term_curses.vala"
		case KBD_CTRL | 'z':
#line 789 "term_curses.c"
		{
			GeeArrayList* _tmp3_;
#line 228 "src/term_curses.vala"
			_tmp3_ = codevec;
#line 228 "src/term_curses.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp3_, (gpointer) ((guintptr) (((key & (~KBD_CTRL)) + 1) - 'a')));
#line 229 "src/term_curses.vala"
			break;
#line 798 "term_curses.c"
		}
#line 200 "src/term_curses.vala"
		case KBD_TAB:
#line 802 "term_curses.c"
		{
			GeeArrayList* _tmp4_;
#line 231 "src/term_curses.vala"
			_tmp4_ = codevec;
#line 231 "src/term_curses.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp4_, (gpointer) ((guintptr) ((guint) 011)));
#line 232 "src/term_curses.vala"
			break;
#line 811 "term_curses.c"
		}
#line 200 "src/term_curses.vala"
		case KBD_RET:
#line 815 "term_curses.c"
		{
			GeeArrayList* _tmp5_;
#line 234 "src/term_curses.vala"
			_tmp5_ = codevec;
#line 234 "src/term_curses.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp5_, (gpointer) ((guintptr) ((guint) 015)));
#line 235 "src/term_curses.vala"
			break;
#line 824 "term_curses.c"
		}
#line 200 "src/term_curses.vala"
		case KBD_CTRL | '_':
#line 828 "term_curses.c"
		{
			GeeArrayList* _tmp6_;
#line 237 "src/term_curses.vala"
			_tmp6_ = codevec;
#line 237 "src/term_curses.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp6_, (gpointer) ((guintptr) ((guint) 037)));
#line 238 "src/term_curses.vala"
			break;
#line 837 "term_curses.c"
		}
#line 200 "src/term_curses.vala"
		case KBD_PGUP:
#line 841 "term_curses.c"
		{
			GeeArrayList* _tmp7_;
#line 240 "src/term_curses.vala"
			_tmp7_ = codevec;
#line 240 "src/term_curses.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp7_, (gpointer) ((guintptr) ((guint) KEY_PPAGE)));
#line 241 "src/term_curses.vala"
			break;
#line 850 "term_curses.c"
		}
#line 200 "src/term_curses.vala"
		case KBD_PGDN:
#line 854 "term_curses.c"
		{
			GeeArrayList* _tmp8_;
#line 243 "src/term_curses.vala"
			_tmp8_ = codevec;
#line 243 "src/term_curses.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp8_, (gpointer) ((guintptr) ((guint) KEY_NPAGE)));
#line 244 "src/term_curses.vala"
			break;
#line 863 "term_curses.c"
		}
#line 200 "src/term_curses.vala"
		case KBD_HOME:
#line 867 "term_curses.c"
		{
			GeeArrayList* _tmp9_;
#line 246 "src/term_curses.vala"
			_tmp9_ = codevec;
#line 246 "src/term_curses.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp9_, (gpointer) ((guintptr) ((guint) KEY_HOME)));
#line 247 "src/term_curses.vala"
			break;
#line 876 "term_curses.c"
		}
#line 200 "src/term_curses.vala"
		case KBD_END:
#line 880 "term_curses.c"
		{
			GeeArrayList* _tmp10_;
#line 249 "src/term_curses.vala"
			_tmp10_ = codevec;
#line 249 "src/term_curses.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp10_, (gpointer) ((guintptr) ((guint) KEY_END)));
#line 250 "src/term_curses.vala"
			break;
#line 889 "term_curses.c"
		}
#line 200 "src/term_curses.vala"
		case KBD_DEL:
#line 893 "term_curses.c"
		{
			GeeArrayList* _tmp11_;
#line 252 "src/term_curses.vala"
			_tmp11_ = codevec;
#line 252 "src/term_curses.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp11_, (gpointer) ((guintptr) ((guint) KEY_DC)));
#line 253 "src/term_curses.vala"
			break;
#line 902 "term_curses.c"
		}
#line 200 "src/term_curses.vala"
		case KBD_BS:
#line 906 "term_curses.c"
		{
			GeeArrayList* _tmp12_;
#line 255 "src/term_curses.vala"
			_tmp12_ = codevec;
#line 255 "src/term_curses.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp12_, (gpointer) ((guintptr) ((guint) 0177)));
#line 256 "src/term_curses.vala"
			break;
#line 915 "term_curses.c"
		}
#line 200 "src/term_curses.vala"
		case KBD_INS:
#line 919 "term_curses.c"
		{
			GeeArrayList* _tmp13_;
#line 258 "src/term_curses.vala"
			_tmp13_ = codevec;
#line 258 "src/term_curses.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp13_, (gpointer) ((guintptr) ((guint) KEY_IC)));
#line 259 "src/term_curses.vala"
			break;
#line 928 "term_curses.c"
		}
#line 200 "src/term_curses.vala"
		case KBD_LEFT:
#line 932 "term_curses.c"
		{
			GeeArrayList* _tmp14_;
#line 261 "src/term_curses.vala"
			_tmp14_ = codevec;
#line 261 "src/term_curses.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp14_, (gpointer) ((guintptr) ((guint) KEY_LEFT)));
#line 262 "src/term_curses.vala"
			break;
#line 941 "term_curses.c"
		}
#line 200 "src/term_curses.vala"
		case KBD_RIGHT:
#line 945 "term_curses.c"
		{
			GeeArrayList* _tmp15_;
#line 264 "src/term_curses.vala"
			_tmp15_ = codevec;
#line 264 "src/term_curses.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp15_, (gpointer) ((guintptr) ((guint) KEY_RIGHT)));
#line 265 "src/term_curses.vala"
			break;
#line 954 "term_curses.c"
		}
#line 200 "src/term_curses.vala"
		case KBD_UP:
#line 958 "term_curses.c"
		{
			GeeArrayList* _tmp16_;
#line 267 "src/term_curses.vala"
			_tmp16_ = codevec;
#line 267 "src/term_curses.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp16_, (gpointer) ((guintptr) ((guint) KEY_UP)));
#line 268 "src/term_curses.vala"
			break;
#line 967 "term_curses.c"
		}
#line 200 "src/term_curses.vala"
		case KBD_DOWN:
#line 971 "term_curses.c"
		{
			GeeArrayList* _tmp17_;
#line 270 "src/term_curses.vala"
			_tmp17_ = codevec;
#line 270 "src/term_curses.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp17_, (gpointer) ((guintptr) ((guint) KEY_DOWN)));
#line 271 "src/term_curses.vala"
			break;
#line 980 "term_curses.c"
		}
#line 200 "src/term_curses.vala"
		case KBD_F1:
#line 984 "term_curses.c"
		{
			GeeArrayList* _tmp18_;
#line 273 "src/term_curses.vala"
			_tmp18_ = codevec;
#line 273 "src/term_curses.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp18_, (gpointer) ((guintptr) ((guint) key_F (1))));
#line 274 "src/term_curses.vala"
			break;
#line 993 "term_curses.c"
		}
#line 200 "src/term_curses.vala"
		case KBD_F2:
#line 997 "term_curses.c"
		{
			GeeArrayList* _tmp19_;
#line 276 "src/term_curses.vala"
			_tmp19_ = codevec;
#line 276 "src/term_curses.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp19_, (gpointer) ((guintptr) ((guint) key_F (2))));
#line 277 "src/term_curses.vala"
			break;
#line 1006 "term_curses.c"
		}
#line 200 "src/term_curses.vala"
		case KBD_F3:
#line 1010 "term_curses.c"
		{
			GeeArrayList* _tmp20_;
#line 279 "src/term_curses.vala"
			_tmp20_ = codevec;
#line 279 "src/term_curses.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp20_, (gpointer) ((guintptr) ((guint) key_F (3))));
#line 280 "src/term_curses.vala"
			break;
#line 1019 "term_curses.c"
		}
#line 200 "src/term_curses.vala"
		case KBD_F4:
#line 1023 "term_curses.c"
		{
			GeeArrayList* _tmp21_;
#line 282 "src/term_curses.vala"
			_tmp21_ = codevec;
#line 282 "src/term_curses.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp21_, (gpointer) ((guintptr) ((guint) key_F (4))));
#line 283 "src/term_curses.vala"
			break;
#line 1032 "term_curses.c"
		}
#line 200 "src/term_curses.vala"
		case KBD_F5:
#line 1036 "term_curses.c"
		{
			GeeArrayList* _tmp22_;
#line 285 "src/term_curses.vala"
			_tmp22_ = codevec;
#line 285 "src/term_curses.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp22_, (gpointer) ((guintptr) ((guint) key_F (5))));
#line 286 "src/term_curses.vala"
			break;
#line 1045 "term_curses.c"
		}
#line 200 "src/term_curses.vala"
		case KBD_F6:
#line 1049 "term_curses.c"
		{
			GeeArrayList* _tmp23_;
#line 288 "src/term_curses.vala"
			_tmp23_ = codevec;
#line 288 "src/term_curses.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp23_, (gpointer) ((guintptr) ((guint) key_F (6))));
#line 289 "src/term_curses.vala"
			break;
#line 1058 "term_curses.c"
		}
#line 200 "src/term_curses.vala"
		case KBD_F7:
#line 1062 "term_curses.c"
		{
			GeeArrayList* _tmp24_;
#line 291 "src/term_curses.vala"
			_tmp24_ = codevec;
#line 291 "src/term_curses.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp24_, (gpointer) ((guintptr) ((guint) key_F (7))));
#line 292 "src/term_curses.vala"
			break;
#line 1071 "term_curses.c"
		}
#line 200 "src/term_curses.vala"
		case KBD_F8:
#line 1075 "term_curses.c"
		{
			GeeArrayList* _tmp25_;
#line 294 "src/term_curses.vala"
			_tmp25_ = codevec;
#line 294 "src/term_curses.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp25_, (gpointer) ((guintptr) ((guint) key_F (8))));
#line 295 "src/term_curses.vala"
			break;
#line 1084 "term_curses.c"
		}
#line 200 "src/term_curses.vala"
		case KBD_F9:
#line 1088 "term_curses.c"
		{
			GeeArrayList* _tmp26_;
#line 297 "src/term_curses.vala"
			_tmp26_ = codevec;
#line 297 "src/term_curses.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp26_, (gpointer) ((guintptr) ((guint) key_F (9))));
#line 298 "src/term_curses.vala"
			break;
#line 1097 "term_curses.c"
		}
#line 200 "src/term_curses.vala"
		case KBD_F10:
#line 1101 "term_curses.c"
		{
			GeeArrayList* _tmp27_;
#line 300 "src/term_curses.vala"
			_tmp27_ = codevec;
#line 300 "src/term_curses.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp27_, (gpointer) ((guintptr) ((guint) key_F (10))));
#line 301 "src/term_curses.vala"
			break;
#line 1110 "term_curses.c"
		}
#line 200 "src/term_curses.vala"
		case KBD_F11:
#line 1114 "term_curses.c"
		{
			GeeArrayList* _tmp28_;
#line 303 "src/term_curses.vala"
			_tmp28_ = codevec;
#line 303 "src/term_curses.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp28_, (gpointer) ((guintptr) ((guint) key_F (11))));
#line 304 "src/term_curses.vala"
			break;
#line 1123 "term_curses.c"
		}
#line 200 "src/term_curses.vala"
		case KBD_F12:
#line 1127 "term_curses.c"
		{
			GeeArrayList* _tmp29_;
#line 306 "src/term_curses.vala"
			_tmp29_ = codevec;
#line 306 "src/term_curses.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp29_, (gpointer) ((guintptr) ((guint) key_F (12))));
#line 307 "src/term_curses.vala"
			break;
#line 1136 "term_curses.c"
		}
		default:
		{
#line 309 "src/term_curses.vala"
			if ((key & 0xff) == key) {
#line 1142 "term_curses.c"
				GeeArrayList* _tmp30_;
#line 310 "src/term_curses.vala"
				_tmp30_ = codevec;
#line 310 "src/term_curses.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp30_, (gpointer) ((guintptr) key));
#line 1148 "term_curses.c"
			}
#line 311 "src/term_curses.vala"
			break;
#line 1152 "term_curses.c"
		}
	}
#line 314 "src/term_curses.vala"
	result = (GeeList*) codevec;
#line 314 "src/term_curses.vala"
	return result;
#line 1159 "term_curses.c"
}

guint
get_char (gint delay)
{
	guint c = 0U;
	guint size = 0U;
	guint result = 0U;
#line 318 "src/term_curses.vala"
	c = (guint) 0;
#line 320 "src/term_curses.vala"
	size = term_buf_len ();
#line 321 "src/term_curses.vala"
	if (size > ((guint) 0)) {
#line 1174 "term_curses.c"
		GeeList* _tmp0_;
		gpointer _tmp1_;
		GeeList* _tmp2_;
#line 322 "src/term_curses.vala"
		_tmp0_ = key_buf;
#line 322 "src/term_curses.vala"
		_tmp1_ = gee_list_get (_tmp0_, ((gint) size) - 1);
#line 322 "src/term_curses.vala"
		c = (guint) ((guintptr) _tmp1_);
#line 323 "src/term_curses.vala"
		_tmp2_ = key_buf;
#line 323 "src/term_curses.vala"
		gee_list_remove_at (_tmp2_, ((gint) size) - 1);
#line 1188 "term_curses.c"
	} else {
#line 325 "src/term_curses.vala"
		timeout (delay);
#line 1192 "term_curses.c"
		{
			gboolean _tmp3_ = FALSE;
#line 327 "src/term_curses.vala"
			_tmp3_ = TRUE;
#line 327 "src/term_curses.vala"
			while (TRUE) {
#line 327 "src/term_curses.vala"
				if (!_tmp3_) {
#line 332 "src/term_curses.vala"
					if (!(c == ((guint) KEY_RESIZE))) {
#line 332 "src/term_curses.vala"
						break;
#line 1205 "term_curses.c"
					}
				}
#line 327 "src/term_curses.vala"
				_tmp3_ = FALSE;
#line 328 "src/term_curses.vala"
				c = (guint) getch ();
#line 330 "src/term_curses.vala"
				if (c == ((guint) KEY_RESIZE)) {
#line 331 "src/term_curses.vala"
					resize_windows ();
#line 1216 "term_curses.c"
				}
			}
		}
	}
#line 335 "src/term_curses.vala"
	result = c;
#line 335 "src/term_curses.vala"
	return result;
#line 1225 "term_curses.c"
}

guint
term_getkey (gint delay)
{
	guint key = 0U;
	guint result = 0U;
#line 339 "src/term_curses.vala"
	key = codetokey (get_char (delay));
#line 340 "src/term_curses.vala"
	while (TRUE) {
#line 340 "src/term_curses.vala"
		if (!(key == ((guint) KBD_META))) {
#line 340 "src/term_curses.vala"
			break;
#line 1241 "term_curses.c"
		}
#line 341 "src/term_curses.vala"
		key = codetokey (get_char (GETKEY_DEFAULT)) | KBD_META;
#line 1245 "term_curses.c"
	}
#line 342 "src/term_curses.vala"
	result = key;
#line 342 "src/term_curses.vala"
	return result;
#line 1251 "term_curses.c"
}

guint
term_getkey_unfiltered (gint delay)
{
	WINDOW* _tmp0_;
	guint key = 0U;
	WINDOW* _tmp1_;
	guint result = 0U;
#line 346 "src/term_curses.vala"
	_tmp0_ = stdscr;
#line 346 "src/term_curses.vala"
	keypad (_tmp0_, FALSE);
#line 347 "src/term_curses.vala"
	key = get_char (delay);
#line 348 "src/term_curses.vala"
	_tmp1_ = stdscr;
#line 348 "src/term_curses.vala"
	keypad (_tmp1_, TRUE);
#line 349 "src/term_curses.vala"
	result = key;
#line 349 "src/term_curses.vala"
	return result;
#line 1275 "term_curses.c"
}

void
term_ungetkey (guint key)
{
	GeeList* codes = NULL;
	GeeList* _tmp0_;
#line 353 "src/term_curses.vala"
	_tmp0_ = keytocodes (key);
#line 353 "src/term_curses.vala"
	codes = _tmp0_;
#line 1287 "term_curses.c"
	{
		gint i = 0;
		GeeList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
#line 354 "src/term_curses.vala"
		_tmp1_ = codes;
#line 354 "src/term_curses.vala"
		_tmp2_ = gee_collection_get_size ((GeeCollection*) _tmp1_);
#line 354 "src/term_curses.vala"
		_tmp3_ = _tmp2_;
#line 354 "src/term_curses.vala"
		i = _tmp3_;
#line 1301 "term_curses.c"
		{
			gboolean _tmp4_ = FALSE;
#line 354 "src/term_curses.vala"
			_tmp4_ = TRUE;
#line 354 "src/term_curses.vala"
			while (TRUE) {
#line 1308 "term_curses.c"
				GeeList* _tmp6_;
				GeeList* _tmp7_;
				gpointer _tmp8_;
#line 354 "src/term_curses.vala"
				if (!_tmp4_) {
#line 1314 "term_curses.c"
					gint _tmp5_;
#line 354 "src/term_curses.vala"
					_tmp5_ = i;
#line 354 "src/term_curses.vala"
					i = _tmp5_ - 1;
#line 1320 "term_curses.c"
				}
#line 354 "src/term_curses.vala"
				_tmp4_ = FALSE;
#line 354 "src/term_curses.vala"
				if (!(i > 0)) {
#line 354 "src/term_curses.vala"
					break;
#line 1328 "term_curses.c"
				}
#line 355 "src/term_curses.vala"
				_tmp6_ = key_buf;
#line 355 "src/term_curses.vala"
				_tmp7_ = codes;
#line 355 "src/term_curses.vala"
				_tmp8_ = gee_list_get (_tmp7_, i - 1);
#line 355 "src/term_curses.vala"
				gee_collection_add ((GeeCollection*) _tmp6_, (gpointer) ((guintptr) ((guint) ((guintptr) _tmp8_))));
#line 1338 "term_curses.c"
			}
		}
	}
#line 352 "src/term_curses.vala"
	_g_object_unref0 (codes);
#line 1344 "term_curses.c"
}

