/* keycode.c generated by valac 0.50.1.42-81856-dirty, the Vala compiler
 * generated from keycode.vala, do not modify */

/* Key encoding and decoding functions

   Copyright (c) 1997-2020 Free Software Foundation, Inc.

   This file is part of GNU Zile.

   GNU Zile is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   GNU Zile is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, see <https://www.gnu.org/licenses/>.  */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>

#define TYPE_KEY_INFO (key_info_get_type ())
typedef struct _KeyInfo KeyInfo;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef gchar* (*KeyStringifier) (gsize key, gpointer user_data);
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _KeyInfo {
	gint code;
	gchar* name;
	gchar* desc;
};

#define KBD_NOKEY G_MAXINT
#define KBD_CTRL 01000
#define KBD_META 02000
#define KBD_CANCEL (KBD_CTRL | 'g')
#define KBD_TAB 00402
#define KBD_RET 00403
#define KBD_PGUP 00404
#define KBD_PGDN 00405
#define KBD_HOME 00406
#define KBD_END 00407
#define KBD_DEL 00410
#define KBD_BS 00411
#define KBD_INS 00412
#define KBD_LEFT 00413
#define KBD_RIGHT 00414
#define KBD_UP 00415
#define KBD_DOWN 00416
#define KBD_F1 00420
#define KBD_F2 00421
#define KBD_F3 00422
#define KBD_F4 00423
#define KBD_F5 00424
#define KBD_F6 00425
#define KBD_F7 00426
#define KBD_F8 00427
#define KBD_F9 00430
#define KBD_F10 00431
#define KBD_F11 00432
#define KBD_F12 00433
GType key_info_get_type (void) G_GNUC_CONST ;
KeyInfo* key_info_dup (const KeyInfo* self);
void key_info_free (KeyInfo* self);
void key_info_copy (const KeyInfo* self,
                    KeyInfo* dest);
void key_info_destroy (KeyInfo* self);
gchar* keytostr (gsize key);
gchar* keytodesc (gsize key);
gchar* chordtostr (gsize key,
                   KeyStringifier func,
                   gpointer func_target);
gchar* chordtodesc (gsize key);
static gchar* _keytodesc_key_stringifier (gsize key,
                                   gpointer self);
guint strtokey (const gchar* buf,
                guint* len);
guint strtochord (const gchar* buf,
                  guint* len);
GeeList* keystrtovec (const gchar* key);
gchar* keyvectostr (GeeList* keys);
static gchar* _keytostr_key_stringifier (gsize key,
                                  gpointer self);
gchar* keyvectodesc (GeeList* keys);
static void _vala_array_add2 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);

const KeyInfo keyinfo[34] = {{KBD_BS, "\\BACKSPACE", "<backspace>"}, {KBD_CTRL, "\\C-", "C-"}, {KBD_DEL, "\\DELETE", "<delete>"}, {KBD_DOWN, "\\DOWN", "<down>"}, {033, "\\e", NULL}, {KBD_END, "\\END", "<end>"}, {KBD_F1, "\\F1", "<f1>"}, {KBD_F10, "\\F10", "<f10>"}, {KBD_F11, "\\F11", "<f11>"}, {KBD_F12, "\\F12", "<f12>"}, {KBD_F2, "\\F2", "<f2>"}, {KBD_F3, "\\F3", "<f3>"}, {KBD_F4, "\\F4", "<f4>"}, {KBD_F5, "\\F5", "<f5>"}, {KBD_F6, "\\F6", "<f6>"}, {KBD_F7, "\\F7", "<f7>"}, {KBD_F8, "\\F8", "<f8>"}, {KBD_F9, "\\F9", "<f9>"}, {KBD_HOME, "\\HOME", "<home>"}, {KBD_INS, "\\INSERT", "<insert>"}, {KBD_LEFT, "\\LEFT", "<left>"}, {KBD_META, "\\M-", "M-"}, {KBD_PGDN, "\\NEXT", "<next>"}, {KBD_PGDN, "\\PAGEDOWN", "<pagedown>"}, {KBD_PGUP, "\\PAGEUP", "<pageup>"}, {KBD_PGUP, "\\PRIOR", "<prior>"}, {KBD_RET, "\\RET", "<RET>"}, {KBD_RET, "\\r", NULL}, {KBD_RIGHT, "\\RIGHT", "<right>"}, {(gint) ' ', "\\SPC", "SPC"}, {KBD_TAB, "\\TAB", "<TAB>"}, {KBD_TAB, "\\t", NULL}, {KBD_UP, "\\UP", "<up>"}, {(gint) '\\', "\\\\", "\\"}};

void
key_info_copy (const KeyInfo* self,
               KeyInfo* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
#line 57 "src/keycode.vala"
	(*dest).code = (*self).code;
#line 57 "src/keycode.vala"
	_tmp0_ = (*self).name;
#line 57 "src/keycode.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 57 "src/keycode.vala"
	_g_free0 ((*dest).name);
#line 57 "src/keycode.vala"
	(*dest).name = _tmp1_;
#line 57 "src/keycode.vala"
	_tmp2_ = (*self).desc;
#line 57 "src/keycode.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 57 "src/keycode.vala"
	_g_free0 ((*dest).desc);
#line 57 "src/keycode.vala"
	(*dest).desc = _tmp3_;
#line 133 "keycode.c"
}

void
key_info_destroy (KeyInfo* self)
{
#line 59 "src/keycode.vala"
	_g_free0 ((*self).name);
#line 60 "src/keycode.vala"
	_g_free0 ((*self).desc);
#line 143 "keycode.c"
}

KeyInfo*
key_info_dup (const KeyInfo* self)
{
	KeyInfo* dup;
#line 57 "src/keycode.vala"
	dup = g_new0 (KeyInfo, 1);
#line 57 "src/keycode.vala"
	key_info_copy (self, dup);
#line 57 "src/keycode.vala"
	return dup;
#line 156 "keycode.c"
}

void
key_info_free (KeyInfo* self)
{
#line 57 "src/keycode.vala"
	key_info_destroy (self);
#line 57 "src/keycode.vala"
	g_free (self);
#line 166 "keycode.c"
}

static GType
key_info_get_type_once (void)
{
	GType key_info_type_id;
	key_info_type_id = g_boxed_type_register_static ("KeyInfo", (GBoxedCopyFunc) key_info_dup, (GBoxedFreeFunc) key_info_free);
	return key_info_type_id;
}

GType
key_info_get_type (void)
{
	static volatile gsize key_info_type_id__volatile = 0;
	if (g_once_init_enter (&key_info_type_id__volatile)) {
		GType key_info_type_id;
		key_info_type_id = key_info_get_type_once ();
		g_once_init_leave (&key_info_type_id__volatile, key_info_type_id);
	}
	return key_info_type_id__volatile;
}

gchar*
keytostr (gsize key)
{
	gboolean _tmp6_ = FALSE;
	gchar* result = NULL;
	{
		guint i = 0U;
#line 106 "src/keycode.vala"
		i = (guint) 0;
#line 198 "keycode.c"
		{
			gboolean _tmp0_ = FALSE;
#line 106 "src/keycode.vala"
			_tmp0_ = TRUE;
#line 106 "src/keycode.vala"
			while (TRUE) {
#line 205 "keycode.c"
				KeyInfo _tmp2_;
#line 106 "src/keycode.vala"
				if (!_tmp0_) {
#line 209 "keycode.c"
					guint _tmp1_;
#line 106 "src/keycode.vala"
					_tmp1_ = i;
#line 106 "src/keycode.vala"
					i = _tmp1_ + 1;
#line 215 "keycode.c"
				}
#line 106 "src/keycode.vala"
				_tmp0_ = FALSE;
#line 106 "src/keycode.vala"
				if (!(i < ((guint) G_N_ELEMENTS (keyinfo)))) {
#line 106 "src/keycode.vala"
					break;
#line 223 "keycode.c"
				}
#line 107 "src/keycode.vala"
				_tmp2_ = keyinfo[i];
#line 107 "src/keycode.vala"
				if (((gsize) _tmp2_.code) == key) {
#line 229 "keycode.c"
					KeyInfo _tmp3_;
					const gchar* _tmp4_;
					gchar* _tmp5_;
#line 108 "src/keycode.vala"
					_tmp3_ = keyinfo[i];
#line 108 "src/keycode.vala"
					_tmp4_ = _tmp3_.name;
#line 108 "src/keycode.vala"
					_tmp5_ = g_strdup (_tmp4_);
#line 108 "src/keycode.vala"
					result = _tmp5_;
#line 108 "src/keycode.vala"
					return result;
#line 243 "keycode.c"
				}
			}
		}
	}
#line 109 "src/keycode.vala"
	if (key <= ((gsize) 0xff)) {
#line 109 "src/keycode.vala"
		_tmp6_ = g_ascii_isgraph ((gchar) key);
#line 252 "keycode.c"
	} else {
#line 109 "src/keycode.vala"
		_tmp6_ = FALSE;
#line 256 "keycode.c"
	}
#line 109 "src/keycode.vala"
	if (_tmp6_) {
#line 260 "keycode.c"
		gchar* _tmp7_;
#line 110 "src/keycode.vala"
		_tmp7_ = g_strdup_printf ("%c", (gchar) key);
#line 110 "src/keycode.vala"
		result = _tmp7_;
#line 110 "src/keycode.vala"
		return result;
#line 268 "keycode.c"
	}
#line 111 "src/keycode.vala"
	result = NULL;
#line 111 "src/keycode.vala"
	return result;
#line 274 "keycode.c"
}

gchar*
keytodesc (gsize key)
{
	gboolean _tmp6_ = FALSE;
	gchar* _tmp8_;
	gchar* result = NULL;
	{
		guint i = 0U;
#line 118 "src/keycode.vala"
		i = (guint) 0;
#line 287 "keycode.c"
		{
			gboolean _tmp0_ = FALSE;
#line 118 "src/keycode.vala"
			_tmp0_ = TRUE;
#line 118 "src/keycode.vala"
			while (TRUE) {
#line 294 "keycode.c"
				KeyInfo _tmp2_;
#line 118 "src/keycode.vala"
				if (!_tmp0_) {
#line 298 "keycode.c"
					guint _tmp1_;
#line 118 "src/keycode.vala"
					_tmp1_ = i;
#line 118 "src/keycode.vala"
					i = _tmp1_ + 1;
#line 304 "keycode.c"
				}
#line 118 "src/keycode.vala"
				_tmp0_ = FALSE;
#line 118 "src/keycode.vala"
				if (!(i < ((guint) G_N_ELEMENTS (keyinfo)))) {
#line 118 "src/keycode.vala"
					break;
#line 312 "keycode.c"
				}
#line 119 "src/keycode.vala"
				_tmp2_ = keyinfo[i];
#line 119 "src/keycode.vala"
				if (((gsize) _tmp2_.code) == key) {
#line 318 "keycode.c"
					KeyInfo _tmp3_;
					const gchar* _tmp4_;
					gchar* _tmp5_;
#line 120 "src/keycode.vala"
					_tmp3_ = keyinfo[i];
#line 120 "src/keycode.vala"
					_tmp4_ = _tmp3_.desc;
#line 120 "src/keycode.vala"
					_tmp5_ = g_strdup (_tmp4_);
#line 120 "src/keycode.vala"
					result = _tmp5_;
#line 120 "src/keycode.vala"
					return result;
#line 332 "keycode.c"
				}
			}
		}
	}
#line 121 "src/keycode.vala"
	if (key <= ((gsize) 0xff)) {
#line 121 "src/keycode.vala"
		_tmp6_ = g_ascii_isgraph ((gchar) key);
#line 341 "keycode.c"
	} else {
#line 121 "src/keycode.vala"
		_tmp6_ = FALSE;
#line 345 "keycode.c"
	}
#line 121 "src/keycode.vala"
	if (_tmp6_) {
#line 349 "keycode.c"
		gchar* _tmp7_;
#line 122 "src/keycode.vala"
		_tmp7_ = g_strdup_printf ("%c", (gchar) key);
#line 122 "src/keycode.vala"
		result = _tmp7_;
#line 122 "src/keycode.vala"
		return result;
#line 357 "keycode.c"
	}
#line 123 "src/keycode.vala"
	_tmp8_ = g_strdup_printf ("<%zx>", key);
#line 123 "src/keycode.vala"
	result = _tmp8_;
#line 123 "src/keycode.vala"
	return result;
#line 365 "keycode.c"
}

gchar*
chordtostr (gsize key,
            KeyStringifier func,
            gpointer func_target)
{
	gchar* chord_string = NULL;
	gchar* _tmp0_;
	gchar* key_string = NULL;
	gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* result = NULL;
#line 131 "src/keycode.vala"
	_tmp0_ = g_strdup ("");
#line 131 "src/keycode.vala"
	chord_string = _tmp0_;
#line 133 "src/keycode.vala"
	if ((key & KBD_CTRL) != ((gsize) 0)) {
#line 385 "keycode.c"
		const gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
#line 134 "src/keycode.vala"
		_tmp1_ = chord_string;
#line 134 "src/keycode.vala"
		_tmp2_ = func ((gsize) KBD_CTRL, func_target);
#line 134 "src/keycode.vala"
		_tmp3_ = _tmp2_;
#line 134 "src/keycode.vala"
		_tmp4_ = g_strconcat (_tmp1_, _tmp3_, NULL);
#line 134 "src/keycode.vala"
		_g_free0 (chord_string);
#line 134 "src/keycode.vala"
		chord_string = _tmp4_;
#line 134 "src/keycode.vala"
		_g_free0 (_tmp3_);
#line 404 "keycode.c"
	}
#line 135 "src/keycode.vala"
	if ((key & KBD_META) != ((gsize) 0)) {
#line 408 "keycode.c"
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
#line 136 "src/keycode.vala"
		_tmp5_ = chord_string;
#line 136 "src/keycode.vala"
		_tmp6_ = func ((gsize) KBD_META, func_target);
#line 136 "src/keycode.vala"
		_tmp7_ = _tmp6_;
#line 136 "src/keycode.vala"
		_tmp8_ = g_strconcat (_tmp5_, _tmp7_, NULL);
#line 136 "src/keycode.vala"
		_g_free0 (chord_string);
#line 136 "src/keycode.vala"
		chord_string = _tmp8_;
#line 136 "src/keycode.vala"
		_g_free0 (_tmp7_);
#line 427 "keycode.c"
	}
#line 137 "src/keycode.vala"
	key = key & (~(KBD_CTRL | KBD_META));
#line 139 "src/keycode.vala"
	_tmp9_ = func (key, func_target);
#line 139 "src/keycode.vala"
	key_string = _tmp9_;
#line 140 "src/keycode.vala"
	_tmp10_ = key_string;
#line 140 "src/keycode.vala"
	if (_tmp10_ != NULL) {
#line 439 "keycode.c"
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
#line 141 "src/keycode.vala"
		_tmp11_ = chord_string;
#line 141 "src/keycode.vala"
		_tmp12_ = key_string;
#line 141 "src/keycode.vala"
		_tmp13_ = g_strconcat (_tmp11_, _tmp12_, NULL);
#line 141 "src/keycode.vala"
		result = _tmp13_;
#line 141 "src/keycode.vala"
		_g_free0 (key_string);
#line 141 "src/keycode.vala"
		_g_free0 (chord_string);
#line 141 "src/keycode.vala"
		return result;
#line 457 "keycode.c"
	}
#line 142 "src/keycode.vala"
	result = NULL;
#line 142 "src/keycode.vala"
	_g_free0 (key_string);
#line 142 "src/keycode.vala"
	_g_free0 (chord_string);
#line 142 "src/keycode.vala"
	return result;
#line 467 "keycode.c"
}

static gchar*
_keytodesc_key_stringifier (gsize key,
                            gpointer self)
{
	gchar* result;
	result = keytodesc (key);
#line 149 "src/keycode.vala"
	return result;
#line 478 "keycode.c"
}

gchar*
chordtodesc (gsize key)
{
	gchar* _tmp0_;
	gchar* result = NULL;
#line 149 "src/keycode.vala"
	_tmp0_ = chordtostr (key, _keytodesc_key_stringifier, NULL);
#line 149 "src/keycode.vala"
	result = _tmp0_;
#line 149 "src/keycode.vala"
	return result;
#line 492 "keycode.c"
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result = '\0';
#line 1232 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, '\0');
#line 1233 "glib-2.0.vapi"
	_tmp0_ = ((gchar*) self)[index];
#line 1233 "glib-2.0.vapi"
	result = _tmp0_;
#line 1233 "glib-2.0.vapi"
	return result;
#line 509 "keycode.c"
}

guint
strtokey (const gchar* buf,
          guint* len)
{
	guint _vala_len = 0U;
	guint result = 0U;
#line 155 "src/keycode.vala"
	g_return_val_if_fail (buf != NULL, 0U);
#line 156 "src/keycode.vala"
	if (string_get (buf, (glong) 0) == '\\') {
#line 522 "keycode.c"
		{
			guint i = 0U;
#line 157 "src/keycode.vala"
			i = (guint) 0;
#line 527 "keycode.c"
			{
				gboolean _tmp0_ = FALSE;
#line 157 "src/keycode.vala"
				_tmp0_ = TRUE;
#line 157 "src/keycode.vala"
				while (TRUE) {
#line 534 "keycode.c"
					KeyInfo _tmp2_;
					const gchar* _tmp3_;
#line 157 "src/keycode.vala"
					if (!_tmp0_) {
#line 539 "keycode.c"
						guint _tmp1_;
#line 157 "src/keycode.vala"
						_tmp1_ = i;
#line 157 "src/keycode.vala"
						i = _tmp1_ + 1;
#line 545 "keycode.c"
					}
#line 157 "src/keycode.vala"
					_tmp0_ = FALSE;
#line 157 "src/keycode.vala"
					if (!(i < ((guint) G_N_ELEMENTS (keyinfo)))) {
#line 157 "src/keycode.vala"
						break;
#line 553 "keycode.c"
					}
#line 158 "src/keycode.vala"
					_tmp2_ = keyinfo[i];
#line 158 "src/keycode.vala"
					_tmp3_ = _tmp2_.name;
#line 158 "src/keycode.vala"
					if (g_str_has_prefix (buf, _tmp3_)) {
#line 561 "keycode.c"
						KeyInfo _tmp4_;
						const gchar* _tmp5_;
						gint _tmp6_;
						gint _tmp7_;
						KeyInfo _tmp8_;
#line 159 "src/keycode.vala"
						_tmp4_ = keyinfo[i];
#line 159 "src/keycode.vala"
						_tmp5_ = _tmp4_.name;
#line 159 "src/keycode.vala"
						_tmp6_ = strlen (_tmp5_);
#line 159 "src/keycode.vala"
						_tmp7_ = _tmp6_;
#line 159 "src/keycode.vala"
						_vala_len = (guint) _tmp7_;
#line 160 "src/keycode.vala"
						_tmp8_ = keyinfo[i];
#line 160 "src/keycode.vala"
						result = (guint) _tmp8_.code;
#line 160 "src/keycode.vala"
						if (len) {
#line 160 "src/keycode.vala"
							*len = _vala_len;
#line 585 "keycode.c"
						}
#line 160 "src/keycode.vala"
						return result;
#line 589 "keycode.c"
					}
				}
			}
		}
#line 162 "src/keycode.vala"
		_vala_len = (guint) 0;
#line 163 "src/keycode.vala"
		result = (guint) KBD_NOKEY;
#line 163 "src/keycode.vala"
		if (len) {
#line 163 "src/keycode.vala"
			*len = _vala_len;
#line 602 "keycode.c"
		}
#line 163 "src/keycode.vala"
		return result;
#line 606 "keycode.c"
	} else {
#line 165 "src/keycode.vala"
		_vala_len = (guint) 1;
#line 166 "src/keycode.vala"
		result = (guint) string_get (buf, (glong) 0);
#line 166 "src/keycode.vala"
		if (len) {
#line 166 "src/keycode.vala"
			*len = _vala_len;
#line 616 "keycode.c"
		}
#line 166 "src/keycode.vala"
		return result;
#line 620 "keycode.c"
	}
#line 155 "src/keycode.vala"
	if (len) {
#line 155 "src/keycode.vala"
		*len = _vala_len;
#line 626 "keycode.c"
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result = 0L;
#line 1447 "glib-2.0.vapi"
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
#line 1447 "glib-2.0.vapi"
	end = _tmp0_;
#line 1448 "glib-2.0.vapi"
	_tmp1_ = end;
#line 1448 "glib-2.0.vapi"
	if (_tmp1_ == NULL) {
#line 1449 "glib-2.0.vapi"
		result = maxlen;
#line 1449 "glib-2.0.vapi"
		return result;
#line 650 "keycode.c"
	} else {
		gchar* _tmp2_;
#line 1451 "glib-2.0.vapi"
		_tmp2_ = end;
#line 1451 "glib-2.0.vapi"
		result = (glong) (_tmp2_ - str);
#line 1451 "glib-2.0.vapi"
		return result;
#line 659 "keycode.c"
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result = NULL;
#line 1458 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1460 "glib-2.0.vapi"
	if (offset >= ((glong) 0)) {
#line 1460 "glib-2.0.vapi"
		_tmp0_ = len >= ((glong) 0);
#line 678 "keycode.c"
	} else {
#line 1460 "glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 682 "keycode.c"
	}
#line 1460 "glib-2.0.vapi"
	if (_tmp0_) {
#line 1462 "glib-2.0.vapi"
		string_length = string_strnlen ((gchar*) self, offset + len);
#line 688 "keycode.c"
	} else {
		gint _tmp1_;
		gint _tmp2_;
#line 1464 "glib-2.0.vapi"
		_tmp1_ = strlen (self);
#line 1464 "glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1464 "glib-2.0.vapi"
		string_length = (glong) _tmp2_;
#line 698 "keycode.c"
	}
#line 1467 "glib-2.0.vapi"
	if (offset < ((glong) 0)) {
#line 1468 "glib-2.0.vapi"
		offset = string_length + offset;
#line 1469 "glib-2.0.vapi"
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
#line 706 "keycode.c"
	} else {
#line 1471 "glib-2.0.vapi"
		g_return_val_if_fail (offset <= string_length, NULL);
#line 710 "keycode.c"
	}
#line 1473 "glib-2.0.vapi"
	if (len < ((glong) 0)) {
#line 1474 "glib-2.0.vapi"
		len = string_length - offset;
#line 716 "keycode.c"
	}
#line 1476 "glib-2.0.vapi"
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
#line 1477 "glib-2.0.vapi"
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
#line 1477 "glib-2.0.vapi"
	result = _tmp3_;
#line 1477 "glib-2.0.vapi"
	return result;
#line 726 "keycode.c"
}

guint
strtochord (const gchar* buf,
            guint* len)
{
	guint _vala_len = 0U;
	guint key = 0U;
	guint k = 0U;
	guint result = 0U;
#line 173 "src/keycode.vala"
	g_return_val_if_fail (buf != NULL, 0U);
#line 174 "src/keycode.vala"
	key = (guint) 0;
#line 174 "src/keycode.vala"
	k = (guint) 0;
#line 176 "src/keycode.vala"
	_vala_len = (guint) 0;
#line 745 "keycode.c"
	{
		gboolean _tmp0_ = FALSE;
#line 177 "src/keycode.vala"
		_tmp0_ = TRUE;
#line 177 "src/keycode.vala"
		while (TRUE) {
#line 752 "keycode.c"
			guint l = 0U;
			gchar* _tmp2_;
			gchar* _tmp3_;
			guint _tmp4_ = 0U;
			guint _tmp5_;
#line 177 "src/keycode.vala"
			if (!_tmp0_) {
#line 760 "keycode.c"
				gboolean _tmp1_ = FALSE;
#line 187 "src/keycode.vala"
				if (k == ((guint) KBD_CTRL)) {
#line 187 "src/keycode.vala"
					_tmp1_ = TRUE;
#line 766 "keycode.c"
				} else {
#line 187 "src/keycode.vala"
					_tmp1_ = k == ((guint) KBD_META);
#line 770 "keycode.c"
				}
#line 187 "src/keycode.vala"
				if (!_tmp1_) {
#line 187 "src/keycode.vala"
					break;
#line 776 "keycode.c"
				}
			}
#line 177 "src/keycode.vala"
			_tmp0_ = FALSE;
#line 180 "src/keycode.vala"
			_tmp2_ = string_substring (buf, (glong) _vala_len, (glong) -1);
#line 180 "src/keycode.vala"
			_tmp3_ = _tmp2_;
#line 180 "src/keycode.vala"
			_tmp5_ = strtokey (_tmp3_, &_tmp4_);
#line 180 "src/keycode.vala"
			l = _tmp4_;
#line 180 "src/keycode.vala"
			k = _tmp5_;
#line 180 "src/keycode.vala"
			_g_free0 (_tmp3_);
#line 181 "src/keycode.vala"
			if (k == ((guint) KBD_NOKEY)) {
#line 182 "src/keycode.vala"
				_vala_len = (guint) 0;
#line 183 "src/keycode.vala"
				result = (guint) KBD_NOKEY;
#line 183 "src/keycode.vala"
				if (len) {
#line 183 "src/keycode.vala"
					*len = _vala_len;
#line 803 "keycode.c"
				}
#line 183 "src/keycode.vala"
				return result;
#line 807 "keycode.c"
			}
#line 185 "src/keycode.vala"
			_vala_len = _vala_len + l;
#line 186 "src/keycode.vala"
			key |= k;
#line 813 "keycode.c"
		}
	}
#line 189 "src/keycode.vala"
	result = key;
#line 189 "src/keycode.vala"
	if (len) {
#line 189 "src/keycode.vala"
		*len = _vala_len;
#line 822 "keycode.c"
	}
#line 189 "src/keycode.vala"
	return result;
#line 826 "keycode.c"
}

GeeList*
keystrtovec (const gchar* key)
{
	GeeArrayList* keys = NULL;
	GeeArrayList* _tmp0_;
	GeeList* result = NULL;
#line 196 "src/keycode.vala"
	g_return_val_if_fail (key != NULL, NULL);
#line 198 "src/keycode.vala"
	_tmp0_ = gee_array_list_new (G_TYPE_UINT, NULL, NULL, NULL, NULL, NULL);
#line 198 "src/keycode.vala"
	keys = _tmp0_;
#line 841 "keycode.c"
	{
		guint i = 0U;
		guint len = 0U;
#line 199 "src/keycode.vala"
		i = (guint) 0;
#line 199 "src/keycode.vala"
		len = (guint) 0;
#line 849 "keycode.c"
		{
			gboolean _tmp1_ = FALSE;
#line 199 "src/keycode.vala"
			_tmp1_ = TRUE;
#line 199 "src/keycode.vala"
			while (TRUE) {
#line 856 "keycode.c"
				gint _tmp2_;
				gint _tmp3_;
				guint code = 0U;
				gchar* _tmp4_;
				gchar* _tmp5_;
				guint _tmp6_ = 0U;
				guint _tmp7_;
				guint _tmp8_;
				GeeArrayList* _tmp9_;
#line 199 "src/keycode.vala"
				if (!_tmp1_) {
#line 199 "src/keycode.vala"
					i += len;
#line 870 "keycode.c"
				}
#line 199 "src/keycode.vala"
				_tmp1_ = FALSE;
#line 199 "src/keycode.vala"
				_tmp2_ = strlen (key);
#line 199 "src/keycode.vala"
				_tmp3_ = _tmp2_;
#line 199 "src/keycode.vala"
				if (!(i < ((guint) _tmp3_))) {
#line 199 "src/keycode.vala"
					break;
#line 882 "keycode.c"
				}
#line 200 "src/keycode.vala"
				_tmp4_ = string_substring (key, (glong) i, (glong) -1);
#line 200 "src/keycode.vala"
				_tmp5_ = _tmp4_;
#line 200 "src/keycode.vala"
				_tmp7_ = strtochord (_tmp5_, &_tmp6_);
#line 200 "src/keycode.vala"
				len = _tmp6_;
#line 200 "src/keycode.vala"
				_tmp8_ = _tmp7_;
#line 200 "src/keycode.vala"
				_g_free0 (_tmp5_);
#line 200 "src/keycode.vala"
				code = _tmp8_;
#line 201 "src/keycode.vala"
				if (code == ((guint) KBD_NOKEY)) {
#line 202 "src/keycode.vala"
					result = NULL;
#line 202 "src/keycode.vala"
					_g_object_unref0 (keys);
#line 202 "src/keycode.vala"
					return result;
#line 906 "keycode.c"
				}
#line 203 "src/keycode.vala"
				_tmp9_ = keys;
#line 203 "src/keycode.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp9_, (gpointer) ((guintptr) code));
#line 912 "keycode.c"
			}
		}
	}
#line 206 "src/keycode.vala"
	result = (GeeList*) keys;
#line 206 "src/keycode.vala"
	return result;
#line 920 "keycode.c"
}

static gchar*
_keytostr_key_stringifier (gsize key,
                           gpointer self)
{
	gchar* result;
	result = keytostr (key);
#line 215 "src/keycode.vala"
	return result;
#line 931 "keycode.c"
}

gchar*
keyvectostr (GeeList* keys)
{
	gchar* key_string = NULL;
	gchar* _tmp0_;
	gchar* result = NULL;
#line 212 "src/keycode.vala"
	g_return_val_if_fail (keys != NULL, NULL);
#line 213 "src/keycode.vala"
	_tmp0_ = g_strdup ("");
#line 213 "src/keycode.vala"
	key_string = _tmp0_;
#line 946 "keycode.c"
	{
		GeeList* _keycode_list = NULL;
		gint _keycode_size = 0;
		GeeList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _keycode_index = 0;
#line 214 "src/keycode.vala"
		_keycode_list = keys;
#line 214 "src/keycode.vala"
		_tmp1_ = _keycode_list;
#line 214 "src/keycode.vala"
		_tmp2_ = gee_collection_get_size ((GeeCollection*) _tmp1_);
#line 214 "src/keycode.vala"
		_tmp3_ = _tmp2_;
#line 214 "src/keycode.vala"
		_keycode_size = _tmp3_;
#line 214 "src/keycode.vala"
		_keycode_index = -1;
#line 214 "src/keycode.vala"
		while (TRUE) {
#line 968 "keycode.c"
			gint _tmp4_;
			gint _tmp5_;
			guint keycode = 0U;
			GeeList* _tmp6_;
			gpointer _tmp7_;
			const gchar* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
#line 214 "src/keycode.vala"
			_keycode_index = _keycode_index + 1;
#line 214 "src/keycode.vala"
			_tmp4_ = _keycode_index;
#line 214 "src/keycode.vala"
			_tmp5_ = _keycode_size;
#line 214 "src/keycode.vala"
			if (!(_tmp4_ < _tmp5_)) {
#line 214 "src/keycode.vala"
				break;
#line 988 "keycode.c"
			}
#line 214 "src/keycode.vala"
			_tmp6_ = _keycode_list;
#line 214 "src/keycode.vala"
			_tmp7_ = gee_list_get (_tmp6_, _keycode_index);
#line 214 "src/keycode.vala"
			keycode = (guint) ((guintptr) _tmp7_);
#line 215 "src/keycode.vala"
			_tmp8_ = key_string;
#line 215 "src/keycode.vala"
			_tmp9_ = chordtostr ((gsize) keycode, _keytostr_key_stringifier, NULL);
#line 215 "src/keycode.vala"
			_tmp10_ = _tmp9_;
#line 215 "src/keycode.vala"
			_tmp11_ = g_strconcat (_tmp8_, _tmp10_, NULL);
#line 215 "src/keycode.vala"
			_g_free0 (key_string);
#line 215 "src/keycode.vala"
			key_string = _tmp11_;
#line 215 "src/keycode.vala"
			_g_free0 (_tmp10_);
#line 1010 "keycode.c"
		}
	}
#line 216 "src/keycode.vala"
	result = key_string;
#line 216 "src/keycode.vala"
	return result;
#line 1017 "keycode.c"
}

static void
_vala_array_add2 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
#line 225 "src/keycode.vala"
	if ((*length) == (*size)) {
#line 225 "src/keycode.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 225 "src/keycode.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 1032 "keycode.c"
	}
#line 225 "src/keycode.vala"
	(*array)[(*length)++] = value;
#line 225 "src/keycode.vala"
	(*array)[*length] = NULL;
#line 1038 "keycode.c"
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result = NULL;
#line 1200 "glib-2.0.vapi"
	if (separator == NULL) {
#line 1201 "glib-2.0.vapi"
		separator = "";
#line 1052 "keycode.c"
	}
#line 1203 "glib-2.0.vapi"
	if (str_array != NULL) {
#line 1056 "keycode.c"
		gboolean _tmp1_ = FALSE;
#line 1203 "glib-2.0.vapi"
		if (str_array_length1 > 0) {
#line 1203 "glib-2.0.vapi"
			_tmp1_ = TRUE;
#line 1062 "keycode.c"
		} else {
			gboolean _tmp2_ = FALSE;
#line 1203 "glib-2.0.vapi"
			if (str_array_length1 == -1) {
#line 1067 "keycode.c"
				const gchar* _tmp3_;
#line 1203 "glib-2.0.vapi"
				_tmp3_ = str_array[0];
#line 1203 "glib-2.0.vapi"
				_tmp2_ = _tmp3_ != NULL;
#line 1073 "keycode.c"
			} else {
#line 1203 "glib-2.0.vapi"
				_tmp2_ = FALSE;
#line 1077 "keycode.c"
			}
#line 1203 "glib-2.0.vapi"
			_tmp1_ = _tmp2_;
#line 1081 "keycode.c"
		}
#line 1203 "glib-2.0.vapi"
		_tmp0_ = _tmp1_;
#line 1085 "keycode.c"
	} else {
#line 1203 "glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 1089 "keycode.c"
	}
#line 1203 "glib-2.0.vapi"
	if (_tmp0_) {
#line 1093 "keycode.c"
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		void* ptr = NULL;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		void* _tmp21_;
		const gchar* _tmp31_;
#line 1205 "glib-2.0.vapi"
		len = (gsize) 1;
#line 1107 "keycode.c"
		{
			gboolean _tmp4_ = FALSE;
#line 1206 "glib-2.0.vapi"
			i = 0;
#line 1206 "glib-2.0.vapi"
			_tmp4_ = TRUE;
#line 1206 "glib-2.0.vapi"
			while (TRUE) {
#line 1116 "keycode.c"
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
#line 1206 "glib-2.0.vapi"
				if (!_tmp4_) {
#line 1123 "keycode.c"
					gint _tmp5_;
#line 1206 "glib-2.0.vapi"
					_tmp5_ = i;
#line 1206 "glib-2.0.vapi"
					i = _tmp5_ + 1;
#line 1129 "keycode.c"
				}
#line 1206 "glib-2.0.vapi"
				_tmp4_ = FALSE;
#line 1206 "glib-2.0.vapi"
				if (str_array_length1 != -1) {
#line 1206 "glib-2.0.vapi"
					_tmp7_ = i < str_array_length1;
#line 1137 "keycode.c"
				} else {
#line 1206 "glib-2.0.vapi"
					_tmp7_ = FALSE;
#line 1141 "keycode.c"
				}
#line 1206 "glib-2.0.vapi"
				if (_tmp7_) {
#line 1206 "glib-2.0.vapi"
					_tmp6_ = TRUE;
#line 1147 "keycode.c"
				} else {
					gboolean _tmp8_ = FALSE;
#line 1206 "glib-2.0.vapi"
					if (str_array_length1 == -1) {
#line 1152 "keycode.c"
						const gchar* _tmp9_;
#line 1206 "glib-2.0.vapi"
						_tmp9_ = str_array[i];
#line 1206 "glib-2.0.vapi"
						_tmp8_ = _tmp9_ != NULL;
#line 1158 "keycode.c"
					} else {
#line 1206 "glib-2.0.vapi"
						_tmp8_ = FALSE;
#line 1162 "keycode.c"
					}
#line 1206 "glib-2.0.vapi"
					_tmp6_ = _tmp8_;
#line 1166 "keycode.c"
				}
#line 1206 "glib-2.0.vapi"
				if (!_tmp6_) {
#line 1206 "glib-2.0.vapi"
					break;
#line 1172 "keycode.c"
				}
#line 1207 "glib-2.0.vapi"
				_tmp11_ = str_array[i];
#line 1207 "glib-2.0.vapi"
				if (_tmp11_ != NULL) {
#line 1178 "keycode.c"
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
#line 1207 "glib-2.0.vapi"
					_tmp12_ = str_array[i];
#line 1207 "glib-2.0.vapi"
					_tmp13_ = strlen ((const gchar*) _tmp12_);
#line 1207 "glib-2.0.vapi"
					_tmp14_ = _tmp13_;
#line 1207 "glib-2.0.vapi"
					_tmp10_ = _tmp14_;
#line 1190 "keycode.c"
				} else {
#line 1207 "glib-2.0.vapi"
					_tmp10_ = 0;
#line 1194 "keycode.c"
				}
#line 1207 "glib-2.0.vapi"
				len += (gsize) _tmp10_;
#line 1198 "keycode.c"
			}
		}
#line 1209 "glib-2.0.vapi"
		if (i == 0) {
#line 1203 "keycode.c"
			gchar* _tmp15_;
#line 1210 "glib-2.0.vapi"
			_tmp15_ = g_strdup ("");
#line 1210 "glib-2.0.vapi"
			result = _tmp15_;
#line 1210 "glib-2.0.vapi"
			return result;
#line 1211 "keycode.c"
		}
#line 1212 "glib-2.0.vapi"
		str_array_length1 = i;
#line 1213 "glib-2.0.vapi"
		_tmp16_ = strlen ((const gchar*) separator);
#line 1213 "glib-2.0.vapi"
		_tmp17_ = _tmp16_;
#line 1213 "glib-2.0.vapi"
		len += (gsize) (_tmp17_ * (i - 1));
#line 1215 "glib-2.0.vapi"
		_tmp18_ = g_malloc (len);
#line 1215 "glib-2.0.vapi"
		res = _tmp18_;
#line 1216 "glib-2.0.vapi"
		_tmp19_ = res;
#line 1216 "glib-2.0.vapi"
		_tmp20_ = str_array[0];
#line 1216 "glib-2.0.vapi"
		_tmp21_ = g_stpcpy ((void*) _tmp19_, (const gchar*) _tmp20_);
#line 1216 "glib-2.0.vapi"
		ptr = _tmp21_;
#line 1233 "keycode.c"
		{
			gboolean _tmp22_ = FALSE;
#line 1217 "glib-2.0.vapi"
			i = 1;
#line 1217 "glib-2.0.vapi"
			_tmp22_ = TRUE;
#line 1217 "glib-2.0.vapi"
			while (TRUE) {
#line 1242 "keycode.c"
				void* _tmp24_;
				void* _tmp25_;
				const gchar* _tmp26_ = NULL;
				const gchar* _tmp27_;
				void* _tmp29_;
				void* _tmp30_;
#line 1217 "glib-2.0.vapi"
				if (!_tmp22_) {
#line 1251 "keycode.c"
					gint _tmp23_;
#line 1217 "glib-2.0.vapi"
					_tmp23_ = i;
#line 1217 "glib-2.0.vapi"
					i = _tmp23_ + 1;
#line 1257 "keycode.c"
				}
#line 1217 "glib-2.0.vapi"
				_tmp22_ = FALSE;
#line 1217 "glib-2.0.vapi"
				if (!(i < str_array_length1)) {
#line 1217 "glib-2.0.vapi"
					break;
#line 1265 "keycode.c"
				}
#line 1218 "glib-2.0.vapi"
				_tmp24_ = ptr;
#line 1218 "glib-2.0.vapi"
				_tmp25_ = g_stpcpy (_tmp24_, (const gchar*) separator);
#line 1218 "glib-2.0.vapi"
				ptr = _tmp25_;
#line 1219 "glib-2.0.vapi"
				_tmp27_ = str_array[i];
#line 1219 "glib-2.0.vapi"
				if (_tmp27_ != NULL) {
#line 1277 "keycode.c"
					const gchar* _tmp28_;
#line 1219 "glib-2.0.vapi"
					_tmp28_ = str_array[i];
#line 1219 "glib-2.0.vapi"
					_tmp26_ = (const gchar*) _tmp28_;
#line 1283 "keycode.c"
				} else {
#line 1219 "glib-2.0.vapi"
					_tmp26_ = "";
#line 1287 "keycode.c"
				}
#line 1219 "glib-2.0.vapi"
				_tmp29_ = ptr;
#line 1219 "glib-2.0.vapi"
				_tmp30_ = g_stpcpy (_tmp29_, _tmp26_);
#line 1219 "glib-2.0.vapi"
				ptr = _tmp30_;
#line 1295 "keycode.c"
			}
		}
#line 1222 "glib-2.0.vapi"
		_tmp31_ = res;
#line 1222 "glib-2.0.vapi"
		res = NULL;
#line 1222 "glib-2.0.vapi"
		result = (gchar*) _tmp31_;
#line 1222 "glib-2.0.vapi"
		return result;
#line 1306 "keycode.c"
	} else {
		gchar* _tmp32_;
#line 1224 "glib-2.0.vapi"
		_tmp32_ = g_strdup ("");
#line 1224 "glib-2.0.vapi"
		result = _tmp32_;
#line 1224 "glib-2.0.vapi"
		return result;
#line 1315 "keycode.c"
	}
}

gchar*
keyvectodesc (GeeList* keys)
{
	gchar** key_strings = NULL;
	gchar** _tmp0_;
	gint key_strings_length1;
	gint _key_strings_size_;
	gchar** _tmp9_;
	gint _tmp9__length1;
	gchar* _tmp10_;
	gchar* result = NULL;
#line 222 "src/keycode.vala"
	g_return_val_if_fail (keys != NULL, NULL);
#line 223 "src/keycode.vala"
	_tmp0_ = g_new0 (gchar*, 0 + 1);
#line 223 "src/keycode.vala"
	key_strings = _tmp0_;
#line 223 "src/keycode.vala"
	key_strings_length1 = 0;
#line 223 "src/keycode.vala"
	_key_strings_size_ = key_strings_length1;
#line 1340 "keycode.c"
	{
		GeeList* _keycode_list = NULL;
		gint _keycode_size = 0;
		GeeList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _keycode_index = 0;
#line 224 "src/keycode.vala"
		_keycode_list = keys;
#line 224 "src/keycode.vala"
		_tmp1_ = _keycode_list;
#line 224 "src/keycode.vala"
		_tmp2_ = gee_collection_get_size ((GeeCollection*) _tmp1_);
#line 224 "src/keycode.vala"
		_tmp3_ = _tmp2_;
#line 224 "src/keycode.vala"
		_keycode_size = _tmp3_;
#line 224 "src/keycode.vala"
		_keycode_index = -1;
#line 224 "src/keycode.vala"
		while (TRUE) {
#line 1362 "keycode.c"
			gint _tmp4_;
			gint _tmp5_;
			guint keycode = 0U;
			GeeList* _tmp6_;
			gpointer _tmp7_;
			gchar* _tmp8_;
#line 224 "src/keycode.vala"
			_keycode_index = _keycode_index + 1;
#line 224 "src/keycode.vala"
			_tmp4_ = _keycode_index;
#line 224 "src/keycode.vala"
			_tmp5_ = _keycode_size;
#line 224 "src/keycode.vala"
			if (!(_tmp4_ < _tmp5_)) {
#line 224 "src/keycode.vala"
				break;
#line 1379 "keycode.c"
			}
#line 224 "src/keycode.vala"
			_tmp6_ = _keycode_list;
#line 224 "src/keycode.vala"
			_tmp7_ = gee_list_get (_tmp6_, _keycode_index);
#line 224 "src/keycode.vala"
			keycode = (guint) ((guintptr) _tmp7_);
#line 225 "src/keycode.vala"
			_tmp8_ = chordtodesc ((gsize) keycode);
#line 225 "src/keycode.vala"
			_vala_array_add2 (&key_strings, &key_strings_length1, &_key_strings_size_, _tmp8_);
#line 1391 "keycode.c"
		}
	}
#line 226 "src/keycode.vala"
	_tmp9_ = key_strings;
#line 226 "src/keycode.vala"
	_tmp9__length1 = key_strings_length1;
#line 226 "src/keycode.vala"
	_tmp10_ = _vala_g_strjoinv (" ", _tmp9_, (gint) _tmp9__length1);
#line 226 "src/keycode.vala"
	result = _tmp10_;
#line 226 "src/keycode.vala"
	key_strings = (_vala_array_free (key_strings, key_strings_length1, (GDestroyNotify) g_free), NULL);
#line 226 "src/keycode.vala"
	return result;
#line 1406 "keycode.c"
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gint i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

