/* bind.c generated by valac 0.50.1.42-81856-dirty, the Vala compiler
 * generated from bind.vala, do not modify */

/* Key bindings and extended commands

   Copyright (c) 1997-2020 Free Software Foundation, Inc.

   This file is part of GNU Zile.

   GNU Zile is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   GNU Zile is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, see <https://www.gnu.org/licenses/>.  */

#include <glib-object.h>
#include <gee.h>
#include <glib.h>
#include <gobject/gvaluecollector.h>
#include <stdlib.h>
#include <string.h>

#define TYPE_BINDING (binding_get_type ())
#define BINDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BINDING, Binding))
#define BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BINDING, BindingClass))
#define IS_BINDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BINDING))
#define IS_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BINDING))
#define BINDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BINDING, BindingClass))

typedef struct _Binding Binding;
typedef struct _BindingClass BindingClass;
typedef struct _BindingPrivate BindingPrivate;

#define TYPE_LISP_FUNC (lisp_func_get_type ())
#define LISP_FUNC(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LISP_FUNC, LispFunc))
#define LISP_FUNC_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LISP_FUNC, LispFuncClass))
#define IS_LISP_FUNC(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LISP_FUNC))
#define IS_LISP_FUNC_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LISP_FUNC))
#define LISP_FUNC_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LISP_FUNC, LispFuncClass))

typedef struct _LispFunc LispFunc;
typedef struct _LispFuncClass LispFuncClass;
#define _lisp_func_unref0(var) ((var == NULL) ? NULL : (var = (lisp_func_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _binding_unref0(var) ((var == NULL) ? NULL : (var = (binding_unref (var), NULL)))
typedef struct _ParamSpecBinding ParamSpecBinding;
typedef enum  {
	FLAGS_NEED_RESYNC = 1 << 0,
	FLAGS_SET_UNIARG = 1 << 1,
	FLAGS_UNIARG_EMPTY = 1 << 2,
	FLAGS_DEFINING_MACRO = 1 << 3
} Flags;

#define TYPE_FLAGS (flags_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_BUFFER (buffer_get_type ())
#define BUFFER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUFFER, Buffer))
#define BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUFFER, BufferClass))
#define IS_BUFFER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUFFER))
#define IS_BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUFFER))
#define BUFFER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUFFER, BufferClass))

typedef struct _Buffer Buffer;
typedef struct _BufferClass BufferClass;
typedef struct _BufferPrivate BufferPrivate;

#define TYPE_MARKER (marker_get_type ())
#define MARKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MARKER, Marker))
#define MARKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MARKER, MarkerClass))
#define IS_MARKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MARKER))
#define IS_MARKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MARKER))
#define MARKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MARKER, MarkerClass))

typedef struct _Marker Marker;
typedef struct _MarkerClass MarkerClass;

#define TYPE_UNDO (undo_get_type ())
#define UNDO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNDO, Undo))
#define UNDO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNDO, UndoClass))
#define IS_UNDO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNDO))
#define IS_UNDO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNDO))
#define UNDO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNDO, UndoClass))

typedef struct _Undo Undo;
typedef struct _UndoClass UndoClass;

#define TYPE_VAR_ENTRY (var_entry_get_type ())
#define VAR_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VAR_ENTRY, VarEntry))
#define VAR_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VAR_ENTRY, VarEntryClass))
#define IS_VAR_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VAR_ENTRY))
#define IS_VAR_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VAR_ENTRY))
#define VAR_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VAR_ENTRY, VarEntryClass))

typedef struct _VarEntry VarEntry;
typedef struct _VarEntryClass VarEntryClass;
typedef struct _LispFuncPrivate LispFuncPrivate;
typedef gboolean (*Function) (glong uniarg, GeeQueue* args);
typedef void (*BindingsProcessor) (const gchar* key, Binding* p, gpointer user_data);
typedef void (*BindingsWalker) (Binding* tree, gchar** keys, gint keys_length1, gpointer user_data);
typedef struct _Block1Data Block1Data;
typedef gboolean (*MovementDelegate) (gpointer user_data);
typedef struct _Block2Data Block2Data;
typedef struct _Block3Data Block3Data;
typedef void (*BufferWriter) (gpointer user_data);
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _Binding {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BindingPrivate * priv;
	LispFunc* func;
	GeeMap* map;
};

struct _BindingClass {
	GTypeClass parent_class;
	void (*finalize) (Binding *self);
};

struct _ParamSpecBinding {
	GParamSpec parent_instance;
};

struct _Buffer {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BufferPrivate * priv;
	gchar* name;
	gchar* filename;
	Buffer* next;
	gsize goalc;
	Marker* mark;
	Marker* markers;
	GList* last_undop;
	GList* next_undop;
	GHashTable* vars;
	gboolean modified;
	gboolean nosave;
	gboolean needname;
	gboolean temporary;
	gboolean readonly;
	gboolean backup;
	gboolean noundo;
	gboolean autofill;
	gboolean isearch;
	gboolean mark_active;
	gchar* dir;
};

struct _BufferClass {
	GTypeClass parent_class;
	void (*finalize) (Buffer *self);
	gsize (*get_length) (Buffer* self);
	const gchar* (*get_eol) (Buffer* self);
};

struct _LispFunc {
	GTypeInstance parent_instance;
	volatile int ref_count;
	LispFuncPrivate * priv;
	gchar* name;
	Function func;
	gboolean interactive;
	gchar* doc;
};

struct _LispFuncClass {
	GTypeClass parent_class;
	void (*finalize) (LispFunc *self);
};

struct _Block1Data {
	int _ref_count_;
	BindingsWalker walker;
	gpointer walker_target;
	GDestroyNotify walker_target_destroy_notify;
	BindingsProcessor process;
	gpointer process_target;
};

struct _Block2Data {
	int _ref_count_;
	LispFunc* f;
};

struct _Block3Data {
	int _ref_count_;
	Block2Data * _data2_;
	gchar* bindings;
};

static gpointer binding_parent_class = NULL;
extern Binding* root_bindings;
Binding* root_bindings = NULL;
extern Flags lastflag;
extern gint last_uniarg;
extern Buffer* cur_bp;
extern LispFunc* _last_command;
LispFunc* _last_command = NULL;
extern LispFunc* _this_command;
LispFunc* _this_command = NULL;
extern Flags thisflag;
extern const gchar* default_bindings;

gpointer binding_ref (gpointer instance);
void binding_unref (gpointer instance);
GParamSpec* param_spec_binding (const gchar* name,
                                const gchar* nick,
                                const gchar* blurb,
                                GType object_type,
                                GParamFlags flags);
void value_set_binding (GValue* value,
                        gpointer v_object);
void value_take_binding (GValue* value,
                         gpointer v_object);
gpointer value_get_binding (const GValue* value);
GType binding_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Binding, binding_unref)
gpointer lisp_func_ref (gpointer instance);
void lisp_func_unref (gpointer instance);
GParamSpec* param_spec_lisp_func (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags);
void value_set_lisp_func (GValue* value,
                          gpointer v_object);
void value_take_lisp_func (GValue* value,
                           gpointer v_object);
gpointer value_get_lisp_func (const GValue* value);
GType lisp_func_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LispFunc, lisp_func_unref)
Binding* binding_new (void);
Binding* binding_construct (GType object_type);
Binding* binding_find (Binding* self,
                       GeeList* keys);
void binding_bind (Binding* self,
                   GeeList* keys,
                   LispFunc* func);
static void binding_finalize (Binding * obj);
static GType binding_get_type_once (void);
guint binding_completion (const gchar* a);
GType flags_get_type (void) G_GNUC_CONST ;
void minibuf_write (const gchar* fmt,
                    ...);
guint getkey (gint delay);
#define GETKEY_DEFAULT -1
void minibuf_clear (void);
GeeList* get_key_sequence (void);
#define KBD_NOKEY G_MAXINT
gchar* keyvectodesc (GeeList* keys);
LispFunc* get_function_by_keys (GeeList* keys);
#define KBD_META 02000
LispFunc* lisp_func_find (const gchar* name);
gboolean self_insert_command (void);
guint lastkey (void);
#define KBD_CTRL 01000
gpointer buffer_ref (gpointer instance);
void buffer_unref (gpointer instance);
GParamSpec* param_spec_buffer (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
void value_set_buffer (GValue* value,
                       gpointer v_object);
void value_take_buffer (GValue* value,
                        gpointer v_object);
gpointer value_get_buffer (const GValue* value);
GType buffer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Buffer, buffer_unref)
gpointer marker_ref (gpointer instance);
void marker_unref (gpointer instance);
GParamSpec* param_spec_marker (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
void value_set_marker (GValue* value,
                       gpointer v_object);
void value_take_marker (GValue* value,
                        gpointer v_object);
gpointer value_get_marker (const GValue* value);
GType marker_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Marker, marker_unref)
gpointer undo_ref (gpointer instance);
void undo_unref (gpointer instance);
GParamSpec* param_spec_undo (const gchar* name,
                             const gchar* nick,
                             const gchar* blurb,
                             GType object_type,
                             GParamFlags flags);
void value_set_undo (GValue* value,
                     gpointer v_object);
void value_take_undo (GValue* value,
                      gpointer v_object);
gpointer value_get_undo (const GValue* value);
GType undo_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Undo, undo_unref)
gpointer var_entry_ref (gpointer instance);
void var_entry_unref (gpointer instance);
GParamSpec* param_spec_var_entry (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags);
void value_set_var_entry (GValue* value,
                          gpointer v_object);
void value_take_var_entry (GValue* value,
                           gpointer v_object);
gpointer value_get_var_entry (const GValue* value);
GType var_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (VarEntry, var_entry_unref)
gboolean* fill_break_line (void);
gboolean buffer_insert_char (Buffer* self,
                             gchar c);
void ding (void);
LispFunc* last_command (void);
void set_this_command (LispFunc* cmd);
gboolean call_command (LispFunc* f,
                       glong uniarg,
                       GeeQueue* args);
void undo_start_sequence (void);
void add_cmd_to_macro (void);
void undo_end_sequence (void);
void get_and_run_command (void);
void minibuf_error (const gchar* fmt,
                    ...);
void init_default_bindings (void);
void lisp_loadstring (const gchar* a);
void walk_bindings (BindingsProcessor process,
                    gpointer process_target);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda23_ (Block1Data* _data1_,
                  Binding* tree,
                  gchar** keys,
                  gint keys_length1);
static gchar** _vala_array_dup1 (gchar** self,
                          gint length);
gchar* chordtodesc (gsize key);
static void _vala_array_add1 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void ___lambda23__bindings_walker (Binding* tree,
                                   gchar** keys,
                                   gint keys_length1,
                                   gpointer self);
void bind_init (void);
static gboolean __lambda24_ (glong uniarg,
                      GeeQueue* args);
GeeList* keystrtovec (const gchar* key);
gchar* minibuf_read_function_name (const gchar* fmt,
                                   ...);
static gboolean ___lambda24__function (glong uniarg,
                                GeeQueue* args);
LispFunc* lisp_func_new (const gchar* name,
                         Function func,
                         gboolean interactive,
                         const gchar* doc);
LispFunc* lisp_func_construct (GType object_type,
                               const gchar* name,
                               Function func,
                               gboolean interactive,
                               const gchar* doc);
static gboolean __lambda26_ (glong uniarg,
                      GeeQueue* args);
gboolean execute_with_uniarg (glong uniarg,
                              MovementDelegate forward,
                              gpointer forward_target,
                              MovementDelegate backward,
                              gpointer backward_target);
static gboolean _self_insert_command_movement_delegate (gpointer self);
static gboolean ___lambda26__function (glong uniarg,
                                GeeQueue* args);
static gboolean __lambda27_ (glong uniarg,
                      GeeQueue* args);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void ____lambda28_ (Block3Data* _data3_,
                    const gchar* key,
                    Binding* p);
static void _____lambda28__bindings_processor (const gchar* key,
                                        Binding* p,
                                        gpointer self);
static gboolean ___lambda27__function (glong uniarg,
                                GeeQueue* args);
static gboolean __lambda29_ (glong uniarg,
                      GeeQueue* args);
void write_temp_buffer (const gchar* name,
                        gboolean show,
                        BufferWriter func,
                        gpointer func_target);
static void __lambda30_ (void);
void bprintf (const gchar* fmt,
              ...);
static void __lambda31_ (const gchar* key,
                  Binding* p);
static void ___lambda31__bindings_processor (const gchar* key,
                                      Binding* p,
                                      gpointer self);
static void ___lambda30__buffer_writer (gpointer self);
static gboolean ___lambda29__function (glong uniarg,
                                GeeQueue* args);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);

Binding*
binding_construct (GType object_type)
{
	Binding* self = NULL;
	GeeTreeMap* _tmp0_;
#line 35 "src/bind.vala"
	self = (Binding*) g_type_create_instance (object_type);
#line 36 "src/bind.vala"
	_tmp0_ = gee_tree_map_new (G_TYPE_UINT, NULL, NULL, TYPE_BINDING, (GBoxedCopyFunc) binding_ref, (GDestroyNotify) binding_unref, NULL, NULL, NULL, NULL, NULL, NULL);
#line 36 "src/bind.vala"
	_g_object_unref0 (self->map);
#line 36 "src/bind.vala"
	self->map = (GeeMap*) _tmp0_;
#line 35 "src/bind.vala"
	return self;
#line 442 "bind.c"
}

Binding*
binding_new (void)
{
#line 35 "src/bind.vala"
	return binding_construct (TYPE_BINDING);
#line 450 "bind.c"
}

static gpointer
_binding_ref0 (gpointer self)
{
#line 44 "src/bind.vala"
	return self ? binding_ref (self) : NULL;
#line 458 "bind.c"
}

Binding*
binding_find (Binding* self,
              GeeList* keys)
{
	gint _tmp0_;
	gint _tmp1_;
	Binding* result = NULL;
#line 39 "src/bind.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 39 "src/bind.vala"
	g_return_val_if_fail (keys != NULL, NULL);
#line 40 "src/bind.vala"
	_tmp0_ = gee_collection_get_size ((GeeCollection*) keys);
#line 40 "src/bind.vala"
	_tmp1_ = _tmp0_;
#line 40 "src/bind.vala"
	if (_tmp1_ == 0) {
#line 478 "bind.c"
		gboolean _tmp2_ = FALSE;
		LispFunc* _tmp3_;
		Binding* _tmp5_;
#line 43 "src/bind.vala"
		_tmp3_ = self->func;
#line 43 "src/bind.vala"
		if (_tmp3_ != NULL) {
#line 43 "src/bind.vala"
			_tmp2_ = TRUE;
#line 488 "bind.c"
		} else {
			GeeMap* _tmp4_;
#line 43 "src/bind.vala"
			_tmp4_ = self->map;
#line 43 "src/bind.vala"
			_tmp2_ = _tmp4_ != NULL;
#line 495 "bind.c"
		}
#line 43 "src/bind.vala"
		_vala_assert (_tmp2_, "func != null || map != null");
#line 44 "src/bind.vala"
		_tmp5_ = _binding_ref0 (self);
#line 44 "src/bind.vala"
		result = _tmp5_;
#line 44 "src/bind.vala"
		return result;
#line 505 "bind.c"
	} else {
		GeeMap* _tmp6_;
		Binding* p = NULL;
		GeeMap* _tmp7_;
		gpointer _tmp8_;
		gpointer _tmp9_;
		Binding* _tmp10_ = NULL;
		Binding* _tmp11_;
#line 46 "src/bind.vala"
		_tmp6_ = self->map;
#line 46 "src/bind.vala"
		_vala_assert (_tmp6_ != NULL, "map != null");
#line 47 "src/bind.vala"
		_tmp7_ = self->map;
#line 47 "src/bind.vala"
		_tmp8_ = gee_list_first (keys);
#line 47 "src/bind.vala"
		_tmp9_ = gee_map_get (_tmp7_, (gpointer) ((guintptr) ((guint) ((guintptr) _tmp8_))));
#line 47 "src/bind.vala"
		p = (Binding*) _tmp9_;
#line 48 "src/bind.vala"
		_tmp11_ = p;
#line 48 "src/bind.vala"
		if (_tmp11_ == NULL) {
#line 48 "src/bind.vala"
			_binding_unref0 (_tmp10_);
#line 48 "src/bind.vala"
			_tmp10_ = NULL;
#line 534 "bind.c"
		} else {
			Binding* _tmp12_;
			gint _tmp13_;
			gint _tmp14_;
			GeeList* _tmp15_;
			GeeList* _tmp16_;
			Binding* _tmp17_;
#line 48 "src/bind.vala"
			_tmp12_ = p;
#line 48 "src/bind.vala"
			_tmp13_ = gee_collection_get_size ((GeeCollection*) keys);
#line 48 "src/bind.vala"
			_tmp14_ = _tmp13_;
#line 48 "src/bind.vala"
			_tmp15_ = gee_list_slice (keys, 1, _tmp14_);
#line 48 "src/bind.vala"
			_tmp16_ = _tmp15_;
#line 48 "src/bind.vala"
			_tmp17_ = binding_find (_tmp12_, _tmp16_);
#line 48 "src/bind.vala"
			_binding_unref0 (_tmp10_);
#line 48 "src/bind.vala"
			_tmp10_ = _tmp17_;
#line 48 "src/bind.vala"
			_g_object_unref0 (_tmp16_);
#line 560 "bind.c"
		}
#line 48 "src/bind.vala"
		result = _tmp10_;
#line 48 "src/bind.vala"
		_binding_unref0 (p);
#line 48 "src/bind.vala"
		return result;
#line 568 "bind.c"
	}
}

static gpointer
_lisp_func_ref0 (gpointer self)
{
#line 56 "src/bind.vala"
	return self ? lisp_func_ref (self) : NULL;
#line 577 "bind.c"
}

void
binding_bind (Binding* self,
              GeeList* keys,
              LispFunc* func)
{
	gint _tmp0_;
	gint _tmp1_;
	Binding* branch = NULL;
	GeeMap* _tmp3_;
	gpointer _tmp4_;
	gpointer _tmp5_;
	Binding* _tmp6_;
	Binding* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	GeeList* _tmp15_;
	GeeList* _tmp16_;
#line 52 "src/bind.vala"
	g_return_if_fail (self != NULL);
#line 52 "src/bind.vala"
	g_return_if_fail (keys != NULL);
#line 52 "src/bind.vala"
	g_return_if_fail (func != NULL);
#line 54 "src/bind.vala"
	_tmp0_ = gee_collection_get_size ((GeeCollection*) keys);
#line 54 "src/bind.vala"
	_tmp1_ = _tmp0_;
#line 54 "src/bind.vala"
	if (_tmp1_ == 0) {
#line 609 "bind.c"
		LispFunc* _tmp2_;
#line 55 "src/bind.vala"
		_g_object_unref0 (self->map);
#line 55 "src/bind.vala"
		self->map = NULL;
#line 56 "src/bind.vala"
		_tmp2_ = _lisp_func_ref0 (func);
#line 56 "src/bind.vala"
		_lisp_func_unref0 (self->func);
#line 56 "src/bind.vala"
		self->func = _tmp2_;
#line 57 "src/bind.vala"
		return;
#line 623 "bind.c"
	}
#line 60 "src/bind.vala"
	_tmp3_ = self->map;
#line 60 "src/bind.vala"
	_tmp4_ = gee_list_first (keys);
#line 60 "src/bind.vala"
	_tmp5_ = gee_map_get (_tmp3_, (gpointer) ((guintptr) ((guint) ((guintptr) _tmp4_))));
#line 60 "src/bind.vala"
	branch = (Binding*) _tmp5_;
#line 63 "src/bind.vala"
	_tmp6_ = branch;
#line 63 "src/bind.vala"
	if (_tmp6_ == NULL) {
#line 637 "bind.c"
		Binding* _tmp7_;
		GeeMap* _tmp8_;
		gpointer _tmp9_;
		Binding* _tmp10_;
#line 64 "src/bind.vala"
		_tmp7_ = binding_new ();
#line 64 "src/bind.vala"
		_binding_unref0 (branch);
#line 64 "src/bind.vala"
		branch = _tmp7_;
#line 65 "src/bind.vala"
		_tmp8_ = self->map;
#line 65 "src/bind.vala"
		_tmp9_ = gee_list_first (keys);
#line 65 "src/bind.vala"
		_tmp10_ = branch;
#line 65 "src/bind.vala"
		gee_map_set (_tmp8_, (gpointer) ((guintptr) ((guint) ((guintptr) _tmp9_))), _tmp10_);
#line 656 "bind.c"
	} else {
		Binding* _tmp11_;
#line 68 "src/bind.vala"
		_tmp11_ = branch;
#line 68 "src/bind.vala"
		_lisp_func_unref0 (_tmp11_->func);
#line 68 "src/bind.vala"
		_tmp11_->func = NULL;
#line 665 "bind.c"
	}
#line 71 "src/bind.vala"
	_tmp12_ = branch;
#line 71 "src/bind.vala"
	_tmp13_ = gee_collection_get_size ((GeeCollection*) keys);
#line 71 "src/bind.vala"
	_tmp14_ = _tmp13_;
#line 71 "src/bind.vala"
	_tmp15_ = gee_list_slice (keys, 1, _tmp14_);
#line 71 "src/bind.vala"
	_tmp16_ = _tmp15_;
#line 71 "src/bind.vala"
	binding_bind (_tmp12_, _tmp16_, func);
#line 71 "src/bind.vala"
	_g_object_unref0 (_tmp16_);
#line 52 "src/bind.vala"
	_binding_unref0 (branch);
#line 683 "bind.c"
}

static void
value_binding_init (GValue* value)
{
#line 30 "src/bind.vala"
	value->data[0].v_pointer = NULL;
#line 691 "bind.c"
}

static void
value_binding_free_value (GValue* value)
{
#line 30 "src/bind.vala"
	if (value->data[0].v_pointer) {
#line 30 "src/bind.vala"
		binding_unref (value->data[0].v_pointer);
#line 701 "bind.c"
	}
}

static void
value_binding_copy_value (const GValue* src_value,
                          GValue* dest_value)
{
#line 30 "src/bind.vala"
	if (src_value->data[0].v_pointer) {
#line 30 "src/bind.vala"
		dest_value->data[0].v_pointer = binding_ref (src_value->data[0].v_pointer);
#line 713 "bind.c"
	} else {
#line 30 "src/bind.vala"
		dest_value->data[0].v_pointer = NULL;
#line 717 "bind.c"
	}
}

static gpointer
value_binding_peek_pointer (const GValue* value)
{
#line 30 "src/bind.vala"
	return value->data[0].v_pointer;
#line 726 "bind.c"
}

static gchar*
value_binding_collect_value (GValue* value,
                             guint n_collect_values,
                             GTypeCValue* collect_values,
                             guint collect_flags)
{
#line 30 "src/bind.vala"
	if (collect_values[0].v_pointer) {
#line 737 "bind.c"
		Binding * object;
		object = collect_values[0].v_pointer;
#line 30 "src/bind.vala"
		if (object->parent_instance.g_class == NULL) {
#line 30 "src/bind.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 744 "bind.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 30 "src/bind.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 748 "bind.c"
		}
#line 30 "src/bind.vala"
		value->data[0].v_pointer = binding_ref (object);
#line 752 "bind.c"
	} else {
#line 30 "src/bind.vala"
		value->data[0].v_pointer = NULL;
#line 756 "bind.c"
	}
#line 30 "src/bind.vala"
	return NULL;
#line 760 "bind.c"
}

static gchar*
value_binding_lcopy_value (const GValue* value,
                           guint n_collect_values,
                           GTypeCValue* collect_values,
                           guint collect_flags)
{
	Binding ** object_p;
	object_p = collect_values[0].v_pointer;
#line 30 "src/bind.vala"
	if (!object_p) {
#line 30 "src/bind.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 775 "bind.c"
	}
#line 30 "src/bind.vala"
	if (!value->data[0].v_pointer) {
#line 30 "src/bind.vala"
		*object_p = NULL;
#line 781 "bind.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 30 "src/bind.vala"
		*object_p = value->data[0].v_pointer;
#line 785 "bind.c"
	} else {
#line 30 "src/bind.vala"
		*object_p = binding_ref (value->data[0].v_pointer);
#line 789 "bind.c"
	}
#line 30 "src/bind.vala"
	return NULL;
#line 793 "bind.c"
}

GParamSpec*
param_spec_binding (const gchar* name,
                    const gchar* nick,
                    const gchar* blurb,
                    GType object_type,
                    GParamFlags flags)
{
	ParamSpecBinding* spec;
#line 30 "src/bind.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_BINDING), NULL);
#line 30 "src/bind.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 30 "src/bind.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 30 "src/bind.vala"
	return G_PARAM_SPEC (spec);
#line 812 "bind.c"
}

gpointer
value_get_binding (const GValue* value)
{
#line 30 "src/bind.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_BINDING), NULL);
#line 30 "src/bind.vala"
	return value->data[0].v_pointer;
#line 822 "bind.c"
}

void
value_set_binding (GValue* value,
                   gpointer v_object)
{
	Binding * old;
#line 30 "src/bind.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_BINDING));
#line 30 "src/bind.vala"
	old = value->data[0].v_pointer;
#line 30 "src/bind.vala"
	if (v_object) {
#line 30 "src/bind.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_BINDING));
#line 30 "src/bind.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 30 "src/bind.vala"
		value->data[0].v_pointer = v_object;
#line 30 "src/bind.vala"
		binding_ref (value->data[0].v_pointer);
#line 844 "bind.c"
	} else {
#line 30 "src/bind.vala"
		value->data[0].v_pointer = NULL;
#line 848 "bind.c"
	}
#line 30 "src/bind.vala"
	if (old) {
#line 30 "src/bind.vala"
		binding_unref (old);
#line 854 "bind.c"
	}
}

void
value_take_binding (GValue* value,
                    gpointer v_object)
{
	Binding * old;
#line 30 "src/bind.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_BINDING));
#line 30 "src/bind.vala"
	old = value->data[0].v_pointer;
#line 30 "src/bind.vala"
	if (v_object) {
#line 30 "src/bind.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_BINDING));
#line 30 "src/bind.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 30 "src/bind.vala"
		value->data[0].v_pointer = v_object;
#line 875 "bind.c"
	} else {
#line 30 "src/bind.vala"
		value->data[0].v_pointer = NULL;
#line 879 "bind.c"
	}
#line 30 "src/bind.vala"
	if (old) {
#line 30 "src/bind.vala"
		binding_unref (old);
#line 885 "bind.c"
	}
}

static void
binding_class_init (BindingClass * klass,
                    gpointer klass_data)
{
#line 30 "src/bind.vala"
	binding_parent_class = g_type_class_peek_parent (klass);
#line 30 "src/bind.vala"
	((BindingClass *) klass)->finalize = binding_finalize;
#line 897 "bind.c"
}

static void
binding_instance_init (Binding * self,
                       gpointer klass)
{
#line 30 "src/bind.vala"
	self->ref_count = 1;
#line 906 "bind.c"
}

static void
binding_finalize (Binding * obj)
{
	Binding * self;
#line 30 "src/bind.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BINDING, Binding);
#line 30 "src/bind.vala"
	g_signal_handlers_destroy (self);
#line 31 "src/bind.vala"
	_lisp_func_unref0 (self->func);
#line 32 "src/bind.vala"
	_g_object_unref0 (self->map);
#line 921 "bind.c"
}

static GType
binding_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_binding_init, value_binding_free_value, value_binding_copy_value, value_binding_peek_pointer, "p", value_binding_collect_value, "p", value_binding_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (BindingClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) binding_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Binding), 0, (GInstanceInitFunc) binding_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType binding_type_id;
	binding_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Binding", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return binding_type_id;
}

GType
binding_get_type (void)
{
	static volatile gsize binding_type_id__volatile = 0;
	if (g_once_init_enter (&binding_type_id__volatile)) {
		GType binding_type_id;
		binding_type_id = binding_get_type_once ();
		g_once_init_leave (&binding_type_id__volatile, binding_type_id);
	}
	return binding_type_id__volatile;
}

gpointer
binding_ref (gpointer instance)
{
	Binding * self;
	self = instance;
#line 30 "src/bind.vala"
	g_atomic_int_inc (&self->ref_count);
#line 30 "src/bind.vala"
	return instance;
#line 956 "bind.c"
}

void
binding_unref (gpointer instance)
{
	Binding * self;
	self = instance;
#line 30 "src/bind.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 30 "src/bind.vala"
		BINDING_GET_CLASS (self)->finalize (self);
#line 30 "src/bind.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 970 "bind.c"
	}
}

guint
binding_completion (const gchar* a)
{
	gchar* b = NULL;
	gchar* _tmp0_;
	Flags _tmp1_;
	const gchar* _tmp7_ = NULL;
	Flags _tmp8_;
	const gchar* _tmp9_;
	guint key = 0U;
	guint result = 0U;
#line 77 "src/bind.vala"
	g_return_val_if_fail (a != NULL, 0U);
#line 78 "src/bind.vala"
	_tmp0_ = g_strdup ("");
#line 78 "src/bind.vala"
	b = _tmp0_;
#line 80 "src/bind.vala"
	_tmp1_ = lastflag;
#line 80 "src/bind.vala"
	if ((_tmp1_ & FLAGS_SET_UNIARG) == FLAGS_SET_UNIARG) {
#line 995 "bind.c"
		glong arg = 0L;
#line 81 "src/bind.vala"
		arg = (glong) abs (last_uniarg);
#line 999 "bind.c"
		{
			gboolean _tmp2_ = FALSE;
#line 82 "src/bind.vala"
			_tmp2_ = TRUE;
#line 82 "src/bind.vala"
			while (TRUE) {
#line 1006 "bind.c"
				const gchar* _tmp3_;
				gchar* _tmp4_;
#line 82 "src/bind.vala"
				if (!_tmp2_) {
#line 85 "src/bind.vala"
					if (!(arg != ((glong) 0))) {
#line 85 "src/bind.vala"
						break;
#line 1015 "bind.c"
					}
				}
#line 82 "src/bind.vala"
				_tmp2_ = FALSE;
#line 83 "src/bind.vala"
				_tmp3_ = b;
#line 83 "src/bind.vala"
				_tmp4_ = g_strdup_printf ("%c %s", (gint) ((gchar) ((arg % 10) + '0')), _tmp3_);
#line 83 "src/bind.vala"
				_g_free0 (b);
#line 83 "src/bind.vala"
				b = _tmp4_;
#line 84 "src/bind.vala"
				arg /= (glong) 10;
#line 1030 "bind.c"
			}
		}
#line 87 "src/bind.vala"
		if (last_uniarg < 0) {
#line 1035 "bind.c"
			const gchar* _tmp5_;
			gchar* _tmp6_;
#line 88 "src/bind.vala"
			_tmp5_ = b;
#line 88 "src/bind.vala"
			_tmp6_ = g_strconcat ("- ", _tmp5_, NULL);
#line 88 "src/bind.vala"
			_g_free0 (b);
#line 88 "src/bind.vala"
			b = _tmp6_;
#line 1046 "bind.c"
		}
	}
#line 92 "src/bind.vala"
	_tmp8_ = lastflag;
#line 92 "src/bind.vala"
	if ((_tmp8_ & (FLAGS_SET_UNIARG | FLAGS_UNIARG_EMPTY)) == (FLAGS_SET_UNIARG | FLAGS_UNIARG_EMPTY)) {
#line 92 "src/bind.vala"
		_tmp7_ = "C-u ";
#line 1055 "bind.c"
	} else {
#line 92 "src/bind.vala"
		_tmp7_ = "";
#line 1059 "bind.c"
	}
#line 91 "src/bind.vala"
	_tmp9_ = b;
#line 91 "src/bind.vala"
	minibuf_write ("%s%s%s-", _tmp7_, _tmp9_, a, NULL);
#line 94 "src/bind.vala"
	key = (guint) getkey (GETKEY_DEFAULT);
#line 95 "src/bind.vala"
	minibuf_clear ();
#line 97 "src/bind.vala"
	result = key;
#line 97 "src/bind.vala"
	_g_free0 (b);
#line 97 "src/bind.vala"
	return result;
#line 1075 "bind.c"
}

GeeList*
get_key_sequence (void)
{
	GeeArrayList* keys = NULL;
	GeeArrayList* _tmp0_;
	guint key = 0U;
	GeeArrayList* _tmp2_;
	GeeList* result = NULL;
#line 103 "src/bind.vala"
	_tmp0_ = gee_array_list_new (G_TYPE_UINT, NULL, NULL, NULL, NULL, NULL);
#line 103 "src/bind.vala"
	keys = _tmp0_;
#line 104 "src/bind.vala"
	key = (guint) 0;
#line 1092 "bind.c"
	{
		gboolean _tmp1_ = FALSE;
#line 106 "src/bind.vala"
		_tmp1_ = TRUE;
#line 106 "src/bind.vala"
		while (TRUE) {
#line 106 "src/bind.vala"
			if (!_tmp1_) {
#line 108 "src/bind.vala"
				if (!(key == ((guint) KBD_NOKEY))) {
#line 108 "src/bind.vala"
					break;
#line 1105 "bind.c"
				}
			}
#line 106 "src/bind.vala"
			_tmp1_ = FALSE;
#line 107 "src/bind.vala"
			key = (guint) getkey (GETKEY_DEFAULT);
#line 1112 "bind.c"
		}
	}
#line 109 "src/bind.vala"
	_tmp2_ = keys;
#line 109 "src/bind.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp2_, (gpointer) ((guintptr) ((guint) key)));
#line 1119 "bind.c"
	{
		gboolean _tmp3_ = FALSE;
#line 110 "src/bind.vala"
		_tmp3_ = TRUE;
#line 110 "src/bind.vala"
		while (TRUE) {
#line 1126 "bind.c"
			Binding* p = NULL;
			Binding* _tmp4_;
			GeeArrayList* _tmp5_;
			Binding* _tmp6_;
			gboolean _tmp7_ = FALSE;
			Binding* _tmp8_;
			GeeArrayList* _tmp11_;
			GeeArrayList* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
#line 110 "src/bind.vala"
			if (!_tmp3_) {
#line 1139 "bind.c"
			}
#line 110 "src/bind.vala"
			_tmp3_ = FALSE;
#line 111 "src/bind.vala"
			_tmp4_ = root_bindings;
#line 111 "src/bind.vala"
			_tmp5_ = keys;
#line 111 "src/bind.vala"
			_tmp6_ = binding_find (_tmp4_, (GeeList*) _tmp5_);
#line 111 "src/bind.vala"
			p = _tmp6_;
#line 112 "src/bind.vala"
			_tmp8_ = p;
#line 112 "src/bind.vala"
			if (_tmp8_ == NULL) {
#line 112 "src/bind.vala"
				_tmp7_ = TRUE;
#line 1157 "bind.c"
			} else {
				Binding* _tmp9_;
				LispFunc* _tmp10_;
#line 112 "src/bind.vala"
				_tmp9_ = p;
#line 112 "src/bind.vala"
				_tmp10_ = _tmp9_->func;
#line 112 "src/bind.vala"
				_tmp7_ = _tmp10_ != NULL;
#line 1167 "bind.c"
			}
#line 112 "src/bind.vala"
			if (_tmp7_) {
#line 113 "src/bind.vala"
				_binding_unref0 (p);
#line 113 "src/bind.vala"
				break;
#line 1175 "bind.c"
			}
#line 114 "src/bind.vala"
			_tmp11_ = keys;
#line 114 "src/bind.vala"
			_tmp12_ = keys;
#line 114 "src/bind.vala"
			_tmp13_ = keyvectodesc ((GeeList*) _tmp12_);
#line 114 "src/bind.vala"
			_tmp14_ = _tmp13_;
#line 114 "src/bind.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp11_, (gpointer) ((guintptr) binding_completion (_tmp14_)));
#line 114 "src/bind.vala"
			_g_free0 (_tmp14_);
#line 110 "src/bind.vala"
			_binding_unref0 (p);
#line 1191 "bind.c"
		}
	}
#line 117 "src/bind.vala"
	result = (GeeList*) keys;
#line 117 "src/bind.vala"
	return result;
#line 1198 "bind.c"
}

LispFunc*
get_function_by_keys (GeeList* keys)
{
	gint _tmp0_;
	gint _tmp1_;
	Binding* p = NULL;
	Binding* _tmp6_;
	Binding* _tmp7_;
	LispFunc* _tmp8_ = NULL;
	Binding* _tmp9_;
	LispFunc* _tmp12_;
	LispFunc* result = NULL;
#line 120 "src/bind.vala"
	g_return_val_if_fail (keys != NULL, NULL);
#line 122 "src/bind.vala"
	_tmp0_ = gee_collection_get_size ((GeeCollection*) keys);
#line 122 "src/bind.vala"
	_tmp1_ = _tmp0_;
#line 122 "src/bind.vala"
	if (_tmp1_ == 1) {
#line 1221 "bind.c"
		guint key = 0U;
		gpointer _tmp2_;
		gboolean _tmp3_ = FALSE;
#line 123 "src/bind.vala"
		_tmp2_ = gee_list_get (keys, 0);
#line 123 "src/bind.vala"
		key = (guint) ((guintptr) _tmp2_);
#line 124 "src/bind.vala"
		if ((key & KBD_META) != ((guint) 0)) {
#line 1231 "bind.c"
			gboolean _tmp4_ = FALSE;
#line 125 "src/bind.vala"
			if (g_ascii_isdigit ((gchar) (key & 0xff))) {
#line 125 "src/bind.vala"
				_tmp4_ = TRUE;
#line 1237 "bind.c"
			} else {
#line 125 "src/bind.vala"
				_tmp4_ = ((gchar) (key & 0xff)) == '-';
#line 1241 "bind.c"
			}
#line 125 "src/bind.vala"
			_tmp3_ = _tmp4_;
#line 1245 "bind.c"
		} else {
#line 124 "src/bind.vala"
			_tmp3_ = FALSE;
#line 1249 "bind.c"
		}
#line 124 "src/bind.vala"
		if (_tmp3_) {
#line 1253 "bind.c"
			LispFunc* _tmp5_;
#line 126 "src/bind.vala"
			_tmp5_ = lisp_func_find ("universal-argument");
#line 126 "src/bind.vala"
			result = _tmp5_;
#line 126 "src/bind.vala"
			return result;
#line 1261 "bind.c"
		}
	}
#line 130 "src/bind.vala"
	_tmp6_ = root_bindings;
#line 130 "src/bind.vala"
	_tmp7_ = binding_find (_tmp6_, keys);
#line 130 "src/bind.vala"
	p = _tmp7_;
#line 131 "src/bind.vala"
	_tmp9_ = p;
#line 131 "src/bind.vala"
	if (_tmp9_ != NULL) {
#line 1274 "bind.c"
		Binding* _tmp10_;
		LispFunc* _tmp11_;
#line 131 "src/bind.vala"
		_tmp10_ = p;
#line 131 "src/bind.vala"
		_tmp11_ = _tmp10_->func;
#line 131 "src/bind.vala"
		_tmp8_ = _tmp11_;
#line 1283 "bind.c"
	} else {
#line 131 "src/bind.vala"
		_tmp8_ = NULL;
#line 1287 "bind.c"
	}
#line 131 "src/bind.vala"
	_tmp12_ = _lisp_func_ref0 (_tmp8_);
#line 131 "src/bind.vala"
	result = _tmp12_;
#line 131 "src/bind.vala"
	_binding_unref0 (p);
#line 131 "src/bind.vala"
	return result;
#line 1297 "bind.c"
}

gboolean
self_insert_command (void)
{
	gboolean ret = FALSE;
	gint key = 0;
	Buffer* _tmp0_;
	gboolean result = FALSE;
#line 135 "src/bind.vala"
	ret = TRUE;
#line 137 "src/bind.vala"
	key = (gint) (lastkey () & (~KBD_CTRL));
#line 138 "src/bind.vala"
	_tmp0_ = cur_bp;
#line 138 "src/bind.vala"
	_tmp0_->mark_active = FALSE;
#line 139 "src/bind.vala"
	if (key <= 0xff) {
#line 1317 "bind.c"
		gboolean _tmp1_ = FALSE;
		Buffer* _tmp5_;
#line 140 "src/bind.vala"
		if (g_ascii_isspace ((gchar) key)) {
#line 1322 "bind.c"
			Buffer* _tmp2_;
#line 140 "src/bind.vala"
			_tmp2_ = cur_bp;
#line 140 "src/bind.vala"
			_tmp1_ = _tmp2_->autofill;
#line 1328 "bind.c"
		} else {
#line 140 "src/bind.vala"
			_tmp1_ = FALSE;
#line 1332 "bind.c"
		}
#line 140 "src/bind.vala"
		if (_tmp1_) {
#line 1336 "bind.c"
			gboolean* _tmp3_;
			gboolean* _tmp4_;
#line 141 "src/bind.vala"
			_tmp3_ = fill_break_line ();
#line 141 "src/bind.vala"
			_tmp4_ = _tmp3_;
#line 141 "src/bind.vala"
			ret = _tmp4_ != NULL;
#line 141 "src/bind.vala"
			_g_free0 (_tmp4_);
#line 1347 "bind.c"
		}
#line 142 "src/bind.vala"
		_tmp5_ = cur_bp;
#line 142 "src/bind.vala"
		buffer_insert_char (_tmp5_, (gchar) key);
#line 1353 "bind.c"
	} else {
#line 144 "src/bind.vala"
		ding ();
#line 145 "src/bind.vala"
		ret = FALSE;
#line 1359 "bind.c"
	}
#line 148 "src/bind.vala"
	result = ret;
#line 148 "src/bind.vala"
	return result;
#line 1365 "bind.c"
}

LispFunc*
last_command (void)
{
	LispFunc* _tmp0_;
	LispFunc* _tmp1_;
	LispFunc* result = NULL;
#line 155 "src/bind.vala"
	_tmp0_ = _last_command;
#line 155 "src/bind.vala"
	_tmp1_ = _lisp_func_ref0 (_tmp0_);
#line 155 "src/bind.vala"
	result = _tmp1_;
#line 155 "src/bind.vala"
	return result;
#line 1382 "bind.c"
}

void
set_this_command (LispFunc* cmd)
{
	LispFunc* _tmp0_;
#line 158 "src/bind.vala"
	g_return_if_fail (cmd != NULL);
#line 159 "src/bind.vala"
	_tmp0_ = _lisp_func_ref0 (cmd);
#line 159 "src/bind.vala"
	_lisp_func_unref0 (_this_command);
#line 159 "src/bind.vala"
	_this_command = _tmp0_;
#line 1397 "bind.c"
}

gboolean
call_command (LispFunc* f,
              glong uniarg,
              GeeQueue* args)
{
	Flags _tmp0_;
	Flags _tmp1_;
	LispFunc* _tmp2_;
	gboolean ok = FALSE;
	Function _tmp3_;
	LispFunc* _tmp4_;
	LispFunc* _tmp5_;
	Flags _tmp6_;
	Flags _tmp7_;
	Flags _tmp8_;
	gboolean result = FALSE;
#line 162 "src/bind.vala"
	g_return_val_if_fail (f != NULL, FALSE);
#line 163 "src/bind.vala"
	_tmp0_ = lastflag;
#line 163 "src/bind.vala"
	thisflag = _tmp0_ & FLAGS_DEFINING_MACRO;
#line 164 "src/bind.vala"
	undo_start_sequence ();
#line 168 "src/bind.vala"
	_tmp1_ = thisflag;
#line 168 "src/bind.vala"
	if (!((_tmp1_ & FLAGS_SET_UNIARG) == FLAGS_SET_UNIARG)) {
#line 169 "src/bind.vala"
		last_uniarg = 1;
#line 1430 "bind.c"
	}
#line 172 "src/bind.vala"
	_tmp2_ = _lisp_func_ref0 (f);
#line 172 "src/bind.vala"
	_lisp_func_unref0 (_this_command);
#line 172 "src/bind.vala"
	_this_command = _tmp2_;
#line 173 "src/bind.vala"
	_tmp3_ = f->func;
#line 173 "src/bind.vala"
	ok = _tmp3_ (uniarg, args);
#line 174 "src/bind.vala"
	_tmp4_ = _this_command;
#line 174 "src/bind.vala"
	_tmp5_ = _lisp_func_ref0 (_tmp4_);
#line 174 "src/bind.vala"
	_lisp_func_unref0 (_last_command);
#line 174 "src/bind.vala"
	_last_command = _tmp5_;
#line 178 "src/bind.vala"
	_tmp6_ = lastflag;
#line 178 "src/bind.vala"
	_tmp7_ = thisflag;
#line 178 "src/bind.vala"
	if (((_tmp6_ & _tmp7_) & FLAGS_DEFINING_MACRO) == FLAGS_DEFINING_MACRO) {
#line 179 "src/bind.vala"
		add_cmd_to_macro ();
#line 1458 "bind.c"
	}
#line 181 "src/bind.vala"
	undo_end_sequence ();
#line 182 "src/bind.vala"
	_tmp8_ = thisflag;
#line 182 "src/bind.vala"
	lastflag = _tmp8_;
#line 184 "src/bind.vala"
	result = ok;
#line 184 "src/bind.vala"
	return result;
#line 1470 "bind.c"
}

void
get_and_run_command (void)
{
	GeeList* keys = NULL;
	GeeList* _tmp0_;
	LispFunc* f = NULL;
	GeeList* _tmp1_;
	LispFunc* _tmp2_;
	LispFunc* _tmp3_;
#line 188 "src/bind.vala"
	_tmp0_ = get_key_sequence ();
#line 188 "src/bind.vala"
	keys = _tmp0_;
#line 189 "src/bind.vala"
	_tmp1_ = keys;
#line 189 "src/bind.vala"
	_tmp2_ = get_function_by_keys (_tmp1_);
#line 189 "src/bind.vala"
	f = _tmp2_;
#line 191 "src/bind.vala"
	minibuf_clear ();
#line 192 "src/bind.vala"
	_tmp3_ = f;
#line 192 "src/bind.vala"
	if (_tmp3_ != NULL) {
#line 1498 "bind.c"
		GeeArrayQueue* _tmp4_ = NULL;
		Flags _tmp5_;
		LispFunc* _tmp7_;
#line 193 "src/bind.vala"
		_tmp5_ = lastflag;
#line 193 "src/bind.vala"
		if ((_tmp5_ & FLAGS_SET_UNIARG) == FLAGS_SET_UNIARG) {
#line 193 "src/bind.vala"
			_g_object_unref0 (_tmp4_);
#line 193 "src/bind.vala"
			_tmp4_ = NULL;
#line 1510 "bind.c"
		} else {
			GeeArrayQueue* _tmp6_;
#line 193 "src/bind.vala"
			_tmp6_ = gee_array_queue_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
#line 193 "src/bind.vala"
			_g_object_unref0 (_tmp4_);
#line 193 "src/bind.vala"
			_tmp4_ = _tmp6_;
#line 1519 "bind.c"
		}
#line 193 "src/bind.vala"
		_tmp7_ = f;
#line 193 "src/bind.vala"
		call_command (_tmp7_, (glong) last_uniarg, (GeeQueue*) _tmp4_);
#line 192 "src/bind.vala"
		_g_object_unref0 (_tmp4_);
#line 1527 "bind.c"
	} else {
		GeeList* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
#line 195 "src/bind.vala"
		_tmp8_ = keys;
#line 195 "src/bind.vala"
		_tmp9_ = keyvectodesc (_tmp8_);
#line 195 "src/bind.vala"
		_tmp10_ = _tmp9_;
#line 195 "src/bind.vala"
		minibuf_error ("%s is undefined", _tmp10_, NULL);
#line 195 "src/bind.vala"
		_g_free0 (_tmp10_);
#line 1542 "bind.c"
	}
#line 187 "src/bind.vala"
	_lisp_func_unref0 (f);
#line 187 "src/bind.vala"
	_g_object_unref0 (keys);
#line 1548 "bind.c"
}

void
init_default_bindings (void)
{
	Binding* _tmp0_;
	const gchar* _tmp9_;
#line 199 "src/bind.vala"
	_tmp0_ = binding_new ();
#line 199 "src/bind.vala"
	_binding_unref0 (root_bindings);
#line 199 "src/bind.vala"
	root_bindings = _tmp0_;
#line 1562 "bind.c"
	{
		guint i = 0U;
#line 202 "src/bind.vala"
		i = (guint) 0;
#line 1567 "bind.c"
		{
			gboolean _tmp1_ = FALSE;
#line 202 "src/bind.vala"
			_tmp1_ = TRUE;
#line 202 "src/bind.vala"
			while (TRUE) {
#line 202 "src/bind.vala"
				if (!_tmp1_) {
#line 1576 "bind.c"
					guint _tmp2_;
#line 202 "src/bind.vala"
					_tmp2_ = i;
#line 202 "src/bind.vala"
					i = _tmp2_ + 1;
#line 1582 "bind.c"
				}
#line 202 "src/bind.vala"
				_tmp1_ = FALSE;
#line 202 "src/bind.vala"
				if (!(i <= ((guint) 0xff))) {
#line 202 "src/bind.vala"
					break;
#line 1590 "bind.c"
				}
#line 203 "src/bind.vala"
				if (g_ascii_isprint ((gchar) i)) {
#line 1594 "bind.c"
					GeeArrayList* keys = NULL;
					GeeArrayList* _tmp3_;
					GeeArrayList* _tmp4_;
					Binding* _tmp5_;
					GeeArrayList* _tmp6_;
					LispFunc* _tmp7_;
					LispFunc* _tmp8_;
#line 204 "src/bind.vala"
					_tmp3_ = gee_array_list_new (G_TYPE_UINT, NULL, NULL, NULL, NULL, NULL);
#line 204 "src/bind.vala"
					keys = _tmp3_;
#line 205 "src/bind.vala"
					_tmp4_ = keys;
#line 205 "src/bind.vala"
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp4_, (gpointer) ((guintptr) i));
#line 206 "src/bind.vala"
					_tmp5_ = root_bindings;
#line 206 "src/bind.vala"
					_tmp6_ = keys;
#line 206 "src/bind.vala"
					_tmp7_ = lisp_func_find ("self-insert-command");
#line 206 "src/bind.vala"
					_tmp8_ = _tmp7_;
#line 206 "src/bind.vala"
					binding_bind (_tmp5_, (GeeList*) _tmp6_, _tmp8_);
#line 206 "src/bind.vala"
					_lisp_func_unref0 (_tmp8_);
#line 203 "src/bind.vala"
					_g_object_unref0 (keys);
#line 1624 "bind.c"
				}
			}
		}
	}
#line 210 "src/bind.vala"
	_tmp9_ = default_bindings;
#line 210 "src/bind.vala"
	lisp_loadstring (_tmp9_);
#line 1633 "bind.c"
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
#line 215 "src/bind.vala"
	g_atomic_int_inc (&_data1_->_ref_count_);
#line 215 "src/bind.vala"
	return _data1_;
#line 1643 "bind.c"
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
#line 215 "src/bind.vala"
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
#line 215 "src/bind.vala"
		(_data1_->walker_target_destroy_notify == NULL) ? NULL : (_data1_->walker_target_destroy_notify (_data1_->walker_target), NULL);
#line 215 "src/bind.vala"
		_data1_->walker = NULL;
#line 215 "src/bind.vala"
		_data1_->walker_target = NULL;
#line 215 "src/bind.vala"
		_data1_->walker_target_destroy_notify = NULL;
#line 215 "src/bind.vala"
		g_slice_free (Block1Data, _data1_);
#line 1663 "bind.c"
	}
}

static gchar**
_vala_array_dup1 (gchar** self,
                  gint length)
{
#line 223 "src/bind.vala"
	if (length >= 0) {
#line 1673 "bind.c"
		gchar** result;
		gint i;
#line 223 "src/bind.vala"
		result = g_new0 (gchar*, length + 1);
#line 223 "src/bind.vala"
		for (i = 0; i < length; i++) {
#line 1680 "bind.c"
			gchar* _tmp0_;
#line 223 "src/bind.vala"
			_tmp0_ = g_strdup (self[i]);
#line 223 "src/bind.vala"
			result[i] = _tmp0_;
#line 1686 "bind.c"
		}
#line 223 "src/bind.vala"
		return result;
#line 1690 "bind.c"
	}
#line 223 "src/bind.vala"
	return NULL;
#line 1694 "bind.c"
}

static void
_vala_array_add1 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
#line 224 "src/bind.vala"
	if ((*length) == (*size)) {
#line 224 "src/bind.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 224 "src/bind.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 1709 "bind.c"
	}
#line 224 "src/bind.vala"
	(*array)[(*length)++] = value;
#line 224 "src/bind.vala"
	(*array)[*length] = NULL;
#line 1715 "bind.c"
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result = NULL;
#line 1200 "glib-2.0.vapi"
	if (separator == NULL) {
#line 1201 "glib-2.0.vapi"
		separator = "";
#line 1729 "bind.c"
	}
#line 1203 "glib-2.0.vapi"
	if (str_array != NULL) {
#line 1733 "bind.c"
		gboolean _tmp1_ = FALSE;
#line 1203 "glib-2.0.vapi"
		if (str_array_length1 > 0) {
#line 1203 "glib-2.0.vapi"
			_tmp1_ = TRUE;
#line 1739 "bind.c"
		} else {
			gboolean _tmp2_ = FALSE;
#line 1203 "glib-2.0.vapi"
			if (str_array_length1 == -1) {
#line 1744 "bind.c"
				const gchar* _tmp3_;
#line 1203 "glib-2.0.vapi"
				_tmp3_ = str_array[0];
#line 1203 "glib-2.0.vapi"
				_tmp2_ = _tmp3_ != NULL;
#line 1750 "bind.c"
			} else {
#line 1203 "glib-2.0.vapi"
				_tmp2_ = FALSE;
#line 1754 "bind.c"
			}
#line 1203 "glib-2.0.vapi"
			_tmp1_ = _tmp2_;
#line 1758 "bind.c"
		}
#line 1203 "glib-2.0.vapi"
		_tmp0_ = _tmp1_;
#line 1762 "bind.c"
	} else {
#line 1203 "glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 1766 "bind.c"
	}
#line 1203 "glib-2.0.vapi"
	if (_tmp0_) {
#line 1770 "bind.c"
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		void* ptr = NULL;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		void* _tmp21_;
		const gchar* _tmp31_;
#line 1205 "glib-2.0.vapi"
		len = (gsize) 1;
#line 1784 "bind.c"
		{
			gboolean _tmp4_ = FALSE;
#line 1206 "glib-2.0.vapi"
			i = 0;
#line 1206 "glib-2.0.vapi"
			_tmp4_ = TRUE;
#line 1206 "glib-2.0.vapi"
			while (TRUE) {
#line 1793 "bind.c"
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
#line 1206 "glib-2.0.vapi"
				if (!_tmp4_) {
#line 1800 "bind.c"
					gint _tmp5_;
#line 1206 "glib-2.0.vapi"
					_tmp5_ = i;
#line 1206 "glib-2.0.vapi"
					i = _tmp5_ + 1;
#line 1806 "bind.c"
				}
#line 1206 "glib-2.0.vapi"
				_tmp4_ = FALSE;
#line 1206 "glib-2.0.vapi"
				if (str_array_length1 != -1) {
#line 1206 "glib-2.0.vapi"
					_tmp7_ = i < str_array_length1;
#line 1814 "bind.c"
				} else {
#line 1206 "glib-2.0.vapi"
					_tmp7_ = FALSE;
#line 1818 "bind.c"
				}
#line 1206 "glib-2.0.vapi"
				if (_tmp7_) {
#line 1206 "glib-2.0.vapi"
					_tmp6_ = TRUE;
#line 1824 "bind.c"
				} else {
					gboolean _tmp8_ = FALSE;
#line 1206 "glib-2.0.vapi"
					if (str_array_length1 == -1) {
#line 1829 "bind.c"
						const gchar* _tmp9_;
#line 1206 "glib-2.0.vapi"
						_tmp9_ = str_array[i];
#line 1206 "glib-2.0.vapi"
						_tmp8_ = _tmp9_ != NULL;
#line 1835 "bind.c"
					} else {
#line 1206 "glib-2.0.vapi"
						_tmp8_ = FALSE;
#line 1839 "bind.c"
					}
#line 1206 "glib-2.0.vapi"
					_tmp6_ = _tmp8_;
#line 1843 "bind.c"
				}
#line 1206 "glib-2.0.vapi"
				if (!_tmp6_) {
#line 1206 "glib-2.0.vapi"
					break;
#line 1849 "bind.c"
				}
#line 1207 "glib-2.0.vapi"
				_tmp11_ = str_array[i];
#line 1207 "glib-2.0.vapi"
				if (_tmp11_ != NULL) {
#line 1855 "bind.c"
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
#line 1207 "glib-2.0.vapi"
					_tmp12_ = str_array[i];
#line 1207 "glib-2.0.vapi"
					_tmp13_ = strlen ((const gchar*) _tmp12_);
#line 1207 "glib-2.0.vapi"
					_tmp14_ = _tmp13_;
#line 1207 "glib-2.0.vapi"
					_tmp10_ = _tmp14_;
#line 1867 "bind.c"
				} else {
#line 1207 "glib-2.0.vapi"
					_tmp10_ = 0;
#line 1871 "bind.c"
				}
#line 1207 "glib-2.0.vapi"
				len += (gsize) _tmp10_;
#line 1875 "bind.c"
			}
		}
#line 1209 "glib-2.0.vapi"
		if (i == 0) {
#line 1880 "bind.c"
			gchar* _tmp15_;
#line 1210 "glib-2.0.vapi"
			_tmp15_ = g_strdup ("");
#line 1210 "glib-2.0.vapi"
			result = _tmp15_;
#line 1210 "glib-2.0.vapi"
			return result;
#line 1888 "bind.c"
		}
#line 1212 "glib-2.0.vapi"
		str_array_length1 = i;
#line 1213 "glib-2.0.vapi"
		_tmp16_ = strlen ((const gchar*) separator);
#line 1213 "glib-2.0.vapi"
		_tmp17_ = _tmp16_;
#line 1213 "glib-2.0.vapi"
		len += (gsize) (_tmp17_ * (i - 1));
#line 1215 "glib-2.0.vapi"
		_tmp18_ = g_malloc (len);
#line 1215 "glib-2.0.vapi"
		res = _tmp18_;
#line 1216 "glib-2.0.vapi"
		_tmp19_ = res;
#line 1216 "glib-2.0.vapi"
		_tmp20_ = str_array[0];
#line 1216 "glib-2.0.vapi"
		_tmp21_ = g_stpcpy ((void*) _tmp19_, (const gchar*) _tmp20_);
#line 1216 "glib-2.0.vapi"
		ptr = _tmp21_;
#line 1910 "bind.c"
		{
			gboolean _tmp22_ = FALSE;
#line 1217 "glib-2.0.vapi"
			i = 1;
#line 1217 "glib-2.0.vapi"
			_tmp22_ = TRUE;
#line 1217 "glib-2.0.vapi"
			while (TRUE) {
#line 1919 "bind.c"
				void* _tmp24_;
				void* _tmp25_;
				const gchar* _tmp26_ = NULL;
				const gchar* _tmp27_;
				void* _tmp29_;
				void* _tmp30_;
#line 1217 "glib-2.0.vapi"
				if (!_tmp22_) {
#line 1928 "bind.c"
					gint _tmp23_;
#line 1217 "glib-2.0.vapi"
					_tmp23_ = i;
#line 1217 "glib-2.0.vapi"
					i = _tmp23_ + 1;
#line 1934 "bind.c"
				}
#line 1217 "glib-2.0.vapi"
				_tmp22_ = FALSE;
#line 1217 "glib-2.0.vapi"
				if (!(i < str_array_length1)) {
#line 1217 "glib-2.0.vapi"
					break;
#line 1942 "bind.c"
				}
#line 1218 "glib-2.0.vapi"
				_tmp24_ = ptr;
#line 1218 "glib-2.0.vapi"
				_tmp25_ = g_stpcpy (_tmp24_, (const gchar*) separator);
#line 1218 "glib-2.0.vapi"
				ptr = _tmp25_;
#line 1219 "glib-2.0.vapi"
				_tmp27_ = str_array[i];
#line 1219 "glib-2.0.vapi"
				if (_tmp27_ != NULL) {
#line 1954 "bind.c"
					const gchar* _tmp28_;
#line 1219 "glib-2.0.vapi"
					_tmp28_ = str_array[i];
#line 1219 "glib-2.0.vapi"
					_tmp26_ = (const gchar*) _tmp28_;
#line 1960 "bind.c"
				} else {
#line 1219 "glib-2.0.vapi"
					_tmp26_ = "";
#line 1964 "bind.c"
				}
#line 1219 "glib-2.0.vapi"
				_tmp29_ = ptr;
#line 1219 "glib-2.0.vapi"
				_tmp30_ = g_stpcpy (_tmp29_, _tmp26_);
#line 1219 "glib-2.0.vapi"
				ptr = _tmp30_;
#line 1972 "bind.c"
			}
		}
#line 1222 "glib-2.0.vapi"
		_tmp31_ = res;
#line 1222 "glib-2.0.vapi"
		res = NULL;
#line 1222 "glib-2.0.vapi"
		result = (gchar*) _tmp31_;
#line 1222 "glib-2.0.vapi"
		return result;
#line 1983 "bind.c"
	} else {
		gchar* _tmp32_;
#line 1224 "glib-2.0.vapi"
		_tmp32_ = g_strdup ("");
#line 1224 "glib-2.0.vapi"
		result = _tmp32_;
#line 1224 "glib-2.0.vapi"
		return result;
#line 1992 "bind.c"
	}
}

static void
__lambda23_ (Block1Data* _data1_,
             Binding* tree,
             gchar** keys,
             gint keys_length1)
{
	GeeMap* _tmp0_;
#line 217 "src/bind.vala"
	g_return_if_fail (tree != NULL);
#line 218 "src/bind.vala"
	_tmp0_ = tree->map;
#line 218 "src/bind.vala"
	_vala_assert (_tmp0_ != NULL, "tree.map != null");
#line 2009 "bind.c"
	{
		GeeIterator* _key_it = NULL;
		GeeMap* _tmp1_;
		GeeSet* _tmp2_;
		GeeSet* _tmp3_;
		GeeSet* _tmp4_;
		GeeIterator* _tmp5_;
		GeeIterator* _tmp6_;
#line 219 "src/bind.vala"
		_tmp1_ = tree->map;
#line 219 "src/bind.vala"
		_tmp2_ = gee_map_get_keys (_tmp1_);
#line 219 "src/bind.vala"
		_tmp3_ = _tmp2_;
#line 219 "src/bind.vala"
		_tmp4_ = _tmp3_;
#line 219 "src/bind.vala"
		_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
#line 219 "src/bind.vala"
		_tmp6_ = _tmp5_;
#line 219 "src/bind.vala"
		_g_object_unref0 (_tmp4_);
#line 219 "src/bind.vala"
		_key_it = _tmp6_;
#line 219 "src/bind.vala"
		while (TRUE) {
#line 2036 "bind.c"
			GeeIterator* _tmp7_;
			guint key = 0U;
			GeeIterator* _tmp8_;
			gpointer _tmp9_;
			Binding* p = NULL;
			GeeMap* _tmp10_;
			gpointer _tmp11_;
			Binding* _tmp12_;
			gchar** keys_ = NULL;
			gchar** _tmp13_;
			gint _tmp13__length1;
			gint keys__length1;
			gint _keys__size_;
			gchar* _tmp14_;
			Binding* _tmp15_;
			LispFunc* _tmp16_;
#line 219 "src/bind.vala"
			_tmp7_ = _key_it;
#line 219 "src/bind.vala"
			if (!gee_iterator_next (_tmp7_)) {
#line 219 "src/bind.vala"
				break;
#line 2059 "bind.c"
			}
#line 219 "src/bind.vala"
			_tmp8_ = _key_it;
#line 219 "src/bind.vala"
			_tmp9_ = gee_iterator_get (_tmp8_);
#line 219 "src/bind.vala"
			key = (guint) ((guintptr) _tmp9_);
#line 220 "src/bind.vala"
			_tmp10_ = tree->map;
#line 220 "src/bind.vala"
			_tmp11_ = gee_map_get (_tmp10_, (gpointer) ((guintptr) key));
#line 220 "src/bind.vala"
			p = (Binding*) _tmp11_;
#line 221 "src/bind.vala"
			_tmp12_ = p;
#line 221 "src/bind.vala"
			_vala_assert (_tmp12_ != NULL, "p != null");
#line 223 "src/bind.vala"
			_tmp13_ = (keys != NULL) ? _vala_array_dup1 (keys, keys_length1) : ((gpointer) keys);
#line 223 "src/bind.vala"
			_tmp13__length1 = keys_length1;
#line 223 "src/bind.vala"
			keys_ = _tmp13_;
#line 223 "src/bind.vala"
			keys__length1 = _tmp13__length1;
#line 223 "src/bind.vala"
			_keys__size_ = keys__length1;
#line 224 "src/bind.vala"
			_tmp14_ = chordtodesc ((gsize) key);
#line 224 "src/bind.vala"
			_vala_array_add1 (&keys_, &keys__length1, &_keys__size_, _tmp14_);
#line 225 "src/bind.vala"
			_tmp15_ = p;
#line 225 "src/bind.vala"
			_tmp16_ = _tmp15_->func;
#line 225 "src/bind.vala"
			if (_tmp16_ != NULL) {
#line 2097 "bind.c"
				gchar** _tmp17_;
				gint _tmp17__length1;
				gchar* _tmp18_;
				gchar* _tmp19_;
				Binding* _tmp20_;
#line 226 "src/bind.vala"
				_tmp17_ = keys_;
#line 226 "src/bind.vala"
				_tmp17__length1 = keys__length1;
#line 226 "src/bind.vala"
				_tmp18_ = _vala_g_strjoinv (" ", _tmp17_, (gint) _tmp17__length1);
#line 226 "src/bind.vala"
				_tmp19_ = _tmp18_;
#line 226 "src/bind.vala"
				_tmp20_ = p;
#line 226 "src/bind.vala"
				_data1_->process (_tmp19_, _tmp20_, _data1_->process_target);
#line 226 "src/bind.vala"
				_g_free0 (_tmp19_);
#line 2117 "bind.c"
			} else {
				BindingsWalker _tmp21_;
				gpointer _tmp21__target;
				Binding* _tmp22_;
				gchar** _tmp23_;
				gint _tmp23__length1;
#line 228 "src/bind.vala"
				_tmp21_ = _data1_->walker;
#line 228 "src/bind.vala"
				_tmp21__target = _data1_->walker_target;
#line 228 "src/bind.vala"
				_tmp22_ = p;
#line 228 "src/bind.vala"
				_tmp23_ = keys_;
#line 228 "src/bind.vala"
				_tmp23__length1 = keys__length1;
#line 228 "src/bind.vala"
				_tmp21_ (_tmp22_, _tmp23_, (gint) _tmp23__length1, _tmp21__target);
#line 2136 "bind.c"
			}
#line 219 "src/bind.vala"
			keys_ = (_vala_array_free (keys_, keys__length1, (GDestroyNotify) g_free), NULL);
#line 219 "src/bind.vala"
			_binding_unref0 (p);
#line 2142 "bind.c"
		}
#line 219 "src/bind.vala"
		_g_object_unref0 (_key_it);
#line 2146 "bind.c"
	}
}

static void
___lambda23__bindings_walker (Binding* tree,
                              gchar** keys,
                              gint keys_length1,
                              gpointer self)
{
#line 217 "src/bind.vala"
	__lambda23_ (self, tree, keys, keys_length1);
#line 2158 "bind.c"
}

void
walk_bindings (BindingsProcessor process,
               gpointer process_target)
{
	Block1Data* _data1_;
	BindingsWalker _tmp0_;
	gpointer _tmp0__target;
	Binding* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
#line 215 "src/bind.vala"
	_data1_ = g_slice_new0 (Block1Data);
#line 215 "src/bind.vala"
	_data1_->_ref_count_ = 1;
#line 215 "src/bind.vala"
	_data1_->process = process;
#line 215 "src/bind.vala"
	_data1_->process_target = process_target;
#line 216 "src/bind.vala"
	_data1_->walker = NULL;
#line 216 "src/bind.vala"
	_data1_->walker_target = NULL;
#line 216 "src/bind.vala"
	_data1_->walker_target_destroy_notify = NULL;
#line 217 "src/bind.vala"
	(_data1_->walker_target_destroy_notify == NULL) ? NULL : (_data1_->walker_target_destroy_notify (_data1_->walker_target), NULL);
#line 217 "src/bind.vala"
	_data1_->walker = NULL;
#line 217 "src/bind.vala"
	_data1_->walker_target = NULL;
#line 217 "src/bind.vala"
	_data1_->walker_target_destroy_notify = NULL;
#line 217 "src/bind.vala"
	_data1_->walker = ___lambda23__bindings_walker;
#line 217 "src/bind.vala"
	_data1_->walker_target = block1_data_ref (_data1_);
#line 217 "src/bind.vala"
	_data1_->walker_target_destroy_notify = block1_data_unref;
#line 232 "src/bind.vala"
	_tmp0_ = _data1_->walker;
#line 232 "src/bind.vala"
	_tmp0__target = _data1_->walker_target;
#line 232 "src/bind.vala"
	_tmp1_ = root_bindings;
#line 232 "src/bind.vala"
	_tmp2_ = g_new0 (gchar*, 0 + 1);
#line 232 "src/bind.vala"
	_tmp3_ = _tmp2_;
#line 232 "src/bind.vala"
	_tmp3__length1 = 0;
#line 232 "src/bind.vala"
	_tmp0_ (_tmp1_, _tmp3_, (gint) 0, _tmp0__target);
#line 232 "src/bind.vala"
	_tmp3_ = (_vala_array_free (_tmp3_, _tmp3__length1, (GDestroyNotify) g_free), NULL);
#line 215 "src/bind.vala"
	block1_data_unref (_data1_);
#line 215 "src/bind.vala"
	_data1_ = NULL;
#line 2220 "bind.c"
}

static gboolean
__lambda24_ (glong uniarg,
             GeeQueue* args)
{
	GeeList* keys = NULL;
	gchar* keystr = NULL;
	gpointer _tmp0_;
	const gchar* _tmp1_;
	gchar* name = NULL;
	gpointer _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp13_;
	LispFunc* func = NULL;
	const gchar* _tmp14_;
	LispFunc* _tmp15_;
	LispFunc* _tmp16_;
	Binding* _tmp18_;
	GeeList* _tmp19_;
	LispFunc* _tmp20_;
	gboolean result = FALSE;
#line 241 "src/bind.vala"
	_tmp0_ = gee_queue_poll (args);
#line 241 "src/bind.vala"
	keystr = (gchar*) _tmp0_;
#line 242 "src/bind.vala"
	_tmp1_ = keystr;
#line 242 "src/bind.vala"
	if (_tmp1_ != NULL) {
#line 2251 "bind.c"
		const gchar* _tmp2_;
		GeeList* _tmp3_;
		GeeList* _tmp4_;
#line 243 "src/bind.vala"
		_tmp2_ = keystr;
#line 243 "src/bind.vala"
		_tmp3_ = keystrtovec (_tmp2_);
#line 243 "src/bind.vala"
		_g_object_unref0 (keys);
#line 243 "src/bind.vala"
		keys = _tmp3_;
#line 244 "src/bind.vala"
		_tmp4_ = keys;
#line 244 "src/bind.vala"
		if (_tmp4_ == NULL) {
#line 2267 "bind.c"
			const gchar* _tmp5_;
#line 245 "src/bind.vala"
			_tmp5_ = keystr;
#line 245 "src/bind.vala"
			minibuf_error ("Key sequence %s is invalid", _tmp5_, NULL);
#line 246 "src/bind.vala"
			result = FALSE;
#line 246 "src/bind.vala"
			_g_free0 (keystr);
#line 246 "src/bind.vala"
			_g_object_unref0 (keys);
#line 246 "src/bind.vala"
			return result;
#line 2281 "bind.c"
		}
	} else {
		GeeList* _tmp6_;
		GeeList* _tmp7_;
		gchar* _tmp8_;
#line 249 "src/bind.vala"
		minibuf_write ("Set key globally: ", NULL);
#line 250 "src/bind.vala"
		_tmp6_ = get_key_sequence ();
#line 250 "src/bind.vala"
		_g_object_unref0 (keys);
#line 250 "src/bind.vala"
		keys = _tmp6_;
#line 251 "src/bind.vala"
		_tmp7_ = keys;
#line 251 "src/bind.vala"
		_tmp8_ = keyvectodesc (_tmp7_);
#line 251 "src/bind.vala"
		_g_free0 (keystr);
#line 251 "src/bind.vala"
		keystr = _tmp8_;
#line 2303 "bind.c"
	}
#line 254 "src/bind.vala"
	_tmp9_ = gee_queue_poll (args);
#line 254 "src/bind.vala"
	name = (gchar*) _tmp9_;
#line 255 "src/bind.vala"
	_tmp10_ = name;
#line 255 "src/bind.vala"
	if (_tmp10_ == NULL) {
#line 2313 "bind.c"
		const gchar* _tmp11_;
		gchar* _tmp12_;
#line 256 "src/bind.vala"
		_tmp11_ = keystr;
#line 256 "src/bind.vala"
		_tmp12_ = minibuf_read_function_name ("Set key %s to command: ", _tmp11_, NULL);
#line 256 "src/bind.vala"
		_g_free0 (name);
#line 256 "src/bind.vala"
		name = _tmp12_;
#line 2324 "bind.c"
	}
#line 257 "src/bind.vala"
	_tmp13_ = name;
#line 257 "src/bind.vala"
	if (_tmp13_ == NULL) {
#line 258 "src/bind.vala"
		result = FALSE;
#line 258 "src/bind.vala"
		_g_free0 (name);
#line 258 "src/bind.vala"
		_g_free0 (keystr);
#line 258 "src/bind.vala"
		_g_object_unref0 (keys);
#line 258 "src/bind.vala"
		return result;
#line 2340 "bind.c"
	}
#line 260 "src/bind.vala"
	_tmp14_ = name;
#line 260 "src/bind.vala"
	_tmp15_ = lisp_func_find (_tmp14_);
#line 260 "src/bind.vala"
	func = _tmp15_;
#line 261 "src/bind.vala"
	_tmp16_ = func;
#line 261 "src/bind.vala"
	if (_tmp16_ == NULL) {
#line 2352 "bind.c"
		const gchar* _tmp17_;
#line 262 "src/bind.vala"
		_tmp17_ = name;
#line 262 "src/bind.vala"
		minibuf_error ("No such function `%s'", _tmp17_, NULL);
#line 263 "src/bind.vala"
		result = FALSE;
#line 263 "src/bind.vala"
		_lisp_func_unref0 (func);
#line 263 "src/bind.vala"
		_g_free0 (name);
#line 263 "src/bind.vala"
		_g_free0 (keystr);
#line 263 "src/bind.vala"
		_g_object_unref0 (keys);
#line 263 "src/bind.vala"
		return result;
#line 2370 "bind.c"
	}
#line 265 "src/bind.vala"
	_tmp18_ = root_bindings;
#line 265 "src/bind.vala"
	_tmp19_ = keys;
#line 265 "src/bind.vala"
	_tmp20_ = func;
#line 265 "src/bind.vala"
	binding_bind (_tmp18_, _tmp19_, _tmp20_);
#line 266 "src/bind.vala"
	result = TRUE;
#line 266 "src/bind.vala"
	_lisp_func_unref0 (func);
#line 266 "src/bind.vala"
	_g_free0 (name);
#line 266 "src/bind.vala"
	_g_free0 (keystr);
#line 266 "src/bind.vala"
	_g_object_unref0 (keys);
#line 266 "src/bind.vala"
	return result;
#line 2392 "bind.c"
}

static gboolean
___lambda24__function (glong uniarg,
                       GeeQueue* args)
{
	gboolean result;
	result = __lambda24_ (uniarg, args);
#line 237 "src/bind.vala"
	return result;
#line 2403 "bind.c"
}

static gboolean
_self_insert_command_movement_delegate (gpointer self)
{
	gboolean result;
	result = self_insert_command ();
#line 277 "src/bind.vala"
	return result;
#line 2413 "bind.c"
}

static gboolean
__lambda26_ (glong uniarg,
             GeeQueue* args)
{
	gboolean result = FALSE;
#line 277 "src/bind.vala"
	result = execute_with_uniarg (uniarg, _self_insert_command_movement_delegate, NULL, NULL, NULL);
#line 277 "src/bind.vala"
	return result;
#line 2425 "bind.c"
}

static gboolean
___lambda26__function (glong uniarg,
                       GeeQueue* args)
{
	gboolean result;
	result = __lambda26_ (uniarg, args);
#line 274 "src/bind.vala"
	return result;
#line 2436 "bind.c"
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
#line 290 "src/bind.vala"
	g_atomic_int_inc (&_data2_->_ref_count_);
#line 290 "src/bind.vala"
	return _data2_;
#line 2446 "bind.c"
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
#line 290 "src/bind.vala"
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
#line 290 "src/bind.vala"
		_lisp_func_unref0 (_data2_->f);
#line 290 "src/bind.vala"
		g_slice_free (Block2Data, _data2_);
#line 2460 "bind.c"
	}
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
#line 292 "src/bind.vala"
	g_atomic_int_inc (&_data3_->_ref_count_);
#line 292 "src/bind.vala"
	return _data3_;
#line 2471 "bind.c"
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
#line 292 "src/bind.vala"
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
#line 292 "src/bind.vala"
		_g_free0 (_data3_->bindings);
#line 292 "src/bind.vala"
		block2_data_unref (_data3_->_data2_);
#line 292 "src/bind.vala"
		_data3_->_data2_ = NULL;
#line 292 "src/bind.vala"
		g_slice_free (Block3Data, _data3_);
#line 2489 "bind.c"
	}
}

static void
____lambda28_ (Block3Data* _data3_,
               const gchar* key,
               Binding* p)
{
	Block2Data* _data2_;
	LispFunc* _tmp0_;
	LispFunc* _tmp1_;
#line 294 "src/bind.vala"
	_data2_ = _data3_->_data2_;
#line 294 "src/bind.vala"
	g_return_if_fail (key != NULL);
#line 294 "src/bind.vala"
	g_return_if_fail (p != NULL);
#line 295 "src/bind.vala"
	_tmp0_ = p->func;
#line 295 "src/bind.vala"
	_tmp1_ = _data2_->f;
#line 295 "src/bind.vala"
	if (_tmp0_ == _tmp1_) {
#line 2513 "bind.c"
		const gchar* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
#line 296 "src/bind.vala"
		_tmp2_ = _data3_->bindings;
#line 296 "src/bind.vala"
		_tmp3_ = strlen (_tmp2_);
#line 296 "src/bind.vala"
		_tmp4_ = _tmp3_;
#line 296 "src/bind.vala"
		if (_tmp4_ > 0) {
#line 2527 "bind.c"
			const gchar* _tmp5_;
			gchar* _tmp6_;
#line 297 "src/bind.vala"
			_tmp5_ = _data3_->bindings;
#line 297 "src/bind.vala"
			_tmp6_ = g_strconcat (_tmp5_, ", ", NULL);
#line 297 "src/bind.vala"
			_g_free0 (_data3_->bindings);
#line 297 "src/bind.vala"
			_data3_->bindings = _tmp6_;
#line 2538 "bind.c"
		}
#line 298 "src/bind.vala"
		_tmp7_ = _data3_->bindings;
#line 298 "src/bind.vala"
		_tmp8_ = g_strconcat (_tmp7_, key, NULL);
#line 298 "src/bind.vala"
		_g_free0 (_data3_->bindings);
#line 298 "src/bind.vala"
		_data3_->bindings = _tmp8_;
#line 2548 "bind.c"
	}
}

static void
_____lambda28__bindings_processor (const gchar* key,
                                   Binding* p,
                                   gpointer self)
{
#line 294 "src/bind.vala"
	____lambda28_ (self, key, p);
#line 2559 "bind.c"
}

static gboolean
__lambda27_ (glong uniarg,
             GeeQueue* args)
{
	gchar* name = NULL;
	gchar* _tmp0_;
	gboolean ok = FALSE;
	const gchar* _tmp1_;
	gboolean result = FALSE;
#line 287 "src/bind.vala"
	_tmp0_ = minibuf_read_function_name ("Where is command: ", NULL);
#line 287 "src/bind.vala"
	name = _tmp0_;
#line 288 "src/bind.vala"
	ok = FALSE;
#line 290 "src/bind.vala"
	_tmp1_ = name;
#line 290 "src/bind.vala"
	if (_tmp1_ != NULL) {
#line 2581 "bind.c"
		Block2Data* _data2_;
		const gchar* _tmp2_;
		LispFunc* _tmp3_;
		LispFunc* _tmp4_;
#line 290 "src/bind.vala"
		_data2_ = g_slice_new0 (Block2Data);
#line 290 "src/bind.vala"
		_data2_->_ref_count_ = 1;
#line 291 "src/bind.vala"
		_tmp2_ = name;
#line 291 "src/bind.vala"
		_tmp3_ = lisp_func_find (_tmp2_);
#line 291 "src/bind.vala"
		_data2_->f = _tmp3_;
#line 292 "src/bind.vala"
		_tmp4_ = _data2_->f;
#line 292 "src/bind.vala"
		if (_tmp4_ != NULL) {
#line 2600 "bind.c"
			Block3Data* _data3_;
			gchar* _tmp5_;
			const gchar* _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
#line 292 "src/bind.vala"
			_data3_ = g_slice_new0 (Block3Data);
#line 292 "src/bind.vala"
			_data3_->_ref_count_ = 1;
#line 292 "src/bind.vala"
			_data3_->_data2_ = block2_data_ref (_data2_);
#line 293 "src/bind.vala"
			_tmp5_ = g_strdup ("");
#line 293 "src/bind.vala"
			_data3_->bindings = _tmp5_;
#line 294 "src/bind.vala"
			walk_bindings (_____lambda28__bindings_processor, _data3_);
#line 302 "src/bind.vala"
			_tmp6_ = _data3_->bindings;
#line 302 "src/bind.vala"
			_tmp7_ = strlen (_tmp6_);
#line 302 "src/bind.vala"
			_tmp8_ = _tmp7_;
#line 302 "src/bind.vala"
			if (_tmp8_ == 0) {
#line 2626 "bind.c"
				const gchar* _tmp9_;
#line 303 "src/bind.vala"
				_tmp9_ = name;
#line 303 "src/bind.vala"
				minibuf_write ("%s is not on any key", _tmp9_, NULL);
#line 2632 "bind.c"
			} else {
				const gchar* _tmp10_;
				const gchar* _tmp11_;
#line 305 "src/bind.vala"
				_tmp10_ = name;
#line 305 "src/bind.vala"
				_tmp11_ = _data3_->bindings;
#line 305 "src/bind.vala"
				minibuf_write ("%s is on %s", _tmp10_, _tmp11_, NULL);
#line 2642 "bind.c"
			}
#line 306 "src/bind.vala"
			ok = TRUE;
#line 292 "src/bind.vala"
			block3_data_unref (_data3_);
#line 292 "src/bind.vala"
			_data3_ = NULL;
#line 2650 "bind.c"
		}
#line 290 "src/bind.vala"
		block2_data_unref (_data2_);
#line 290 "src/bind.vala"
		_data2_ = NULL;
#line 2656 "bind.c"
	}
#line 309 "src/bind.vala"
	result = ok;
#line 309 "src/bind.vala"
	_g_free0 (name);
#line 309 "src/bind.vala"
	return result;
#line 2664 "bind.c"
}

static gboolean
___lambda27__function (glong uniarg,
                       GeeQueue* args)
{
	gboolean result;
	result = __lambda27_ (uniarg, args);
#line 284 "src/bind.vala"
	return result;
#line 2675 "bind.c"
}

static void
__lambda31_ (const gchar* key,
             Binding* p)
{
	LispFunc* _tmp0_;
	const gchar* _tmp1_;
#line 327 "src/bind.vala"
	g_return_if_fail (key != NULL);
#line 327 "src/bind.vala"
	g_return_if_fail (p != NULL);
#line 328 "src/bind.vala"
	_tmp0_ = p->func;
#line 328 "src/bind.vala"
	_tmp1_ = _tmp0_->name;
#line 328 "src/bind.vala"
	bprintf ("%-15s %s\n", key, _tmp1_, NULL);
#line 2694 "bind.c"
}

static void
___lambda31__bindings_processor (const gchar* key,
                                 Binding* p,
                                 gpointer self)
{
#line 327 "src/bind.vala"
	__lambda31_ (key, p);
#line 2704 "bind.c"
}

static void
__lambda30_ (void)
{
#line 323 "src/bind.vala"
	bprintf ("Key translations:\n", NULL);
#line 324 "src/bind.vala"
	bprintf ("%-15s %s\n", "key", "binding", NULL);
#line 325 "src/bind.vala"
	bprintf ("%-15s %s\n", "---", "-------", NULL);
#line 327 "src/bind.vala"
	walk_bindings (___lambda31__bindings_processor, NULL);
#line 2718 "bind.c"
}

static void
___lambda30__buffer_writer (gpointer self)
{
#line 319 "src/bind.vala"
	__lambda30_ ();
#line 2726 "bind.c"
}

static gboolean
__lambda29_ (glong uniarg,
             GeeQueue* args)
{
	gboolean result = FALSE;
#line 319 "src/bind.vala"
	write_temp_buffer ("*Help*", TRUE, ___lambda30__buffer_writer, NULL);
#line 331 "src/bind.vala"
	result = TRUE;
#line 331 "src/bind.vala"
	return result;
#line 2740 "bind.c"
}

static gboolean
___lambda29__function (glong uniarg,
                       GeeQueue* args)
{
	gboolean result;
	result = __lambda29_ (uniarg, args);
#line 316 "src/bind.vala"
	return result;
#line 2751 "bind.c"
}

void
bind_init (void)
{
	LispFunc* _tmp0_;
	LispFunc* _tmp1_;
	LispFunc* _tmp2_;
	LispFunc* _tmp3_;
	LispFunc* _tmp4_;
	LispFunc* _tmp5_;
	LispFunc* _tmp6_;
	LispFunc* _tmp7_;
#line 237 "src/bind.vala"
	_tmp0_ = lisp_func_new ("global-set-key", ___lambda24__function, TRUE, "Bind a command to a key sequence.\n" \
"Read key sequence and function name, and bind the function to the key\n" \
"sequence.");
#line 237 "src/bind.vala"
	_tmp1_ = _tmp0_;
#line 237 "src/bind.vala"
	_lisp_func_unref0 (_tmp1_);
#line 274 "src/bind.vala"
	_tmp2_ = lisp_func_new ("self-insert-command", ___lambda26__function, TRUE, "Insert the character you type.\n" \
"Whichever character you type to run this command is inserted.");
#line 274 "src/bind.vala"
	_tmp3_ = _tmp2_;
#line 274 "src/bind.vala"
	_lisp_func_unref0 (_tmp3_);
#line 284 "src/bind.vala"
	_tmp4_ = lisp_func_new ("where-is", ___lambda27__function, TRUE, "Print message listing key sequences that invoke the command DEFINITION" \
".\n" \
"Argument is a command name.");
#line 284 "src/bind.vala"
	_tmp5_ = _tmp4_;
#line 284 "src/bind.vala"
	_lisp_func_unref0 (_tmp5_);
#line 316 "src/bind.vala"
	_tmp6_ = lisp_func_new ("describe-bindings", ___lambda29__function, TRUE, "Show a list of all defined keys, and their definitions.");
#line 316 "src/bind.vala"
	_tmp7_ = _tmp6_;
#line 316 "src/bind.vala"
	_lisp_func_unref0 (_tmp7_);
#line 2789 "bind.c"
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gint i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

