/*
    $Id: check_bitfield.c,v 1.2 2003/02/19 16:38:33 hvr Exp $

    Copyright (C) 2001 Herbert Valerio Riedel <hvr@gnu.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include <stdio.h>

#include <libvcd/vcd_types.h>
#include <libvcd/vcd_files.h>
#include <libvcd/vcd_files_private.h>

const static struct {
  InfoSpiContents bitfield;
  uint8_t intval;
} InfoSpiContents_table[256] = {
  { { .audio_type = 0, .video_type = 0, .item_cont = 0, .ogt = 0 }, 0x00 },
  { { .audio_type = 1, .video_type = 0, .item_cont = 0, .ogt = 0 }, 0x01 },
  { { .audio_type = 2, .video_type = 0, .item_cont = 0, .ogt = 0 }, 0x02 },
  { { .audio_type = 3, .video_type = 0, .item_cont = 0, .ogt = 0 }, 0x03 },
  { { .audio_type = 0, .video_type = 1, .item_cont = 0, .ogt = 0 }, 0x04 },
  { { .audio_type = 1, .video_type = 1, .item_cont = 0, .ogt = 0 }, 0x05 },
  { { .audio_type = 2, .video_type = 1, .item_cont = 0, .ogt = 0 }, 0x06 },
  { { .audio_type = 3, .video_type = 1, .item_cont = 0, .ogt = 0 }, 0x07 },
  { { .audio_type = 0, .video_type = 2, .item_cont = 0, .ogt = 0 }, 0x08 },
  { { .audio_type = 1, .video_type = 2, .item_cont = 0, .ogt = 0 }, 0x09 },
  { { .audio_type = 2, .video_type = 2, .item_cont = 0, .ogt = 0 }, 0x0a },
  { { .audio_type = 3, .video_type = 2, .item_cont = 0, .ogt = 0 }, 0x0b },
  { { .audio_type = 0, .video_type = 3, .item_cont = 0, .ogt = 0 }, 0x0c },
  { { .audio_type = 1, .video_type = 3, .item_cont = 0, .ogt = 0 }, 0x0d },
  { { .audio_type = 2, .video_type = 3, .item_cont = 0, .ogt = 0 }, 0x0e },
  { { .audio_type = 3, .video_type = 3, .item_cont = 0, .ogt = 0 }, 0x0f },
  { { .audio_type = 0, .video_type = 4, .item_cont = 0, .ogt = 0 }, 0x10 },
  { { .audio_type = 1, .video_type = 4, .item_cont = 0, .ogt = 0 }, 0x11 },
  { { .audio_type = 2, .video_type = 4, .item_cont = 0, .ogt = 0 }, 0x12 },
  { { .audio_type = 3, .video_type = 4, .item_cont = 0, .ogt = 0 }, 0x13 },
  { { .audio_type = 0, .video_type = 5, .item_cont = 0, .ogt = 0 }, 0x14 },
  { { .audio_type = 1, .video_type = 5, .item_cont = 0, .ogt = 0 }, 0x15 },
  { { .audio_type = 2, .video_type = 5, .item_cont = 0, .ogt = 0 }, 0x16 },
  { { .audio_type = 3, .video_type = 5, .item_cont = 0, .ogt = 0 }, 0x17 },
  { { .audio_type = 0, .video_type = 6, .item_cont = 0, .ogt = 0 }, 0x18 },
  { { .audio_type = 1, .video_type = 6, .item_cont = 0, .ogt = 0 }, 0x19 },
  { { .audio_type = 2, .video_type = 6, .item_cont = 0, .ogt = 0 }, 0x1a },
  { { .audio_type = 3, .video_type = 6, .item_cont = 0, .ogt = 0 }, 0x1b },
  { { .audio_type = 0, .video_type = 7, .item_cont = 0, .ogt = 0 }, 0x1c },
  { { .audio_type = 1, .video_type = 7, .item_cont = 0, .ogt = 0 }, 0x1d },
  { { .audio_type = 2, .video_type = 7, .item_cont = 0, .ogt = 0 }, 0x1e },
  { { .audio_type = 3, .video_type = 7, .item_cont = 0, .ogt = 0 }, 0x1f },
  { { .audio_type = 0, .video_type = 0, .item_cont = 1, .ogt = 0 }, 0x20 },
  { { .audio_type = 1, .video_type = 0, .item_cont = 1, .ogt = 0 }, 0x21 },
  { { .audio_type = 2, .video_type = 0, .item_cont = 1, .ogt = 0 }, 0x22 },
  { { .audio_type = 3, .video_type = 0, .item_cont = 1, .ogt = 0 }, 0x23 },
  { { .audio_type = 0, .video_type = 1, .item_cont = 1, .ogt = 0 }, 0x24 },
  { { .audio_type = 1, .video_type = 1, .item_cont = 1, .ogt = 0 }, 0x25 },
  { { .audio_type = 2, .video_type = 1, .item_cont = 1, .ogt = 0 }, 0x26 },
  { { .audio_type = 3, .video_type = 1, .item_cont = 1, .ogt = 0 }, 0x27 },
  { { .audio_type = 0, .video_type = 2, .item_cont = 1, .ogt = 0 }, 0x28 },
  { { .audio_type = 1, .video_type = 2, .item_cont = 1, .ogt = 0 }, 0x29 },
  { { .audio_type = 2, .video_type = 2, .item_cont = 1, .ogt = 0 }, 0x2a },
  { { .audio_type = 3, .video_type = 2, .item_cont = 1, .ogt = 0 }, 0x2b },
  { { .audio_type = 0, .video_type = 3, .item_cont = 1, .ogt = 0 }, 0x2c },
  { { .audio_type = 1, .video_type = 3, .item_cont = 1, .ogt = 0 }, 0x2d },
  { { .audio_type = 2, .video_type = 3, .item_cont = 1, .ogt = 0 }, 0x2e },
  { { .audio_type = 3, .video_type = 3, .item_cont = 1, .ogt = 0 }, 0x2f },
  { { .audio_type = 0, .video_type = 4, .item_cont = 1, .ogt = 0 }, 0x30 },
  { { .audio_type = 1, .video_type = 4, .item_cont = 1, .ogt = 0 }, 0x31 },
  { { .audio_type = 2, .video_type = 4, .item_cont = 1, .ogt = 0 }, 0x32 },
  { { .audio_type = 3, .video_type = 4, .item_cont = 1, .ogt = 0 }, 0x33 },
  { { .audio_type = 0, .video_type = 5, .item_cont = 1, .ogt = 0 }, 0x34 },
  { { .audio_type = 1, .video_type = 5, .item_cont = 1, .ogt = 0 }, 0x35 },
  { { .audio_type = 2, .video_type = 5, .item_cont = 1, .ogt = 0 }, 0x36 },
  { { .audio_type = 3, .video_type = 5, .item_cont = 1, .ogt = 0 }, 0x37 },
  { { .audio_type = 0, .video_type = 6, .item_cont = 1, .ogt = 0 }, 0x38 },
  { { .audio_type = 1, .video_type = 6, .item_cont = 1, .ogt = 0 }, 0x39 },
  { { .audio_type = 2, .video_type = 6, .item_cont = 1, .ogt = 0 }, 0x3a },
  { { .audio_type = 3, .video_type = 6, .item_cont = 1, .ogt = 0 }, 0x3b },
  { { .audio_type = 0, .video_type = 7, .item_cont = 1, .ogt = 0 }, 0x3c },
  { { .audio_type = 1, .video_type = 7, .item_cont = 1, .ogt = 0 }, 0x3d },
  { { .audio_type = 2, .video_type = 7, .item_cont = 1, .ogt = 0 }, 0x3e },
  { { .audio_type = 3, .video_type = 7, .item_cont = 1, .ogt = 0 }, 0x3f },
  { { .audio_type = 0, .video_type = 0, .item_cont = 0, .ogt = 1 }, 0x40 },
  { { .audio_type = 1, .video_type = 0, .item_cont = 0, .ogt = 1 }, 0x41 },
  { { .audio_type = 2, .video_type = 0, .item_cont = 0, .ogt = 1 }, 0x42 },
  { { .audio_type = 3, .video_type = 0, .item_cont = 0, .ogt = 1 }, 0x43 },
  { { .audio_type = 0, .video_type = 1, .item_cont = 0, .ogt = 1 }, 0x44 },
  { { .audio_type = 1, .video_type = 1, .item_cont = 0, .ogt = 1 }, 0x45 },
  { { .audio_type = 2, .video_type = 1, .item_cont = 0, .ogt = 1 }, 0x46 },
  { { .audio_type = 3, .video_type = 1, .item_cont = 0, .ogt = 1 }, 0x47 },
  { { .audio_type = 0, .video_type = 2, .item_cont = 0, .ogt = 1 }, 0x48 },
  { { .audio_type = 1, .video_type = 2, .item_cont = 0, .ogt = 1 }, 0x49 },
  { { .audio_type = 2, .video_type = 2, .item_cont = 0, .ogt = 1 }, 0x4a },
  { { .audio_type = 3, .video_type = 2, .item_cont = 0, .ogt = 1 }, 0x4b },
  { { .audio_type = 0, .video_type = 3, .item_cont = 0, .ogt = 1 }, 0x4c },
  { { .audio_type = 1, .video_type = 3, .item_cont = 0, .ogt = 1 }, 0x4d },
  { { .audio_type = 2, .video_type = 3, .item_cont = 0, .ogt = 1 }, 0x4e },
  { { .audio_type = 3, .video_type = 3, .item_cont = 0, .ogt = 1 }, 0x4f },
  { { .audio_type = 0, .video_type = 4, .item_cont = 0, .ogt = 1 }, 0x50 },
  { { .audio_type = 1, .video_type = 4, .item_cont = 0, .ogt = 1 }, 0x51 },
  { { .audio_type = 2, .video_type = 4, .item_cont = 0, .ogt = 1 }, 0x52 },
  { { .audio_type = 3, .video_type = 4, .item_cont = 0, .ogt = 1 }, 0x53 },
  { { .audio_type = 0, .video_type = 5, .item_cont = 0, .ogt = 1 }, 0x54 },
  { { .audio_type = 1, .video_type = 5, .item_cont = 0, .ogt = 1 }, 0x55 },
  { { .audio_type = 2, .video_type = 5, .item_cont = 0, .ogt = 1 }, 0x56 },
  { { .audio_type = 3, .video_type = 5, .item_cont = 0, .ogt = 1 }, 0x57 },
  { { .audio_type = 0, .video_type = 6, .item_cont = 0, .ogt = 1 }, 0x58 },
  { { .audio_type = 1, .video_type = 6, .item_cont = 0, .ogt = 1 }, 0x59 },
  { { .audio_type = 2, .video_type = 6, .item_cont = 0, .ogt = 1 }, 0x5a },
  { { .audio_type = 3, .video_type = 6, .item_cont = 0, .ogt = 1 }, 0x5b },
  { { .audio_type = 0, .video_type = 7, .item_cont = 0, .ogt = 1 }, 0x5c },
  { { .audio_type = 1, .video_type = 7, .item_cont = 0, .ogt = 1 }, 0x5d },
  { { .audio_type = 2, .video_type = 7, .item_cont = 0, .ogt = 1 }, 0x5e },
  { { .audio_type = 3, .video_type = 7, .item_cont = 0, .ogt = 1 }, 0x5f },
  { { .audio_type = 0, .video_type = 0, .item_cont = 1, .ogt = 1 }, 0x60 },
  { { .audio_type = 1, .video_type = 0, .item_cont = 1, .ogt = 1 }, 0x61 },
  { { .audio_type = 2, .video_type = 0, .item_cont = 1, .ogt = 1 }, 0x62 },
  { { .audio_type = 3, .video_type = 0, .item_cont = 1, .ogt = 1 }, 0x63 },
  { { .audio_type = 0, .video_type = 1, .item_cont = 1, .ogt = 1 }, 0x64 },
  { { .audio_type = 1, .video_type = 1, .item_cont = 1, .ogt = 1 }, 0x65 },
  { { .audio_type = 2, .video_type = 1, .item_cont = 1, .ogt = 1 }, 0x66 },
  { { .audio_type = 3, .video_type = 1, .item_cont = 1, .ogt = 1 }, 0x67 },
  { { .audio_type = 0, .video_type = 2, .item_cont = 1, .ogt = 1 }, 0x68 },
  { { .audio_type = 1, .video_type = 2, .item_cont = 1, .ogt = 1 }, 0x69 },
  { { .audio_type = 2, .video_type = 2, .item_cont = 1, .ogt = 1 }, 0x6a },
  { { .audio_type = 3, .video_type = 2, .item_cont = 1, .ogt = 1 }, 0x6b },
  { { .audio_type = 0, .video_type = 3, .item_cont = 1, .ogt = 1 }, 0x6c },
  { { .audio_type = 1, .video_type = 3, .item_cont = 1, .ogt = 1 }, 0x6d },
  { { .audio_type = 2, .video_type = 3, .item_cont = 1, .ogt = 1 }, 0x6e },
  { { .audio_type = 3, .video_type = 3, .item_cont = 1, .ogt = 1 }, 0x6f },
  { { .audio_type = 0, .video_type = 4, .item_cont = 1, .ogt = 1 }, 0x70 },
  { { .audio_type = 1, .video_type = 4, .item_cont = 1, .ogt = 1 }, 0x71 },
  { { .audio_type = 2, .video_type = 4, .item_cont = 1, .ogt = 1 }, 0x72 },
  { { .audio_type = 3, .video_type = 4, .item_cont = 1, .ogt = 1 }, 0x73 },
  { { .audio_type = 0, .video_type = 5, .item_cont = 1, .ogt = 1 }, 0x74 },
  { { .audio_type = 1, .video_type = 5, .item_cont = 1, .ogt = 1 }, 0x75 },
  { { .audio_type = 2, .video_type = 5, .item_cont = 1, .ogt = 1 }, 0x76 },
  { { .audio_type = 3, .video_type = 5, .item_cont = 1, .ogt = 1 }, 0x77 },
  { { .audio_type = 0, .video_type = 6, .item_cont = 1, .ogt = 1 }, 0x78 },
  { { .audio_type = 1, .video_type = 6, .item_cont = 1, .ogt = 1 }, 0x79 },
  { { .audio_type = 2, .video_type = 6, .item_cont = 1, .ogt = 1 }, 0x7a },
  { { .audio_type = 3, .video_type = 6, .item_cont = 1, .ogt = 1 }, 0x7b },
  { { .audio_type = 0, .video_type = 7, .item_cont = 1, .ogt = 1 }, 0x7c },
  { { .audio_type = 1, .video_type = 7, .item_cont = 1, .ogt = 1 }, 0x7d },
  { { .audio_type = 2, .video_type = 7, .item_cont = 1, .ogt = 1 }, 0x7e },
  { { .audio_type = 3, .video_type = 7, .item_cont = 1, .ogt = 1 }, 0x7f },
  { { .audio_type = 0, .video_type = 0, .item_cont = 0, .ogt = 2 }, 0x80 },
  { { .audio_type = 1, .video_type = 0, .item_cont = 0, .ogt = 2 }, 0x81 },
  { { .audio_type = 2, .video_type = 0, .item_cont = 0, .ogt = 2 }, 0x82 },
  { { .audio_type = 3, .video_type = 0, .item_cont = 0, .ogt = 2 }, 0x83 },
  { { .audio_type = 0, .video_type = 1, .item_cont = 0, .ogt = 2 }, 0x84 },
  { { .audio_type = 1, .video_type = 1, .item_cont = 0, .ogt = 2 }, 0x85 },
  { { .audio_type = 2, .video_type = 1, .item_cont = 0, .ogt = 2 }, 0x86 },
  { { .audio_type = 3, .video_type = 1, .item_cont = 0, .ogt = 2 }, 0x87 },
  { { .audio_type = 0, .video_type = 2, .item_cont = 0, .ogt = 2 }, 0x88 },
  { { .audio_type = 1, .video_type = 2, .item_cont = 0, .ogt = 2 }, 0x89 },
  { { .audio_type = 2, .video_type = 2, .item_cont = 0, .ogt = 2 }, 0x8a },
  { { .audio_type = 3, .video_type = 2, .item_cont = 0, .ogt = 2 }, 0x8b },
  { { .audio_type = 0, .video_type = 3, .item_cont = 0, .ogt = 2 }, 0x8c },
  { { .audio_type = 1, .video_type = 3, .item_cont = 0, .ogt = 2 }, 0x8d },
  { { .audio_type = 2, .video_type = 3, .item_cont = 0, .ogt = 2 }, 0x8e },
  { { .audio_type = 3, .video_type = 3, .item_cont = 0, .ogt = 2 }, 0x8f },
  { { .audio_type = 0, .video_type = 4, .item_cont = 0, .ogt = 2 }, 0x90 },
  { { .audio_type = 1, .video_type = 4, .item_cont = 0, .ogt = 2 }, 0x91 },
  { { .audio_type = 2, .video_type = 4, .item_cont = 0, .ogt = 2 }, 0x92 },
  { { .audio_type = 3, .video_type = 4, .item_cont = 0, .ogt = 2 }, 0x93 },
  { { .audio_type = 0, .video_type = 5, .item_cont = 0, .ogt = 2 }, 0x94 },
  { { .audio_type = 1, .video_type = 5, .item_cont = 0, .ogt = 2 }, 0x95 },
  { { .audio_type = 2, .video_type = 5, .item_cont = 0, .ogt = 2 }, 0x96 },
  { { .audio_type = 3, .video_type = 5, .item_cont = 0, .ogt = 2 }, 0x97 },
  { { .audio_type = 0, .video_type = 6, .item_cont = 0, .ogt = 2 }, 0x98 },
  { { .audio_type = 1, .video_type = 6, .item_cont = 0, .ogt = 2 }, 0x99 },
  { { .audio_type = 2, .video_type = 6, .item_cont = 0, .ogt = 2 }, 0x9a },
  { { .audio_type = 3, .video_type = 6, .item_cont = 0, .ogt = 2 }, 0x9b },
  { { .audio_type = 0, .video_type = 7, .item_cont = 0, .ogt = 2 }, 0x9c },
  { { .audio_type = 1, .video_type = 7, .item_cont = 0, .ogt = 2 }, 0x9d },
  { { .audio_type = 2, .video_type = 7, .item_cont = 0, .ogt = 2 }, 0x9e },
  { { .audio_type = 3, .video_type = 7, .item_cont = 0, .ogt = 2 }, 0x9f },
  { { .audio_type = 0, .video_type = 0, .item_cont = 1, .ogt = 2 }, 0xa0 },
  { { .audio_type = 1, .video_type = 0, .item_cont = 1, .ogt = 2 }, 0xa1 },
  { { .audio_type = 2, .video_type = 0, .item_cont = 1, .ogt = 2 }, 0xa2 },
  { { .audio_type = 3, .video_type = 0, .item_cont = 1, .ogt = 2 }, 0xa3 },
  { { .audio_type = 0, .video_type = 1, .item_cont = 1, .ogt = 2 }, 0xa4 },
  { { .audio_type = 1, .video_type = 1, .item_cont = 1, .ogt = 2 }, 0xa5 },
  { { .audio_type = 2, .video_type = 1, .item_cont = 1, .ogt = 2 }, 0xa6 },
  { { .audio_type = 3, .video_type = 1, .item_cont = 1, .ogt = 2 }, 0xa7 },
  { { .audio_type = 0, .video_type = 2, .item_cont = 1, .ogt = 2 }, 0xa8 },
  { { .audio_type = 1, .video_type = 2, .item_cont = 1, .ogt = 2 }, 0xa9 },
  { { .audio_type = 2, .video_type = 2, .item_cont = 1, .ogt = 2 }, 0xaa },
  { { .audio_type = 3, .video_type = 2, .item_cont = 1, .ogt = 2 }, 0xab },
  { { .audio_type = 0, .video_type = 3, .item_cont = 1, .ogt = 2 }, 0xac },
  { { .audio_type = 1, .video_type = 3, .item_cont = 1, .ogt = 2 }, 0xad },
  { { .audio_type = 2, .video_type = 3, .item_cont = 1, .ogt = 2 }, 0xae },
  { { .audio_type = 3, .video_type = 3, .item_cont = 1, .ogt = 2 }, 0xaf },
  { { .audio_type = 0, .video_type = 4, .item_cont = 1, .ogt = 2 }, 0xb0 },
  { { .audio_type = 1, .video_type = 4, .item_cont = 1, .ogt = 2 }, 0xb1 },
  { { .audio_type = 2, .video_type = 4, .item_cont = 1, .ogt = 2 }, 0xb2 },
  { { .audio_type = 3, .video_type = 4, .item_cont = 1, .ogt = 2 }, 0xb3 },
  { { .audio_type = 0, .video_type = 5, .item_cont = 1, .ogt = 2 }, 0xb4 },
  { { .audio_type = 1, .video_type = 5, .item_cont = 1, .ogt = 2 }, 0xb5 },
  { { .audio_type = 2, .video_type = 5, .item_cont = 1, .ogt = 2 }, 0xb6 },
  { { .audio_type = 3, .video_type = 5, .item_cont = 1, .ogt = 2 }, 0xb7 },
  { { .audio_type = 0, .video_type = 6, .item_cont = 1, .ogt = 2 }, 0xb8 },
  { { .audio_type = 1, .video_type = 6, .item_cont = 1, .ogt = 2 }, 0xb9 },
  { { .audio_type = 2, .video_type = 6, .item_cont = 1, .ogt = 2 }, 0xba },
  { { .audio_type = 3, .video_type = 6, .item_cont = 1, .ogt = 2 }, 0xbb },
  { { .audio_type = 0, .video_type = 7, .item_cont = 1, .ogt = 2 }, 0xbc },
  { { .audio_type = 1, .video_type = 7, .item_cont = 1, .ogt = 2 }, 0xbd },
  { { .audio_type = 2, .video_type = 7, .item_cont = 1, .ogt = 2 }, 0xbe },
  { { .audio_type = 3, .video_type = 7, .item_cont = 1, .ogt = 2 }, 0xbf },
  { { .audio_type = 0, .video_type = 0, .item_cont = 0, .ogt = 3 }, 0xc0 },
  { { .audio_type = 1, .video_type = 0, .item_cont = 0, .ogt = 3 }, 0xc1 },
  { { .audio_type = 2, .video_type = 0, .item_cont = 0, .ogt = 3 }, 0xc2 },
  { { .audio_type = 3, .video_type = 0, .item_cont = 0, .ogt = 3 }, 0xc3 },
  { { .audio_type = 0, .video_type = 1, .item_cont = 0, .ogt = 3 }, 0xc4 },
  { { .audio_type = 1, .video_type = 1, .item_cont = 0, .ogt = 3 }, 0xc5 },
  { { .audio_type = 2, .video_type = 1, .item_cont = 0, .ogt = 3 }, 0xc6 },
  { { .audio_type = 3, .video_type = 1, .item_cont = 0, .ogt = 3 }, 0xc7 },
  { { .audio_type = 0, .video_type = 2, .item_cont = 0, .ogt = 3 }, 0xc8 },
  { { .audio_type = 1, .video_type = 2, .item_cont = 0, .ogt = 3 }, 0xc9 },
  { { .audio_type = 2, .video_type = 2, .item_cont = 0, .ogt = 3 }, 0xca },
  { { .audio_type = 3, .video_type = 2, .item_cont = 0, .ogt = 3 }, 0xcb },
  { { .audio_type = 0, .video_type = 3, .item_cont = 0, .ogt = 3 }, 0xcc },
  { { .audio_type = 1, .video_type = 3, .item_cont = 0, .ogt = 3 }, 0xcd },
  { { .audio_type = 2, .video_type = 3, .item_cont = 0, .ogt = 3 }, 0xce },
  { { .audio_type = 3, .video_type = 3, .item_cont = 0, .ogt = 3 }, 0xcf },
  { { .audio_type = 0, .video_type = 4, .item_cont = 0, .ogt = 3 }, 0xd0 },
  { { .audio_type = 1, .video_type = 4, .item_cont = 0, .ogt = 3 }, 0xd1 },
  { { .audio_type = 2, .video_type = 4, .item_cont = 0, .ogt = 3 }, 0xd2 },
  { { .audio_type = 3, .video_type = 4, .item_cont = 0, .ogt = 3 }, 0xd3 },
  { { .audio_type = 0, .video_type = 5, .item_cont = 0, .ogt = 3 }, 0xd4 },
  { { .audio_type = 1, .video_type = 5, .item_cont = 0, .ogt = 3 }, 0xd5 },
  { { .audio_type = 2, .video_type = 5, .item_cont = 0, .ogt = 3 }, 0xd6 },
  { { .audio_type = 3, .video_type = 5, .item_cont = 0, .ogt = 3 }, 0xd7 },
  { { .audio_type = 0, .video_type = 6, .item_cont = 0, .ogt = 3 }, 0xd8 },
  { { .audio_type = 1, .video_type = 6, .item_cont = 0, .ogt = 3 }, 0xd9 },
  { { .audio_type = 2, .video_type = 6, .item_cont = 0, .ogt = 3 }, 0xda },
  { { .audio_type = 3, .video_type = 6, .item_cont = 0, .ogt = 3 }, 0xdb },
  { { .audio_type = 0, .video_type = 7, .item_cont = 0, .ogt = 3 }, 0xdc },
  { { .audio_type = 1, .video_type = 7, .item_cont = 0, .ogt = 3 }, 0xdd },
  { { .audio_type = 2, .video_type = 7, .item_cont = 0, .ogt = 3 }, 0xde },
  { { .audio_type = 3, .video_type = 7, .item_cont = 0, .ogt = 3 }, 0xdf },
  { { .audio_type = 0, .video_type = 0, .item_cont = 1, .ogt = 3 }, 0xe0 },
  { { .audio_type = 1, .video_type = 0, .item_cont = 1, .ogt = 3 }, 0xe1 },
  { { .audio_type = 2, .video_type = 0, .item_cont = 1, .ogt = 3 }, 0xe2 },
  { { .audio_type = 3, .video_type = 0, .item_cont = 1, .ogt = 3 }, 0xe3 },
  { { .audio_type = 0, .video_type = 1, .item_cont = 1, .ogt = 3 }, 0xe4 },
  { { .audio_type = 1, .video_type = 1, .item_cont = 1, .ogt = 3 }, 0xe5 },
  { { .audio_type = 2, .video_type = 1, .item_cont = 1, .ogt = 3 }, 0xe6 },
  { { .audio_type = 3, .video_type = 1, .item_cont = 1, .ogt = 3 }, 0xe7 },
  { { .audio_type = 0, .video_type = 2, .item_cont = 1, .ogt = 3 }, 0xe8 },
  { { .audio_type = 1, .video_type = 2, .item_cont = 1, .ogt = 3 }, 0xe9 },
  { { .audio_type = 2, .video_type = 2, .item_cont = 1, .ogt = 3 }, 0xea },
  { { .audio_type = 3, .video_type = 2, .item_cont = 1, .ogt = 3 }, 0xeb },
  { { .audio_type = 0, .video_type = 3, .item_cont = 1, .ogt = 3 }, 0xec },
  { { .audio_type = 1, .video_type = 3, .item_cont = 1, .ogt = 3 }, 0xed },
  { { .audio_type = 2, .video_type = 3, .item_cont = 1, .ogt = 3 }, 0xee },
  { { .audio_type = 3, .video_type = 3, .item_cont = 1, .ogt = 3 }, 0xef },
  { { .audio_type = 0, .video_type = 4, .item_cont = 1, .ogt = 3 }, 0xf0 },
  { { .audio_type = 1, .video_type = 4, .item_cont = 1, .ogt = 3 }, 0xf1 },
  { { .audio_type = 2, .video_type = 4, .item_cont = 1, .ogt = 3 }, 0xf2 },
  { { .audio_type = 3, .video_type = 4, .item_cont = 1, .ogt = 3 }, 0xf3 },
  { { .audio_type = 0, .video_type = 5, .item_cont = 1, .ogt = 3 }, 0xf4 },
  { { .audio_type = 1, .video_type = 5, .item_cont = 1, .ogt = 3 }, 0xf5 },
  { { .audio_type = 2, .video_type = 5, .item_cont = 1, .ogt = 3 }, 0xf6 },
  { { .audio_type = 3, .video_type = 5, .item_cont = 1, .ogt = 3 }, 0xf7 },
  { { .audio_type = 0, .video_type = 6, .item_cont = 1, .ogt = 3 }, 0xf8 },
  { { .audio_type = 1, .video_type = 6, .item_cont = 1, .ogt = 3 }, 0xf9 },
  { { .audio_type = 2, .video_type = 6, .item_cont = 1, .ogt = 3 }, 0xfa },
  { { .audio_type = 3, .video_type = 6, .item_cont = 1, .ogt = 3 }, 0xfb },
  { { .audio_type = 0, .video_type = 7, .item_cont = 1, .ogt = 3 }, 0xfc },
  { { .audio_type = 1, .video_type = 7, .item_cont = 1, .ogt = 3 }, 0xfd },
  { { .audio_type = 2, .video_type = 7, .item_cont = 1, .ogt = 3 }, 0xfe },
  { { .audio_type = 3, .video_type = 7, .item_cont = 1, .ogt = 3 }, 0xff }
};

int
main (int argc, const char *argv[])
{
  int i;

  for (i = 0; i < 256; ++i)
    {
      const union {
	InfoSpiContents bf;
	uint8_t byte;
      } *u = (void *) &InfoSpiContents_table[i].bitfield;

      if (u->byte != InfoSpiContents_table[i].intval)
	{
	  printf ("failed at index %d (%.2x != %.2x)\n", 
		  i, u->byte, InfoSpiContents_table[i].intval);
	  return 1;
	}
    }

  return 0;
}
