.\"Do not edit this file.  It was created from units.texinfo
.\"using texi2man version 1.2.4 on Thu 06 Aug 2020 10:21:26 PM EDT
.\"This manual is for GNU Units (version 2.20),
.\"which performs units conversions and units calculations.
.\"
.\"Copyright \(co 1996, 1997, 1999, 2000, 2001, 2002, 2004, 2005, 2007,
.\"2011\(en2020 Free Software Foundation, Inc.
.\"
.\"Permission is granted to copy, distribute and/or modify this document
.\"under the terms of the GNU Free Documentation License, Version 1.3 or
.\"any later version published by the Free Software Foundation; with no
.\"Invariant Sections, with no Front-Cover Texts, and with no Back-Cover
.\"Texts.
.TH UNITS 1   "6 August 2020"
.\"
.\"------------------------------------------------------------------------
.\" ensure that ASCII circumflex U+005E (^) and tilde U+007E (~)
.\" are not remapped, so that example text can be copied and pasted
.tr ^\(ha
.tr ~\(ti
.\" override translation in troffrc
.ie .if '\*[.T]'utf8' .tr `\(oq'\(cq
.\" override mapping of ` to 60h with Tascii; assume
.\" we don't need a backquote for an example
.el .if n .tr `'
.if n .tr \(bu*
.\" override translation to MIDDLE DOT
.if '\*(.T'utf8' .tr \(bu\(bu
.if '\*(.T'cp1252' .tr \(bu\(bu
.if '\*(.T'ansi' .tr \(bu\(bu
.\"------------------------------------------------------------------------
.\"
.SH NAME
units \(em unit conversion and calculation program
.\" hack to prevent very thick fraction bars with gropdf
.\" '-1' makes thickness proportional to type size
.if \n(.g .if t \Z@\D't -1'@
.PP
.SH SYNOPSIS
.PP
.CW units
.RI [ options ]
.RI [ from-unit
.RI [ to-unit ]]
.PP
.SH DESCRIPTION
The \%\f(CWunits\fR program converts quantities expressed in various
systems of measurement to their equivalents in other systems of
measurement.  Like many similar programs, it can handle multiplicative
scale changes. It can also handle nonlinear conversions such as
Fahrenheit to
Celsius;
see \fITemperature Conversions\fP.
The program can also perform conversions from and to sums of
units, such as converting between meters and feet plus inches.
.PP
Basic operation is simple: you enter the units that you want to convert
\fIfrom\fP and the units that you want to convert \fIto\fP.
You can use the program interactively with prompts, or you can use it
from the command line.
.PP
Beyond simple unit conversions, \%\f(CWunits\fR can be used as a
general-purpose scientific calculator that keeps track of units in its
calculations.  You can form arbitrary complex mathematical expressions
of dimensions including sums, products, quotients, powers, and even roots
of dimensions.  Thus you can ensure accuracy and dimensional consistency
when working with long expressions that involve many different units
that may combine in complex ways; for an illustration,
see \fIComplicated Unit Expressions\fP.
.PP
The units are defined in an external data file.  You can use the
extensive data file that comes with this program, or you can
provide your own data file to suit your needs.  You can also use your
own data file to supplement the standard data file.
.PP
You can change the default behavior of \%\f(CWunits\fR with various
options given on the command line. See \fIInvoking Units\fP for a
description of the available options.
.PP
.SH INTERACTING WITH \f(BIUNITS\fP
To invoke \%\f(CWunits\fR for interactive use, type \%\f(CIunits\fR at your
shell prompt.  The program will print something like this:
.PP
.EX
Currency exchange rates from www.timegenie.com on 2014-03-05 
2860 units, 109 prefixes, 85 nonlinear units

You have:
.EE
.PP
At the \%\(oq\f(CWYou\ have:\fR\(cq prompt, type the quantity and units that
you are converting \fIfrom\fP.  For example, if you want to convert ten
meters to feet, type \%\f(CI10 meters\fR.  Next, \%\f(CWunits\fR will print
\%\(oq\f(CWYou\ want:\fR\(cq.  You should type the units you want to convert
\fIto\fP.  To convert to feet, you would type \%\f(CIfeet\fR.  If the
\%\f(CWreadline\fR library was compiled in, then \fItab\fP will
complete unit names. See \fIReadline Support\fP for more information
about \%\f(CWreadline\fR.  To quit the program type \%\f(CIquit\fR or
\%\f(CIexit\fR at either prompt.  
.PP
The result will be displayed in two ways.  The first line of output,
which is marked with a \%\(oq\f(CW*\fR\(cq to indicate multiplication, gives the
result of the conversion you have asked for.  The second line of output,
which is marked with a \%\(oq\f(CW/\fR\(cq to indicate division, gives the inverse
of the conversion factor.  If you convert 10 meters to feet,
\%\f(CWunits\fR will print
.PP
.EX
    * 32.808399
    / 0.03048
.EE
.PP
which tells you that 10 meters equals about 32.8 feet.
The second number gives the conversion in the opposite direction.
In this case, it tells you that 1 foot is equal to about
0.03 dekameters since the dekameter is 10 meters.
It also tells you that 1/32.8 is about 0.03.
.PP
The \%\f(CWunits\fR program prints the inverse because sometimes it is a
more convenient number.  In the example above, for example, the inverse
value is an exact conversion: a foot is exactly 0.03048 dekameters.
But the number given the other direction is inexact.
.PP
If you convert grains to pounds, you will see the following:
.PP
.EX
You have: grains
You want: pounds
        * 0.00014285714
        / 7000
.EE
.PP
   From the second line of the output you can immediately see that a grain
is equal to a seven thousandth of a pound.  This is not so obvious from
the first line of the output.
If you find  the output format  confusing, try using the
\%\(oq\f(CW-\&-verbose\fR\(cq option:
.PP
.EX
You have: grain
You want: aeginamina
        grain = 0.00010416667 aeginamina
        grain = (1 / 9600) aeginamina
.EE
.PP
If you request a conversion between units that measure reciprocal
dimensions, then \%\f(CWunits\fR will display the conversion results with an extra
note indicating that reciprocal conversion has been done:
.PP
.EX
You have: 6 ohms
You want: siemens
        reciprocal conversion
        * 0.16666667
        / 6
.EE
.PP
Reciprocal conversion can be suppressed by using the \%\(oq\f(CW-\&-strict\fR\(cq option.
As usual, use
the \%\(oq\f(CW-\&-verbose\fR\(cq option to get more comprehensible output:
.PP
.EX
You have: tex
You want: typp
        reciprocal conversion
        1 / tex = 496.05465 typp
        1 / tex = (1 / 0.0020159069) typp

You have: 20 mph
You want: sec/mile
        reciprocal conversion
        1 / 20 mph = 180 sec/mile
        1 / 20 mph = (1 / 0.0055555556) sec/mile
.EE
.PP
If you enter incompatible unit types, the \%\f(CWunits\fR program will
print a message indicating that the units are not conformable and
it will display the reduced form for each unit:
.PP
.EX
You have: ergs/hour
You want: fathoms kg^2 / day
conformability error
        2.7777778e-11 kg m^2 / sec^3
        2.1166667e-05 kg^2 m / sec
.EE
.PP
If you only want to find the reduced form or definition of a unit,
simply press \fIEnter\fP at the \%\(oq\f(CWYou\ want:\fR\(cq prompt.  Here is an
example:
.PP
.EX
You have: jansky
You want:
        Definition: fluxunit = 1e-26 W/m^2 Hz = 1e-26 kg / s^2
.EE
.PP
The output from \%\f(CWunits\fR indicates that the jansky is defined to be
equal to a fluxunit which in turn is defined to be a certain combination
of watts, meters, and hertz.  The fully reduced (and in this case
somewhat more cryptic) form appears on the far right.
.PP
Some named units are treated as dimensionless in some situations.
These units include the radian and steradian.  These units will be
treated as equal to 1 in units conversions.  Power is equal to torque
times angular velocity.  This conversion can only be performed if the
radian is dimensionless.
.PP
.EX
You have: (14 ft lbf) (12 radians/sec)
You want: watts
        * 227.77742
        / 0.0043902509
.EE
.PP
It is also possible to compute roots and other non-integer powers of
dimensionless units; this allows computations such as the altitude of
geosynchronous orbit:
.PP
.EX
You have: cuberoot(G earthmass / (circle/siderealday)^2) - earthradius
You want: miles
        * 22243.267
        / 4.4957425e-05
.EE
.PP
Named dimensionless units are not treated as dimensionless
in other contexts.  They cannot be used as exponents
so for example, \%\(oq\f(CWmeter^radian\fR\(cq is forbidden.
.PP
If you want a list of options you can type \%\f(CI?\fR at the
\%\(oq\f(CWYou\ want:\fR\(cq prompt.  The program will display a list of named
units that are conformable with the unit that you entered at the
\%\(oq\f(CWYou\ have:\fR\(cq prompt above.  Conformable unit \fIcombinations\fP
will not appear on this list.
.PP
Typing \%\f(CIhelp\fR at either prompt displays a short help message.
You can also type \%\f(CIhelp\fR followed by a unit name.  This will
invoke a pager on the units data base at the point where that unit
is defined.  You can read the definition and comments that may
give more details or historical information about the unit.  (You
can generally quit out of the page by pressing \%\(oq\f(CWq\fR\(cq.)
.PP
Typing \%\f(CIsearch\fR \fItext\fP will display a list of all of the units
whose names contain \fItext\fP as a substring along with their definitions.
This may help in the case where you aren't sure of the right unit name.
.PP
.SH USING \f(BIUNITS\fP NON-INTERACTIVELY
The \%\f(CWunits\fR program can perform units conversions non-interactively
from the command line.  To do this, type the command, type the original
unit expression, and type the new units you want.  If a units
expression contains non-alphanumeric characters, you may need to protect
it from interpretation by the shell using single or double quote
characters.
.PP
If you type
.PP
.EX
units "2 liters" quarts
.EE
.PP
then \%\f(CWunits\fR will print
.PP
.EX
    * 2.1133764
    / 0.47317647
.EE
.PP
and then exit.
The output tells you that 2 liters is about 2.1 quarts, or alternatively that
a quart is about 0.47 times 2 liters.
.PP
\%\f(CWunits\fR does not require a space between a numerical value and
the unit, so the previous example can be given as
.PP
.EX
units 2liters quarts
.EE
.PP
to avoid having to quote the first argument.
.PP
If the conversion is successful, \%\f(CWunits\fR will return success (zero)
to the calling environment.  If you enter  non-conformable
units, then \%\f(CWunits\fR will print a message giving the reduced form of
each unit and it will return failure (nonzero) to the calling environment.
.PP
If the \%\(oq\f(CW-\&-conformable\fR\(cq option is given, only one unit expression
is allowed, and \%\f(CWunits\fR will print all units conformable with
that expression; it is equivalent to giving \%\f(CI?\fR at the
\%\(oq\f(CWYou\ want:\fR\(cq prompt.  For example,
.PP
.EX
units --conformable gauss
B_FIELD   tesla
Gs        gauss
T         tesla
gauss     abvolt sec / cm^2
stT       stattesla
statT     stattesla
stattesla statWb/cm^2
tesla     Wb/m^2
.EE
.PP
If you give more than one unit expression with the
\%\(oq\f(CW-\&-conformable\fR\(cq option, the program will exit with an error
message and return failure.  This option has no effect in interactive
mode.
.PP
If the \%\(oq\f(CW-\&-terse\fR\(cq (\%\(oq\f(CW-t\fR\(cq) option is given with the
\%\(oq\f(CW-\&-conformable\fR\(cq option, conformable units are shown without
definitions; with the previous example, this would give
.PP
.EX
units --terse --conformable gauss
B_FIELD
Gs
T
gauss
stT
statT
stattesla
tesla
.EE
.PP
When the \%\(oq\f(CW-\&-conformable\fR\(cq option is not given and you invoke
\%\f(CWunits\fR with only one argument, \%\f(CWunits\fR will print the
definition of the specified unit.  It will return failure if the unit is
not defined and success if the unit is defined.
.PP
.SH UNIT DEFINITIONS
The conversion information is read from a units data file that
is called \%\(oq\f(CWdefinitions.units\fR\(cq and is usually located in
the \%\(oq\f(CW/usr/share/units\fR\(cq directory.
If you invoke \%\f(CWunits\fR with the \%\(oq\f(CW-V\fR\(cq option, it will print
the location of this file.
The default
file includes definitions for all familiar units, abbreviations and
metric prefixes.  It also includes many obscure or archaic units.
Many common spelled-out numbers (e.g., \%\(oq\f(CWseventeen\fR\(cq) are recognized.
.PP
Many constants of nature are defined, including these:
.PP
.EX
pi          \fRratio of circumference to diameter\fP
c           \fRspeed of light\fP
e           \fRcharge on an electron\fP
force       \fRacceleration of gravity\fP
mole        \fRAvogadro's number\fP
water       \fRpressure per unit height of water\fP
Hg          \fRpressure per unit height of mercury\fP
au          \fRastronomical unit\fP
k           \fRBoltzman's constant\fP
mu0         \fRpermeability of vacuum\fP
epsilon0    \fRpermittivity of vacuum\fP
G           \fRGravitational constant\fP
mach        \fRspeed of sound\fP
.EE
.PP
The standard data file includes atomic masses for all of the elements
and numerous other constants.  Also included are the densities of
various ingredients used in baking so that \%\(oq\f(CW2\ cups flour_sifted\fR\(cq
can be converted to \%\(oq\f(CWgrams\fR\(cq.  This is not an exhaustive list.
Consult the units data file to see the complete list, or to see the
definitions that are used.
.PP
The \%\(oq\f(CWpound\fR\(cq is a unit of mass.  To get force, multiply by the
force conversion unit \%\(oq\f(CWforce\fR\(cq or use the shorthand \%\(oq\f(CWlbf\fR\(cq.
(Note that \%\(oq\f(CWg\fR\(cq is already taken as the standard abbreviation for
the gram.)  The unit \%\(oq\f(CWounce\fR\(cq is also a unit of mass.  The fluid
ounce is \%\(oq\f(CWfluidounce\fR\(cq or \%\(oq\f(CWfloz\fR\(cq.  When British capacity
units differ from their US counterparts, such as the British Imperial
gallon, the unit is defined both ways with \%\(oq\f(CWbr\fR\(cq and \%\(oq\f(CWus\fR\(cq
prefixes.  Your locale settings will determine the value of the
unprefixed unit.  Currency is prefixed with its country
name: \%\(oq\f(CWbelgiumfranc\fR\(cq, \%\(oq\f(CWbritainpound\fR\(cq.
.PP
When searching for a unit, if the specified string does not appear
exactly as a unit name, then the \%\f(CWunits\fR program will try to
remove a trailing \%\(oq\f(CWs\fR\(cq, \%\(oq\f(CWes\fR\(cq.  Next units will replace a
trailing \%\(oq\f(CWies\fR\(cq with \%\(oq\f(CWy\fR\(cq.  If that fails,
\%\f(CWunits\fR will check for a prefix.  The database includes all
of the standard metric prefixes.  Only one prefix is permitted per
unit, so \%\(oq\f(CWmicromicrofarad\fR\(cq will fail.  However, prefixes can
appear alone with no unit following them, so
\%\(oq\f(CWmicro*microfarad\fR\(cq will work, as will \%\(oq\f(CWmicro microfarad\fR\(cq.
.PP
To find out which units and prefixes are available, read the standard
units data file, which is extensively annotated.
.PP
.SS English Customary Units
English customary units differ in various ways in different
regions.  In Britain a complex system of volume measurements featured
different gallons for different materials such as a wine gallon and
ale gallon that different by twenty percent.  This complexity was
swept away in 1824 by a reform that created an entirely new gallon,
the British Imperial gallon defined as the volume occupied by ten
pounds of water.  Meanwhile in the USA the gallon is derived from the
1707 Winchester wine gallon, which is 231 cubic inches.  These gallons
differ by about twenty percent.  By default if \%\f(CWunits\fR runs in
the \%\(oq\f(CWen_GB\fR\(cq locale you will get the British volume measures.  If
it runs in the \%\(oq\f(CWen_US\fR\(cq locale you will get the US volume
measures.  In other locales the default values are the US
definitions.  If you wish to force different definitions, then set the
environment variable \%\f(CWUNITS_ENGLISH\fR to either \%\(oq\f(CWUS\fR\(cq or
\%\(oq\f(CWGB\fR\(cq to set the desired definitions independent of the locale.
.PP
Before 1959, the value of a yard (and other units of measure defined in
terms of it) differed slightly among English-speaking countries.  In
1959, Australia, Canada, New Zealand, the United Kingdom, the United
States, and South Africa adopted the Canadian value of 1\ yard =
0.9144\ m (exactly), which was approximately halfway between the
values used by the UK and the US; it had the additional advantage of
making 1\ inch = 2.54\ cm (exactly).  This new standard was
termed the \fIInternational Yard\fP.  Australia, Canada, and the UK then
defined all customary lengths in terms of the International Yard
(Australia did not define the furlong or rod); because many US land
surveys were in terms of the pre-1959 units, the US continued to define
customary surveyors' units (furlong, chain, rod, and link) in terms of
the previous value for the foot, which was termed the
\fIUS survey foot\fP.  The US defined a \fIUS survey mile\fP as 5280 US
survey feet, and defined a \fIstatute mile\fP as a US survey mile.  The
US values for these units differ from the international values by about
2\ ppm.
.PP
The \%\f(CWunits\fR program uses the international values for these
units; the US values can be obtained by using either the \%\(oq\f(CWUS\fR\(cq or
the \%\(oq\f(CWsurvey\fR\(cq prefix.  In either case, the simple familiar
relationships among the units are maintained, e.g., 1 \%\(oq\f(CWfurlong\fR\(cq =
660 \%\(oq\f(CWft\fR\(cq, and 1 \%\(oq\f(CWUSfurlong\fR\(cq = 660 \%\(oq\f(CWUSft\fR\(cq, though the
metric equivalents differ slightly between the two cases.
The \%\(oq\f(CWUS\fR\(cq prefix or the \%\(oq\f(CWsurvey\fR\(cq prefix can also be used to
obtain the US survey mile and the value of the US yard prior to 1959,
e.g., \%\(oq\f(CWUSmile\fR\(cq or \%\(oq\f(CWsurveymile\fR\(cq (but \fInot\fP
\%\(oq\f(CWUSsurveymile\fR\(cq).  To get the US value of the statute mile, use
either \%\(oq\f(CWUSstatutemile\fR\(cq or \%\(oq\f(CWUSmile\fR\(cq.
.PP
Except for distances that extend over hundreds of miles (such as in the
US State Plane Coordinate System), the differences in the miles are
usually insignificant:
.PP
.EX
You have: 100 surveymile - 100 mile
You want: inch
        * 12.672025
        / 0.078913984
.EE
.PP
The pre-1959 UK values for these units can be obtained with the prefix
\%\(oq\f(CWUK\fR\(cq.
.PP
In the US, the acre is officially defined in terms of the US survey
foot, but \%\f(CWunits\fR uses a definition based on the international
foot.  If you want the official US acre use \%\(oq\f(CWUSacre\fR\(cq and
similarly use \%\(oq\f(CWUSacrefoot\fR\(cq for the official US version of that
unit.  The difference between these units is about 4 parts per million.
.PP
.SH UNIT EXPRESSIONS
.SS Operators
You can enter more complicated units by combining units with operations
such as multiplication, division, powers, addition, subtraction, and
parentheses for grouping.  You can use the customary symbols for these
operators when \%\f(CWunits\fR is invoked with its default options.
Additionally, \%\f(CWunits\fR supports some extensions, including high
priority multiplication using a space, and a high priority numerical
division operator (\%\(oq\f(CW|\fR\(cq) that can simplify some expressions.
.PP
You multiply units using a space or an asterisk (\%\(oq\f(CW*\fR\(cq).
The next example shows both forms:
.PP
.EX
You have: arabicfoot * arabictradepound * force
You want: ft lbf
        * 0.7296
        / 1.370614
.EE
.PP
You can divide units using the slash (\%\(oq\f(CW/\fR\(cq) or with \%\(oq\f(CWper\fR\(cq:
.PP
.EX
You have: furlongs per fortnight
You want: m/s
        * 0.00016630986
        / 6012.8727
.EE
.PP
You can use parentheses for grouping:
.PP
.EX
You have: (1/2) kg / (kg/meter)
You want: league
        * 0.00010356166
        / 9656.0833
.EE
.PP
White space surrounding operators is optional, so the previous example
could have used \%\(oq\f(CW(1/2)kg/(kg/meter)\fR\(cq.  As a consequence, however,
hyphenated spelled-out numbers (e.g., \%\(oq\f(CWforty-two\fR\(cq) cannot be used;
\%\(oq\f(CWforty-two\fR\(cq is interpreted as \%\(oq\f(CW40 - 2\fR\(cq.
.PP
Multiplication using a space has a higher precedence
than division using a slash and is evaluated left to right;
in effect, the first \%\(oq\f(CW/\fR\(cq character marks the beginning of the
denominator of a unit expression.
This makes it simple to enter a quotient with several terms in the
denominator: \%\(oq\f(CWJ\ /\ mol\ K\fR\(cq.
The \%\(oq\f(CW*\fR\(cq and \%\(oq\f(CW/\fR\(cq operators have the same precedence, and are
evaluated left to right; if you multiply with \%\(oq\f(CW*\fR\(cq, you must group
the terms in the denominator with parentheses: \%\(oq\f(CWJ\ /\ (mol\ *\ K)\fR\(cq.
.PP
The higher precedence of the space operator may not always be advantageous.
For example, \%\(oq\f(CWm/s\ s/day\fR\(cq is equivalent to
\%\(oq\f(CWm\ /\ s\ s\ day\fR\(cq and has dimensions of length per time cubed.
Similarly, \%\(oq\f(CW1/2\ meter\fR\(cq refers to a unit of reciprocal length
equivalent to 0.5/meter, perhaps not what you would intend if
you entered that expression.  The get a half meter you would need to
use parentheses: \%\(oq\f(CW(1/2)\ meter\fR\(cq.
The \%\(oq\f(CW*\fR\(cq operator is convenient for multiplying a sequence of
quotients.  For example, \%\(oq\f(CWm/s\ *\ s/day\fR\(cq is equivalent to
\%\(oq\f(CWm/day\fR\(cq.  Similarly, you could write \%\(oq\f(CW1/2\ *\ meter\fR\(cq to get
half a meter.
.PP
The \%\f(CWunits\fR program supports another option for numerical fractions:
you can indicate division of \fInumbers\fP with the vertical bar
(\%\(oq\f(CW|\fR\(cq), so if you wanted half a meter you could write
\%\(oq\f(CW1|2\ meter\fR\(cq.
You cannot use the vertical bar to indicate division of non-numerical
units (e.g., \%\(oq\f(CWm|s\fR\(cq results in an error message).
.PP
Powers of units can be specified using the \%\(oq\f(CW^\fR\(cq character, as shown in
the following example, or by simple concatenation of a unit and its
exponent: \%\(oq\f(CWcm3\fR\(cq is equivalent to \%\(oq\f(CWcm^3\fR\(cq;
if the exponent is more than one digit, the \%\(oq\f(CW^\fR\(cq is required.
You can also use \%\(oq\f(CW**\fR\(cq as an exponent operator.
.PP
.EX
You have: cm^3
You want: gallons
        * 0.00026417205
        / 3785.4118
.EE
.PP
Concatenation only works with a single unit name: if you write \%\(oq\f(CW(m/s)2\fR\(cq,
\%\f(CWunits\fR will treat it as multiplication by 2.
When a unit includes a prefix, exponent operators apply to the
combination, so \%\(oq\f(CWcentimeter3\fR\(cq gives cubic centimeters.  If you
separate the prefix from the unit with any multiplication operator (e.g.,
\%\(oq\f(CWcenti meter^3\fR\(cq), the prefix is treated as a separate unit, so
the exponent applies only to the unit without the prefix.  The second
example is equivalent to \%\(oq\f(CWcenti * (meter^3)\fR\(cq, and gives a hundredth
of a cubic meter, not a cubic centimeter.  The \%\f(CWunits\fR program
is limited internally to products of 99 units; accordingly, expressions
like \%\(oq\f(CWmeter^100\fR\(cq or \%\(oq\f(CWjoule^34\fR\(cq (represented internally as
\%\(oq\f(CWkg^34\ m^68\ /\ s^68\fR\(cq) will fail.
.PP
The \%\(oq\f(CW|\fR\(cq
operator has the highest precedence, so you can write the square root of
two thirds as \%\(oq\f(CW2|3^1|2\fR\(cq.
The \%\(oq\f(CW^\fR\(cq operator has the second highest precedence, and is
evaluated right to left, as usual:
.PP
.EX
You have: 5 * 2^3^2
You want:
        Definition: 2560
.EE
.PP
With a dimensionless base unit, any dimensionless exponent is meaningful
(e.g., \%\(oq\f(CWpi^exp(2.371)\fR\(cq).  Even though angle is sometimes treated as
dimensionless, exponents cannot have dimensions of angle:
.PP
.EX
You have: 2^radian
                 ^
Exponent not dimensionless
.EE
.PP
If the base unit is not dimensionless, the
exponent must be a rational number \fIp\fP/\fIq\fP, and the
dimension of the unit must be a power of \fIq\fP, so \%\(oq\f(CWgallon^2|3\fR\(cq
works but \%\(oq\f(CWacre^2|3\fR\(cq fails.  An exponent using the slash (\%\(oq\f(CW/\fR\(cq)
operator (e.g., \%\(oq\f(CWgallon^(2/3)\fR\(cq) is also acceptable; the parentheses
are needed because the precedence of \%\(oq\f(CW^\fR\(cq is higher than that of
\%\(oq\f(CW/\fR\(cq.  Since \%\f(CWunits\fR cannot represent dimensions with
exponents greater than 99, a fully reduced exponent must have
\fIq\fP\ <\ 100.  When raising a non-dimensionless unit to a power,
\%\f(CWunits\fR attempts to convert a decimal exponent to a rational
number with \fIq\fP\ <\ 100.  If this is not possible
\%\f(CWunits\fR displays an error message:
.PP
.EX
You have: ft^1.234
Base unit not dimensionless; rational exponent required
.EE
.PP
A decimal exponent must match its rational representation to machine
precision, so \%\(oq\f(CWacre^1.5\fR\(cq works but \%\(oq\f(CWgallon^0.666\fR\(cq does not.
.PP
.SS Sums and Differences of Units
You may sometimes want to add values of
different units that are outside the SI.
You may also wish to use \%\f(CWunits\fR as a
calculator that keeps track of units.  Sums of conformable units are written with
the \%\(oq\f(CW+\fR\(cq character, and differences with the \%\(oq\f(CW-\fR\(cq character.
.PP
.EX
You have: 2 hours + 23 minutes + 32 seconds
You want: seconds
        * 8612
        / 0.00011611705
.EE
.PP
.EX
You have: 12 ft + 3 in
You want: cm
        * 373.38
        / 0.0026782366
.EE
.PP
.EX
You have: 2 btu + 450 ft lbf
You want: btu
        * 2.5782804
        / 0.38785542
.EE
.PP
The expressions that are added or subtracted must reduce to identical
expressions in primitive units, or an error message will be displayed:
.PP
.EX
You have: 12 printerspoint - 4 heredium
                                      ^
Illegal sum of non-conformable units
.EE
.PP
As usual, the precedence for \%\(oq\f(CW+\fR\(cq and \%\(oq\f(CW-\fR\(cq is lower than that of
the other operators.
A fractional quantity such as 2\ 1/2 cups can be given as
\%\(oq\f(CW(2+1|2) cups\fR\(cq; the parentheses are necessary because
multiplication has higher precedence than addition.  If you omit the
parentheses, \%\f(CWunits\fR attempts to add \%\(oq\f(CW2\fR\(cq and
\%\(oq\f(CW1|2 cups\fR\(cq, and you get an error message:
.PP
.EX
You have: 2+1|2 cups
                   ^
Illegal sum or difference of non-conformable units
.EE
.PP
The expression could also be correctly written as \%\(oq\f(CW(2+1/2) cups\fR\(cq.
If you write \%\(oq\f(CW2\ 1|2 cups\fR\(cq the space is interpreted as
\fImultiplication\fP so the result is the same as \%\(oq\f(CW1 cup\fR\(cq.
.PP
The \%\(oq\f(CW+\fR\(cq and \%\(oq\f(CW-\fR\(cq characters sometimes appears in exponents like
\%\(oq\f(CW3.43e+8\fR\(cq.  This leads to an ambiguity in an expression like
\%\(oq\f(CW3e+2 yC\fR\(cq.  The unit \%\(oq\f(CWe\fR\(cq is a small unit of charge, so this
can be regarded as equivalent to \%\(oq\f(CW(3e+2) yC\fR\(cq or \%\(oq\f(CW(3 e)+(2 yC)\fR\(cq.
This ambiguity is resolved by always interpreting \%\(oq\f(CW+\fR\(cq and \%\(oq\f(CW-\fR\(cq as part
of an exponent if possible.
.PP
.SS Numbers as Units
For \%\f(CWunits\fR, numbers are just another kind of unit.  They can
appear as many times as you like and in any order in a unit expression.
For example, to find the volume of a box that is 2 ft by 3 ft by 12 ft
in steres, you could do the following:
.PP
.EX
You have: 2 ft 3 ft 12 ft
You want: stere
        * 2.038813
        / 0.49048148

You have: $ 5 / yard
You want: cents / inch
        * 13.888889
        / 0.072
.EE
.PP
And the second example shows how the dollar sign in the units conversion
can precede the five.  Be careful:  \%\f(CWunits\fR will interpret
\%\(oq\f(CW$5\fR\(cq with no space as equivalent to \%\(oq\f(CWdollar^5\fR\(cq.
.PP
.SS Built-in Functions
Several built-in functions are provided: \%\(oq\f(CWsin\fR\(cq, \%\(oq\f(CWcos\fR\(cq,
\%\(oq\f(CWtan\fR\(cq, \%\(oq\f(CWln\fR\(cq, \%\(oq\f(CWlog\fR\(cq, \%\(oq\f(CWexp\fR\(cq, \%\(oq\f(CWacos\fR\(cq,
\%\(oq\f(CWatan\fR\(cq, \%\(oq\f(CWasin\fR\(cq, \%\(oq\f(CWcosh\fR\(cq, \%\(oq\f(CWsinh\fR\(cq, \%\(oq\f(CWtanh\fR\(cq,
\%\(oq\f(CWacosh\fR\(cq, \%\(oq\f(CWasinh\fR\(cq, and \%\(oq\f(CWatanh\fR\(cq.
The \%\(oq\f(CWsin\fR\(cq, \%\(oq\f(CWcos\fR\(cq, and \%\(oq\f(CWtan\fR\(cq
functions require either a dimensionless argument or an argument with
dimensions of angle.  
.PP
.EX
You have: sin(30 degrees)
You want:
        Definition: 0.5

You have: sin(pi/2)
You want:
        Definition: 1

You have: sin(3 kg)
                  ^
Unit not dimensionless
.EE
.PP
The other functions on the list require dimensionless arguments.  The
inverse trigonometric functions return arguments with dimensions of
angle.
.PP
The \%\(oq\f(CWln\fR\(cq and \%\(oq\f(CWlog\fR\(cq functions give natural log and log base
10 respectively.  To obtain logs for any integer base, enter the
desired base immediately after \%\(oq\f(CWlog\fR\(cq.  For example, to get log
base 2 you would write \%\(oq\f(CWlog2\fR\(cq and to get log base 47 you could
write \%\(oq\f(CWlog47\fR\(cq.  
.PP
.EX
You have: log2(32)
You want: 
        Definition: 5
You have: log3(32)
You want: 
        Definition: 3.1546488
You have: log4(32)
You want: 
        Definition: 2.5
You have: log32(32)
You want: 
        Definition: 1
You have: log(32)
You want: 
        Definition: 1.50515
You have: log10(32)
You want: 
        Definition: 1.50515
.EE
.PP
If you wish to take roots of units, you may use the \%\(oq\f(CWsqrt\fR\(cq or
\%\(oq\f(CWcuberoot\fR\(cq functions.  These functions require that the argument
have the appropriate root.  You can obtain higher roots by using
fractional exponents:
.PP
.EX
You have: sqrt(acre)
You want: feet
        * 208.71074
        / 0.0047913202

You have: (400 W/m^2 / stefanboltzmann)^(1/4)
You have:
        Definition: 289.80882 K

You have: cuberoot(hectare)
                          ^
Unit not a root
.EE
.PP
.SS Previous Result
You can insert the result of the previous conversion using the
underscore (\%\(oq\f(CW_\fR\(cq).  It is useful when you want to
convert the same input to several different units, for example
.PP
.EX
You have: 2.3 tonrefrigeration
You want: btu/hr
        * 27600
        / 3.6231884e-005
You have: _
You want: kW
        * 8.0887615
        / 0.12362832
.EE
.PP
Suppose you want to do some deep frying that requires an oil depth of
2\ inches.  You have 1/2 gallon of oil, and want to know the
largest-diameter pan that will maintain the required depth.  The
nonlinear unit \%\(oq\f(CWcirclearea\fR\(cq gives the \fIradius\fP of the circle
(see \fIOther Nonlinear Units\fP, for a more detailed description) in SI
units; you want the \fIdiameter\fP in \fIinches\fP:
.PP
.EX
You have: 1|2 gallon / 2 in
You want: circlearea
        0.10890173 m
You have: 2 _
You want: in
        * 8.5749393
        / 0.1166189
.EE
.PP
In most cases, surrounding white space is optional, so the previous
example could have used \%\(oq\f(CW2_\fR\(cq.  If \%\(oq\f(CW_\fR\(cq follows a non-numerical
unit symbol, however, the space is required:
.PP
.EX
You have: m_
           ^
Parse error
.EE
.PP
When \%\(oq\f(CW_\fR\(cq is followed by a digit, the operation is multiplication
rather than exponentiation, so that \%\(oq\f(CW_2\fR\(cq, is equivalent to
\%\(oq\f(CW_\ *\ 2\fR\(cq rather than \%\(oq\f(CW_^2\fR\(cq.
.PP
You can use the \%\(oq\f(CW_\fR\(cq symbol any number of times; for example,
.PP
.EX
You have: m
You want:
        Definition: 1 m
You have: _ _
You want:
        Definition: 1 m^2
.EE
.PP
Using \%\(oq\f(CW_\fR\(cq before a conversion has been performed (e.g.,
immediately after invocation) generates an error:
.tr '\(aq
.PP
.EX
You have: _
          ^
No previous result; '_' not set
.EE
.tr '\(cq
.PP
Accordingly, \%\(oq\f(CW_\fR\(cq serves no purpose when \%\f(CWunits\fR is invoked
non-interactively.
.PP
If \%\f(CWunits\fR is invoked with the \%\(oq\f(CW-\&-verbose\fR\(cq option
(see \fIInvoking Units\fP), the value of \%\(oq\f(CW_\fR\(cq is not expanded:
.PP
.EX
You have: mile
You want: ft
        mile = 5280 ft
        mile = (1 / 0.00018939394) ft
You have: _
You want: m
        _ = 1609.344 m
        _ = (1 / 0.00062137119) m
.EE
.PP
You can give \%\(oq\f(CW_\fR\(cq at the \%\(oq\f(CWYou\ want:\fR\(cq prompt, but it
usually is not very useful.
.PP
.SS Complicated Unit Expressions
The \%\f(CWunits\fR program is especially helpful in ensuring accuracy
and dimensional consistency when converting lengthy unit expressions.
.if t .ig ++
For example, one form of the Darcy-Weisbach fluid-flow equation is
.RS 5n
.PP
Delta \fIP\fP = (8 / pi)^2 (\fIrho\fP \fIfLQ\fP^2) / \fId\fP^5,
.RE
.PP
where Delta \fIP\fP is the pressure drop, \fIrho\fP is the mass density,
\fIf\fP is the (dimensionless) friction factor, \fIL\fP is the length
of the pipe, \fIQ\fP is the volumetric flow rate, and \fId\fP
is the pipe diameter.
It might be desired to have the equation in the form
.RS 5n
.PP
Delta \fIP\fP = A1 \fIrho\fP \fIfLQ\fP^2 / \fId\fP^5
.RE
.PP
.++
.if n .ig ++
.EQ
delim $$
.EN
For example, one form of the Darcy\-Weisbach fluid-flow equation is
.RS 5n
.PP
.EQ
DELTA P = 8 over pi sup 2 rho fL Q sup 2 over d sup 5 ,
.EN
.RE
.PP
where $DELTA P$ is the pressure drop, $rho$ is the mass density,
$f$ is the (dimensionless) friction factor, $L$ is the length
of the pipe, $Q$ is the volumetric flow rate, and $d$
is the pipe diameter.
It might be desired to have the equation in the form
.RS 5n
.PP
.EQ
DELTA P = A sub 1 rho fL Q sup 2 over d sup 5
.EN
.RE
.PP
.EQ
delim off
.EN
.++
.PP
that accepted the user's normal units; for typical units used in the US,
the required conversion could be something like
.PP
.EX
You have: (8/pi^2)(lbm/ft^3)ft(ft^3/s)^2(1/in^5)
You want: psi
        * 43.533969
        / 0.022970568
.EE
.PP
The parentheses allow individual terms in the expression to be entered naturally,
as they might be read from the formula.  Alternatively, the
multiplication could be done with the \%\(oq\f(CW*\fR\(cq rather than a space;
then parentheses are needed only around \%\(oq\f(CWft^3/s\fR\(cq because of its
exponent:
.PP
.EX
You have: 8/pi^2 * lbm/ft^3 * ft * (ft^3/s)^2 /in^5
You want: psi
        * 43.533969
        / 0.022970568
.EE
.PP
Without parentheses, and using spaces for multiplication, the previous
conversion would need to be entered as
.PP
.EX
You have: 8 lb ft ft^3 ft^3 / pi^2 ft^3 s^2 in^5
You want: psi
        * 43.533969
        / 0.022970568
.EE
.PP
.SS Backwards Compatibility: \%\(oq\f(CW*\fR\(cq and \%\(oq\f(CW-\fR\(cq
The original \%\f(CWunits\fR assigned multiplication a higher
precedence than division using the slash.  This differs from the
usual precedence rules, which give multiplication and division equal
precedence, and can be confusing for people who think
of units as a calculator.
.PP
The star operator (\%\(oq\f(CW*\fR\(cq) included in this \%\f(CWunits\fR program
has, by default, the same precedence as division,
and hence follows the usual precedence rules.  For backwards
compatibility you can invoke \%\f(CWunits\fR
with the \%\(oq\f(CW-\&-oldstar\fR\(cq
option.  Then \%\(oq\f(CW*\fR\(cq has a higher precedence than
division, and the same precedence as multiplication using the space.
.PP
Historically, the hyphen (\%\(oq\f(CW-\fR\(cq) has been used in technical
publications to indicate products of units, and the original
\%\f(CWunits\fR program treated it as a multiplication operator.
Because \%\f(CWunits\fR provides
several other ways to obtain unit products, and because \%\(oq\f(CW-\fR\(cq is a
subtraction operator in general algebraic expressions, \%\f(CWunits\fR
treats the binary \%\(oq\f(CW-\fR\(cq as a subtraction operator by default.
For backwards compatibility use the \%\(oq\f(CW-\&-product\fR\(cq option, which
causes \%\f(CWunits\fR to treat the binary \%\(oq\f(CW-\fR\(cq operator as a
product operator.  When \%\(oq\f(CW-\fR\(cq is a multiplication operator
it has the same precedence as multiplication with a space, giving it a
higher precedence than division.
.PP
When \%\(oq\f(CW-\fR\(cq is used as a unary operator it negates its operand.
Regardless of the \%\f(CWunits\fR options, if
\%\(oq\f(CW-\fR\(cq appears after \%\(oq\f(CW(\fR\(cq or after
\%\(oq\f(CW+\fR\(cq, then it will act as a negation operator.  So you can always compute 20
degrees minus 12 minutes by entering \%\(oq\f(CW20\ degrees + -12\ arcmin\fR\(cq.
You must use this construction when you define new units because you
cannot know what options will be in force when your definition is
processed.
.PP
.SH NONLINEAR UNIT CONVERSIONS
Nonlinear units are represented using functional notation.  They make
possible nonlinear unit conversions such as temperature.
.PP
.SS Temperature Conversions
Conversions between temperatures are different from linear conversions
between temperature \fIincrements\fP\(emsee the example below.  The
absolute temperature conversions are handled by units starting with
\%\(oq\f(CWtemp\fR\(cq, and you must use functional notation.
The temperature-increment conversions are done using units starting
with \%\(oq\f(CWdeg\fR\(cq and they do not require functional notation.
.PP
.EX
You have: tempF(45)
You want: tempC
        7.2222222

You have: 45 degF
You want: degC
        * 25
        / 0.04
.EE
.PP
Think of \%\(oq\f(CWtempF(\fIx\fP)\fR\(cq not as a function but as a notation that
indicates that \fIx\fP should have units of \%\(oq\f(CWtempF\fR\(cq attached to
it.  See \fIDefining Nonlinear Units\fP.  The first conversion shows that if it's 45
degrees Fahrenheit outside, it's 7.2 degrees Celsius.  The second
conversion indicates that a change of 45 degrees Fahrenheit corresponds
to a change of 25 degrees Celsius.  The conversion from
\%\(oq\f(CWtempF(\fIx\fP)\fR\(cq is to absolute temperature, so that
.PP
.EX
You have: tempF(45)
You want: degR
        * 504.67
        / 0.0019814929
.EE
.PP
gives the same result as
.PP
.EX
You have: tempF(45)
You want: tempR
        * 504.67
        / 0.0019814929
.EE
.PP
But if you convert \%\(oq\f(CWtempF(\fIx\fP)\fR\(cq to \%\(oq\f(CWdegC\fR\(cq, the output is
probably not what you expect:
.PP
.EX
You have: tempF(45)
You want: degC
        * 280.37222
        / 0.0035666871
.EE
.PP
The result is the temperature in K, because \%\(oq\f(CWdegC\fR\(cq is defined as
\%\(oq\f(CWK\fR\(cq, the Kelvin. For consistent results, use the \%\(oq\f(CWtemp\fIX\fP\fR\(cq units
when converting to a temperature rather than converting a temperature
increment.
.PP
The \%\(oq\f(CWtempC()\fR\(cq and \%\(oq\f(CWtempF()\fR\(cq definitions are limited to
positive absolute temperatures, and giving a value that would result in
a negative absolute temperature generates an error message:
.PP
.EX
You have: tempC(-275)
                    ^
Argument of function outside domain
.EE
.PP
.SS Other Nonlinear Units
Some other examples of nonlinear units are numerous different ring
sizes and wire gauges, the grit sizes used for abrasives, the decibel
scale, shoe size, scales for the density of sugar (e.g., baume).
The standard data file also supplies units for computing the area of a
circle and the volume of a sphere.  See the standard units data file
for more details.
Wire gauges
with multiple zeroes are signified using negative numbers where two
zeroes is \%\(oq\f(CW-1\fR\(cq.  Alternatively, you can use the synonyms \%\(oq\f(CWg00\fR\(cq,
\%\(oq\f(CWg000\fR\(cq, and so on that are defined in the standard units data file.
.PP
.EX
You have: wiregauge(11)
You want: inches
        * 0.090742002
        / 11.020255

You have: brwiregauge(g00)
You want: inches
        * 0.348
        / 2.8735632

You have: 1 mm
You want: wiregauge
        18.201919

You have: grit_P(600)
You want: grit_ansicoated
        342.76923
.EE
.PP
The last example shows the conversion from P graded sand paper,
which is the European standard and may be marked \(lqP600\(rq on the back,
to the USA standard.
.PP
You can compute the area of a circle using the nonlinear unit,
\%\(oq\f(CWcirclearea\fR\(cq.  You can also do this using the circularinch or
circleinch.  The next example shows two ways to compute the area of a
circle with a five inch radius and one way to compute the volume of a
sphere with a radius of one meter.
.PP
.EX
You have: circlearea(5 in)
You want: in2
        * 78.539816
        / 0.012732395

You have: 10^2 circleinch
You want: in2
        * 78.539816
        / 0.012732395

You have: spherevol(meter)
You want: ft3
        * 147.92573
        / 0.0067601492
.EE
.PP
The inverse of a nonlinear conversion is indicated by prefixing a tilde
(\%\(oq\f(CW~\fR\(cq) to the nonlinear unit name:
.PP
.EX
You have: ~wiregauge(0.090742002 inches)
You want:
        Definition: 11
.EE
.PP
You can give a nonlinear unit definition without an argument or
parentheses, and press \fIEnter\fP at the \%\(oq\f(CWYou\ want:\fR\(cq prompt to
get the definition of a nonlinear unit; if the definition is not valid
for all real numbers, the range of validity is also given.  If the
definition requires specific units this information is also
displayed:
.PP
.EX
You have: tempC
        Definition: tempC(x) = x K + stdtemp
                    defined for x >= -273.15
You have: ~tempC
        Definition: ~tempC(tempC) = (tempC +(-stdtemp))/K
                    defined for tempC >= 0 K
You have: circlearea
        Definition: circlearea(r) = pi r^2
                    r has units m
.EE
.PP
To see the definition of the inverse use the \%\(oq\f(CW~\fR\(cq notation.  In
this case the parameter in the functional definition will
usually be the name of the unit.  Note that the inverse for
\%\(oq\f(CWtempC\fR\(cq shows that it requires units of \%\(oq\f(CWK\fR\(cq in the
specification of the allowed range of values.  
Nonlinear unit conversions are described in more detail in
\fIDefining Nonlinear Units\fP.
.PP
.SH UNIT LISTS: CONVERSION TO SUMS OF UNITS
Outside of the SI, it is sometimes desirable to convert a single
unit to a sum of units\(emfor example, feet to feet plus inches.
The conversion \fIfrom\fP sums of units was described in
\fISums and Differences of Units\fP, and is a simple matter of adding
the units with the \%\(oq\f(CW+\fR\(cq sign:
.PP
.EX
You have: 12 ft + 3 in + 3|8 in
You want: ft
        * 12.28125
        / 0.081424936
.EE
.PP
Although you can similarly write a sum of units to convert \fIto\fP,
the result will not be the conversion to the units in the sum, but
rather the conversion to the particular sum that you have entered:
.PP
.EX
You have: 12.28125 ft
You want: ft + in + 1|8 in
        * 11.228571
        / 0.089058524
.EE
.PP
The unit expression given at the \%\(oq\f(CWYou\ want:\fR\(cq prompt is
equivalent to asking for conversion to multiples of
\%\(oq\f(CW1\ ft + 1\ in + 1|8\ in\fR\(cq, which is 1.09375 ft, so the
conversion in the previous example is equivalent to
.PP
.EX
You have: 12.28125 ft
You want: 1.09375 ft
        * 11.228571
        / 0.089058524
.EE
.PP
In converting to a sum of units like miles, feet and inches, you
typically want the largest integral value for the first unit, followed
by the largest integral value for the next, and the remainder converted
to the last unit.
You can do this conversion easily with \%\f(CWunits\fR using a special
syntax for lists of units.  You must list the desired units in order
from largest to smallest, separated by the semicolon (\%\(oq\f(CW;\fR\(cq)
character:
.PP
.EX
You have: 12.28125 ft
You want: ft;in;1|8 in
        12 ft + 3 in + 3|8 in
.EE
.PP
The conversion always gives integer coefficients on the units in the
list, except possibly the last unit when the conversion is not exact:
.PP
.EX
You have: 12.28126 ft
You want: ft;in;1|8 in
        12 ft + 3 in + 3.00096 * 1|8 in
.EE
.PP
The order in which you list the units is important:
.PP
.EX
You have: 3 kg
You want: oz;lb
        105 oz + 0.051367866 lb

You have: 3 kg
You want: lb;oz
        6 lb + 9.8218858 oz
.EE
.PP
Listing ounces before pounds produces a technically correct result,
but not a very useful one.  You must list the units in descending
order of size in order to get the most useful result.
.PP
Ending a unit list with the separator \%\(oq\f(CW;\fR\(cq
has the same effect as repeating the last
unit on the list, so \%\(oq\f(CWft;in;1|8 in;\fR\(cq is equivalent to
\%\(oq\f(CWft;in;1|8 in;1|8 in\fR\(cq.  With the example above, this gives
.PP
.EX
You have: 12.28126 ft
You want: ft;in;1|8 in;
        12 ft + 3 in + 3|8 in + 0.00096 * 1|8 in
.EE
.PP
in effect separating the integer and fractional parts of the
coefficient for the last unit.  If you instead
prefer to round the last coefficient to an integer
you can do this with the \%\(oq\f(CW-\&-round\fR\(cq (\%\(oq\f(CW-r\fR\(cq) option.
With the previous example, the result is
.PP
.EX
You have: 12.28126 ft
You want: ft;in;1|8 in
        12 ft + 3 in + 3|8 in (rounded down to nearest 1|8 in)
.EE
.PP
When you use the \%\(oq\f(CW-r\fR\(cq option, repeating the last unit on the
list has no effect (e.g., \%\(oq\f(CWft;in;1|8 in;1|8 in\fR\(cq is equivalent to
\%\(oq\f(CWft;in;1|8 in\fR\(cq), and hence neither does ending a list with a
\%\(oq\f(CW;\fR\(cq.  With a single unit and the \%\(oq\f(CW-r\fR\(cq option, a terminal \%\(oq\f(CW;\fR\(cq
\fIdoes\fP have an effect: it causes \%\f(CWunits\fR to treat the
single unit as a list and produce a rounded value for the single unit.
Without the extra \%\(oq\f(CW;\fR\(cq, the \%\(oq\f(CW-r\fR\(cq option has no effect on
single unit conversions.  This example shows the output using the
\%\(oq\f(CW-r\fR\(cq option:
.PP
.EX
You have: 12.28126 ft
You want: in
        * 147.37512
        / 0.0067854058

You have: 12.28126 ft
You want: in;
        147 in (rounded down to nearest in)
.EE
.PP
Each unit that appears in the list must be conformable with the first
unit on the list, and of course the listed units must also be
conformable with the unit that you enter at the \%\(oq\f(CWYou\ have:\fR\(cq
prompt.
.PP
.EX
You have: meter
You want: ft;kg
             ^
conformability error
        ft = 0.3048 m
        kg = 1 kg

You have: meter
You want: lb;oz
conformability error
        1 m
        0.45359237 kg
.EE
.PP
In the first case, \%\f(CWunits\fR reports the disagreement between
units appearing on the list.  In the second case, \%\f(CWunits\fR
reports disagreement between the unit you entered and the desired
conversion.  This conformability error is based on the first
unit on the unit list.
.PP
Other common candidates for conversion to sums of units are
angles and time:
.PP
.EX
You have: 23.437754 deg
You want; deg;arcmin;arcsec
    23 deg + 26 arcmin + 15.9144 arcsec

You have: 7.2319 hr
You want: hr;min;sec
    7 hr + 13 min + 54.84 sec
.EE
.PP
In North America, recipes for cooking typically measure ingredients by
volume, and use units that are not always convenient multiples of each
other.  Suppose that you have a recipe for 6 and you wish to make a
portion for 1.  If the recipe calls for 2\ 1/2 cups of an
ingredient, you might wish to know the measurements in terms of
measuring devices you have available, you could use \%\f(CWunits\fR and
enter
.PP
.EX
You have: (2+1|2) cup / 6
You want: cup;1|2 cup;1|3 cup;1|4 cup;tbsp;tsp;1|2 tsp;1|4 tsp
        1|3 cup + 1 tbsp + 1 tsp
.EE
.PP
By default, if a unit in a list begins with fraction of the form
1|\fIx\fP and its multiplier is an integer, the fraction is given as
the product of the multiplier and the numerator; for example,
.PP
.EX
You have: 12.28125 ft
You want: ft;in;1|8 in;
        12 ft + 3 in + 3|8 in
.EE
.PP
In many cases, such as the example above, this is what is wanted, but
sometimes it is not.  For example, a cooking recipe for 6 might call
for 5\ 1/4 cup of an ingredient, but you want a portion for 2, and
your 1-cup measure is not available; you might try
.PP
.EX
You have: (5+1|4) cup / 3
You want: 1|2 cup;1|3 cup;1|4 cup
        3|2 cup + 1|4 cup
.EE
.PP
This result might be fine for a baker who has a 1\ 1/2-cup measure
(and recognizes the equivalence), but it may not be as useful to
someone with more limited set of measures, who does want to do
additional calculations, and only wants to know \(lqHow many 1/2-cup
measures to I need to add?\(rq  After all, that's what was actually
asked.  With the \%\(oq\f(CW-\&-show-factor\fR\(cq option, the factor will not be
combined with a unity numerator, so that you get
.PP
.EX
You have: (5+1|4) cup / 3
You want: 1|2 cup;1|3 cup;1|4 cup
        3 * 1|2 cup + 1|4 cup
.EE
.PP
A user-specified fractional unit with a numerator other than 1 is never
overridden, however\(emif a unit list specifies \%\(oq\f(CW3|4 cup;1|2 cup\fR\(cq,
a result equivalent to 1\ 1/2 cups will always be shown as
\%\(oq\f(CW2 * 3|4\ cup\fR\(cq whether or not the \%\(oq\f(CW-\&-show-factor\fR\(cq option
is given.
.PP
Some applications for unit lists may be less obvious.  Suppose that you
have a postal scale and wish to ensure that it's accurate at 1\ oz,
but have only metric calibration weights.  You might try
.PP
.EX
You have: 1 oz
You want: 100 g;50 g; 20 g;10 g;5 g;2 g;1 g;
        20 g + 5 g + 2 g + 1 g + 0.34952312 * 1 g
.EE
.PP
You might then place one each of the 20\ g, 5\ g, 2\ g, and
1\ g weights on the scale and hope that it indicates close to
.PP
.EX
You have: 20 g + 5 g + 2 g + 1 g
You want: oz;
        0.98767093 oz
.EE
.PP
Appending \%\(oq\f(CW;\fR\(cq to \%\(oq\f(CWoz\fR\(cq forces a one-line display that includes
the unit; here the integer part of the result is zero, so it is not
displayed.
.PP
A unit list such as
.PP
.EX
cup;1|2\ cup;1|3\ cup;1|4\ cup;tbsp;tsp;1|2\ tsp;1|4\ tsp
.EE
.PP
can be tedious to enter.  The \%\f(CWunits\fR program provides shorthand names
for some common combinations:
.PP
.EX
hms         \fRhours, minutes, seconds\fP
dms         \fRangle: degrees, minutes, seconds\fP
time        \fRyears, days, hours, minutes and seconds\fP
usvol       \fRUS cooking volume: cups and smaller\fP
.EE
.PP
Using these shorthands, or \fIunit list aliases\fP,
you can do the following conversions:
.PP
.EX
You have: anomalisticyear
You want: time
        1 year + 25 min + 3.4653216 sec
You have: 1|6 cup
You want: usvol
        2 tbsp + 2 tsp
.EE
.PP
You cannot combine a unit list alias with other units: it must appear
alone at the \%\(oq\f(CWYou\ want:\fR\(cq prompt.
.PP
You can display the definition of a unit list alias by entering it at
the \%\(oq\f(CWYou\ have:\fR\(cq prompt:
.PP
.EX
You have: dms
        Definition: unit list, deg;arcmin;arcsec
.EE
.PP
When you specify compact output with \%\(oq\f(CW-\&-compact\fR\(cq,
\%\(oq\f(CW-\&-terse\fR\(cq or \%\(oq\f(CW-t\fR\(cq and perform conversion to a unit list,
\%\f(CWunits\fR lists the conversion factors for each unit in the
list, separated by semicolons.  
.PP
.EX
You have: year
You want: day;min;sec
365;348;45.974678
.EE
.PP
Unlike the case of regular
output, zeros \fIare\fP included in this output list:
.PP
.EX
You have: liter
You want: cup;1|2 cup;1|4 cup;tbsp
4;0;0;3.6280454
.EE
.PP
.SH ALTERNATIVE UNIT SYSTEMS
.SS CGS Units
The SI\(eman extension of the MKS (meter\(enkilogram\(ensecond) system\(emhas
largely supplanted the older CGS (centimeter\(engram\(ensecond) system, but
CGS units are still used in a few specialized fields, especially in
physics where they lead to a more elegant formulation of Maxwell's equations.
Conversions between SI and CGS involving mechanical units are
straightforward, involving powers of 10 (e.g., 1\ m\ =\ 100\ cm).
Conversions involving electromagnetic units are more complicated, and
\%\f(CWunits\fR supports four different systems of CGS units: 
electrostatic units (ESU), electromagnetic units (EMU), the
Gaussian system and the Heaviside\(enLorentz system. 
The differences between these systems
arise from different choices made for proportionality
constants in electromagnetic equations.
Coulomb's law gives electrostatic force between two
charges separated by a distance
.EQ
delim $$
.EN
.if n \fIr\fP:
.if t $r$:
.RS 5n
.PP
.if n \fIF\fP = \fIk\fP_C \fIq\fP_1\ \fIq\fP_2\ /\ \fIr\fP^2.
.if t \{
.EQ
F = k sub roman C { q sub 1 q sub 2} over r sup 2.
.EN
.\}
.RE
.PP
.PP
Ampere's law gives the electromagnetic force per unit length
between two current-carrying conductors separated by a distance
.if n \fIr\fP:
.if t $r$:
.RS 5n
.PP
.if n \fIF\fP/\fIl\fP = 2 \fIk\fP_A \fII\fP_1\ \fII\fP_2\ /\ \fIr\fP.
.if t \{
.EQ
F over l = 2 k sub roman A { I sub 1 I sub 2 } over r .
.EN
.\}
.RE
.PP
.PP
The two constants,
.if n \fIk\fP_C and \fIk\fP_A,
.if t $k sub roman C$ and $k sub roman A$,
are related by the square of the speed of light:
.if n \fIk\fP_A\ =\ \fIk\fP_C\ /\ \fIc\fP^2.
.if t $k sub roman A = k sub roman C / c sup 2$.
.PP
In the SI, the constants have dimensions, and an additional base unit,
the ampere, measures electric current.  The CGS systems do not define
new base units, but express charge and current as derived units in
terms of mass, length, and time.  In the ESU system, the constant for
Coulomb's law is chosen to be unity and dimensionless, which defines
the unit of charge.  In the EMU system, the constant for Ampere's law
is chosen to be unity and dimensionless, which defines a unit of
current.  The Gaussian system usually uses the ESU units for charge
and current; it chooses another constant so that the units for the
electric and magnetic fields are the same.  The Heaviside\(enLorentz
system is \(lqrationalized\(rq so that factors of
.if n 4{pi}
.if t 4\(*p
do not appear in
Maxwell's equations.  The SI system is similarly rationalized, but the
other CGS systems are not.  In the Heaviside\(enLorentz (HLU) system the
factor of
.if n 4{pi}
.if t 4\(*p
appears in Coulomb's law instead; this system differs
from the Gaussian system by factors of
.if n the square root of 4{pi}
.if t \(sr\o'\[sqrtex]4'\o'\[sqrtex]\(*p'\^.
.PP
The dimensions of electrical quantities in the various CGS systems are
different from the SI dimensions for the same units;
strictly, conversions between these systems and SI are not possible.
But units in different systems relate to the same physical quantities,
so there is a \fIcorrespondence\fP between these units.
The \%\f(CWunits\fR program defines the units so that you can convert
between corresponding units in the various systems.  
.PP
The CGS definitions involve
.if n cm^(1/2) and g^(1/2),
.if t cm$"" sup {1/2}$ and g$"" sup {1/2}$,
which is problematic because \%\f(CWunits\fR does not normally support
fractional roots of base units.  The \%\(oq\f(CW-\&-units\fR\(cq (\%\(oq\f(CW-u\fR\(cq)
option allows selection of a CGS unit system and works around this
restriction by introducing base units for the square roots of length
and mass: \%\(oq\f(CWsqrt_cm\fR\(cq and \%\(oq\f(CWsqrt_g\fR\(cq.  The centimeter then
becomes \%\(oq\f(CWsqrt_cm^2\fR\(cq and the gram, \%\(oq\f(CWsqrt_g^2\fR\(cq.  This allows
working from equations using the units in the CGS system, and
enforcing dimensional conformity within that system.  Recognized CGS
arguments to the \%\(oq\f(CW-\&-units\fR\(cq option are \%\(oq\f(CWgauss[ian]\fR\(cq,
\%\(oq\f(CWesu\fR\(cq, \%\(oq\f(CWemu\fR\(cq, \%\(oq\f(CWlhu\fR\(cq; the argument is case insensitive.
You can also give \%\(oq\f(CWsi\fR\(cq which just enforces the default SI mode
and displays \%\(oq\f(CW(SI)\fR\(cq at the \%\(oq\f(CWYou\ have:\fR\(cq prompt to
emphasize the units mode.  Some other types of units are also
supported as described below.  Giving an unrecognized system generates
a warning, and \%\f(CWunits\fR uses SI units.
.PP
The changes resulting from the \%\(oq\f(CW-\&-units\fR\(cq option are actually
controlled by the \%\f(CWUNITS_SYSTEM\fR environment variable.  If you
frequently work with one of the supported CGS units systems, you may set
this environment variable rather than giving the \%\(oq\f(CW-\&-units\fR\(cq option
at each invocation.  As usual, an option given on the command line
overrides the setting of the environment variable. For example, if you would
normally work with Gaussian units but might occasionally work with
SI, you could set \%\f(CWUNITS_SYSTEM\fR to \%\(oq\f(CWgaussian\fR\(cq and specify
SI with the \%\(oq\f(CW-\&-units\fR\(cq option.
Unlike the argument to the \%\(oq\f(CW-\&-units\fR\(cq option, the value of
\%\f(CWUNITS_SYSTEM\fR \fIis\fP case sensitive, so setting a value of
\%\(oq\f(CWEMU\fR\(cq will have no effect other than to give an error message and
set SI units.
.PP
The CGS definitions appear as conditional settings in the standard
units data file, which you can consult for more information on how
these units are defined, or on how to define an alternate units system.
.PP
The ESU system derives the electromagnetic units from its unit of
charge, the statcoulomb,
which is defined from 
Coulomb's law.  The statcoulomb equals
.if n dyne^(1/2)\ cm, or cm^(3/2)\ g^(1/2)\ s^(\(mi1).
.if t $roman dyne sup {1/2} ^ roman cm$,
.if t or $roman cm sup {3/2} ^ roman g sup {1/2} ^ roman s sup {-1}$.
The unit of current, the statampere, is statcoulomb\ sec, analogous to
the relationship in SI.  Other electrical units are then derived in a
manner similar to that for SI units; the units use the SI names prefixed
by \%\(oq\f(CWstat-\fR\(cq, e.g., \%\(oq\f(CWstatvolt\fR\(cq or \%\(oq\f(CWstatV\fR\(cq.  The prefix
\%\(oq\f(CWst-\fR\(cq is also recognized (e.g., \%\(oq\f(CWstV\fR\(cq).
.PP
The EMU system derives the electromagnetic units from its unit of current,
the abampere, which is defined in terms of Ampere's law.  The abampere
is equal to 
.if n dyne^(1/2), or cm^(1/2)\ g^(1/2)\ s^(\(mi1).
.if t $roman dyne sup {1/2}$,
.if t or $roman cm sup {1/2} ^ roman g sup {1/2} ^ roman s sup{-1}$.
.EQ
delim off
.EN
The unit of charge, the abcoulomb, is
abampere\ sec, again analogous to the SI relationship.
Other electrical units are then derived in a
manner similar to that for SI units; the units use the SI names prefixed
by \%\(oq\f(CWab-\fR\(cq, e.g., \%\(oq\f(CWabvolt\fR\(cq or \%\(oq\f(CWabV\fR\(cq.  The magnetic field
units include the gauss, the oersted and the maxwell. 
.PP
The Gaussian units system, which was also known as the Symmetric
System,
uses the same charge and current units as the ESU system (e.g.,
\%\(oq\f(CWstatC\fR\(cq, \%\(oq\f(CWstatA\fR\(cq); it differs by defining the magnetic field
so that it has the same units as the electric field.  The resulting
magnetic field units are the same ones used in the EMU system: the
gauss, the oersted and the maxwell.
.PP
The Heaviside\(enLorentz system appears to lack named units.  We define
five basic units, \%\(oq\f(CWhlu_charge\fR\(cq, \%\(oq\f(CWhlu_current\fR\(cq, \%\(oq\f(CWhlu_volt\fR\(cq, \%\(oq\f(CWhlu_efield\fR\(cq and
\%\(oq\f(CWhlu_bfield\fR\(cq for conversions with this system.  It is important to
remember that with all of the CGS systems, the units may look the same
but mean something different.  The HLU system and Gaussian systems
both measure magnetic field using the same CGS dimensions, but the
amount of magnetic field with the same units is different in the two
systems.  
.PP
The CGS systems define units that measure the same thing but may have
conflicting dimensions.  Furthermore, the dimensions of the
electromagnetic CGS units are never compatible with SI.
But if you measure charge in two different systems you have measured the
same physical thing, so there is a \fIcorrespondence\fP between the
units in the different systems, and \%\f(CWunits\fR supports conversions
between corresponding units.  When running with SI, \%\f(CWunits\fR
defines all of the CGS units in terms of SI.  When you select a CGS
system, \%\f(CWunits\fR defines the SI units and the other CGS system
units in terms of the system you have selected.
.PP
.EX
(Gaussian) You have: statA
           You want: abA
        * 3.335641e-11
        / 2.9979246e+10
(Gaussian) You have: abA
           You want: sqrt(dyne)
conformability error
        2.9979246e+10 sqrt_cm^3 sqrt_g / s^2
        1 sqrt_cm sqrt_g / s
.EE
.PP
In the above example, \%\f(CWunits\fR converts between the current
units statA and abA even though the abA, from the EMU system, has
incompatible dimensions.  This works because in Gaussian mode, the abA
is defined in terms of the statA, so it does not have the correct
definition for EMU; consequently, you cannot convert the abA to its EMU
definition.
.PP
One challenge of conversion is that because
the CGS system has fewer base units, quantities that have different
dimensions in SI may have the same dimension in a CGS system.  And
yet, they may not have the same conversion factor.  For example, the
unit for the E field and B fields are the same in the
Gaussian system, but the conversion factors to SI are quite
different.  This means that correct conversion is only possible if you
keep track of what quantity is being measured.  You cannot convert
statV/cm to SI without indicating which type of field the unit
measures.  To aid in dimensional analysis, \%\f(CWunits\fR defines
various dimension units such as LENGTH, TIME, and CHARGE to be the
appropriate dimension in SI.  The
electromagnetic dimensions such as B_FIELD or E_FIELD may be useful
aids both for conversion and dimensional analysis in CGS.  You
can convert them to or from CGS in order to perform SI conversions
that in some cases will not work directly due to dimensional incompatibilities.
This example shows how the Gaussian system uses the same units for all
of the fields, but they all have different conversion factors with
SI. 
.PP
.EX
(Gaussian) You have: statV/cm
           You want: E_FIELD
        * 29979.246
        / 3.335641e-05
(Gaussian) You have: statV/cm
           You want: B_FIELD
        * 0.0001
        / 10000
(Gaussian) You have: statV/cm
           You want: H_FIELD
        * 79.577472
        / 0.012566371
(Gaussian) You have: statV/cm
           You want: D_FIELD
        * 2.6544187e-07
        / 3767303.1
.EE
.PP
The next example shows that the oersted cannot be converted directly
to the SI unit of magnetic field, A/m, because the dimensions
conflict.  We cannot redefine the ampere to make this work because
then it would not convert with the statampere.  But you can still do
this conversion as shown below.
.PP
.EX
(Gaussian) You have: oersted
           You want: A/m
conformability error
        1 sqrt_g / s sqrt_cm
        29979246 sqrt_cm sqrt_g / s^2
(Gaussian) You have: oersted
           You want: H_FIELD
        * 79.577472
        / 0.012566371
.EE
.PP
.SS Natural Units
Like the CGS units, \(lqnatural\(rq units are an alternative to the SI
system used primarily physicists in different fields, with different
systems tailored to different fields of study.  These
systems are \(lqnatural\(rq because the base measurements are defined
using physical constants instead of arbitrary values such as the meter
or second.  In different branches of physics, different physical constants
are more fundamental, which has given rise to a variety of incompatible natural
unit systems.
.PP
The supported systems are the \(lqnatural\(rq units (which seem to have no
better name) used in high energy physics and cosmology, the Planck
units, often used my scientists working with gravity, and the Hartree
atomic units are favored by those working in physical chemistry and
condensed matter physics.  
.PP
You can select the various natural units using the \%\(oq\f(CW-\&-units\fR\(cq
option in the same way that you select the CGS units.  The \(lqnatural\(rq
units come in two types, a rationalized system derived from the
Heaviside\(enLorentz units and an unrationalized system derived from the
Gaussian system.  You can select these using \%\(oq\f(CWnatural\fR\(cq and
\%\(oq\f(CWnatural-gauss\fR\(cq respectively.  For conversions in SI mode,
several unit names starting with \%\(oq\f(CWnatural\fR\(cq are available.
This \(lqnatural\(rq system is defined by setting
.if n {hbar},
.if t \[hbar],
c and the Boltzman
constant to 1.  Only a single base unit remains: the electron volt.  
.PP
The Planck units exist in a variety of forms, and \%\f(CWunits\fR
supports two.  Both supported forms are rationalized, in that factors
of
.if n 4{pi}
.if t 4\(*p
do not appear in Maxwell's equations.  However, Planck units
can also differ based on how the gravitational constant is treated.
This system is similar to the natural units in that c,
.if n {hbar},
.if t \[hbar],
and
Boltzman's constant are set to 1, but in this system, Newton's
gravitational constant,
\fIG\fP
is also fixed.  In the \(lqreduced\(rq Planck
system,
.EQ
delim $$
.EN
.if n 8{pi}\fIG\fP\ =\ 1
.if t $8 pi G = 1$
whereas in the unreduced system
.if n \fIG\fP\ =\ 1.
.if t $G = 1$.
The reduced system eliminates factors of
.if n 8{pi}
.if t 8\(*p
.EQ
delim off
.EN
from the Einstein field equations for gravitation, so this is similar to
the process of forming rationalized units to simplify Maxwell's equations.
To obtain the unreduced system use the name \%\(oq\f(CWplanck\fR\(cq and for the
reduced Planck units, \%\(oq\f(CWplanck-red\fR\(cq.  Units such as
\%\(oq\f(CWplanckenergy\fR\(cq and \%\(oq\f(CWplanckenergy_red\fR\(cq enable you to convert
the unreduced and reduced Planck energy unit in SI mode between the
various systems.  In Planck units, all measurements are
dimensionless.  
.PP
The final natural unit system is the Hartree atomic units.  Like the
Planck units, all measurements in the Hartree units are dimensionless,
but this system is defined by defined from completely different
physical constants: the electron mass, Planck's constant, the electron
charge, and the Coulomb constant are the defining physical
quantities, which are all set to unity.  To invoke this system with
the \%\(oq\f(CW-\&-units\fR\(cq option use the name \%\(oq\f(CWhartree\fR\(cq.  
.PP
.SS Prompt Prefix
If a unit system is specified with the \%\(oq\f(CW-\&-units\fR\(cq option, the
selected system's name is prepended to the \%\(oq\f(CWYou\ have:\fR\(cq prompt
as a reminder, e.g.,
.PP
.EX
(Gaussian) You have: stC
           You want:
        Definition: statcoulomb = sqrt(dyne) cm = 1 sqrt_cm^3 sqrt_g / s
.EE
.PP
You can suppressed the prefix by including a line
.PP
.EX
!prompt
.EE
.PP
with no argument in a site or personal units data file.  The prompt can
be conditionally suppressed by including such a line within
\%\(oq\f(CW!var\fR\(cq ... \%\(oq\f(CW!endvar\fR\(cq constructs, e.g.,
.PP
.EX
!var UNITS_SYSTEM gaussian gauss
!prompt
!endvar
.EE
.PP
This might be appropriate if you normally use Gaussian units and find
the prefix distracting but want to be reminded when you have selected a
different CGS system.
.PP
.SH LOGGING CALCULATIONS
The \%\(oq\f(CW-\&-log\fR\(cq option allows you to save the results of calculations
in a file; this can be useful if you need a permanent record of your
work.  For example, the fluid-flow conversion in
\fIComplicated Unit Expressions\fP, is lengthy, and if you were to use
it in designing a piping system, you might want a record of it for the
project file.  If the interactive session
.PP
.EX
# Conversion factor A1 for pressure drop
# dP = A1 rho f L Q^2/d^5
You have: (8/pi^2) (lbm/ft^3)ft(ft^3/s)^2(1/in^5) # Input units
You want: psi
        * 43.533969
        / 0.022970568
.EE
.PP
were logged, the log file would contain
.PP
.EX
### Log started Fri Oct 02 15:55:35 2015

# Conversion factor A1 for pressure drop
# dP = A1 rho f L Q^2/d^5
From: (8/pi^2) (lbm/ft^3)ft(ft^3/s)^2(1/in^5)   # Input units
To:   psi
        * 43.533969
        / 0.022970568
.EE
.PP
The time is written to the log file when the file is opened.
.PP
The use of comments can help clarify the meaning of calculations for
the log.  
The log includes conformability errors between the units at the
\%\(oq\f(CWYou\ have:\fR\(cq and \%\(oq\f(CWYou\ want:\fR\(cq prompts, but not other
errors, including lack of conformability of items in sums or differences
or among items in a unit list.  For example, a conversion between zenith
angle and elevation angle could involve
.PP
.EX
You have: 90 deg - (5 deg + 22 min + 9 sec)
                                   ^
Illegal sum or difference of non-conformable units
You have: 90 deg - (5 deg + 22 arcmin + 9 arcsec)
You want: dms
        84 deg + 37 arcmin + 51 arcsec
You have: _
You want: deg
        * 84.630833
        / 0.011816024
You have:
.EE
.PP
The log file would contain
.PP
.EX
From: 90 deg - (5 deg + 22 arcmin + 9 arcsec)
To:   deg;arcmin;arcsec
        84 deg + 37 arcmin + 51 arcsec
From: _
To:   deg
        * 84.630833
        / 0.011816024
.EE
.PP
The initial entry error (forgetting that minutes have dimension of time,
and that arcminutes must be used for dimensions of angle) does not
appear in the output.  When converting to a unit list alias,
\%\f(CWunits\fR expands the alias in the log file.
.PP
The \%\(oq\f(CWFrom:\fR\(cq and \%\(oq\f(CWTo:\fR\(cq tags are written to the log file even if
the \%\(oq\f(CW-\&-quiet\fR\(cq option is given.  If the log file exists when
\%\f(CWunits\fR is invoked, the new results are appended to the log file.
The time is written to the log file each time the file is opened.
The \%\(oq\f(CW-\&-log\fR\(cq option is ignored when \%\f(CWunits\fR is used
non-interactively.
.PP
.SH INVOKING \f(BIUNITS\fP
You invoke \%\f(CWunits\fR like this:
.PP
.EX
units [\fIoptions\fP] [\fIfrom-unit\fP [\fIto-unit\fP]]
.EE
.PP
If the \fIfrom-unit\fP and \fIto-unit\fP are omitted, the program
will use interactive prompts to determine which conversions to perform.
See \fIInteractive Use\fP.
If both \fIfrom-unit\fP and \fIto-unit\fP are given, \%\f(CWunits\fR will
print the result of that single conversion and then exit.
If only \fIfrom-unit\fP appears on the command line, \%\f(CWunits\fR will
display the definition of that unit and exit.
Units specified on the command line may need
to be quoted to protect them from shell interpretation and to group
them into two arguments.  Note also that the \%\(oq\f(CW-\&-quiet\fR\(cq option
is enabled by default if you specify \fIfrom-unit\fP on the command line.  
See \fICommand Line Use\fP.
.PP
The default behavior of \%\f(CWunits\fR can be changed by various
options given on the command line.  In most cases, the options may be
given in either short form (a single \%\(oq\f(CW-\fR\(cq followed by a single
character)
or long form (\%\(oq\f(CW--\fR\(cq followed by a word or hyphen-separated words).
Short-form options are cryptic but require
less typing; long-form options require more typing but are more
explanatory and may be more mnemonic.  With long-form options you need
only enter sufficient characters to uniquely identify the option to
the program.  For example, \%\(oq\f(CW--out\ %f\fR\(cq works, but
\%\(oq\f(CW--o\ %f\fR\(cq fails because \%\f(CWunits\fR has other long options
beginning with \%\(oq\f(CWo\fR\(cq.  However, \%\(oq\f(CW--q\fR\(cq works because
\%\(oq\f(CW--quiet\fR\(cq is the only long option beginning with \%\(oq\f(CWq\fR\(cq.
.PP
Some options require
arguments to specify a value (e.g., \%\(oq\f(CW-d\ 12\fR\(cq or
\%\(oq\f(CW--digits\ 12\fR\(cq).  Short-form options that do not take
arguments may be concatenated (e.g., \%\(oq\f(CW-erS\fR\(cq is equivalent to
\%\(oq\f(CW-e\ -r\ -S\fR\(cq); the last option in such a list may be one
that takes an argument (e.g., \%\(oq\f(CW-ed\ 12\fR\(cq).  With short-form
options, the space between an option and its argument is optional (e.g.,
\%\(oq\f(CW-d12\fR\(cq is equivalent to \%\(oq\f(CW-d\ 12\fR\(cq).  Long-form options may
not be concatenated, and the space between a long-form option and its
argument is required.  Short-form and long-form options may be
intermixed on the command line.  Options may be given in any order, but
when incompatible options (e.g., \%\(oq\f(CW-\&-output-format\fR\(cq and
\%\(oq\f(CW-\&-exponential\fR\(cq) are given in combination, behavior is controlled
by the last option given.  For example, \%\(oq\f(CW-o%.12f\ -e\fR\(cq gives
exponential format with the default eight significant digits).
.PP
The following options are available:
.TP
.BR "\-\^c" ", " "\-\^\-\^check"
Check that all units and prefixes defined in the units data file reduce
to primitive units.  Print a list of all units that
cannot be reduced.  Also display some other diagnostics about
suspicious definitions in the units data file.  Only definitions active
in the current locale are checked.  You should always run
\%\f(CWunits\fR with this option after modifying a units data file.
.TP
.BR "\-\^\\-\^check-verbose" ", " "\-\^\-\^verbose-check"
Like the \%\(oq\f(CW-\&-check\fR\(cq option, this option prints a list of units that
cannot be reduced.  But to help find unit  definitions that cause
endless loops,
it lists the units as they are checked.
If \%\f(CWunits\fR hangs, then the last unit to be printed has a bad
definition.  Only definitions active in the current locale are checked.
.TP
.BR "\-\^d \fIndigits\fP" ", " "\-\^\-\^digits \fIndigits\fP"
Set the number of significant digits in the output to the value
specified (which must be greater than zero).  For example,
\%\(oq\f(CW-d\ 12\fR\(cq sets the number of significant digits to 12.
With exponential output \%\f(CWunits\fR displays one digit to the left
of the decimal
point
and eleven digits to the right of the decimal point.
On most systems, the maximum number of internally meaningful digits is
15; if you specify a greater number than your system's maximum, \%\f(CWunits\fR
will print a warning and set the number to the largest meaningful
value.  To directly set the maximum value, give an argument
of \%\f(CWmax\fR (e.g., \%\(oq\f(CW-d\ max\fR\(cq).  Be aware, of course, that
\(lqsignificant\(rq here refers only to the \fIdisplay\fP of numbers; if
results depend on physical constants not known to this precision, the
physically meaningful precision may be less than that shown.  The
\%\(oq\f(CW-\&-digits\fR\(cq option conflicts with the \%\(oq\f(CW-\&-output-format\fR\(cq
option.
.TP
.BR "\-\^e" ", " "\-\^\-\^exponential"
Set the numeric output format to exponential (i.e., scientific
notation), like that used in the Unix \%\f(CWunits\fR program.
The default precision is eight significant digits (seven digits to the
right of the decimal point); this can be changed with the
\%\(oq\f(CW-\&-digits\fR\(cq option.  The \%\(oq\f(CW-\&-exponential\fR\(cq
option conflicts with the \%\(oq\f(CW-\&-output-format\fR\(cq option.
.TP
.BR "\-\^o \fIformat\fP" ", " "\-\^\-\^output-format \fIformat\fP"
This option affords complete control over the numeric output format
using the specified \fIformat\fP. The format is a single floating
point numeric format for the \%\f(CWprintf()\fR function in the
C programming language.  All compilers support the format types \%\(oq\f(CWg\fR\(cq
and \%\(oq\f(CWG\fR\(cq to specify significant digits, \%\(oq\f(CWe\fR\(cq and \%\(oq\f(CWE\fR\(cq for
scientific notation, and \%\(oq\f(CWf\fR\(cq for fixed-point decimal.
The ISO C99 standard introduced the \%\(oq\f(CWF\fR\(cq type for fixed-point
decimal and the \%\(oq\f(CWa\fR\(cq and \%\(oq\f(CWA\fR\(cq types for hexadecimal
floating point; these types are allowed with compilers that support
them.  The default format is \%\(oq\f(CW%.8g\fR\(cq; for greater precision, you
could specify \%\(oq\f(CW-o\ %.15g\fR\(cq. See \fINumeric Output Format\fP and
the documentation for \%\f(CWprintf()\fR for more detailed descriptions of the
format specification.  The \%\(oq\f(CW-\&-output-format\fR\(cq option affords the
greatest control of the output appearance, but requires at least
rudimentary knowledge of the \%\f(CWprintf()\fR format syntax.  If you
don't want to bother with the \%\f(CWprintf()\fR syntax, you can specify
greater precision more simply with the \%\(oq\f(CW-\&-digits\fR\(cq option or
select exponential format with \%\(oq\f(CW-\&-exponential\fR\(cq.  The
\%\(oq\f(CW-\&-output-format\fR\(cq option is incompatible with the
\%\(oq\f(CW-\&-exponential\fR\(cq and \%\(oq\f(CW-\&-digits\fR\(cq options.
.TP
.BR "\-\^f \fIfilename\fP" ", " "\-\^\-\^file \fIfilename\fP"
Instruct \%\f(CWunits\fR to load the units file \fIfilename\fP.  You
can specify up to 25 units files on the command line.  When you use
this option, \%\f(CWunits\fR will load \fIonly\fP the files you list
on the command line; it will not load the standard file or your
personal units file unless you explicitly list them.  If \fIfilename\fP
is the empty string (\%\(oq\f(CW-f\ ""\fR\(cq), the default units file (or that
specified by \%\f(CWUNITSFILE\fR) will be loaded in addition to any others
specified with \%\(oq\f(CW-f\fR\(cq.
.TP
.BR "\-\^L \fIlogfile\fP" ", " "\-\^\-\^log \fIlogfile\fP"
Save the results of calculations in the file \fIlogfile\fP; this can be
useful if it is important to have a record of unit conversions or other
calculations that are to be used extensively or in a critical activity
such as a program or design project.  If \fIlogfile\fP exits, the new
results are appended to the file.
This option is ignored when \%\f(CWunits\fR is used non-interactively.
See \fILogging Calculations\fP for a more detailed description and some
examples.
.TP
.BR "\-\^H \fIfilename\fP" ", " "\-\^\-\^history \fIfilename\fP"
Instruct \%\f(CWunits\fR to save history to \fIfilename\fP, so that a
record of your commands is available for retrieval across different
\%\f(CWunits\fR invocations.  To prevent the history from being saved
set \fIfilename\fP to the empty string (\%\(oq\f(CW-H\ ""\fR\(cq).  This
option has no effect if readline is not available.  
.TP
.BR "\-\^h" ", " "\-\^\-\^help"
Print out a summary of the options for \%\f(CWunits\fR.
.TP
.BR "\-\^m" ", " "\-\^\-\^minus"
Causes \%\(oq\f(CW-\fR\(cq to be interpreted as a subtraction operator.  This is
the default behavior.
.TP
.BR "\-\^p" ", " "\-\^\-\^product"
Causes \%\(oq\f(CW-\fR\(cq to be interpreted as a multiplication operator when it
has two operands.  It will act as a negation operator when it has only one
operand: \%\(oq\f(CW(-3)\fR\(cq.  By default \%\(oq\f(CW-\fR\(cq is treated as a
subtraction operator.
.TP
.BR "\-\^\\-\^oldstar"
Causes \%\(oq\f(CW*\fR\(cq to have the old-style precedence, higher than the
precedence of division so that \%\(oq\f(CW1/2*3\fR\(cq will equal \%\(oq\f(CW1/6\fR\(cq.
.TP
.BR "\-\^\\-\^newstar"
Forces \%\(oq\f(CW*\fR\(cq to have the new (default) precedence that follows
the usual rules of algebra: the precedence of \%\(oq\f(CW*\fR\(cq is the same as
the precedence of \%\(oq\f(CW/\fR\(cq, so that \%\(oq\f(CW1/2*3\fR\(cq will equal \%\(oq\f(CW3/2\fR\(cq.
.TP
.BR "\-\^r" ", " "\-\^\-\^round"
When converting to a combination of units given by a unit list, round
the value of the last unit in the list to the nearest integer.
.TP
.BR "\-\^S" ", " "\-\^\-\^show-factor"
When converting to a combination of units specified in a list,
always show a non-unity factor before a unit that
begins with a fraction with a unity denominator.  By default, if the
unit in a list begins with fraction of the form 1|\fIx\fP and
its multiplier is an integer other than 1, the fraction is given as the
product of the multiplier and the numerator (e.g., \%\(oq\f(CW3|8\ in\fR\(cq
rather than \%\(oq\f(CW3 * 1|8\ in\fR\(cq).  In some cases, this is not what is
wanted; for example, the results for a cooking recipe might show
\%\(oq\f(CW3 * 1|2\ cup\fR\(cq as \%\(oq\f(CW3|2\ cup\fR\(cq.
With the \%\(oq\f(CW-\&-show-factor\fR\(cq option, a
result equivalent to 1.5 cups will display as \%\(oq\f(CW3 * 1|2\ cup\fR\(cq
rather than \%\(oq\f(CW3|2\ cup\fR\(cq.  A user-specified fractional unit with
a numerator other than 1 is never overridden, however\(emif a unit list
specifies \%\(oq\f(CW3|4 cup;1|2 cup\fR\(cq, a result equivalent to 1\ 1/2 cups
will always be shown as \%\(oq\f(CW2 * 3|4\ cup\fR\(cq whether or not the
\%\(oq\f(CW-\&-show-factor\fR\(cq option is given.
.TP
.BR "\-\^\\-\^conformable"
In non-interactive mode, show all units conformable with the original
unit expression.  Only one unit expression is allowed; if you give more
than one, \%\f(CWunits\fR will exit with an error message and return
failure.
.TP
.BR "\-\^v" ", " "\-\^\-\^verbose"
Give slightly more verbose output when converting units.  When combined
with the \%\(oq\f(CW-c\fR\(cq option this gives the same effect as
\%\(oq\f(CW-\&-check-verbose\fR\(cq.  When combined with \%\(oq\f(CW-\&-version\fR\(cq
produces a more detailed output, equivalent to the \%\(oq\f(CW-\&-info\fR\(cq
option.  
.TP
.BR "\-\^V" ", " "\-\^\-\^version"
Print the program version number, tell whether the \%\f(CWreadline\fR
library has been included, tell whether UTF-8 support has been included;
give the locale, the location of the default units data file, and the
location of the personal units data file; indicate if the personal units
data file does not exist.
.IP
When given in combination with the \%\(oq\f(CW-\&-terse\fR\(cq option, the program
prints only the version number and exits.
.IP
When given in combination with the \%\(oq\f(CW-\&-verbose\fR\(cq option, the
program, the \%\(oq\f(CW-\&-version\fR\(cq option has the same effect as the
\%\(oq\f(CW-\&-info\fR\(cq option below.
.TP
.BR "\-\^I" ", " "\-\^\-\^info"
Print the information given with the \%\(oq\f(CW-\&-version\fR\(cq option, show the
pathname of the units program, show the status of the \%\f(CWUNITSFILE\fR
and \%\f(CWMYUNITSFILE\fR environment variables, and additional information
about how \%\f(CWunits\fR locates the related files.  On systems running
Microsoft Windows, the status of the \%\f(CWUNITSLOCALE\fR environment
variable and information about the related locale map are also given.
This option is usually of interest only to developers and
administrators, but it can sometimes be useful for troubleshooting.
.IP
Combining the \%\(oq\f(CW-\&-version\fR\(cq and \%\(oq\f(CW-\&-verbose\fR\(cq options has the
same effect as giving \%\(oq\f(CW-\&-info\fR\(cq.
.TP
.BR "\-\^U" ", " "\-\^\-\^unitsfile"
Print the location of the default units data file and exit; if the file
cannot be found, print \(lqUnits data file not found\(rq.
.TP
.BR "\-\^u (gauss[ian]|esu|emu)" ", " "\-\^\-\^units (gauss[ian]|esu|emu)"
Specify a CGS units system: Gaussian, ESU, or EMU.
.TP
.BR "\-\^l \fIlocale\fP" ", " "\-\^\-\^locale \fIlocale\fP"
Force a specified locale such as \%\(oq\f(CWen_GB\fR\(cq to get British
definitions by default.  This overrides the locale determined from
system settings or environment variables.
See \fILocale\fP for a description of locale format.
.TP
.BR "\-\^n" ", " "\-\^\-\^nolists"
Disable conversion to unit lists.
.TP
.BR "\-\^s" ", " "\-\^\-\^strict"
Suppress conversion of units to their reciprocal units.  For
example, \%\f(CWunits\fR will normally convert hertz to seconds
because these units are reciprocals of each other.  The strict option
requires that units be strictly conformable to perform a conversion, and
will give an error if you attempt to convert hertz to seconds.
.TP
.BR "\-\^1" ", " "\-\^\-\^one-line"
Give only one line of output (the forward conversion); do not print
the reverse conversion.  If a reciprocal conversion is
performed, then \%\f(CWunits\fR will still print the \(lqreciprocal
conversion\(rq line.
.TP
.BR "\-\^t" ", " "\-\^\-\^terse"
Print only a single conversion factor.  This option can be used when
calling \%\f(CWunits\fR from another program so that the output is easy to
parse.  This option has the combined
effect of these options:  \%\(oq\f(CW-\&-strict\fR\(cq \%\(oq\f(CW-\&-quiet\fR\(cq \%\(oq\f(CW-\&-one-line\fR\(cq
\%\(oq\f(CW-\&-compact\fR\(cq.  When combined with \%\(oq\f(CW-\&-version\fR\(cq it produces
a display showing only the program name and version number.  
.TP
.BR "\-\^\\-\^compact"
Give compact output featuring only the conversion factor; the
multiplication and division signs are not shown, and there is no leading
whitespace.  If you convert to a unit list, then the output is a
semicolon separated list of factors.  
This turns off the \%\(oq\f(CW-\&-verbose\fR\(cq option.
.TP
.BR "\-\^q" ", " "\-\^\-\^quiet" ", " "\-\^\-\^silent"
Suppress the display of statistics about the number of units loaded,
any messages printed by the units database, 
and the prompting of the user for units.  This option does not
affect how \%\f(CWunits\fR displays the results.  This option is
turned on by default if you invoke \%\f(CWunits\fR with a unit
expression on the command line.  
.IP
.SH SCRIPTING WITH \f(BIUNITS\fP
Despite its numerous options, \%\f(CWunits\fR cannot cover every
conceivable unit-conversion task.
For example, suppose we have found some mysterious scale, but cannot
figure out the units in which it is reporting.  We reach into our
pocket, place a 3.75-gram coin on the scale, and observe the scale
reading \%\(oq\f(CW0.120\fR\(cq.  How do we quickly determine the units?  Or we
might wonder if a unit has any \(lqsynonyms,\(rq i.e., other units with the
same value.
.PP
The capabilities of \%\f(CWunits\fR are easily extended with simple
scripting.  Both questions above involve conformable units; on a system
with Unix-like utilities, conversions to conformable units could be
shown accomplished with the following script:
.tr '\(aq
.if n .tr `\`
.PP
.EX
#!/bin/sh

progname=`basename $0 .sh`
umsg="Usage: $progname [<number>] unit"

if [ $# -lt 1 ]
then
    echo "$progname: missing quantity to convert"
    echo "$umsg"
    exit 1
fi

for unit in `units --conformable "$*" | cut -f 1 -d ' '`
do
    echo "$*"   # have -- quantity to convert
    echo $unit  # want -- conformable unit
done | units --terse --verbose
.EE
.ie .if '*[.T]'utf8' .tr `\(oq
.el .if n .tr `'
.tr '\(cq
.tr '\(cq
.PP
When \%\f(CWunits\fR is invoked with no non-option arguments, it reads
\fIhave\fP/\fIwant\fP pairs, on alternating lines, from its standard
input, so the task can be accomplished with only two invocations of
\%\f(CWunits\fR.  This avoids the computational overhead of needlessly
reprocessing the units database for each conformable unit, as well as
the inherent system overhead of process invocation.
.PP
By itself, the script is not very useful.  But it could be used in
combination with other commands to address specific tasks.  For example,
running the script through a simple output filter could help solve the
scale problem above.  If the script is named \%\f(CWconformable\fR,
running
.PP
.EX
$ conformable 3.75g | grep 0.120
.EE
.PP
gives
.EX
        3.75g = 0.1205653 apounce
        3.75g = 0.1205653 fineounce
        3.75g = 0.1205653 ozt
        3.75g = 0.1205653 tradewukiyeh
        3.75g = 0.1205653 troyounce
.EE
.PP
So we might conclude that the scale is calibrated in troy ounces.
.PP
We might run
.EX
$ units --verbose are
        Definition: 100 m^2 = 100 m^2
.EE
.PP
and wonder if \%\(oq\f(CWare\fR\(cq has any synonyms, value.  To find out, we could
run
.PP
.EX
$ conformable are | grep "= 1 "
        are = 1 a
        are = 1 are
.EE
.PP
.SH OUTPUT STYLES
The output can be tweaked in various ways using command line options.
With no options, the output looks like this
.PP
.EX
$ units
Currency exchange rates from FloatRates (USD base) on 2019-02-20 
3070 units, 109 prefixes, 109 nonlinear units

You have: 23ft
You want: m
        * 7.0104
        / 0.14264521
You have: m
You want: ft;in
        3 ft + 3.3700787 in
.EE
.PP
This is arguably a bit cryptic; the \%\(oq\f(CW-\&-verbose\fR\(cq
option makes clear what the output means:
.PP
.EX
$ units --verbose
Currency exchange rates from FloatRates (USD base) on 2019-02-20 
3070 units, 109 prefixes, 109 nonlinear units

You have: 23 ft
You want: m
        23 ft = 7.0104 m
        23 ft = (1 / 0.14264521) m
You have: meter
You want: ft;in
        meter = 3 ft + 3.3700787 in
.EE
.PP
The \%\(oq\f(CW-\&-quiet\fR\(cq option suppresses the clutter displayed when
\%\f(CWunits\fR starts, as well as the prompts to the user.
This option is enabled by default when you
give units on the command line.  
.PP
.EX
$ units --quiet  
23 ft
m
        * 7.0104
        / 0.14264521
        
$ units 23ft m 
        * 7.0104
        / 0.14264521
.EE
.PP
The remaining style options allow you to display only numerical values
without the tab or the multiplication and division signs, or to display just a
single line showing the forward conversion:
.tr '\(aq
.PP
.EX
$ units --compact 23ft m
7.0104
0.14264521

$ units --compact m 'ft;in'
3;3.3700787

$ units --one-line 23ft m
        * 7.0104

$ units --one-line 23ft 1/m
        reciprocal conversion
        * 0.14264521
        
$ units --one-line 23ft kg
conformability error
        7.0104 m
        1 kg
.EE
.PP
Note that when converting to a unit list, the \%\(oq\f(CW-\&-compact\fR\(cq
option displays a semicolon separated list of results.  Also be aware
that the
\%\(oq\f(CWone-line\fR\(cq option doesn't live up to its name if you
execute a reciprocal conversion or if you get a conformability error.
The former case can be prevented using the \%\(oq\f(CW-\&-strict\fR\(cq option,
which suppresses reciprocal conversions.  
Similarly you can suppress unit list conversion using
\%\(oq\f(CW-\&-nolists\fR\(cq.
It is impossible to prevent
the three line error output.  
.PP
.EX
$ units --compact --nolists m 'ft;in' 
Error in 'ft;in': Parse error

$ units --one-line --strict 23ft 1/m
.EE
.PP
The various style options can be combined appropriately.  The ultimate
combination is the \%\(oq\f(CW-\&-terse\fR\(cq option, which combines 
\%\(oq\f(CW-\&-strict\fR\(cq, \%\(oq\f(CW-\&-quiet\fR\(cq, \%\(oq\f(CW-\&-one-line\fR\(cq,
and \%\(oq\f(CW-\&-compact\fR\(cq to produce the minimal output,
just a single number for regular conversions and a semicolon
separated list for conversion to unit lists.  This will likely be the
best choice for programs that want to call \%\f(CWunits\fR and then
process its result.
.PP
.EX
$ units --terse 23ft m
7.0104

$ units --terse m 'ft;in'
3;3.3700787

$ units --terse 23ft 1/m
conformability error
7.0104 m
1 / m
.EE
.tr '\(cq
.PP
.SH ADDING YOUR OWN DEFINITIONS
.SS Units Data Files
The units and prefixes that \%\f(CWunits\fR can convert are
defined in the units
data file, typically \%\(oq\f(CW/usr/share/units/definitions.units\fR\(cq.
If you can't find this file, run \%\f(CWunits\ --version\fR to get
information on the file locations for your installation.  Although you
can extend or modify this data file if you have appropriate user
privileges, it's usually better to put extensions in separate files so
that the definitions will be preserved if you update \%\f(CWunits\fR.
.PP
You can include additional data files in the units database using
the \%\(oq\f(CW!include\fR\(cq command in the standard units data file. For
example
.PP
.EX
!include    /usr/local/share/units/local.units
.EE
.PP
might be appropriate for a site-wide supplemental data file.
The location of the \%\(oq\f(CW!include\fR\(cq statement in the standard units
data file is important; later definitions replace earlier ones,
so any definitions in an included file will override definitions before
the \%\(oq\f(CW!include\fR\(cq statement in the standard units data file.
With normal invocation, no warning is given about redefinitions; to
ensure that you don't have an unintended redefinition, run
\%\f(CWunits\ -c\fR after making changes to any units data file.
.PP
If you want to add your own units in addition to or in place of
standard or site-wide supplemental units data files, you can include
them in the \%\(oq\f(CW.units\fR\(cq file in your home directory.  If this
file exists it is read after the standard units data file, so that any
definitions in this file will replace definitions of the same units in
the standard data file or in files included from the standard data
file.  This file will not be read if any units files are specified on
the command line.  (Under Windows the personal units file is
named \%\(oq\f(CWunitdef.units\fR\(cq.)  Running \%\f(CWunits\ -V\fR will
display the location and name of your personal units file.
.PP
The \%\f(CWunits\fR program first tries to determine your home
directory from the \%\f(CWHOME\fR environment variable.  On systems running
Microsoft Windows, if \%\f(CWHOME\fR does not exist, \%\f(CWunits\fR
attempts to find your home directory from \%\f(CWHOMEDRIVE\fR,
\%\f(CWHOMEPATH\fR and \%\f(CWUSERPROFILE\fR.
You can specify an arbitrary file as your personal units data file with
the \%\f(CWMYUNITSFILE\fR environment variable; if this variable exists, its
value is used without searching your home directory.
The default units data files are described in more detail in
\fIData Files\fP.
.PP
.SS Defining New Units and Prefixes
A unit is specified on a single line by giving its name and an
equivalence.  Comments start with a \%\(oq\f(CW#\fR\(cq character, which can appear
anywhere in a line.  The backslash character (\%\(oq\f(CW\e\fR\(cq)
acts as a continuation
character if it appears as the last character on a line, making it
possible to spread definitions out over several lines if desired.
A file can be included by giving the command \%\(oq\f(CW!include\fR\(cq followed by
the file's name.  The \%\(oq\f(CW!\fR\(cq must be the first character on the
line.  The file will be sought in the same directory as the
parent file unless you give a full path.  The name of the file to be
included cannot contain spaces or the comment character \%\(oq\f(CW#\fR\(cq.
.PP
Unit names must not contain any of the operator characters \%\(oq\f(CW+\fR\(cq,
\%\(oq\f(CW-\fR\(cq, \%\(oq\f(CW*\fR\(cq, \%\(oq\f(CW/\fR\(cq, \%\(oq\f(CW|\fR\(cq, \%\(oq\f(CW^\fR\(cq, \%\(oq\f(CW;\fR\(cq, \%\(oq\f(CW~\fR\(cq,
the comment character \%\(oq\f(CW#\fR\(cq, or parentheses.  They cannot begin or
end with an underscore (\%\(oq\f(CW_\fR\(cq), a comma (\%\(oq\f(CW,\fR\(cq) or a decimal point
(\%\(oq\f(CW.\fR\(cq).  The figure dash (U+2012), typographical minus (`\-';
U+2212), and en dash (`--'; U+2013) are converted to the operator
\%\(oq\f(CW-\fR\(cq, so none of these characters can appear in unit names.  Names
cannot begin with a digit, and if a name ends in a digit other than
zero or one, the digit must be preceded by a string beginning with an
underscore, and afterwards consisting only of digits, decimal points, or
commas.  For example, \%\(oq\f(CWfoo_2\fR\(cq, \%\(oq\f(CWfoo_2,1\fR\(cq, or \%\(oq\f(CWfoo_3.14\fR\(cq
are valid names but \%\(oq\f(CWfoo2\fR\(cq or \%\(oq\f(CWfoo_a2\fR\(cq are invalid.  The
underscore is necessary because without it, \%\f(CWunits\fR cannot determine
whether \%\(oq\f(CWfoo2\fR\(cq is a unit name or represents \%\(oq\f(CWfoo^2\fR\(cq.  Zero
and one are exceptions because \%\f(CWunits\fR never interprets them
as exponents.
.PP
You could define nitrous oxide as
.PP
.EX
N2O     nitrogen 2  + oxygen
.EE
.PP
but would need to define nitrogen dioxide as
.PP
.EX
NO_2    nitrogen + oxygen 2
.EE
.PP
Be careful to define new units in terms of old ones so that a
reduction leads to the primitive units, which are marked with \%\(oq\f(CW!\fR\(cq
characters.  Dimensionless units are indicated by using the string
\%\(oq\f(CW!dimensionless\fR\(cq for the unit definition.
.PP
When adding new units, be sure to use the \%\(oq\f(CW-c\fR\(cq option to check
that the new units reduce properly.  If you create a loop in the units
definitions, then \%\f(CWunits\fR will hang when invoked with the
\%\(oq\f(CW-c\fR\(cq option.  You will need to use the \%\(oq\f(CW-\&-check-verbose\fR\(cq
option, which prints out each unit as it is checked.  The program will
still hang, but the last unit printed will be the unit that caused the
infinite loop.
.PP
If you define any units that contain
\%\(oq\f(CW+\fR\(cq characters in their definitions,
carefully check them because the \%\(oq\f(CW-c\fR\(cq option
will not catch non-conformable sums.  Be careful with the \%\(oq\f(CW-\fR\(cq
operator as well.  When used as a binary operator, the \%\(oq\f(CW-\fR\(cq
character can perform addition or multiplication
depending on the options used to invoke \%\f(CWunits\fR.
To ensure consistent behavior use \%\(oq\f(CW-\fR\(cq only as a unary negation
operator when writing units definitions.  To multiply two units leave a
space or use the \%\(oq\f(CW*\fR\(cq operator with care, recalling that it has
two possible precedence values and may require parentheses to ensure
consistent behavior.  To compute the difference
of \%\(oq\f(CWfoo\fR\(cq and \%\(oq\f(CWbar\fR\(cq write \%\(oq\f(CWfoo+(-bar)\fR\(cq or even \%\(oq\f(CWfoo+-bar\fR\(cq.
.PP
You may wish to intentionally redefine a unit.  When you do this, and
use the \%\(oq\f(CW-c\fR\(cq option, \%\f(CWunits\fR displays a warning message
about the redefinition.  You can suppress these warnings by redefining
a unit using a \%\(oq\f(CW+\fR\(cq at the beginning of the unit name.  Do not
include any white space between the \%\(oq\f(CW+\fR\(cq and the redefined unit
name.
.PP
Here is an example of a short data file that defines some basic
units:
.PP
.EX
m       !               # The meter is a primitive unit
sec     !               # The second is a primitive unit
rad     !dimensionless  # A dimensionless primitive unit
micro-  1e-6            # Define a prefix
minute  60 sec          # A minute is 60 seconds
hour    60 min          # An hour is 60 minutes
inch    72 m            # Inch defined incorrectly terms of meters
ft      12 inches       # The foot defined in terms of inches
mile    5280 ft         # And the mile
+inch   0.0254 m        # Correct redefinition, warning suppressed
.EE
.PP
A unit that ends with a \%\(oq\f(CW-\fR\(cq character is a prefix.  If a prefix
definition contains any \%\(oq\f(CW/\fR\(cq characters, be sure they are protected
by parentheses.  If you define \%\(oq\f(CWhalf- 1/2\fR\(cq, then \%\(oq\f(CWhalfmeter\fR\(cq
would be equivalent to \%\(oq\f(CW1 / (2\ meter)\fR\(cq.
.PP
.SS Defining Nonlinear Units
Some unit conversions of interest are nonlinear; for
example, temperature conversions between the Fahrenheit and Celsius
scales cannot be done by simply multiplying by conversion factors.
.PP
When you give a linear unit definition such as \%\(oq\f(CWinch 2.54\ cm\fR\(cq
you are providing information that \%\f(CWunits\fR uses to convert
values in inches into primitive units of meters.  For nonlinear units,
you give a functional definition that provides the same information.
.PP
Nonlinear units are represented using a functional notation.
It is best to regard this notation not as a function call but
as a way of adding units to a number, much the same way that
writing a linear unit name after a number adds units to that number.
Internally, nonlinear units are defined by a pair of functions
that convert to and from linear units in the database, so that
an eventual conversion to primitive units is possible.
.PP
Here is an example nonlinear unit definition:
.PP
.EX
tempF(x) units=[1;K] domain=[-459.67,) range=[0,) \e
            (x+(-32)) degF + stdtemp ; (tempF+(-stdtemp))/degF + 32
.EE
.PP
A nonlinear unit definition comprises a unit name, a formal parameter
name, two functions, and optional specifications for units, the domain,
and the range (the domain of the inverse function).  The functions tell
\%\f(CWunits\fR how to convert to and from the new unit.  To produce
valid results, the arguments of these functions need to have the correct
dimensions and be within the domains for which the functions are
defined.
.PP
The definition begins with the unit name followed immediately (with no
spaces) by a \%\(oq\f(CW(\fR\(cq character.  In the parentheses is the name of the
formal parameter.  Next is an optional specification of the units
required by the functions in the definition.  In the example above,
the \%\(oq\f(CWunits=[1;K]\fR\(cq specification indicates that the
\%\(oq\f(CWtempF\fR\(cq function requires an input argument conformable with
\%\(oq\f(CW1\fR\(cq (i.e., the argument is dimensionless), and that the inverse
function requires an input argument conformable with \%\(oq\f(CWK\fR\(cq.  For
normal nonlinear units definition, the forward function will always take
a dimensionless argument; in general, the inverse function will need
units that match the quantity measured by your nonlinear unit.
Specifying the units enables \%\f(CWunits\fR to perform error checking
on function arguments, and also to assign units to domain and range
specifications, which are described later.
.PP
Next the function definitions appear.  In the example above, the
\%\(oq\f(CWtempF\fR\(cq function is defined by
.PP
.EX
tempF(x) = (x+(-32)) degF + stdtemp
.EE
.PP
This gives a rule for converting \%\(oq\f(CWx\fR\(cq in the units \%\(oq\f(CWtempF\fR\(cq
to linear units of absolute temperature, which makes it possible to
convert from tempF to other units.
.PP
To enable conversions to Fahrenheit, you must give a rule for the
inverse conversions.  The inverse will be \%\(oq\f(CWx(tempF)\fR\(cq and its
definition appears after a \%\(oq\f(CW;\fR\(cq character.  In our example, the
inverse is
.PP
.EX
x(tempF) = (tempF+(-stdtemp))/degF + 32
.EE
.PP
This inverse definition takes an absolute temperature as its argument
and converts it to the Fahrenheit temperature.  The inverse can be
omitted by leaving out the \%\(oq\f(CW;\fR\(cq character and the inverse
definition, but then conversions \fIto\fP the unit will not be
possible.  If the inverse definition is omitted, the \%\(oq\f(CW-\&-check\fR\(cq
option will display a warning.  It is up to you to calculate and enter
the correct inverse function to obtain proper conversions; the
\%\(oq\f(CW-\&-check\fR\(cq option tests the inverse at one point and prints an
error if it is not valid there, but this is not a guarantee that your
inverse is correct.
.PP
With some definitions, the units may vary.  For example, the definition
.PP
.EX
square(x)       x^2
.EE
.PP
can have any arbitrary units, and can also take dimensionless arguments.
In such a case, you should \fInot\fP specify units.
If a definition takes a root of its arguments, the definition is valid
only for units that yield such a root.  For example,
.PP
.EX
squirt(x)       sqrt(x)
.EE
.PP
is valid for a dimensionless argument, and for arguments with even
powers of units.
.PP
Some definitions may not be valid for all real numbers.  In such cases,
\%\f(CWunits\fR can handle errors better if you specify an appropriate
domain and range.  You specify the domain and range as shown below:
.PP
.EX
baume(d) units=[1;g/cm^3] domain=[0,130.5] range=[1,10] \e
         (145/(145-d)) g/cm^3 ; (baume+-g/cm^3) 145 / baume
.EE
.PP
In this example the domain is specified after \%\(oq\f(CWdomain=\fR\(cq with
the endpoints given in brackets.  In accord with mathematical
convention, square brackets indicate a closed interval (one that
includes its endpoints), and parentheses indicate an open interval (one
that does not include its endpoints).  An interval can be open or closed
on one or both ends; an interval that is unbounded on either end is
indicated by omitting the limit on that end.  For example, a quantity to
which decibel (dB) is applied may have any value greater than zero, so
the range is indicated by \%\(oq\f(CW(0,)\fR\(cq:
.PP
.EX
decibel(x) units=[1;1] range=(0,) 10^(x/10); 10 log(decibel)
.EE
.PP
If the domain or range is given, the second endpoint must be greater
than the first.
.PP
The domain and range specifications can appear independently and in any
order along with the units specification.
The values for the domain and range endpoints are attached to the units
given in the units specification, and if necessary, the parameter value
is adjusted for comparison with the endpoints.  For example, if a
definition includes \%\(oq\f(CWunits=[1;ft]\fR\(cq and \%\(oq\f(CWrange=[3,)\fR\(cq, the range
will be taken as 3\ ft to infinity.  If the function is passed a
parameter of \%\(oq\f(CW900\ mm\fR\(cq, that value will be adjusted to
2.9527559\ ft, which is outside the specified range.
If you omit the units specification from the previous example,
\%\f(CWunits\fR can not tell whether you intend the lower endpoint
to be 3\ ft or 3\ microfurlongs, and can not adjust the
parameter value of 900\ mm for comparison.  Without units, 
numerical values other than zero or plus or minus infinity for domain or
range endpoints are meaningless, and accordingly they are not allowed.  If
you give other values without units, then the definition will be ignored
and you will get an error message.
.PP
Although the units, domain, and range specifications are optional, it's
best to give them when they are applicable; doing so allows
\%\f(CWunits\fR to perform better error checking and give more helpful
error messages.  Giving the domain and range also enables the
\%\(oq\f(CW-\&-check\fR\(cq option to find a point in the domain to use for its
point check of your inverse definition.
.PP
You can make synonyms for nonlinear units by providing both the
forward and inverse functions; inverse functions can be obtained using
the \%\(oq\f(CW~\fR\(cq operator.  So to create a synonym for \%\(oq\f(CWtempF\fR\(cq you
could write
.PP
.EX
fahrenheit(x) units=[1;K] tempF(x); ~tempF(fahrenheit)
.EE
.PP
This is useful for creating a nonlinear unit
definition that differs slightly from an existing definition without
having to repeat the original functions.  For example,
.PP
.EX
dBW(x)     units=[1;W] range=[0,) dB(x) W ;  ~dB(dBW/W) 
.EE
.PP
If you wish a synonym to refer to an existing nonlinear unit without
modification, you can do so more simply by adding the synonym with
appended parentheses as a new unit, with the existing nonlinear
unit\(emwithout parentheses\(emas the definition.  So to create a synonym
for \%\(oq\f(CWtempF\fR\(cq you could write
.PP
.EX
fahrenheit()  tempF
.EE
.PP
The definition must be a nonlinear unit; for example, the synonym
.PP
.EX
fahrenheit()  meter
.EE
.PP
will result in an error message when \%\f(CWunits\fR starts.
.PP
You may occasionally wish to define a function that operates on units.
This can be done using a nonlinear unit definition.  For example, the
definition below provides conversion between radius and the area of a
circle.  This definition requires a length as input and
produces an area as output, as indicated by the \%\(oq\f(CWunits=\fR\(cq specification.
Specifying the range as the nonnegative numbers can prevent cryptic
error messages.
.PP
.EX
circlearea(r) units=[m;m^2] range=[0,)   pi r^2 ; sqrt(circlearea/pi)
.EE
.PP
.SS Defining Piecewise Linear Units
Sometimes you may be interested in a piecewise linear unit such as
many wire gauges.  Piecewise linear units can be defined by specifying
conversions to linear units on a list of points.
Conversion at other points will be done by linear interpolation.
A partial definition of zinc gauge is
.PP
.EX
zincgauge[in] 1 0.002, 10 0.02, 15 0.04, 19 0.06, 23 0.1
.EE
.PP
In this example, \%\(oq\f(CWzincgauge\fR\(cq is the name of the piecewise linear
unit.  The definition of such a unit is indicated by the
embedded \%\(oq\f(CW[\fR\(cq character.  After the bracket, you should indicate the
units to be attached to the numbers in the table.
No spaces can appear before the
\%\(oq\f(CW]\fR\(cq character, so a definition like \%\(oq\f(CWfoo[kg meters]\fR\(cq is
invalid; instead write \%\(oq\f(CWfoo[kg*meters]\fR\(cq.  The definition of the
unit consists of a list of pairs optionally separated by commas.
This list defines a function for converting from the piecewise linear
unit to linear units.  The
first item in each pair is the function argument; the second item is the
value of the function at that argument (in the units specified in brackets).
In this example,
we define \%\(oq\f(CWzincgauge\fR\(cq at five points.  For example, we set
\%\(oq\f(CWzincgauge(1)\fR\(cq equal to \%\(oq\f(CW0.002\ in\fR\(cq.  Definitions like this
may be  more readable  if written using  continuation characters as
.PP
.EX
zincgauge[in] \e
     1 0.002  \e
    10 0.02   \e
    15 0.04   \e
    19 0.06   \e
    23 0.1
.EE
.PP
With the preceding definition, the following conversion can be
performed:
.PP
.EX
You have: zincgauge(10)
You want: in
    * 0.02
    / 50
You have: .01 inch
You want: zincgauge
    5
.EE
.PP
If you define a piecewise linear unit that is not strictly monotonic,
then the inverse will not be well defined.  If the inverse is requested
for such a unit, \%\f(CWunits\fR will return the smallest inverse.
.PP
After adding nonlinear units definitions, you should normally run
\%\f(CWunits\ --check\fR to check for errors.  If the \%\(oq\f(CWunits\fR\(cq
keyword is not given, the \%\(oq\f(CW-\&-check\fR\(cq option checks a nonlinear unit
definition using a dimensionless argument, and then checks using an
arbitrary combination of units, as well as the square and cube of that
combination; a warning is given if any of these tests fail.  For
example,
.tr '\(aq
.PP
.EX
Warning: function 'squirt(x)' defined as 'sqrt(x)'
         failed for some test inputs:
         squirt(7(kg K)^1): Unit not a root
         squirt(7(kg K)^3): Unit not a root
.EE
.tr '\(cq
.PP
Running \%\f(CWunits\ --check\fR will print a warning if a
non-monotonic piecewise linear unit is encountered.  For example, the
relationship between ANSI coated abrasive designation and mean particle
size is non-monotonic in the vicinity of 800 grit:
.PP
.EX
ansicoated[micron] \e
     . . .
    600 10.55 \e
    800 11.5 \e
    1000 9.5 \e
.EE
.PP
Running \%\f(CWunits\ --check\fR would give the error message
.tr '\(aq
.PP
.EX
Table 'ansicoated' lacks unique inverse around entry 800
.EE
.tr '\(cq
.PP
Although the inverse is not well defined in this region, it's not really
an error.  Viewing such error messages can be tedious, and if there are
enough of them, they can distract from true errors.  Error checking for
nonlinear unit definitions can be suppressed by giving the
\%\(oq\f(CWnoerror\fR\(cq keyword; for the examples above, this could be done as
.PP
.EX
squirt(x) noerror domain=[0,) range=[0,) sqrt(x); squirt^2
ansicoated[micron] noerror \e
     . . .
.EE
.PP
Use the \%\(oq\f(CWnoerror\fR\(cq keyword with caution.  The safest approach after
adding a nonlinear unit definition is to run \%\f(CWunits\ --check\fR
and confirm that there are no actual errors before adding the
\%\(oq\f(CWnoerror\fR\(cq keyword.
.PP
.SS Defining Unit List Aliases
Unit list aliases are treated differently from unit definitions,
because they are a data entry shorthand rather than a true definition
for a new unit.
A unit list alias definition begins with \%\(oq\f(CW!unitlist\fR\(cq and includes the
alias and the definition;  for example, the aliases included in the
standard units data file are
.PP
.EX
!unitlist   hms     hr;min;sec
!unitlist   time    year;day;hr;min;sec
!unitlist   dms     deg;arcmin;arcsec
!unitlist   ftin    ft;in;1|8 in
!unitlist   usvol   cup;3|4 cup;2|3 cup;1|2 cup;1|3 cup;1|4 cup;\e
                    tbsp;tsp;1|2 tsp;1|4 tsp;1|8 tsp
.EE
.PP
Unit list aliases are only for unit lists, so the definition must
include a \%\(oq\f(CW;\fR\(cq.  Unit list aliases can never be combined with
units or other unit list aliases, so the definition of \%\(oq\f(CWtime\fR\(cq
shown above could \fInot\fP have been shortened to
\%\(oq\f(CWyear;day;hms\fR\(cq.
.PP
As usual, be sure to run \%\f(CWunits\ --check\fR to ensure that the
units listed in unit list aliases are conformable.
.PP
.SH NUMERIC OUTPUT FORMAT
By default, \%\f(CWunits\fR shows results to eight significant
digits. You can change this with the \%\(oq\f(CW-\&-exponential\fR\(cq,
\%\(oq\f(CW-\&-digits\fR\(cq, and \%\(oq\f(CW-\&-output-format\fR\(cq options.  The first
sets an exponential format (i.e., scientific notation) like that used
in the original Unix \%\f(CWunits\fR program, the second allows you to
specify a different number of significant digits, and the last allows
you to control the output appearance using the format for the
\%\f(CWprintf()\fR function in the C programming language.  If you only
want to change the number of significant digits or specify exponential
format type, use the \%\(oq\f(CW-\&-digits\fR\(cq and \%\(oq\f(CW-\&-exponential\fR\(cq
options.  The \%\(oq\f(CW-\&-output-format\fR\(cq option affords the greatest
control of the output appearance, but requires at least rudimentary
knowledge of the \%\f(CWprintf()\fR format syntax. See \fIInvoking Units\fP
for descriptions of these options.
.PP
.SS Format Specification
The format specification recognized with the \%\(oq\f(CW-\&-output-format\fR\(cq
option is a subset of that for \%\f(CWprintf()\fR.  The format specification has
the form
.\".CW "%\fR[\fP\fIflags\fP\fR][\fP\fIwidth\fP\fR][\fP.\fIprecision\fP\fR]\fP\fItype\fP" ;
\%\f(CW%\fR[\fIflags\fP][\fIwidth\fP][\c
\%\f(CW.\fR\fIprecision\fP]\fItype\fP;
it must begin with \%\(oq\f(CW%\fR\(cq, and must end with a floating-point type
specifier:
\%\(oq\f(CWg\fR\(cq or \%\(oq\f(CWG\fR\(cq to specify the number of significant digits,
\%\(oq\f(CWe\fR\(cq or \%\(oq\f(CWE\fR\(cq for scientific notation, and \%\(oq\f(CWf\fR\(cq for
fixed-point decimal.  The ISO C99 standard added the \%\(oq\f(CWF\fR\(cq type for
fixed-point decimal and the \%\(oq\f(CWa\fR\(cq and \%\(oq\f(CWA\fR\(cq types for hexadecimal
floating point; these types are allowed with compilers that support
them.  Type length modifiers (e.g., \%\(oq\f(CWL\fR\(cq to indicate a long double)
are inapplicable and are not allowed.
.PP
The default format for \%\f(CWunits\fR is \%\(oq\f(CW%.8g\fR\(cq;
for greater precision, you could specify \%\(oq\f(CW-o\ %.15g\fR\(cq.
The \%\(oq\f(CWg\fR\(cq and \%\(oq\f(CWG\fR\(cq format types use exponential format whenever
the exponent would be less than \-4, so the value 0.000013
displays as \%\(oq\f(CW1.3e-005\fR\(cq.  These types also use exponential notation
when the exponent is greater than or equal to the precision, so with the
default format, the value
.if t .ig ++
5e7
.++
.if n .ig ++
.EQ
5 times 10 sup 7
.EN
.++
displays as \%\(oq\f(CW50000000\fR\(cq and the value
.if t .ig ++
5e8
.++
.if n .ig ++
.EQ
5 times 10 sup 8
.EN
.++
displays as \%\(oq\f(CW5e+008\fR\(cq.  If you prefer fixed-point display, you might
specify \%\(oq\f(CW-o\ %.8f\fR\(cq; however, small numbers will display very
few significant digits, and values less than
.if t .ig ++
0.5e\-8
.++
.if n .ig ++
.EQ
0.5 times 10 sup -8
.EN
.++
will show nothing but zeros.
.PP
The format specification may include one or more optional flags:
\%\(oq\f(CW+\fR\(cq, \%\(oq\f(CW\ \fR\(cq (space), \%\(oq\f(CW#\fR\(cq, \%\(oq\f(CW-\fR\(cq, or \%\(oq\f(CW0\fR\(cq (the
digit zero).  The digit-grouping flag
.ie \n(.g \(oq\(aq'
.el \&'
is allowed with compilers that support it.  Flags are followed by an
optional value for the minimum field width, and an optional precision
specification that begins with a period (e.g., \%\(oq\f(CW.6\fR\(cq).  The field
width includes the digits, decimal point, the exponent, thousands
separators (with the digit-grouping flag), and the sign if any of these
are shown.
.PP
.SS Flags
The \%\(oq\f(CW+\fR\(cq flag causes the output to have a sign (\%\(oq\f(CW+\fR\(cq or \%\(oq\f(CW-\fR\(cq).
The space flag \%\(oq\f(CW\ \fR\(cq is similar to the \%\(oq\f(CW+\fR\(cq flag, except
that when the value is positive, it is prefixed with a space rather than
a plus sign; this flag is ignored if the \%\(oq\f(CW+\fR\(cq flag is also given.
The \%\(oq\f(CW+\fR\(cq or \%\(oq\f(CW\ \fR\(cq flag could be useful if conversions might
include positive and negative results, and you wanted to align
the decimal points in exponential notation.
The \%\(oq\f(CW#\fR\(cq flag causes the output value to contain a decimal point in
all cases; by default, the output contains a decimal point only if there
are digits (which can be trailing zeros) to the right of the point.
With the \%\(oq\f(CWg\fR\(cq or \%\(oq\f(CWG\fR\(cq types, the \%\(oq\f(CW#\fR\(cq flag also prevents the
suppression of trailing zeros.
The digit-grouping flag
.ie \n(.g \(oq\(aq'
.el \&`''
shows a thousands separator in digits to the left of the decimal point.
This can be useful when displaying large numbers in fixed-point decimal;
for example, with the format \%\(oq\f(CW%f\fR\(cq,
.PP
.EX
You have: mile
You want: microfurlong
        * 8000000.000000
        / 0.000000
.EE
.PP
the magnitude of the first result may not be immediately obvious without
counting the digits to the left of the decimal point.  If the thousands
separator is the comma (\%\(oq\f(CW,\fR\(cq), the output with the format
.ie \n(.g \(oq%\(aqf'
.el `%'f'
might be
.PP
.EX
You have: mile
You want: microfurlong
        * 8,000,000.000000
        / 0.000000
.EE
.PP
making the magnitude readily apparent.  Unfortunately, few compilers
support the digit-grouping flag.
.PP
With the \%\(oq\f(CW-\fR\(cq flag, the output value is left aligned within the
specified field width.  If a field width greater than needed to show the
output value is specified, the \%\(oq\f(CW0\fR\(cq (zero) flag causes the output
value to be left padded with zeros until the specified field width is
reached; for example, with the format \%\(oq\f(CW%011.6f\fR\(cq,
.PP
.EX
You have: troypound
You want: grain
        * 5760.000000
        / 0000.000174
.EE
.PP
The \%\(oq\f(CW0\fR\(cq flag has no effect if the \%\(oq\f(CW-\fR\(cq (left align) flag is
given.
.PP
.SS Field Width
By default, the output value is left aligned and shown with the minimum
width necessary for the specified (or default) precision.  If a field
width greater than this is specified, the value shown is right aligned,
and padded on the left with enough spaces to provide the specified field
width.  A width specification is typically used with fixed-point decimal
to have columns of numbers align at the decimal point; this arguably is
less useful with \%\f(CWunits\fR than with long columnar output, but it
may nonetheless assist in quickly assessing the relative magnitudes of
results.  For example, with the format \%\(oq\f(CW%12.6f\fR\(cq,
.PP
.EX
You have: km
You want: in
        * 39370.078740
        /     0.000025
You have: km
You want: rod
        *   198.838782
        /     0.005029
You have: km
You want: furlong
        *     4.970970
        /     0.201168
.EE
.PP
.SS Precision
The meaning of \(lqprecision\(rq depends on the format type.  With \%\(oq\f(CWg\fR\(cq
or \%\(oq\f(CWG\fR\(cq, it specifies the number of significant digits (like the
\%\(oq\f(CW-\&-digits\fR\(cq option); with \%\(oq\f(CWe\fR\(cq, \%\(oq\f(CWE\fR\(cq, \%\(oq\f(CWf\fR\(cq, or
\%\(oq\f(CWF\fR\(cq, it specifies the maximum number of digits to be shown after
the decimal point.
.PP
With the \%\(oq\f(CWg\fR\(cq and \%\(oq\f(CWG\fR\(cq format types, trailing zeros are
suppressed, so the results may sometimes have fewer digits than the
specified precision (as indicated above, the \%\(oq\f(CW#\fR\(cq flag causes
trailing zeros to be displayed).
.PP
The default precision is 6, so \%\(oq\f(CW%g\fR\(cq is equivalent to \%\(oq\f(CW%.6g\fR\(cq,
and would show the output to six significant digits.  Similarly,
\%\(oq\f(CW%e\fR\(cq or \%\(oq\f(CW%f\fR\(cq would show the output with six digits after the
decimal point.
.PP
The C \%\f(CWprintf()\fR function allows a precision of arbitrary size, whether or
not all of the digits are meaningful.  With most compilers, the maximum
internal precision with \%\f(CWunits\fR is 15 decimal digits (or 13
hexadecimal digits).
With the \%\(oq\f(CW-\&-digits\fR\(cq option, you are limited
to the maximum internal precision; with the \%\(oq\f(CW-\&-output-format\fR\(cq
option, you may specify a precision greater than this, but it may not be
meaningful.  In some cases, specifying excess precision can result in
rounding artifacts.  For example, a pound is exactly 7000 grains, but
with the format \%\(oq\f(CW%.18g\fR\(cq, the output might be
.PP
.EX
You have: pound
You want: grain
        * 6999.9999999999991
        / 0.00014285714285714287
.EE
.PP
With the format \%\(oq\f(CW%.25g\fR\(cq you might get the following:
.PP
.EX
You have: 1/3
You want:
        Definition: 0.333333333333333314829616256247
.EE
.PP
In this case the displayed value includes a series of digits that represent the
underlying binary floating-point approximation to 1/3 but are not
meaningful for the desired computation.
In general, the result with excess precision is system dependent.
The precision affects only the \fIdisplay\fP of numbers; if a result
relies on physical constants that are not known to the specified
precision, the number of physically meaningful digits may be less than
the number of digits shown.
.PP
See the documentation for \%\f(CWprintf()\fR for more detailed descriptions of the
format specification.
.PP
The \%\(oq\f(CW-\&-output-format\fR\(cq option is incompatible with the
\%\(oq\f(CW-\&-exponential\fR\(cq or \%\(oq\f(CW-\&-digits\fR\(cq options; if the former is
given in combination with either of the latter, the format is controlled
by the last option given.
.PP
.SH LOCALIZATION
Some units have different values in different locations.  The
localization feature accommodates this by allowing a units data file to
specify definitions that depend on the user's locale.
.PP
.SS Locale
A locale is a subset of a user's environment that indicates the user's
language and country, and some attendant preferences, such as the
formatting of dates.  The \%\f(CWunits\fR program attempts to determine
the locale from the POSIX setlocale function; if this cannot be done,
\%\f(CWunits\fR examines the environment
variables \%\f(CWLC_CTYPE\fR and \%\f(CWLANG\fR.
On POSIX systems, a locale is of the form
\fIlanguage\fP\%\f(CW_\fR\fIcountry\fP, where \fIlanguage\fP is the
two-character code from ISO 639-1 and \fIcountry\fP is the two-character
code from ISO 3166-1; \fIlanguage\fP is lower case and \fIcountry\fP is
upper case. For example, the POSIX locale for the United Kingdom is \%\f(CWen_GB\fR.
.PP
On systems running Microsoft Windows, the value returned by setlocale()
is different from that on POSIX systems; \%\f(CWunits\fR attempts to map
the Windows value to a POSIX value by means of a table in the file
\%\(oq\f(CWlocale_map.txt\fR\(cq in the same directory as the other data files.  The
file includes entries for many combinations of language and country, and
can be extended to include other combinations.  The \%\(oq\f(CWlocale_map.txt\fR\(cq
file comprises two tab-separated columns; each entry is of the form
.PP
.RS 5n
\fIWindows-locale\fP   \fIPOSIX-locale\fP
.RE
.PP
where \fIPOSIX-locale\fP is as described above, and \fIWindows-locale\fP
typically spells out both the language and country.  For example, the
entry for the United States is
.PP
.EX
English_United States   en_US
.EE
.PP
You can force \%\f(CWunits\fR to run in a desired locale by using the
\%\(oq\f(CW-l\fR\(cq option.
.PP
In order to create unit definitions for a particular locale you begin
a block of definitions in a unit datafile with \%\(oq\f(CW!locale\fR\(cq followed
by a locale name.  The \%\(oq\f(CW!\fR\(cq must be the first character on the
line.  The \%\f(CWunits\fR program reads the following
definitions only if the current locale matches.  You end the block of
localized units with \%\(oq\f(CW!endlocale\fR\(cq.  Here is an example, which
defines the British gallon.
.PP
.EX
!locale en_GB
gallon       4.54609 liter
!endlocale
.EE
.PP
.SS Additional Localization
Sometimes the locale isn't sufficient to determine unit preferences.
There could be regional preferences, or a company could have specific
preferences.  Though probably uncommon, such differences could arise
with the choice of English customary units outside of English-speaking
countries.  To address this, \%\f(CWunits\fR allows specifying
definitions that depend on environment variable settings.
The environment variables can be controled based on the current locale,
or the user can set them to force a particular group of definitions.
.PP
A conditional block of definitions in a units data file begins with
either \%\(oq\f(CW!var\fR\(cq or \%\(oq\f(CW!varnot\fR\(cq following by an environment
variable name and then a space separated
list of values.  The leading \%\(oq\f(CW!\fR\(cq must appear in the first column of a units
data file, and the conditional block is terminated by \%\(oq\f(CW!endvar\fR\(cq.
Definitions in blocks beginning with \%\(oq\f(CW!var\fR\(cq are executed only if the
environment variable is exactly equal to one of the listed values.
Definitions in blocks beginning with \%\(oq\f(CW!varnot\fR\(cq are executed only if the
environment variable does \fInot\fP equal any of the list values.
.PP
The inch has long been a customary measure of length in many places.
The word comes from the Latin \fIuncia\fP meaning \(lqone twelfth,\(rq
referring to its relationship with the foot.  By the 20th century, the
inch was officially defined in English-speaking countries relative to
the yard, but until 1959, the yard differed slightly among those
countries.  In France the customary inch, which was displaced in 1799
by the meter, had a different length based on a french foot.  These
customary definitions could be accommodated as follows:
.PP
.EX
!var INCH_UNIT usa
yard          3600|3937 m
!endvar
!var INCH_UNIT canada
yard          0.9144 meter
!endvar
!var INCH_UNIT uk
yard          0.91439841 meter
!endvar
!var INCH_UNIT canada uk usa
foot          1|3 yard
inch          1|12 foot
!endvar
!var INCH_UNIT france
foot          144|443.296 m
inch          1|12 foot
line          1|12 inch
!endvar
!varnot INCH_UNIT usa uk france canada
!message Unknown value for INCH_UNIT
!endvar
.EE
.PP
When \%\f(CWunits\fR reads the above definitions it will check the
environment variable \%\f(CWINCH_UNIT\fR and load only the definitions for
the appropriate section.  If \%\f(CWINCH_UNIT\fR is unset or is not set to
one of the four values listed, then \%\f(CWunits\fR will run the last
block.  In this case that block uses the
\%\(oq\f(CW!message\fR\(cq command to display a warning message.  Alternatively
that block could set default values.
.PP
In order to create default values that are overridden by user settings
the data file can use the \%\(oq\f(CW!set\fR\(cq command, which sets an
environment variable \fIonly if it is not already set\fP;  these
settings are only for the current \%\f(CWunits\fR invocation and do
not persist.  So if the example above were preceded by
\%\(oq\f(CW!set INCH_UNIT france\fR\(cq, then this would make \%\(oq\f(CWfrance\fR\(cq the
default value for \%\f(CWINCH_UNIT\fR.  If the user had set the variable
in the environment before invoking \%\f(CWunits\fR, then
\%\f(CWunits\fR would use the user's value.
.PP
To link these settings to the user's locale you combine the \%\(oq\f(CW!set\fR\(cq
command with the \%\(oq\f(CW!locale\fR\(cq command.
If you wanted to combine the above example with suitable locales you
could do by \fIpreceding\fP the above definition with the following:
.PP
.EX
!locale en_US
!set INCH_UNIT usa
!endlocale
!locale en_GB
!set INCH_UNIT uk
!endlocale
!locale en_CA
!set INCH_UNIT canada
!endlocale
!locale fr_FR
!set INCH_UNIT france
!endlocale
!set INCH_UNIT france
.EE
.PP
These definitions set the overall default for \%\f(CWINCH_UNIT\fR to
\%\(oq\f(CWfrance\fR\(cq and set default values for four locales appropriately.
The overall default setting comes last so that it only applies when
\%\f(CWINCH_UNIT\fR was not set by one of the other commands or by the
user.
.PP
If the variable given after \%\(oq\f(CW!var\fR\(cq or \%\(oq\f(CW!varnot\fR\(cq is undefined,
then \%\f(CWunits\fR prints an error message and ignores the
definitions that follow.  Use \%\(oq\f(CW!set\fR\(cq to create defaults to
prevent this situation from arising.  The \%\(oq\f(CW-c\fR\(cq
option only checks the definitions that are active for the current
environment and locale, so when adding new definitions take care to
check that all cases give rise to a well defined set of definitions.
.PP
.SH ENVIRONMENT VARIABLES
The \%\f(CWunits\fR program uses the following environment variables:
.TP
.BR "HOME"
Specifies the location of your home directory; it is used by
\%\f(CWunits\fR to find a personal units data file \%\(oq\f(CW.units\fR\(cq.  On
systems running Microsoft Windows, the file is \%\(oq\f(CWunitdef.units\fR\(cq, and
if \%\f(CWHOME\fR does not exist, \%\f(CWunits\fR tries to determine your
home directory from the \%\f(CWHOMEDRIVE\fR and \%\f(CWHOMEPATH\fR environment
variables; if these variables do not exist, units finally tries
\%\f(CWUSERPROFILE\fR\(emtypically \%\(oq\f(CWC:\eUsers\e\fIusername\fP\fR\(cq (Windows
Vista and Windows\ 7) or
\%\(oq\f(CWC:\eDocuments\ and\ Settings\e\fIusername\fP\fR\(cq (Windows\ XP).
.TP
.BR "LC_CTYPE, LANG"
Checked to determine the locale if \%\f(CWunits\fR cannot obtain it
from the operating system.  Sections of the
standard units data file are specific to certain locales.
.TP
.BR "MYUNITSFILE"
Specifies your personal units data file.  If this variable exists,
\%\f(CWunits\fR uses its value rather than searching your home
directory for \%\(oq\f(CW.units\fR\(cq.  The personal units file will not be
loaded if any data files are given using the \%\(oq\f(CW-f\fR\(cq option.
.TP
.BR "PAGER"
Specifies the pager to use for help and for displaying the conformable
units.  The help function browses the units database and calls
the pager using the \%\(oq\f(CW+n\fR\(cq\fIn\fP syntax for specifying a line
number.  The default pager is \%\f(CWmore\fR; \%\f(CWPAGER\fR can be used
to specify alternatives such as \%\f(CWless\fR, \%\f(CWpg\fR,
\%\f(CWemacs\fR, or \%\f(CWvi\fR.
.TP
.BR "UNITS_ENGLISH"
Set to either \%\(oq\f(CWUS\fR\(cq or
\%\(oq\f(CWGB\fR\(cq to choose United States or British volume definitions,
overriding the default from your locale.
.TP
.BR "UNITSFILE"
Specifies the units data file to use (instead of the default).
You can only specify a single units data file using this environment
variable.  If units data files are given using the \%\(oq\f(CW-f\fR\(cq option,
the file specified by \%\f(CWUNITSFILE\fR will be not be loaded unless the
\%\(oq\f(CW-f\fR\(cq option is given with the empty string
(\%\(oq\f(CWunits\ -f\ ""\fR\(cq).
.TP
.BR "UNITSLOCALEMAP"
Windows only; this variable has no effect on Unix-like systems.
Specifies the units locale map file to use (instead of the default).
This variable seldom needs to be set, but you can use it to ensure that
the locale map file will be found if you specify a location for the
units data file using either the \%\(oq\f(CW-f\fR\(cq option or the
\%\f(CWUNITSFILE\fR environment variable, and that location does not also
contain the locale map file.
.TP
.BR "UNITS_SYSTEM"
This environment variable is used in the standard data file to select
CGS measurement systems.  Currently supported systems are \%\(oq\f(CWesu\fR\(cq,
\%\(oq\f(CWemu\fR\(cq, \%\(oq\f(CWgauss[ian]\fR\(cq, and \%\(oq\f(CWsi\fR\(cq.  The default is \%\(oq\f(CWsi\fR\(cq.
.IP
.SH DATA FILES
The \%\f(CWunits\fR program uses two default data files:
\%\(oq\f(CWdefinitions.units\fR\(cq and \%\(oq\f(CWcurrency.units\fR\(cq.  The program can
also use an optional personal units data file \%\(oq\f(CW.units\fR\(cq
(\%\(oq\f(CWunitdef.units\fR\(cq under Windows) located in the user's home
directory.  The personal units data file is described in more detail in
\fIUnits Data Files\fP.
.PP
On Unix-like systems, the data files are typically located in
\%\(oq\f(CW/usr/share/units\fR\(cq if \%\f(CWunits\fR is provided with the
operating system, or in \%\(oq\f(CW/usr/local/share/units\fR\(cq if \%\f(CWunits\fR
is compiled from the source distribution.  Note that the currency file
\%\(oq\f(CWcurrency.units\fR\(cq is a symbolic link to another location.  
.PP
On systems running Microsoft Windows, the files may be in the same
locations if Unix-like commands are available, a Unix-like file
structure is present (e.g., \%\(oq\f(CWC:/usr/local\fR\(cq), and \%\f(CWunits\fR is
compiled from the source distribution.  If Unix-like commands are not
available, a more common location is
\%\(oq\f(CWC:\eProgram\ Files\ (x86)\eGNU\eunits\fR\(cq (for 64-bit Windows
installations) or \%\(oq\f(CWC:\eProgram\ Files\eGNU\eunits\fR\(cq (for 32-bit
installations).
.PP
If \%\f(CWunits\fR is obtained from the GNU Win32 Project
(\fRhttp://gnuwin32.sourceforge.net/\fP), the files are commonly in
\%\(oq\f(CWC:\eProgram\ Files\eGnuWin32\eshare\eunits\fR\(cq.
.PP
If the default units data file is not an absolute pathname,
\%\f(CWunits\fR will look for the file in the directory that contains
the \%\f(CWunits\fR program; if the file is not found there,
\%\f(CWunits\fR will look in a directory \%\f(CW../share/units\fR relative
to the directory with the \%\f(CWunits\fR program.
.PP
You can determine the location of the files by running
\%\f(CWunits\ --version\fR.  Running \%\f(CWunits\ --info\fR
will give you additional information about the files, how
\%\f(CWunits\fR will attempt to find them, and the status of the
related environment variables.
.PP
.SH UNICODE SUPPORT
The standard units data file is in Unicode, using UTF-8 encoding.  Most
definitions use only ASCII characters (i.e., code points U+0000 through
U+007F); definitions using non-ASCII characters appear in blocks
beginning with \%\(oq\f(CW!utf8\fR\(cq and ending with \%\(oq\f(CW!endutf8\fR\(cq.
.PP
The non-ASCII definitions are loaded only if the platform and the locale
support UTF-8.  Platform support is determined when \%\f(CWunits\fR
is compiled; the locale is checked at every invocation of
\%\f(CWunits\fR.  To see if your version of \%\f(CWunits\fR includes
Unicode support, invoke the program with the \%\(oq\f(CW-\&-version\fR\(cq option.
.PP
When Unicode support is available, \%\f(CWunits\fR checks every line
within UTF-8 blocks in all of the units data files for invalid or
non-printing UTF-8 sequences; if such sequences occur, \%\f(CWunits\fR
ignores the entire line.  In addition to checking validity,
\%\f(CWunits\fR determines the display width of non-ASCII characters to
ensure proper positioning of the pointer in some error messages and to
align columns for the \%\(oq\f(CWsearch\fR\(cq and \%\(oq\f(CW?\fR\(cq commands.
.PP
As of early 2019, Microsoft Windows provides limited support for UTF-8
in console applications, and accordingly, \%\f(CWunits\fR does not
support Unicode on Windows.  The UTF-16 and UTF-32 encodings are not
supported on any platforms.
.PP
If Unicode support is available and definitions that contain non-ASCII
UTF-8 characters are added to a units data file, those definitions
should be enclosed within \%\(oq\f(CW!utf8\fR\(cq ... \%\(oq\f(CW!endutf8\fR\(cq to ensure
that they are only loaded when Unicode support is available.  As usual,
the \%\(oq\f(CW!\fR\(cq must appear as the first character on the line.  As
discussed in \fIUnits Data Files\fP, it's usually best to put such
definitions in supplemental data files linked by an \%\(oq\f(CW!include\fR\(cq
command or in a personal units data file.
.PP
When Unicode support is not available, \%\f(CWunits\fR makes no assumptions
about character encoding, except that characters in the range 00\(en7F
hexadecimal correspond to ASCII encoding.  Non-ASCII characters are
simply sequences of bytes, and have no special meanings; for definitions
in supplementary units data files, you can use any encoding consistent
with this assumption.  For example, if you wish to use non-ASCII
characters in definitions when running \%\f(CWunits\fR under Windows,
you can use a character set such as Windows \(lqANSI\(rq (code page 1252 in
the US and Western Europe); if this is done, the console code page must
be set to the same encoding for the characters to display properly.
You can even use UTF-8, though some messages may be improperly aligned,
and \%\f(CWunits\fR will not detect invalid UTF-8 sequences.  If you use
UTF-8 encoding when Unicode support is not available, you should place any
definitions with non-ASCII characters \fIoutside\fP \%\(oq\f(CW!utf8\fR\(cq
... \%\(oq\f(CW!endutf8\fR\(cq blocks\(emotherwise, they will be ignored.
.PP
Typeset material other than code examples usually uses the Unicode minus
(U+2212) rather than the ASCII hyphen-minus operator (U+002D) used in
\%\f(CWunits\fR; the figure dash (U+2012) and en dash (U+2013) are also
occasionally used.  To allow such material to be copied and pasted for
interactive use or in units data files, \%\f(CWunits\fR converts these
characters to U+002D before further processing.  Because of this, none
of these characters can appear in unit names.
.PP
.SH READLINE SUPPORT
If the \%\f(CWreadline\fR package has been compiled in, then when
\%\f(CWunits\fR is used interactively, numerous command line editing
features are available.  To check if your version of \%\f(CWunits\fR
includes \%\f(CWreadline\fR, invoke the program with the
\%\(oq\f(CW-\&-version\fR\(cq option.
.PP
For complete information about \%\f(CWreadline\fR, consult the
documentation for the \%\f(CWreadline\fR package.  Without any
configuration, \%\f(CWunits\fR will allow editing in the style of
emacs.  Of particular use with \%\f(CWunits\fR are the completion
commands.
.PP
If you type a few characters and then hit \fIESC\fP followed by
\%\f(CI?\fR, then \%\f(CWunits\fR will display a list of all the units that
start with the characters typed.  For example, if you type \%\f(CImetr\fR and
then request completion, you will see something like this:
.PP
.EX
You have: metr
metre             metriccup         metrichorsepower  metrictenth
metretes          metricfifth       metricounce       metricton
metriccarat       metricgrain       metricquart       metricyarncount
You have: metr
.EE
.PP
If there is a unique way to complete a unit name, you can hit the \fITAB\fP key
and \%\f(CWunits\fR will provide the rest of the unit name.  If \%\f(CWunits\fR
beeps, it means that there is no unique completion.  Pressing the \fITAB\fP
key a second time will print the list of all completions.
.PP
The readline library also keeps a history of the values you enter.
You can move through this history using the up and down arrows.  The
history is saved to the file \%\(oq\f(CW.units_history\fR\(cq in your home
directory so that it will persist across multiple \%\f(CWunits\fR
invocations.  If you wish to keep work for a certain project separate
you can change the history filename using the \%\(oq\f(CW-\&-history\fR\(cq
option.  You could, for example, make an alias for \%\f(CWunits\fR to
\%\f(CWunits --history .units_history\fR so that \%\f(CWunits\fR would
save separate history in the current directory.  
The length of each history file is limited to 5000 lines.  Note also that if
you run several concurrent copies of \%\f(CWunits\fR each one will save
its new history to the history file upon exit.
.PP
.SH UPDATING CURRENCY EXCHANGE RATES
.na
The units program database includes currency exchange rates and prices
for some precious metals.  Of course, these values change over time,
sometimes very rapidly, and \%\f(CWunits\fR cannot provide real-time
values.  To update the exchange rates, run \%\f(CWunits_cur\fR, which
rewrites the file containing the currency rates, typically
\%\(oq\f(CW/var/lib/\:units/\:currency.units\fR\(cq or
\%\(oq\f(CW/usr/local/\:com/\:units/\:currency.units\fR\(cq
on a Unix-like system or
\%\(oq\f(CWC:\Program\ Files\ (x86)\\:GNU\\:units\\:definitions.units\fR\(cq on a Windows
system.
.ad b
.PP
This program requires Python (\fRhttps://www.python.org\fP); either
version 2 or 3 will work.  The program must be run with suitable
permissions to write the file.  To keep the rates updated automatically,
run it using a cron job on a Unix-like system, or a similar scheduling
program on a different system.
.PP
Reliable free sources of currency exchange rates have been annoyingly
ephemeral.  The program currently supports several sources:
.PP
.IP \h'1n'\(bu 4n
FloatRates (\fRhttps://www/floatrates.com\fP).
The US dollar (\%\(oq\f(CWUSD\fR\(cq) is the default base currency.  You can
change the base currency with the
\%\(oq\f(CW-b\fR\(cq option described below.  Allowable base currencies are listed on
the FloatRates website.  Exchange rates update daily.  
.PP
.IP \h'1n'\(bu 4n
The European Central Bank (\fRhttps://www.ecb.europa.eu\fP).
The base currency is always the euro (\%\(oq\f(CWEUR\fR\(cq).  Exchange rates 
update daily.  This source offers a more limited list of currencies
than the others.  
.PP
.IP \h'1n'\(bu 4n
Fixer (\fRhttps://fixer.io\fP).
Registration for a free API key is required.  With a free API key, base
currency is the euro; exchange rates are updated hourly, the
service has a limit of 1,000 API calls per month, and SSL encryption
(https protocol) is not available.  Most of these restrictions are
eliminated or reduced with paid plans.
.PP
.IP \h'1n'\(bu 4n
open exchange rates (\fRhttps://openexchangerates.org\fP).
Registration for a free API key is required.  With a free API key, the
base currency is the US dollar; exchange rates are updated hourly, and
there is a limit of 1,000 API calls per month.  Most of these
restrictions are eliminated or reduced with paid plans.
.PP
The default source is FloatRates; you can select a different one using
\%\(oq\f(CW-s\fR\(cq option described below.
.PP
Precious metals pricing is obtained from Packetizer
(\fRwww.packetizer.com\fP).  This site updates once per day.
.PP
You invoke \%\f(CWunits_cur\fR like this:
.PP
.EX
units_cur [\fIoptions\fP] [\fIoutfile\fP]
.EE
.PP
By default, the output is written to the default currency file described
above; this is usually what you want, because this is where
\%\f(CWunits\fR looks for the file.  If you wish, you can specify a
different filename on the command line and \%\f(CWunits_cur\fR will
write the data to that file.  If you give \%\(oq\f(CW-\fR\(cq for the file it will
write to standard output.
.PP
The following options are available:
.TP
.BR "\-\^h" ", " "\-\^\-\^help"
Print a summary of the options for \%\f(CWunits_cur\fR.
.TP
.BR "\-\^V" ", " "\-\^\-\^version"
Print the \%\f(CWunits_cur\fR version number.
.TP
.BR "\-\^v" ", " "\-\^\-\^verbose"
Give slightly more verbose output when attempting to update currency
exchange rates.
.TP
.BR "\-\^s \fIsource\fP" ", " "\-\^\-\^source \fIsource\fP"
Specify the source for currency exchange rates; currently supported
values are \%\(oq\f(CWfloatrates\fR\(cq (for FloatRates), \%\(oq\f(CWeubank\fR\(cq (for the
European Central Bank), \%\(oq\f(CWfixer\fR\(cq (for Fixer), and
\%\(oq\f(CWopenexchangerates\fR\(cq (for open exchange rates); the last two require
an API key to be given with the \%\(oq\f(CW-k\fR\(cq option.
.TP
.BR "\-\^b \fIbase\fP" ", " "\-\^\-\^base \fIbase\fP"
Set the base currency (when allowed by the site providing the data).
\fIbase\fP should be a 3-letter ISO currency code, e.g., \%\(oq\f(CWUSD\fR\(cq.
The specified currency will be the primitive currency unit used by
\%\f(CWunits\fR.  You may find it convenient to specify your local
currency.  Conversions may be more accurate and you will be able to
convert to your currency by simply hitting \fIEnter\fP at the
\%\(oq\f(CWYou\ want:\fR\(cq prompt.  This option is ignored if the source
does not allow specifying the base currency.  (Currently only
floatrates supports this option.)
.TP
.BR "\-\^k \fIkey\fP" ", " "\-\^\-\^key \fIkey\fP"
Set the API key to \fIkey\fP for sources that require it.
.IP
.SH DATABASE COMMAND SYNTAX
.TP
.BR "\fIunit\fP \fIdefinition\fP"
Define a regular unit.
.TP
.BR "\fIprefix\fP- \fIdefinition\fP"
Define a prefix.
.TP
.BR "\fIfuncname\fP(\fIvar\fP) noerror units=[\fIin\-\^units\fP,\fIout-units\fP] domain=[\fIx1\fP,\fIx2\fP] range=[\fIy1\fP,\fIy2\fP] \fIdefinition(var)\fP ; \fIinverse(funcname)\fP"
Define a nonlinear unit or unit function.  The four optional keywords \%\f(CWnoerror\fR,
\%\f(CWunits=\fR, \%\f(CWrange=\fR and \%\f(CWdomain=\fR can appear in
any order.  The definition of the inverse is optional.
.TP
.BR "\fItabname\fP[\fIout\-\^units\fP] noerror \fIpair-list\fP"
Define a piecewise linear unit.  The pair list gives the points on the
table listed in ascending order.  The \%\f(CWnoerror\fR keyword is
optional.  
.TP
.BR "!endlocale"
End a block of definitions beginning with \%\(oq\f(CW!locale\fR\(cq
.TP
.BR "!endutf8"
End a block of definitions begun with \%\(oq\f(CW!utf8\fR\(cq
.TP
.BR "!endvar"
End a block of definitions begun with \%\(oq\f(CW!var\fR\(cq or \%\(oq\f(CW!varnot\fR\(cq
.TP
.BR "!include \fIfile\fP"
Include the specified file.
.TP
.BR "!locale \fIvalue\fP"
Load the following definitions only of the locale is set to
\fIvalue\fP.
.TP
.BR "!message \fItext\fP"
Display \fItext\fP when the database is read unless the quiet
option (\%\(oq\f(CW-q\fR\(cq) is enabled.  If you omit \fItext\fP, then units
will display a blank line.  Messages will also appear in the log
file.  
.TP
.BR "!prompt \fItext\fP"
Prefix the \%\(oq\f(CWYou\ have:\fR\(cq prompt with the specified text.  If
you omit \fItext\fP, then any existing prefix is canceled.  
.TP
.BR "!set \fIvariable\fP \fIvalue\fP"
Sets the environment variable, \fIvariable\fP, to the specified
value \fIonly if\fP it is not already set.
.TP
.BR "!unitlist \fIalias\fP \fIdefinition\fP"
Define a unit list alias.
.TP
.BR "!utf8"
Load the following definitions only if \%\f(CWunits\fR is running with
UTF-8 enabled.
.TP
.BR "!var \fIenvar\fP \fIvalue\-\^list\fP"
Load the block of definitions that follows only if the environment
variable \fIenvar\fP is set to one of the values listed in the
space-separated value list.  If \fIenvar\fP is not set,
\%\f(CWunits\fR prints an error message and ignores the block of
definitions.
.TP
.BR "!varnot \fIenvar\fP \fIvalue\-\^list\fP"
Load the block of definitions that follows only if the environment
variable \fIenvar\fP is set to value that is \fInot\fP listed in the
space-separated value list.  If \fIenvar\fP is not set, \%\f(CWunits\fR
prints an error message and ignores the block of definitions.
.IP
.SH FILES
@DATAFILE@ \(em the standard units data file
.SH AUTHOR
.I units
was written by Adrian Mariano
