/* tag: primary applet header file
 *
 * Copyright (C) 2000  Andrew Chatham
 * Copyright (C) 2003  Charles Duffy
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#ifndef TICKET_APPLET_H_
#define TICKET_APPLET_H_

#include <gnome.h>
#include <panel-applet.h>
#include <panel-applet-gconf.h>

#define USER_CONFIG_KEY "user"
#define REALM_CONFIG_KEY "realm"
#define REFRESH_CONFIG_KEY "refresh"
#define COMMANDS_CONFIG_KEY "commands"

#define MIN_REFRESH (1000*60*1)

// A lot of this is taken from the code for slashapp 

typedef struct {
  PanelApplet applet;

  GtkWidget *frame;
  GtkWidget *button;
  GtkWidget *label;

  guint32 timeout;

  /* Properties */

  GtkWidget *p_box;

  guint refresh;
  gchar *user;
  gchar *realm;
  GList *cmds;

  guint p_refresh;
  gchar *p_cmds;
  GtkWidget *user_entry;
  GtkWidget *realm_entry;

  GtkWidget *cmd_list;


  /* For Password Dialog */

  GtkWidget *pass_entry;
} TicketApplet;

void change_timeout(TicketApplet *ad);
void refresh(TicketApplet *ad);

typedef struct {
  PanelAppletClass klass;
} TicketAppletClass;

#define TICKET_APPLET(o) (G_TYPE_CHECK_INSTANCE_CAST ((o), \
                          ticket_applet_get_type(),          \
                          TicketApplet))
#define TICKET_IS_APPLET(o) (G_TYPE_CHECK_INSTANCE_TYPE ((o), \
                             TICKET_TYPE_APPLET))

#endif // TICKET_APPLET_H_
