/* tag: kerberos (via Shishi) utility functions (source)
 *
 * Copyright (C) 2000  Andrew Chatham
 * Copyright (C) 2003  Charles Duffy
 * Copyright (C) 2003  Simon Josefsson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <com_err.h>
#include <config.h>

#include "krb-util.h"

#include <shishi.h>

#include <libgnome/libgnome.h>

char * progname = "ticket_applet";

#define clear_error(e) memset((char *) &e, 0, sizeof(krb_error))

static krb_error
make_error(int code)
{
  krb_error error;

  strncpy(error.message, shishi_strerror (code), 255);
  error.code = code;
  return error;
}

krb_error
krb_get_tickets(char *princ, char *pass)
{
  Shishi *sh;
  Shishi_tkt *tkt;
  Shishi_tkts_hint hint;
  char *cname;
  char *crealm;
  char *tgtname;
  int rc;

  if ((rc = shishi_init (&sh)))
    return make_error (rc);

  if ((rc = shishi_parse_name (sh, princ, &cname, &crealm)))
    return make_error (rc);

  if (cname)
    shishi_principal_default_set (sh, cname);
  if (crealm)
    shishi_realm_default_set (sh, crealm);

  asprintf (&tgtname, "krbtgt/%s", shishi_realm_default (sh));
  if (tgtname == NULL)
    return make_error (SHISHI_MALLOC_ERROR);

  memset (&hint, 0, sizeof (hint));
  hint.client = (char *) cname;
  hint.server = (char *) tgtname;
  hint.passwd = pass;
#if 0
  hint.tktflags |= SHISHI_TICKETFLAGS_RENEWABLE;
  hint.tktflags |= SHISHI_TICKETFLAGS_PROXIABLE;
  hint.tktflags |= SHISHI_TICKETFLAGS_FORWARDABLE;
#endif

  tkt = shishi_tkts_get (shishi_tkts_default (sh), &hint);
  if (!tkt)
    return make_error (/* XXX */SHISHI_ASN1_ERROR);

  shishi_done (sh);

  return make_error (SHISHI_OK);
}

krb_error
krb_time_left(int * t)
{
  Shishi *sh;
  Shishi_tkt *tkt;
  Shishi_tkts_hint hint;
  char *cname;
  char *crealm;
  char *tgtname;
  int rc;

  if ((rc = shishi_init (&sh)))
    return make_error (rc);

  asprintf (&tgtname, "krbtgt/%s", shishi_realm_default (sh));
  if (tgtname == NULL)
    return make_error (SHISHI_MALLOC_ERROR);

  memset (&hint, 0, sizeof (hint));
  hint.server = (char *) tgtname;

  tkt = shishi_tkts_find (shishi_tkts_default (sh), &hint);
  if (tkt)
    {
      *t = shishi_tkt_endctime (tkt) - time (NULL);
      if (*t < 0)
	*t = 0;
    }
  else
    return make_error (/* XXX */SHISHI_ASN1_ERROR);

  shishi_done (sh);

  return make_error (SHISHI_OK);
}

char *
krb_time_left_as_string(void)
{
  int t;
  int min,hr;
  char *msg;
  krb_error error;

  error = krb_time_left(&t);

  if (error.code) {
    msg = strdup("???");
    fprintf(stderr, "WARNING " PACKAGE ": %s\n\n",
	    error.message);
  } else {
    min = t / 60 % 60;
    hr = t / 60 / 60 % 60;
    msg = malloc(15);
    snprintf(msg, 15, " %d : %.2d ", hr, min);
  }

  return msg;
}
