.TH grops @MAN1EXT@ "@MDATE@" "groff @VERSION@"
.SH Name
grops \-
.I groff
output driver for PostScript
.
.
.\" ====================================================================
.\" Legal Terms
.\" ====================================================================
.\"
.\" Copyright 1989-2014 Free Software Foundation, Inc.
.\"           2020-2024 G. Branden Robinson
.\"
.\" Permission is granted to make and distribute verbatim copies of this
.\" manual provided the copyright notice and this permission notice are
.\" preserved on all copies.
.\"
.\" Permission is granted to copy and distribute modified versions of
.\" this manual under the conditions for verbatim copying, provided that
.\" the entire resulting derived work is distributed under the terms of
.\" a permission notice identical to this one.
.\"
.\" Permission is granted to copy and distribute translations of this
.\" manual into another language, under the above conditions for
.\" modified versions, except that this permission notice may be
.\" included in translations approved by the Free Software Foundation
.\" instead of in the original English.
.
.
.\" Save and disable compatibility mode (for, e.g., Solaris 10/11).
.do nr *groff_grops_1_man_C \n[.cp]
.cp 0
.
.\" Define fallback for groff 1.23's MR macro if the system lacks it.
.nr do-fallback 0
.if !\n(.f           .nr do-fallback 1 \" mandoc
.if  \n(.g .if !d MR .nr do-fallback 1 \" older groff
.if !\n(.g           .nr do-fallback 1 \" non-groff *roff
.if \n[do-fallback]  \{\
.  de MR
.    ie \\n(.$=1 \
.      I \%\\$1
.    el \
.      IR \%\\$1 (\\$2)\\$3
.  .
.\}
.rr do-fallback
.
.
.\" This macro definition is poor style from a portability standpoint,
.\" but it's a good test and demonstration of the standard font
.\" repertoire for the devices where it has any effect at all, and so
.\" should be retained.
.de FT
.  if '\\*(.T'ps' .ft \\$1
.  if '\\*(.T'pdf' .ft \\$1
..
.
.\" ====================================================================
.SH Synopsis
.\" ====================================================================
.
.SY grops
.RB [ \-glm ]
.RB [ \-b\~\c
.IR  brokenness-flags ]
.RB [ \-c\~\c
.IR num-copies ]
.RB [ \-F\~\c
.IR font-directory ]
.RB [ \-I\~\c
.IR inclusion-directory ]
.RB [ \-p\~\c
.IR paper-format ]
.RB [ \-P\~\c
.IR prologue-file ]
.RB [ \-w\~\c
.IR rule-thickness ]
.RI [ file\~ .\|.\|.]
.YS
.
.
.P
.SY grops
.B \-\-help
.YS
.
.
.P
.SY grops
.B \-v
.YS
.
.SY grops
.B \%\-\-version
.YS
.
.
.\" ====================================================================
.SH Description
.\" ====================================================================
.
The GNU
.I roff
PostScript output driver translates the output of
.MR @g@troff @MAN1EXT@
into PostScript.
.
Normally,
.I grops
is invoked by
.MR groff @MAN1EXT@
when the latter is given the
.RB \[lq] \-T\~ps \[rq]
option.
.
(In this installation,
.B @DEFAULT_DEVICE@
is the default output device.)
.
Use
.IR groff 's
.B \-P
option to pass any options shown above to
.IR grops .
.
If no
.I file
arguments are given,
or if
.I file
is \[lq]\-\[rq],
.I grotty
reads the standard input stream.
.
It writes to the standard output stream.
.
.
.P
When called with multiple
.I file
arguments,
.I grops
doesn't produce a valid document structure
(one conforming to the Document Structuring Conventions).
.
To print such catenated output,
it is necessary to deactivate DSC handling in the printing program or
previewer.
.
.
.P
See section \[lq]Font installation\[rq] below for a guide to installing
fonts for
.IR grops .
.
.
.\" ====================================================================
.SH Options
.\" ====================================================================
.
.B \-\-help
displays a usage message,
while
.B \-v
and
.B \%\-\-version
show version information;
all exit afterward.
.
.
.TP 8n \" "-F dir" + 2n
.BI \-b\~ n
Work around problems with spoolers,
previewers,
and older printers.
.
Normally,
.I grops
produces output at PostScript \%LanguageLevel\~2 that conforms to
version 3.0 of the Document Structuring Conventions.
.
Some software and devices can't handle such a data stream.
.
The value
.RI of\~ n
determines what
.I grops
does to make its output acceptable to such consumers.
.
If
.I n
is
.BR 0 ,
.I grops
employs no workarounds,
which is the default;
it can be changed by modifying the
.B broken
directive in
.IR grops 's
.I DESC
file.
.
.
.IP
Add\~1 to suppress generation of
.B %%Begin\%Document\%Setup
and
.B %%End\%Document\%Setup
comments;
this is needed for early versions of TranScript that get confused by
anything between the
.B %%End\%Prolog
comment and the first
.B %%Page
comment.
.
.
.IP
Add\~2 to omit lines in included files beginning with
.BR %!\& ,
which confuse Sun's
.I pageview
previewer.
.
.
.IP
Add\~4 to omit lines in included files beginning with
.BR %%Page ,
.B %%Trailer
and
.BR %%End\%Prolog ;
this is needed for spoolers that don't understand
.B %%Begin\%Document
and
.B %%End\%Document
comments.
.
.
.IP
Add\~8 to write
.B %!PS\-Adobe\-2.0
rather than
.B %!PS\-Adobe\-3.0
as the first line of the PostScript output;
this is needed when using Sun's Newsprint with a printer that requires
page reversal.
.
.
.IP
Add\~16 to omit media size information
(that is,
output neither a
.B %%Document\%Media
comment nor the
.B setpagedevice
PostScript command).
.
This was the behavior of
.I groff
1.18.1 and earlier;
it is
needed for older printers that don't understand PostScript
\%LanguageLevel\~2,
and is also necessary if the output is further processed to produce an
EPS file;
see subsection \[lq]Escapsulated PostScript\[rq] below.
.
.
.TP
.BI \-c\~ n
Output
.I n
copies of each page.
.
.
.TP
.BI \-F\~ dir
Prepend directory
.RI dir /dev name
to the search path for
font and device description and PostScript prologue files;
.I name
is the name of the device,
usually
.BR ps .
.
.
.TP
.B \-g
Generate PostScript code to guess the page length.
.
The guess is correct only if the imageable area is vertically centered
on the page.
.
This option allows you to generate documents that can be printed on both
U.S.\& letter and A4 paper formats without change.
.
.
.TP
.BI \-I\~ dir
Search the directory
.I dir
for files named in
.B \[rs]X\[aq]ps: file\[aq]
and
.B \[rs]X\[aq]ps: import\[aq]
escape sequences.
.
.B \-I
may be specified more than once;
each
.I dir
is searched in the given order.
.
To search the current working directory before others,
add
.RB \[lq] "\-I .\&" \[rq]
at the desired place;
it is otherwise searched last.
.
.
.TP
.B \-l
Use landscape orientation rather than portrait.
.
.
.TP
.B \-m
Turn on manual feed for the document.
.
.
.TP
.BI \-p\~ fmt
Set physical dimensions of output medium,
overriding the
.BR \%papersize ,
.BR \%paperlength ,
and
.B \%paperwidth
directives in the
.I DESC
file.
.
.I fmt
can be any argument accepted by the
.B \%papersize
directive;
see
.MR groff_font @MAN5EXT@ .
.
.
.TP
.BI \-P\~ prologue
Use the file
.IR prologue ,
sought in the
.I groff
font search path,
as the PostScript prologue,
overriding the default
(see section \[lq]Files\[rq] below)
and the environment variable
.I GROPS_PROLOGUE.
.
.
.TP
.BI \-w\~ n
Draw rules (lines) with a thickness of
.IR n \~thousandths
of an em.
.
The default thickness is
.B 40
(0.04\~em).
.
.
.\" ====================================================================
.SH Usage
.\" ====================================================================
.
The input to
.I grops
must be in the format output by
.MR @g@troff @MAN1EXT@ ,
described in
.MR groff_out @MAN5EXT@ .
.
In addition,
the device and font description files for the device used must meet
certain requirements.
.
The device resolution must be an integer multiple of\~72 times the
.BR sizescale .
.
The device description file must contain a valid paper format;
see
.MR groff_font @MAN5EXT@ .
.
Each font description file must contain a directive
.
.RS
.EX
.RI internalname\~ psname
.EE
.RE
.
which says that the PostScript name of the font is
.IR psname .
.
.
.P
A font description file may also contain a directive
.
.RS
.EX
.RI encoding\~ enc-file
.EE
.RE
.
which says that
the PostScript font should be reencoded using the encoding described in
.IR enc-file ;
this file should consist of a sequence of lines of the form
.
.
.RS
.EX
.I pschar code
.EE
.RE
.
where
.I pschar
is the PostScript name of the character,
and
.I code
is its position in the encoding expressed as a decimal integer;
valid values are in the range 0 to\~255.
.
Lines starting with
.B #
and blank lines are ignored.
.
The code for each character given in the font description file must
correspond to the code for the character in encoding file,
or to the code in the default encoding for the font if the PostScript
font is not to be reencoded.
.
This code can be used with the
.B \[rs]N
escape sequence in
.I @g@troff
to select the character,
even if it does not have a
.I groff
glyph name.
.
Every character in the font description file must exist in the
PostScript font,
and the widths given in the font description file must match the widths
used in the PostScript font.
.
.I grops
assumes that a character with a
.I groff
name of
.B space
is blank
(makes no marks on the page);
it can make use of such a character to generate more efficient and
compact PostScript output.
.
.
.P
.I grops
is able to display all glyphs in a PostScript font;
it is not limited to 256 of them.
.
.I enc-file
(or the default encoding if no encoding file is specified)
just defines the
order of glyphs for the first 256 characters;
all other glyphs are accessed with additional encoding vectors which
.I grops
produces on the fly.
.
.
.P
.I grops
can embed fonts in a document that are necessary to render it;
this is called \[lq]downloading\[rq].
.
Such fonts must be in PFA format.
.
Use
.MR pfbtops @MAN1EXT@
to convert a Type\~1 font in PFB format.
.
Downloadable fonts must be listed a
.I download
file containing lines of the form
.
.RS
.EX
.I psname file
.EE
.RE
.
where
.I psname
is the PostScript name of the font,
and
.I file
is the name of the file containing it.
.
Blank lines and those
beginning with
.B #
are ignored;
fields are separated by tabs.
.
.I file
is sought using the same mechanism as for
.I groff
font description files.
.
The
.I download
file itself is as well;
currently,
the first matching file found in the device and font description search
path is used.
.
.
.P
If the file containing a downloadable font or imported document
conforms to the Adobe Document Structuring Conventions,
then
.I grops
interprets any comments in the files sufficiently to ensure that its
own output is conforming.
.
It also supplies any needed font resources that are listed in the
.I download
file
as well as any needed file resources.
.
It is also able to handle inter-resource dependencies.
.
For example,
suppose that you have a downloadable font called Garamond,
and also a downloadable font called Garamond-Outline which depends on
Garamond
(typically it would be defined to copy Garamond's font dictionary,
and change the PaintType),
then it is necessary for Garamond to appear before Garamond-Outline in
the PostScript document.
.
.I grops
handles this automatically provided that the downloadable font file
for Garamond-Outline indicates its dependence on Garamond by means of
the Document Structuring Conventions,
for example by beginning with the following lines.
.
.RS
.EX
%!PS\-Adobe\-3.0 Resource\-Font
%%DocumentNeededResources: font Garamond
%%EndComments
%%IncludeResource: font Garamond
.EE
.RE
.
In this case,
both Garamond and Garamond-Outline would need to be listed
in the
.I download
file.
.
A downloadable font should not include its own name in a
.B %%Document\%Supplied\%Resources
comment.
.
.
.P
.I grops
does not interpret
.B %%Document\%Fonts
comments.
.
The
.BR %%Document\%Needed\%Resources ,
.BR %%Document\%Supplied\%Resources ,
.BR %%Include\%Resource ,
.BR %%Begin\%Resource ,
and
.B %%End\%Resource
comments
(or possibly the old
.BR %%Document\%Needed\%Fonts ,
.BR %%Document\%Supplied\%Fonts ,
.BR %%Include\%Font ,
.BR %%Begin\%Font ,
and
.B %%End\%Font
comments)
should be used.
.
.
.P
The default stroke and fill colors are black.
.
For colors defined in the \[lq]rgb\[rq] color space,
.B setrgbcolor
is used;
for \[lq]cmy\[rq] and \[lq]cmyk\[rq],
.BR setcmykcolor ;
and for \[lq]gray\[rq],
.BR setgray .
.
.B setcmykcolor
is a PostScript \%LanguageLevel\~2 command and thus not available on
some older printers.
.
.
.\" ====================================================================
.SS Typefaces
.\" ====================================================================
.
Styles called
.BR R ,
.BR I ,
.BR B ,
and
.B BI
mounted at font positions 1 to\~4.
.
Text fonts are grouped into families
.BR A ,
.BR BM ,
.BR C ,
.BR H ,
.BR HN ,
.BR N ,
.BR P ,
.RB and\~ T ,
each having members in each of these styles.
.
.
.RS
.TP 8n \" BMBI + 2n + hand-tuned for PDF
.B AR
.FT AR
AvantGarde-Book
.FT
.
.TQ
.B AI
.FT AI
AvantGarde-BookOblique
.FT
.
.TQ
.B AB
.FT AB
AvantGarde-Demi
.FT
.
.TQ
.B ABI
.FT ABI
AvantGarde-DemiOblique
.FT
.
.TQ
.B BMR
.FT BMR
Bookman-Light
.FT
.
.TQ
.B BMI
.FT BMI
Bookman-LightItalic
.FT
.
.TQ
.B BMB
.FT BMB
Bookman-Demi
.FT
.
.TQ
.B BMBI
.FT BMBI
Bookman-DemiItalic
.FT
.
.TQ
.B CR
.FT CR
Courier
.FT
.
.TQ
.B CI
.FT CI
Courier-Oblique
.FT
.
.TQ
.B CB
.FT CB
Courier-Bold
.FT
.
.TQ
.B CBI
.FT CBI
Courier-BoldOblique
.FT
.
.TQ
.B HR
.FT HR
Helvetica
.FT
.
.TQ
.B HI
.FT HI
Helvetica-Oblique
.FT
.
.TQ
.B HB
.FT HB
Helvetica-Bold
.FT
.
.TQ
.B HBI
.FT HBI
Helvetica-BoldOblique
.FT
.
.TQ
.B HNR
.FT HNR
Helvetica-Narrow
.FT
.
.TQ
.B HNI
.FT HNI
Helvetica-Narrow-Oblique
.FT
.
.TQ
.B HNB
.FT HNB
Helvetica-Narrow-Bold
.FT
.
.TQ
.B HNBI
.FT HNBI
Helvetica-Narrow-BoldOblique
.FT
.
.TQ
.B NR
.FT NR
NewCenturySchlbk-Roman
.FT
.
.TQ
.B NI
.FT NI
NewCenturySchlbk-Italic
.FT
.
.TQ
.B NB
.FT NB
NewCenturySchlbk-Bold
.FT
.
.TQ
.B NBI
.FT NBI
NewCenturySchlbk-BoldItalic
.FT
.
.TQ
.B PR
.FT PR
Palatino-Roman
.FT
.
.TQ
.B PI
.FT PI
Palatino-Italic
.FT
.
.TQ
.B PB
.FT PB
Palatino-Bold
.FT
.
.TQ
.B PBI
.FT PBI
Palatino-BoldItalic
.FT
.
.TQ
.B TR
.FT TR
Times-Roman
.FT
.
.TQ
.B TI
.FT TI
Times-Italic
.FT
.
.TQ
.B TB
.FT TB
Times-Bold
.FT
.
.TQ
.B TBI
.FT TBI
Times-BoldItalic
.FT
.RE
.
.
.br
.ne 3v
.P
Another text font is not a member of a family.
.
.
.RS
.TP 8n \" BMBI (above) + 2n + hand-tuned for PDF
.B ZCMI
.FT ZCMI
ZapfChancery-MediumItalic
.FT
.RE
.
.
.P
Special fonts include
.BR S ,
the PostScript Symbol font;
.BR ZD ,
Zapf Dingbats;
.B SS
(slanted symbol),
which contains oblique forms of lowercase Greek letters derived from
Symbol;
.BR EURO ,
which offers a Euro glyph for use with old devices lacking it;
and
.BR ZDR ,
a reversed version of Zapf Dingbats
(with symbols flipped about the vertical axis).
.
Most glyphs in these fonts are unnamed and must be accessed using
.BR \[rs]N .
.
The last three are not standard PostScript fonts,
but supplied by
.I groff
and therefore included in the default
.I download
file.
.
.
.P
.I grops
furthermore supports a naming scheme for East Asian typefaces
shared with
.MR grohtml @MAN1EXT@ ,
.MR gropdf @MAN1EXT@ ,
and
.MR grotty @MAN1EXT@ .
.
.
.RS
.TP
.B CSH
Simplified Chinese,
Hei style
.
.TQ
.B CSS
Simplified Chinese,
Song style
.
.TQ
.B CTH
Traditional Chinese,
Hei style
.
.TQ
.B CTS
Traditional Chinese,
Song style
.
.TQ
.B JPG
Japanese,
Gothic style
.
.TQ
.B JPM
Japanese,
Mincho style
.
.TQ
.B KOG
Korean,
Gothic style
.
.TQ
.B KOM
Korean,
Mincho style
.RE
.
.
.\" ====================================================================
.SS "Device extension commands"
.\" ====================================================================
.
.I grops
recognizes device extension commands produced by the
.I groff
request
.B \%device
or
.I roff
.B \[rs]X
escape sequence,
but interprets only those that begin with a
.RB \[lq] ps: \[rq]
tag.
.
.
.TP
.BI "\[rs]X\[aq]ps: exec\~" code \[aq]
.RS
Execute the arbitrary PostScript commands
.IR code .
.
The PostScript
.I \%currentpoint
is set to the
.I groff
drawing position when the
.B \[rs]X
escape sequence is interpreted before executing
.IR code .
.
The origin is at the top left corner of the page;
.IR x \~coordinates
increase to the right,
and
.IR y \~coordinates
down the page.
.
A
.RB procedure\~ u
is defined that converts
.I groff
basic units to the coordinate system in effect
(provided the user doesn't change the scale).
.
For example,
.
.RS
.EX
\&.nr x 1i
\[rs]X\[aq]ps: exec \[rs]nx u 0 rlineto stroke\[aq]
.EE
.RE
.
draws a horizontal line one inch long.
.
.I code
may make changes to the graphics state,
but any changes persist only to the end of the page.
.
A dictionary containing the definitions specified by the
.B def
and
.B mdef
commands is on top of the dictionary stack.
.
If your code adds definitions to this dictionary,
you should allocate space for them using
.RB \[lq] "\[rs]X\[aq]ps:\~mdef\~"
.IB n \[aq]\c
\[rq].
.
Any definitions persist only until the end of the page.
.
If you use the
.B \[rs]Y
escape sequence with an argument that names a macro,
.I code
can extend over multiple lines.
.
For example,
.
.RS
.EX
\&.nr x 1i
\&.de y
\&ps: exec
\&\[rs]nx u 0 rlineto
\&stroke
\&..
\&\[rs]Yy
.EE
.RE
.
is another way to draw a horizontal line one inch long.
.
The single backslash before
.RB \[lq] nx \[rq]\[em]the
only reason to use a register while defining the macro
.RB \[lq] y \[rq]\[em]is
to convert a user-specified dimension
.RB \[lq] 1i \[rq]
to
.I groff
basic units which are in turn converted to PostScript units with the
.B u
procedure.
.
.
.br
.ne 3v
.P
.I grops
wraps user-specified PostScript code into a dictionary,
nothing more.
.
In particular,
it doesn't start and end the inserted code with
.B save
and
.BR restore ,
respectively.
.
This must be supplied by the user,
if necessary.
.RE
.
.
.TP
.BI "\[rs]X\[aq]ps: file\~" name \[aq]
This is the same as the
.B exec
command except that the PostScript code is read from file
.IR name .
.
.
.TP
.BI "\[rs]X\[aq]ps: def\~" code \[aq]
Place a PostScript definition contained in
.I code
in the prologue.
.
There should be at most one definition per
.B \[rs]X
command.
.
Long definitions can be split over several
.B \[rs]X
commands;
all the
.I code
arguments are simply joined together separated by newlines.
.
The definitions are placed in a dictionary which is automatically
pushed on the dictionary stack when an
.B exec
command is executed.
.
If you use the
.B \[rs]Y
escape sequence with an argument that names a macro,
.I code
can extend over multiple lines.
.
.
.TP
.BI "\[rs]X\[aq]ps: mdef\~" "n code" \[aq]
Like
.BR def ,
except that
.I code
may contain up to
.IR n \~definitions.
.
.I grops
needs to know how many definitions
.I code
contains
so that it can create an appropriately sized PostScript dictionary
to contain them.
.
.
.TP
.BI "\[rs]X\[aq]ps: import\~" "file llx lly urx ury width\~"\c
.RI [ height ]\c
.B \[aq]
Import a PostScript graphic from
.IR file .
.
The arguments
.IR llx ,
.IR lly ,
.IR urx ,
and
.I ury
give the bounding box of the graphic in the default PostScript
coordinate system.
.
They should all be integers:
.I llx
and
.I lly
are the
.I x
and
.IR y \~coordinates
of the lower left corner of the graphic;
.I urx
and
.I ury
are the
.I x
and
.IR y \~coordinates
of the upper right corner of the graphic;
.I width
and
.I height
are integers that give the desired width and height in
.I groff
basic units of the graphic.
.
.
.IP
The graphic is scaled so that it has this width and height
and translated so that the lower left corner of the graphic is
located at the position associated with
.B \[rs]X
command.
.
If the height argument is omitted it is scaled uniformly in the
.I x
and
.IR y \~axes
so that it has the specified width.
.
.
.IP
The contents of the
.B \[rs]X
command are not interpreted by
.IR @g@troff ,
so vertical space for the graphic is not automatically added,
and the
.I width
and
.I height
arguments are not allowed to have attached scaling indicators.
.
.
.IP
If the PostScript file complies with the Adobe Document Structuring
Conventions and contains a
.B %%Bounding\%Box
comment,
then the bounding box can be automatically extracted from within
.I groff
input by using the
.B psbb
request.
.
.
.IP
See
.MR groff_tmac @MAN5EXT@
for a description of the
.B PSPIC
macro which provides a convenient high-level interface for inclusion of
PostScript graphics.
.
.
.TP
.B \[rs]X\[aq]ps: invis\[aq]
.TQ
.B \[rs]X\[aq]ps: endinvis\[aq]
No output is generated for text and drawing commands
that are bracketed with these
.B \[rs]X
commands.
.
These commands are intended for use when output from
.I @g@troff
is previewed before being processed with
.IR grops ;
if the previewer is unable to display certain characters
or other constructs,
then other substitute characters or constructs can be used for
previewing by bracketing them with these
.B \[rs]X
commands.
.
.
.RS
.P
For example,
.I \%gxditview
is not able to display a proper
.B \[rs][em]
character because the standard X11 fonts do not provide it;
this problem can be overcome with the following request.
.
.
.IP
.EX
\&.char \[rs][em] \[rs]X\[aq]ps: invis\[aq]\[rs]
\[rs]Z\[aq]\[rs]v\[aq]-.25m\[aq]\[rs]h\[aq].05m\[aq]\c
\[rs]D\[aq]l .9m 0\[aq]\[rs]h\[aq].05m\[aq]\[aq]\[rs]
\[rs]X\[aq]ps: endinvis\[aq]\[rs][em]
.EE
.
.
.P
In this case,
.I \%gxditview
is unable to display the
.B \[rs][em]
character and draws the line,
whereas
.I grops
prints the
.B \[rs][em]
character
and ignores the line
(this code is already in file
.IR Xps.tmac ,
which is loaded if a document intended for
.I grops
is previewed with
.IR \%gxditview ).
.RE
.
.
.br
.ne 3v
.P
If a PostScript procedure
.B BPhook
has been defined via a
.RB \[lq] "ps:\~def" \[rq]
or
.RB \[lq] "ps:\~mdef" \[rq]
device extension command,
it is executed at the beginning of every page
(before anything is drawn or written by
.IR groff ).
.
For example,
to underlay the page contents with the word \[lq]DRAFT\[rq] in light
gray,
you might use the following.
.
.RS
.EX
\&.de XX
ps: def
/BPhook
{ gsave .9 setgray clippath pathbbox exch 2 copy
  .5 mul exch .5 mul translate atan rotate pop pop
  /NewCenturySchlbk-Roman findfont 200 scalefont setfont
  (DRAFT) dup stringwidth pop \-.5 mul \-70 moveto show
  grestore }
def
\&..
\&.devicem XX
.EE
.RE
.
.
.P
Or,
to cause lines and polygons to be drawn with square linecaps and mitered
linejoins instead of the round linecaps and linejoins normally used by
.IR grops ,
use the following.
.
.RS
.EX
\&.de XX
ps: def
/BPhook { 2 setlinecap 0 setlinejoin } def
\&..
\&.devicem XX
.EE
.RE
.
(Square linecaps,
as opposed to butt linecaps
.RB (\[lq] "0 setlinecap" \[rq]),
give true corners in boxed tables even though the lines are drawn
unconnected.)
.
.
.\" ====================================================================
.SS "Encapsulated PostScript"
.\" ====================================================================
.
.I grops
itself doesn't emit bounding box information.
.
The following script,
.IR groff2eps ,
produces an EPS file.
.
.
.RS
.P
.EX
#!/bin/sh
groff \-P\-b16 "$1" > "$1".ps
gs \-dNOPAUSE \-sDEVICE=bbox \-\- "$1".ps 2> "$1".bbox
sed \-e "/\[ha]%%Orientation/r $1.bbox" \[rs]
    \-e "/\[ha]%!PS\-Adobe\-3.0/s/$/ EPSF\-3.0/" "$1".ps > "$1".eps
rm "$1".ps "$1".bbox
.EE
.RE
.
.
.P
You can then use
.RB \[lq] "groff2eps foo" \[rq]
to convert file
.I foo
to
.IR foo.eps .
.
.
.\" ====================================================================
.SS "TrueType and other font formats"
.\" ====================================================================
.
To use TrueType fonts with
.IR grops ,
convert them first to Type\~42 format,
a PostScript wrapper equivalent to the PFA format described in
.MR pfbtops @MAN1EXT@ .
.
Several methods exist to generate a Type\~42 wrapper;
some of them involve the use of a PostScript interpreter such as
Ghostscript\[em]see
.MR gs 1 .
.
.
.P
.UR https://fontforge.org/
FontForge
.UE
converts most outline font formats.
.
Here's how we'd set up Roboto Slab Serif for use with
.IR groff .
.
.
.RS 4
.P
.EX
MAP=@FONTDIR@/devps/generate/text.map
TTF=/usr/share/fonts/truetype/roboto/slab/RobotoSlab\-Regular.ttf
BASE=$(basename \[dq]$TTF\[dq])
INT=${BASE%.ttf}
PFA=$INT.pfa
AFM=$INT.afm
GFN=RSR
DIR=$HOME/.local/groff/font
mkdir \-p \[dq]$DIR\[dq]/devps
fontforge \-lang=ff \-c \[dq]Open(\[rs]\[dq]$TTF\[rs]\[dq]);\[rs]
\tGenerate(\[rs]\[dq]$DIR/devps/$PFA\[rs]\[dq]);\[dq]
afmtodit \[dq]$DIR/devps/$AFM\[dq] \[dq]$MAP\[dq] \
\[dq]$DIR/devps/$GFN\[dq]
printf \[dq]$BASE\[rs]t$PFA\[rs]n\[dq] >> \[dq]$DIR/devps/download\[dq]
.EE
.RE
.
.
.P
.I fontforge
and
.I afmtodit
may produce warnings depending on font file attributes.
.
Test the font as follows.
.
.
.RS 4
.P
.EX
printf \[dq].ft RSR\[rs]nHello, world!\[rs]n\[dq] | groff \-F \
\[dq]$DIR\[dq] > hello.ps
.EE
.RE
.
.
.P
Once you're satisfied that the font works,
you may want to generate any available related styles
(for instance,
Roboto Slab
also has \[lq]Bold\[rq],
\[lq]Light\[rq],
and
\[lq]Thin\[rq]
styles)
and set up
.I GROFF_FONT_PATH
in your environment to include the directory you keep the generated
fonts in so that you don't have to use the
.B \-F
option.
.
.
.\" ====================================================================
.SH "Font installation"
.\" ====================================================================
.
The following is a step-by-step font installation guide for
.I grops.
.
.
.IP \[bu] 3n
Convert your font to something
.I groff
understands.
.
This is a PostScript Type\~1 font in PFA format or a PostScript
Type\~42 font,
together with an AFM file.
.
A PFA file begins as follows.
.
.RS
.RS \" two RS calls to get inboard of IP indentation
.EX
%!PS\-AdobeFont\-1.0:
.EE
.RE
.
A PFB file contains this string as well,
preceded by some non-printing bytes.
.
If your font is in PFB format,
use
.IR groff 's
.MR pfbtops @MAN1EXT@
program to convert it to PFA.
.
For TrueType and other font formats,
we recommend
.IR fontforge ,
which can convert most outline font formats.
.
A Type\~42 font file begins as follows.
.
.RS
.EX
%!PS\-TrueTypeFont
.EE
.RE
.
This is a wrapper format for TrueType fonts.
.
Old PostScript printers might not support them
(that is,
they might not have a built-in TrueType font interpreter).
.
In the following steps,
we will consider the use of CTAN's
.UR https://\:ctan.org/\:tex\-archive/\:fonts/\:brushscr
BrushScriptX-Italic
.UE
font in PFA format.
.RE \" now restore left margin
.
.
.IP \[bu]
Convert the AFM file to a
.I groff
font description file with the
.MR afmtodit @MAN1EXT@
program.
.
For instance,
.
.RS
.RS \" two RS calls to get inboard of IP indentation
.EX
$ \c
.B afmtodit BrushScriptX\-Italic.afm text.map BSI
.EE
.RE
.
converts the Adobe Font Metric file
.I BrushScriptX\-Italic.afm
to the
.I groff
font description file
.IR BSI .
.RE \" now restore left margin
.
.
.IP
If you have a font family which provides regular upright (roman),
bold,
italic,
and
bold-italic styles
(where \[lq]italic\[rq] may be \[lq]oblique\[rq] or \[lq]slanted\[rq]),
we recommend using the letters
.BR R ,
.BR B ,
.BR I ,
and
.BR BI ,
respectively,
as suffixes to the
.I groff
font family name to enable
.IR groff 's
font family and style selection features.
.
An example is
.IR groff 's
built-in support for Times:
the font family
name is abbreviated as
.BR T ,
and the
.I groff
font names are therefore
.BR TR ,
.BR TB ,
.BR TI ,
and
.BR TBI .
.
In our example,
however,
the BrushScriptX font is available in a single style only,
italic.
.
.
.IP \[bu]
Install the
.I groff
font description file(s) in a
.I devps
subdirectory in the search path that
.I groff
uses for device and font file descriptions.
.
See the
.I GROFF_FONT_PATH
entry in section \[lq]Environment\[rq] of
.MR @g@troff @MAN1EXT@
for the current value of the font search path.
.
While
.I groff
doesn't directly use AFM files,
it is a good idea to store them alongside its font description files.
.
.
.IP \[bu]
Register fonts in the
.I devps/download
file so they can be located for embedding in PostScript files
.I grops
generates.
.
Only the first
.I download
file encountered in the font search path is read.
.
If in doubt,
copy the default
.I download
file
(see section \[lq]Files\[rq] below)
to the first directory in the font search path and add your fonts there.
.
The PostScript font name used by
.I grops
is stored in the
.B internalname
field in the
.I groff
font description file.
.
(This name does not necessarily resemble the font's file name.)
.
We add the following line to
.IR download .
.
.RS
.RS \" two RS calls to get inboard of IP indentation
.EX
BrushScriptX\-Italic\[->]BrushScriptX\-Italic.pfa
.EE
.RE \" but only one to get back to it
.
A tab character,
depicted as \[->],
separates the fields.
.RE \" now restore left margin
.
.
.IP \[bu]
Test the selection and embedding of the new font.
.
.RS
.RS \" two RS calls to get inboard of IP indentation
.EX
printf "\[rs]\[rs]f[BSI]Hello, world!\[rs]n" \
| groff \-T ps >hello.ps
see hello.pdf
.EE
.RE
.RE \" now restore left margin
.
.
.\" ====================================================================
.SH "Old fonts"
.\" ====================================================================
.
.I groff
versions 1.19.2 and earlier contained descriptions of a slightly
different set of the base 35 PostScript level 2 fonts defined by Adobe.
.
The older set has 314 glyphs and a larger set of kerning pairs;
the newer one has only 229 glyphs,
but includes the Euro sign.
.
For backward compatibility,
these old font descriptions are also installed in the
.I @OLDFONTDIR@/\:\%devps
directory.
.
.
.P
To use them,
make sure that
.I grops
finds the fonts before the default system fonts
(with the same names):
either give
.I grops
the
.B \-F
command-line option,
.
.RS
.EX
$ \c
.B groff \-Tps \-P\-F \-P@OLDFONTDIR@ \c
\&.\|.\|.
.EE
.RE
.
or add the directory to
.IR groff 's
font and device description search path environment variable,
.
.RS
.EX
$ \c
.B GROFF_FONT_PATH=\:@OLDFONTDIR@ \[rs]
.RS
.B groff \-Tps \c
\&.\|.\|.
.RE
.EE
.RE
.
when the command runs.
.
.
.\" ====================================================================
.SH "Exit status"
.\" ====================================================================
.
.I \%grops
exits with
.RB status\~ 0
on successful operation,
.RB status\~ 2
if the program cannot interpret its command-line arguments,
and
.RB status\~ 1
if it encounters an error during operation.
.
.
.br
.ne 3v
.\" ====================================================================
.SH Environment
.\" ====================================================================
.
.TP
.I GROFF_FONT_PATH
A list of directories in which to seek the selected output device's
directory of device and font description files.
.
See
.MR @g@troff @MAN1EXT@
and
.MR groff_font @MAN5EXT@ .
.
.
.TP
.I GROPS_PROLOGUE
If this is set to
.IR foo ,
then
.I grops
uses the file
.I foo
(in the font path) instead of the default prologue file
.IR prologue .
.
The option
.B \-P
overrides this environment variable.
.
.
.TP
.I SOURCE_DATE_EPOCH
A timestamp
(expressed as seconds since the Unix epoch)
to use as the output creation timestamp in place of the current time.
.
The time is converted to human-readable form using
.MR gmtime 3
and
.MR asctime 3 ,
and recorded in a PostScript comment.
.
.
.TP
.I TZ
The time zone to use when converting the current time to human-readable form;
see
.MR tzset 3 .
If
.I SOURCE_DATE_EPOCH
is used, it is always converted to human-readable form using UTC.
.
.
.\" ====================================================================
.SH Files
.\" ====================================================================
.
.TP
.I @FONTDIR@/\:\%devps/\:DESC
describes the
.B ps
output device.
.
.
.TP
.IR @FONTDIR@/\:\%devps/ F
describes the font known
.RI as\~ F
on device
.BR ps .
.
.
.TP
.I @FONTDIR@/\:\%devps/\:\%download
lists fonts available for embedding within the PostScript document
(or download to the device).
.
.
.TP
.I @FONTDIR@/\:\%devps/\:\%prologue
is the default PostScript prologue prefixed to every output file.
.
.
.TP
.I @FONTDIR@/\:\%devps/\:text.enc
describes the encoding scheme used by most PostScript Type\~1 fonts;
the
.B \%encoding
directive of
font description files for the
.B ps
device refers to it.
.
.
.TP
.I @MACRODIR@/\:ps.tmac
defines macros for use with the
.B ps
output device.
.
It is automatically loaded by
.I troffrc
when the
.B ps
output device is selected.
.
.
.TP
.I @MACRODIR@/\:pspic.tmac
defines the
.B PSPIC
macro for embedding images in a document;
see
.MR groff_tmac @MAN5EXT@ .
.
It is automatically loaded by
.I troffrc.
.
.
.TP
.I @MACRODIR@/psold.tmac
provides replacement glyphs for text fonts that lack complete coverage
of the ISO\~Latin-1 character set;
using it,
.I groff
can produce glyphs like eth (\[Sd]) and thorn (\[Tp]) that older
PostScript printers do not natively support.
.
.
.P
.I grops
creates temporary files using the template
.RI \[lq] grops XXXXXX\[rq];
see
.MR groff @MAN1EXT@ .
.
.
.\" ====================================================================
.SH "See also"
.\" ====================================================================
.
.UR http://\:partners\:.adobe\:.com/\:public/\:developer/\:en/\:ps/\
\:5001\:.DSC_Spec\:.pdf
PostScript Language Document Structuring Conventions Specification
.UE
.
.
.P
.MR afmtodit @MAN1EXT@ ,
.MR groff @MAN1EXT@ ,
.MR @g@troff @MAN1EXT@ ,
.MR pfbtops @MAN1EXT@ ,
.MR groff_char @MAN7EXT@ ,
.MR groff_font @MAN5EXT@ ,
.MR groff_out @MAN5EXT@ ,
.MR groff_tmac @MAN5EXT@
.
.
.\" Clean up.
.rm FT
.
.\" Restore compatibility mode (for, e.g., Solaris 10/11).
.cp \n[*groff_grops_1_man_C]
.do rr *groff_grops_1_man_C
.
.
.\" Local Variables:
.\" fill-column: 72
.\" mode: nroff
.\" End:
.\" vim: set filetype=groff textwidth=72:
