.TH @g@chem @MAN1EXT@ "@MDATE@" "groff @VERSION@"
.SH Name
@g@chem \- embed chemical structure diagrams in
.I groff
documents
.
.
.\" ====================================================================
.\" Legal Terms
.\" ====================================================================
.\"
.\" Copyright (C) 2006-2020 Free Software Foundation, Inc.
.\"
.\" This file is part of chem, which is part of groff, a free software
.\" project.
.\"
.\" You can redistribute it and/or modify it under the terms of the GNU
.\" General Public License version 2 (GPL2) as published by the Free
.\" Software Foundation.
.\"
.\" The license text for GPL2 is available in the internet at
.\" <http://www.gnu.org/licenses/gpl-2.0.html>.
.
.
.\" Save and disable compatibility mode (for, e.g., Solaris 10/11).
.do nr *groff_chem_1_man_C \n[.cp]
.cp 0
.
.\" Define fallback for groff 1.23's MR macro if the system lacks it.
.de @@
.  de MR
.    ie \n(.$=1 \
.      I %\$1
.    el \
.      IR %\$1 (\$2)\$3
.  \\.
..
.if  \n(.g .if !d MR .@@
.if !\n(.g .@@
.rm @@
.
.
.\" ====================================================================
.SH Synopsis
.\" ====================================================================
.
.SY @g@chem
.RB [ \-\- ]
.RI [ file\~ .\|.\|.]
.YS
.
.
.SY @g@chem
.B \-h
.
.SY @g@chem
.B \-\-help
.YS
.
.
.SY @g@chem
.B \-v
.
.SY @g@chem
.B \-\-version
.YS
.
.
.\" ====================================================================
.SH Description
.\" ====================================================================
.
.I chem
produces chemical structure diagrams.
.
Today's version is best suited for organic chemistry (bonds, rings).
.
The
.I @g@chem
program is a
.I groff
preprocessor like
.IR @g@eqn ,
.IR @g@pic ,
.IR @g@tbl ,
etc.
.
It generates
.I pic
output such that all
.I chem
parts are translated into diagrams of the
.I pic
language.
.
.
.P
If no operands are given,
or if
.I file
is
.RB \[lq] \- \[rq],
.I @g@chem
reads the standard input stream.
.
.B \-h
and
.B \-\-help
display a usage message,
whereas
.B \-v
and
.B \-\-version
display version information;
all exit.
.
.
.P
The program
.I @g@chem
originates from the Perl source file
.IR chem.pl .
.
It tells
.I @g@pic
to include a copy of the macro file
.IR chem.pic .
.
Moreover the
.I groff
source file
.I pic.tmac
is loaded.
.
.
.P
In a style reminiscent of
.I eqn
and
.IR pic ,
the
.I chem
diagrams are written in a special language.
.
.
.P
A set of
.I chem
lines looks like this
.
.
.IP
.EX
\&.cstart
.I chem data
\&.cend
.EE
.
.
.P
Lines containing the keywords
.B .cstart
and
.B .cend
start and end the input for
.IR @g@chem ,
respectively.
.
In
.I pic
context, i.e., after the call of
.BR .PS ,
.I chem
input can optionally be started by the line
.B \%begin\~chem
and ended by the line with the single word
.B end
instead.
.
.
.P
Anything outside these initialization lines is copied through
without modification;
all data between the initialization lines is converted into
.I pic
commands to draw the diagram.
.
.
.P
As an example,
.
.IP
.EX
\&.cstart
CH3
bond
CH3
\&.cend
.EE
.
.
.P
prints two
.B CH3
groups with a bond between them.
.
.
.P
If you want to create just
.I groff
output, you must run
.I @g@chem
followed by
.I groff
with the option
.B \-p
for the activation of
.IR @g@pic :
.IP
.I @g@chem
.RI [ file\~ .\|.\|.\&]
.BR "| groff \-p\~" .\|.\|.
.
.
.\" ====================================================================
.SH Language
.\" ====================================================================
.
The
.I chem
input language is rather small.
.
It provides rings of several styles and a way to glue them together as
desired,
bonds of several styles,
moieties
(e.g.,
.BR C ,
.BR NH3 ,
\&.\|.\|.,
and strings.
.
.
.\" ====================================================================
.SS "Setting variables"
.\" ====================================================================
.
There are some variables that can be set by commands.
.
Such commands have two possible forms, either
.
.RS
.P
.I "variable value"
.RE
.
.P
or
.
.RS
.P
.IB "variable " = " value"
.RE
.
.P
This sets the given
.I variable
to the argument
.IR value .
If more arguments are given only the last argument is taken, all other
arguments are ignored.
.
.
.P
There are only a few variables to be set by these commands:
.
.TP
.BI textht " arg"
Set the height of the text to
.IR arg ;
default is 0.16.
.
.TP
.BI cwid " arg"
Set the character width to
.IR arg ;
default is 0.12.
.
.TP
.BI db " arg"
Set the bond length to
.IR arg ;
default is 0.2.
.
.TP
.BI size " arg"
Scale the diagram to make it look plausible at point size
.IR arg ;
default is 10 point.
.
.
.\" ====================================================================
.SS Bonds
.\" ====================================================================
.
This
.
.RS
.SY bond
.RI [ direction ]
.RI [ length\ n ]
.RB [ from\ \c
.IR Name | picstuff ]
.YS
.RE
.
.P
draws a single bond in direction from nearest corner of
.IR Name .
.B bond
can also be
.BR "double bond" ,
.BR "front bond" ,
.BR "back bond" ,
etc.
.
(We will get back to
.I Name
soon.)
.
.
.P
.I direction
is the angle in degrees (0\~up, positive clockwise)
or a direction word like
.BR up ,
.BR down ,
.B sw
(=\~southwest), etc.
.
If no direction is specified, the bond goes in the current direction
(usually that of the last bond).
.
.
.P
Normally the bond begins at the last object placed;  this
can be changed by naming a
.B from
place.
.
For instance, to make a simple alkyl chain:
.
.RS
.TS
tab (@);
lb l.
CH3
bond@(this one goes right from the CH3)
C@(at the right end of the bond)
double bond up@(from the C)
O@(at the end of the double bond)
bond right from C
CH3
.TE
.RE
.
.
.P
A length in inches may be specified to override the default length.
.
Other
.I pic
commands can be tacked on to the end of a bond command, to created
dotted or dashed bonds or to specify a
.B to
place.
.
.
.\" ====================================================================
.SS Rings
.\" ====================================================================
.
There are lots of rings,
but only five- and six-sided rings get much support.
.
.B ring
by itself is a six-sided ring;
.B benzene
is the benzene ring with a circle inside.
.B aromatic
puts a circle into any kind of ring.
.
.RS
.SY ring
.RB [ \%pointing\  ( up | right | left | down )]
.RB [ \%aromatic ]
.RB [ put\ Mol\ at\ \fIn\/\fP ]
.RB [ \%double\ \c
.IR i , j\ \/\c
.IR k , l\ \/\c
\&.\|.\|.\&
.RI [ picstuff ]
.YS
.RE
.
.
.P
The vertices of a ring are numbered 1, 2, \&.\|.\|.\& from the
vertex that points in the natural compass direction.
.
So for a hexagonal ring with the point at the top, the top vertex
is\~1, while if the ring has a point at the east side, that is
vertex\~1.
.
This is expressed as
.
.IP
.EX
R1: ring pointing up
R2: ring pointing right
.EE
.
.
.P
The ring vertices are named
.BR .V1 ,
\&.\|.\|.,
.BI .V n\fR,\fP
with
.B .V1
in the pointing direction.
.
So the corners of
.B R1
are
.B R1.V1
(the
.IR top ),
.BR R1.V2 ,
.BR R1.V3 ,
.B R1.V4
(the
.IR bottom ),
etc., whereas for
.BR R2 ,
.B R2.V1
is the rightmost vertex and
.B R2.V4
the leftmost.
.
These vertex names are used for connecting bonds or other rings.
.
For example,
.
.IP
.EX
R1: benzene pointing right
R2: benzene pointing right with .V6 at R1.V2
.EE
.
.
.P
creates two benzene rings connected along a side.
.
.
.P
Interior double bonds are specified as
.B \%double
.IB n1 , "n2 n3" , n4
.RB .\|.\|. ;
each number pair adds an interior bond.
.
So the alternate form of a benzene ring is
.
.IP
.B "ring double 1,2 3,4 5,6"
.
.
.P
Heterocycles (rings with something other than carbon at a vertex) are
written as
.BI put\  X\  at\  V\fR,\fP
as in
.
.IP
.B "R: ring put N at 1 put O at 2"
.
.
.P
In this heterocycle,
.B R.N
and
.B R.O
become synonyms for
.B R.V1
and
.BR R.V2 .
.
.
.P
There are two five-sided rings.
.
.B ring5
is pentagonal with a side that matches the six-sided ring;
it has four natural directions.
.
A
.B \%flatring
is a five-sided ring created by chopping one corner of a six-sided ring
so that it exactly matches the six-sided rings.
.
.
.P
The description of a ring has to fit on a single line.
.
.
.\" ====================================================================
.SS "Moieties and strings"
.\" ====================================================================
.
A moiety is a string of characters beginning with a capital letter,
such as N(C2H5)2.
.
Numbers are converted to subscripts (unless they appear to be
fractional values, as in N2.5H).
.
The name of a moiety is determined from the moiety after special
characters have been stripped out: e.g., N(C2H5)2) has the name NC2H52.
.
.
.P
Moieties can be specified in two kinds.
.
Normally a moiety is placed right after the last thing mentioned,
separated by a semicolon surrounded by spaces, e.g.,
.
.IP
.B "B1: bond ; OH"
.
.P
Here the moiety is
.BR OH ;
it is set after a bond.
.
.
.P
As the second kind a moiety can be positioned as the first word in a
.IR pic -like
command, e.g.,
.
.IP
.B "CH3 at C + (0.5,0.5)"
.
.P
Here the moiety is
.BR CH3 .
It is placed at a position relative to
.BR C ,
a moiety used earlier in the chemical structure.
.
.
.P
So moiety names can be specified as
.I chem
positions everywhere in the
.I chem
code.
.
Beneath their printing moieties are names for places.
.
.
.P
The moiety
.B BP
is special.
.
It is not printed but just serves as a mark to be referred to in later
.I chem
commands.
.
For example,
.
.IP
.B "bond ; BP"
.
.P
sets a mark at the end of the bond.
.
This can be used then for specifying a place.
.
The name
.B BP
is derived from
.I branch point
(i.e., line crossing).
.
.
.P
A string within double quotes
.B \(dq
is interpreted as a part of a
.I chem
command.
.
It represents a string that should be printed (without the quotes).
.
Text within quotes
.BR \(dq .\|.\|.\& \(dq
is treated more or less like a moiety except that no changes are made to
the quoted part.
.
.
.\" ====================================================================
.SS Names
.\" ====================================================================
.
In the alkyl chain above, notice that the carbon atom
.B C
was used both to draw something and as the name for a place.
.
A moiety always defines a name for a place;  you can use
your own names for places instead, and indeed, for rings
you will have to.
.
A name is just
.
.IP
.IB Name :
\&.\|.\|.
.
.
.P
.I Name
is often the name of a moiety like
.BR CH3 ,
but it need not to be.
.
Any name that begins with a capital letter and which contains
only letters and numbers is valid:
.
.RS
.TP
.B First:
.B bond
.TQ
\&
.B "bond 30 from First"
.RE
.
.
.\" ====================================================================
.SS Miscellaneous
.\" ====================================================================
.
The specific construction
.RS
.TP
.BR bond \~.\|.\|.\&\~ "; moiety"
.RE
.P
is equivalent to
.IP
.EX
bond
moiety
.EE
.
.
.P
Otherwise, each item has to be on a separate line (and only one line).
Note that there must be whitespace after the semicolon which separates
the commands.
.
.
.P
A period character
.B .\&
or a single quote
.B \[aq]
in the first column of a line signals a
.I troff
command, which is copied through as-is.
.
.
.P
A line whose first non-blank character is a hash character
.RB ( # )
is treated as a comment and thus ignored.
.
However, hash characters within a word are kept.
.
.
.P
A line whose first word is
.B pic
is copied through as-is after the word
.B pic
has been removed.
.
.
.P
The command
.IP
.B size
.I n
.P
scales the diagram to make it look plausible at point size\~\c
.I n
(default is 10\~point).
.
.
.P
Anything else is assumed to be
.I pic
code, which is copied through with a label.
.
.
.P
Since
.I @g@chem
is a
.I @g@pic
preprocessor, it is possible to include
.I pic
statements in the middle of a diagram to draw things not provided for
by
.I chem
itself.
.
Such
.I pic
statements should be included in
.I chem
code by adding
.B pic
as the first word of this line for clarity.
.
.
.P
The following
.I pic
commands are accepted as
.I chem
commands, so no
.B pic
command word is needed:
.
.IP
.B define
Start the definition of
.I pic
macro within
.IR chem .
.
.RS
.TP
.B [
Start a block composite.
.
.TP
.B ]
End a block composite.
.
.TP
.B {
Start a macro definition block.
.
.TP
.B }
End a macro definition block.
.RE
.
.P
The macro names from
.B define
statements are stored and their call is accepted as a
.I chem
command as well.
.
.
.\" ====================================================================
.SS "Wish list"
.\" ====================================================================
.
.P
This TODO list was collected by Brian Kernighan.
.
.
.P
Error checking is minimal; errors are usually detected and reported in
an oblique fashion by
.IR pic .
.
.
.P
There is no library or file inclusion mechanism, and there is no
shorthand for repetitive structures.
.
.
.P
The extension mechanism is to create
.I pic
macros, but these are tricky to get right and don't have all the
properties of built-in objects.
.
.
.P
There is no in-line chemistry yet
(e.g.,
analogous to the
.BR $ .\|.\|. $
construct of
.IR eqn ).
.
.
.P
There is no way to control entry point for bonds on groups.
.
Normally a bond connects to the carbon atom if entering from
the top or bottom and otherwise to the nearest corner.
.
.
.P
Bonds from substituted atoms on heterocycles do not join at the proper
place without adding a bit of
.IR pic .
.
.
.P
There is no decent primitive for brackets.
.
.
.P
Text (quoted strings) doesn't work very well.
.
.
.P
A squiggle bond is needed.
.
.
.\" ====================================================================
.SH Files
.\" ====================================================================
.
.TP
.I @DATASUBDIR@/\:pic/\:chem\:.pic
A collection of
.I pic
macros needed by
.IR @g@chem .
.
.TP
.I @MACRODIR@/\:pic\:.tmac
A macro file which redefines
.BR .PS ,
.BR .PE ,
and
.B .PF
to center
.I pic
diagrams.
.
.TP
.IR @DOCDIR@/\:\%examples/\:chem/\: * .chem
Example files for
.IR chem .
.
.TP
.IR @DOCDIR@/\:\%examples/\:chem/\:122/\: * .chem
Example files from the
.I chem
article by its authors,
\[lq]CHEM\[em]A Program for Typesetting Chemical Structure Diagrams:
User Manual\[rq]
(CSTR\~#122).
.
.
.\" ====================================================================
.SH Authors
.\" ====================================================================
.
The GNU version of
.I chem
was written by
.MT groff\-bernd\:.warken\-72@\:web\:.de
Bernd Warken
.ME .
.
It is based on the documentation of Brian Kernighan's original
.I awk
version of
.IR chem .
.
.
.\" ====================================================================
.SH "See also"
.\" ====================================================================
.
\[lq]CHEM\[em]A Program for Typesetting Chemical Diagrams: User
Manual\[rq]
by Jon L.\& Bentley,
Lynn W.\& Jelinski,
and
Brian W.\& Kernighan,
1992,
AT&T Bell Laboratories Computing Science Technical Report No.\& 122
.
.
.P
.MR groff @MAN1EXT@ ,
.MR @g@pic @MAN1EXT@
.
.
.\" Restore compatibility mode (for, e.g., Solaris 10/11).
.cp \n[*groff_chem_1_man_C]
.do rr *groff_chem_1_man_C
.
.
.\" Local Variables:
.\" fill-column: 72
.\" mode: nroff
.\" End:
.\" vim: set filetype=groff textwidth=72:
