.TH pfbtops @MAN1EXT@ "@MDATE@" "groff @VERSION@"
.SH Name
pfbtops \- translate PostScript Printer Font Binary files to Printer
Font ASCII
.
.
.\" ====================================================================
.\" Legal Terms
.\" ====================================================================
.\"
.\" Copyright (C) 1989-2020 Free Software Foundation, Inc.
.\"
.\" Permission is granted to make and distribute verbatim copies of this
.\" manual provided the copyright notice and this permission notice are
.\" preserved on all copies.
.\"
.\" Permission is granted to copy and distribute modified versions of
.\" this manual under the conditions for verbatim copying, provided that
.\" the entire resulting derived work is distributed under the terms of
.\" a permission notice identical to this one.
.\"
.\" Permission is granted to copy and distribute translations of this
.\" manual into another language, under the above conditions for
.\" modified versions, except that this permission notice may be
.\" included in translations approved by the Free Software Foundation
.\" instead of in the original English.
.
.
.\" Save and disable compatibility mode (for, e.g., Solaris 10/11).
.do nr *groff_pfbtops_1_man_C \n[.cp]
.cp 0
.
.\" Define fallback for groff 1.23's MR macro if the system lacks it.
.de @@
.  de MR
.    ie \n(.$=1 \
.      I %\$1
.    el \
.      IR %\$1 (\$2)\$3
.  \\.
..
.if  \n(.g .if !d MR .@@
.if !\n(.g .@@
.rm @@
.
.
.\" ====================================================================
.SH Synopsis
.\" ====================================================================
.
.SY pfbtops
.RI [ pfb-file ]
.YS
.
.
.SY pfbtops
.B \-\-help
.YS
.
.
.SY pfbtops
.B \-v
.
.SY pfbtops
.B \-\-version
.YS
.
.
.\" ====================================================================
.SH Description
.\" ====================================================================
.
.I pfbtops
translates a PostScript Type\~1 font in Printer Font Binary (PFB) format
to Printer Font ASCII (PFA) format,
splitting overlong lines in text packets into smaller chunks.
.
If
.I pfb-file
is omitted,
the PFB file will be read from the standard input stream.
.
The PFA font will be written on the standard output stream.
.
PostScript fonts for MS-DOS were historically supplied in PFB format.
.
Use of a PostScript Type\~1 font with
.I groff
requires conversion of its metrics
(AFM file)
to a
.I groff
font description file;
see
.MR afmtodit @MAN1EXT@.
.
.
.P
The
.B \-\-help
option displays a usage message,
while
.B \-v
and
.B \-\-version
show version information;
all exit afterward.
.
.
.\" ====================================================================
.SH "See also"
.\" ====================================================================
.
.MR grops @MAN1EXT@ ,
.MR gropdf @MAN1EXT@
.
.
.\" Restore compatibility mode (for, e.g., Solaris 10/11).
.cp \n[*groff_pfbtops_1_man_C]
.do rr *groff_pfbtops_1_man_C
.
.
.\" Local Variables:
.\" fill-column: 72
.\" mode: nroff
.\" End:
.\" vim: set filetype=groff textwidth=72:
