'\" t
.\" Save and disable compatibility mode (for, e.g., Solaris 10/11).
.do nr groff_ms_C \n[.C]
.cp 0
.TH GROFF_MS @MAN7EXT@ "@MDATE@" "groff @VERSION@"
.SH NAME
groff_ms \- GNU roff manuscript macro package for formatting documents
.
.
.\" ====================================================================
.\" Legal Terms
.\" ====================================================================
.\"
.\" Copyright (C) 1989-2018 Free Software Foundation, Inc.
.\"
.\" Permission is granted to make and distribute verbatim copies of this
.\" manual provided the copyright notice and this permission notice are
.\" preserved on all copies.
.\"
.\" Permission is granted to copy and distribute modified versions of
.\" this manual under the conditions for verbatim copying, provided that
.\" the entire resulting derived work is distributed under the terms of
.\" a permission notice identical to this one.
.\"
.\" Permission is granted to copy and distribute translations of this
.\" manual into another language, under the above conditions for
.\" modified versions, except that this permission notice may be
.\" included in translations approved by the Free Software Foundation
.\" instead of in the original English.
.
.
.\" ====================================================================
.SH SYNOPSIS
.\" ====================================================================
.
.SY "groff -ms"
.RI [ option
\&.\|.\|.\&]
.RI [ input-file
\&.\|.\|.\&]
.SY "groff -m ms"
.RI [ option
\&.\|.\|.\&]
.RI [ input-file
\&.\|.\|.\&]
.
.
.\" ====================================================================
.SH DESCRIPTION
.\" ====================================================================
.
This manual page describes the GNU version of the
.I ms
macros,
part of the
.I groff
typesetting system.
.
The
.I ms
macros are mostly compatible with the documented behavior of the 4.3
.SM BSD
Unix
.I ms
macros (see
.I Differences from troff ms
below for details).
.
The
.I ms
macros are suitable for reports, letters, books, and technical
documentation.
.
.
.\" ====================================================================
.SH USAGE
.\" ====================================================================
.
The
.I ms
macro package expects files to have a certain amount of structure.
.
The simplest documents can begin with a paragraph macro and consist of
text separated by paragraph macros or even blank lines.
.
Longer documents have a structure as follows:
.
.TP
.B "Document type"
If you use the
.B RP
(report) macro at the beginning of the document,
.I groff
prints the cover page information on its own page;
otherwise it prints the information on the
first page with your document text immediately following.
.
Other document formats found in AT&T
.I troff
are specific to AT&T or Berkeley, and are not supported in
.IR "groff ms" .
.
.TP
.B "Format and layout"
By setting number registers,
you can change your document's
margins, spacing, headers and footers, footnotes,
and the base point size for the text.
.
See
.I "Document control registers"
below for more details.
.
.TP
.B "Cover page"
A cover page consists of a title,
and optionally the author's name and institution,
an abstract, and the date.
.
See
.I "Cover page macros"
below for more details.
.
.TP
.B "Body"
Following the cover page is your document.
It consists of paragraphs, headings, and lists.
.
.TP
.B "Table of contents"
Longer documents usually include a table of contents,
which you can add by placing the
.B TC
macro at the end of your document.
.
.
.\" ====================================================================
.SS "Document control registers"
.\" ====================================================================
.
The following table lists the document control
number registers.
.
For the sake of consistency,
set registers related to margins at the beginning of your document,
or just after the
.B RP
macro.
.
.
.LP
.ne 12
.B Margin settings
.RS
.TS
cb   cb cb cb
lfCW l  l  l.
Reg.	Definition	Effective	Default
_
PO	Page offset (left margin)	next page	1i
LL	Line length	next paragraph	6i
LT	Header/footer length	next paragraph	6i
HM	Top (header) margin	next page	1i
FM	Bottom (footer) margin	next page	1i
_
.TE
.RE
.
.LP
.ne 12
.B Text settings
.RS
.TS
cb   cb cb cb
lfCW lx l  l.
Reg.	Definition	Effective	Default
_
PS	T{
Point size
T}	next paragraph	10p
VS	T{
Line spacing (leading)
T}	next paragraph	12p
PSINCR	T{
Point size increment
for section headings of
increasing importance
T}	next heading	1p
GROWPS	T{
Heading level
beyond which PSINCR
is ignored
T}	next heading	0
_
.TE
.RE
.
.LP
.ne 11
.B Paragraph settings
.RS
.TS
cb   cb cb cb
lfCW lx l  l.
Reg.	Definition	Effective	Default
_
PI	T{
Initial indent
T}	next paragraph	5n
PD	T{
Space between paragraphs
T}	next paragraph	0.3v
QI	T{
Quoted paragraph indent
T}	next paragraph	5n
PORPHANS	T{
Number of initial lines
to be kept together
T}	next paragraph	1
HORPHANS	T{
Number of initial lines
to be kept with heading
T}	next heading	1
_
.TE
.RE
.
.LP
.ne 7
.B Footnote settings
.RS
.TS
cb   cb cb cb
lfCW l  l  l.
Reg.	Definition	Effective	Default
_
FL	Footnote length	next footnote	\[rs]n[LL]*5/6
FI	Footnote indent	next footnote	2n
FF	Footnote format	next footnote	0
FPS	Point size	next footnote	\[rs]n[PS]\-2
FVS	Vert.\& spacing	next footnote	\[rs]n[FPS]+2
FPD	Para.\& spacing	next footnote	\[rs]n[PD]/2
_
.TE
.RE
.
.LP
.ne 6
.B Other settings
.RS
.TS
cb   cb cb cb
lfCW l  l  l.
Reg.	Definition	Effective	Default
_
DD	Display, table, eqn, pic spacing	next para.	0.5v
MINGW	Minimum width between columns	next page	2n
_
.TE
.RE
.
.
.\" ====================================================================
.SS "Cover page macros"
.\" ====================================================================
.
Use the following macros to create a cover page for your document
in the order shown.
.
.TP
.BR ".RP " [ no ]
Specifies the report format for your document.
.
The report format creates a separate cover page.
.
With no
.B RP
macro,
.I groff
prints a subset of the
cover page on page\~1 of your document.
.
.IP
If you use the optional
.B no
argument,
.I groff
prints a title page but
does not repeat any of the title page information
(title, author, abstract, etc.\&)
on page\~1 of the document.
.
.TP
.B .P1
(P-one) Prints the header on page\~1.
.
The default is to suppress the header.
.
.TP
.B .DA\c
.RI " [" xxx ]
(optional) Print the current date,
or the arguments to the macro if any,
on the title page (if specified)
and in the footers.
.
This is the default for
.IR nroff .
.
.TP
.B .ND\c
.RI " [" xxx ]
(optional) Print the current date,
or the arguments to the macro if any,
on the title page (if specified)
but not in the footers.
.
This is the default for
.IR troff .
.
.TP
.B .TL
Specifies the document title.
.
.I Groff
collects text following the
.B TL
macro into the title, until reaching the author name or abstract.
.
.TP
.B .AU
Specifies the author's name.
.
You can specify multiple authors by using an
.B AU
macro for each author.
.
.TP
.B .AI
Specifies the author's institution.
.
You can specify multiple institutions.
.
.TP
.BR ".AB " [ no ]
Begins the abstract.
.
The default is to print the word
.BR ABSTRACT ,
centered and in italics, above the text of the abstract.
.
The option
.B no
suppresses this heading.
.
.TP
.B .AE
End the abstract.
.
.
.\" ====================================================================
.SS Paragraphs
.\" ====================================================================
.
Use the
.B PP
macro to create indented paragraphs,
and the
.B LP
macro to create paragraphs with no initial indent.
.
.
.PP
The
.B QP
macro indents all text at both left and right margins
by the amount of the register
.BR QI .
.
The effect is reminiscent of the HTML
.B <BLOCKQUOTE>
tag.
.
The next paragraph or heading returns the margins to normal.
.
.B QP
inserts the vertical space specified in register
.B PD
as inter-paragraph spacing.
.
.
.PP
A paragraph bracketed between the macros
.B QS
and
.B QE
has the same appearance as a paragraph started with
.B QP
and a following paragraph started with
.BR LP .
.
Both
.B QS
and
.B QE
insert the inter-paragraph spacing specified in
.B PD
and the text is indented on both sides by the amount of register
.BR QI .
.
The text between
.B QS
and
.B QE
can be split into further paragraphs by using
.B \&.LP
or
.BR \&.PP .
.
.
.PP
The
.B XP
macro produces an \(lqexdented\(rq paragraph; that is, one with a
hanging indent.
.
The first line of the paragraph begins at
the left margin,
and subsequent lines are indented
(the opposite of
.BR PP ).
.
.
.PP
For each of the above paragraph types,
and also for any list entry introduced by the
.B IP
macro
(described later),
the document control register
.BR PORPHANS ,
sets the
.I minimum
number of lines which must be printed,
after the start of the paragraph,
and before any page break occurs.
.
If there is insufficient space remaining on the current page
to accommodate this number of lines,
then a page break is forced
.I before
the first line of the paragraph is printed.
.
.
.PP
Similarly,
when a section heading
(see subsection
.I Headings
below)
precedes any of these paragraph types,
the
.B HORPHANS
document control register specifies the
.I minimum
number of lines of the paragraph
which must be kept on the same page as the heading.
.
If insufficient space remains on the current page
to accommodate the heading and this number of lines of paragraph text,
then a page break is forced
.I before
the heading is printed.
.
.
.\" ====================================================================
.SS Headings
.\" ====================================================================
.
Use headings to create a hierarchical structure
for your document.
.
By default,
the
.I ms
macros print headings in
.B bold
using the same font family and point size as the body text.
.
For output devices which support scalable fonts,
this behaviour may be modified by defining the document control
registers
.B GROWPS
and
.BR PSINCR .
.
.
.PP
The following heading macros are available:
.
.TP
.BI .NH\  xx
Numbered heading.
.
The argument
.I xx
is either a numeric argument to indicate the
level of the heading, or
.B S\~\c
.IR "xx\~xx\~" .\|.\|.\&
to set the section number explicitly.
.
If you specify heading levels out of sequence,
such as invoking
.B ".NH\ 3"
after
.BR ".NH\ 1" ,
.I groff
prints a warning on standard error.
.
.IP
If the
.B GROWPS
register is set to a value
greater than the level of the heading,
then the point size of the heading will be increased by
.B PSINCR
units over the text size specified by the
.B PS
register,
for each level by which the heading level is less than
the value of
.BR GROWPS .
.
For example,
the sequence:
.
.RS
.ne 12
.nf
.IP
\&.nr PS 10
\&.nr GROWPS 3
\&.nr PSINCR 1.5p
\&.
\&.NH 1
Top Level Heading
\&.
\&.NH 2
Second Level Heading
\&.
\&.NH 3
Third Level Heading
.fi
.RE
.
.IP
will cause
.RI \*(lq 1.\ Top\ Level\ Heading \*(rq
to be printed in 13pt
.B bold
text, followed by
.RI \*(lq 1.1.\ Second\ Level\ Heading \*(rq
in 11.5pt
.B bold
text, while
.RI \*(lq 1.1.1.\ Third\ Level\ Heading \*(rq,
and all more deeply nested heading levels,
will remain in the 10pt
.B bold
text which is specified by the
.B PS
register.
.
.IP
Note that the value stored in
.B PSINCR
is interpreted in
.I groff
basic units;
the
.I p
scaling factor should be employed when assigning a value specified in
points.
.
.IP
The style used to represent the section number,
within a numbered heading,
is controlled by the
.B SN\-STYLE
string;
this may be set to either the
.B SN\-DOT
or the
.B SN\-NO\-DOT
style,
(described below),
by aliasing
.B SN\-STYLE
accordingly.
.
By default,
.B SN\-STYLE
is initialised by defining the alias
.RS
.nf
.IP
\&.als SN\-STYLE SN\-DOT
.fi
.RE
.IP
it may be changed to the
.B SN\-NO\-DOT
style,
if preferred,
by defining the alternative alias
.RS
.nf
.IP
\&.als SN\-STYLE SN\-NO\-DOT
.fi
.RE
.IP
Any such change becomes effective with the first use of
.BR .NH ,
.I after
the new alias is defined.
.
.IP
After invoking
.BR .NH ,
the assigned heading number is available in the strings
.B SN\-DOT
(as it appears in the default formatting style for numbered headings,
with a terminating period following the number),
and
.B SN\-NO\-DOT
(with this terminating period omitted).
.
The string
.B SN
is also defined,
as an alias for
.BR SN\-DOT ;
if preferred,
the user may redefine it as an alias for
.BR SN\-NO\-DOT ,
'ne 10
by including the initialisation:
.
.RS
.nf
.IP
\&.als SN SN\-NO\-DOT
.fi
.RE
.
.IP
at any time;
the change becomes effective with the next use of
.BR .NH ,
.I after
the new alias is defined.
.
.TP
.B .SH\c
.RI " [" xx ]
Unnumbered subheading.
.
The use of the optional
.I xx
argument is a GNU extension,
which adjusts the point size of the unnumbered subheading
to match that of a numbered heading,
introduced using
.BI .NH\  xx
with the same value of
.IR xx .
.
For example,
given the same settings for
.BR PS ,
.B GROWPS
and
.BR PSINCR ,
as used in the preceding
.B .NH
example,
the sequence:
.
.RS
.ne
.nf
.IP
\&.SH 2
An Unnumbered Subheading
.fi
.RE
.
.IP
will print
.RI \*(lq "An Unnumbered Subheading" \*(rq
in 11.5pt
.B bold
text.
.
.
.\" ====================================================================
.SS Highlighting
.\" ====================================================================
.
The
.I ms
macros provide a variety of methods to highlight
or emphasize text:
.
.TP
.B .B\c
.RI " [" txt " [" post " [" pre ]]]
Sets its first argument in
.BR "bold type" .
.
If you specify a second argument,
.I groff
prints it in the previous font after
the bold text, with no intervening space
(this allows you to set punctuation after
the highlighted text without highlighting
the punctuation).
.
Similarly, it prints the third argument (if any)
in the previous font
.B before
the first argument.
.
For example,
.RS
.
.IP
\&.B foo ) (
.RE
.
.IP
prints
.RB \(lq( foo )\(rq.
.
.IP
If you give this macro no arguments,
.I groff
prints all text following in bold until
the next highlighting, paragraph, or heading macro.
.
.TP
.B .R\c
.RI " [" txt " [" post " [" pre ]]]
Sets its first argument in
roman (or regular) type.
.
It operates similarly to the
.B B
macro otherwise.
.
.TP
.B .I\c
.RI " [" txt " [" post " [" pre ]]]
Sets its first argument in
.IR "italic type" .
It operates similarly to the
.B B
macro otherwise.
.
.TP
.B .CW\c
.RI " [" txt " [" post " [" pre ]]]
Sets its first argument in a constant-width face.
.
It operates similarly to the
.B B
macro otherwise.
.
.TP
.B .BI\c
.RI " [" txt " [" post " [" pre ]]]
Sets its first argument in bold italic type.
.
It operates similarly to the
.B B
macro otherwise.
.
.TP
.B .BX\c
.RI " [" txt ]
Prints its argument and draws a box around it.
.
If you want to box a string that contains spaces,
use a digit-width space (\[rs]0).
.
.TP
.B .UL\c
.RI " [" txt " [" post ]]
Prints its first argument with an underline.
.
If you specify a second argument,
.I groff
prints it in the previous font after the underlined text, with no
intervening space.
.
.TP
.B .LG
Prints all text following in larger type
(2\~points larger than the current point size) until
the next font size, highlighting, paragraph, or heading macro.
.
You can specify this macro multiple times to enlarge the point size as
needed.
.
.TP
.B .SM
Prints all text following in
smaller type
(2\~points smaller than the current point size) until
the next type size, highlighting, paragraph, or heading macro.
.
You can specify this macro multiple times to reduce the point size as
needed.
.
.TP
.B .NL
Prints all text following in
the normal point size
(that is, the value of the
.B PS
register).
.
.TP
.BI \[rs]*{ text \[rs]*}
Print the enclosed
.I text
as a superscript.
.
.
.\" ====================================================================
.SS Indents
.\" ====================================================================
.
You may need to indent sections of text.
.
A typical use for indents is to create nested lists and sublists.
.
.
.PP
Use the
.B RS
and
.B RE
macros to start and end a section of indented text, respectively.
.
The
.B PI
register controls the amount of indent.
.
.
.PP
You can nest indented sections as deeply as needed by using multiple,
nested pairs of
.B RS
and
.BR RE .
.
.
.\" ====================================================================
.SS Lists
.\" ====================================================================
.
The
.B IP
macro handles duties for all lists.
.
Its syntax is as follows:
.
.TP
.B .IP\c
.RI " [" marker " [" width ]]
The
.I marker
is usually a bullet character
.B \[rs](bu
for unordered lists,
a number (or auto-incrementing number register) for numbered lists,
or a word or phrase for indented (glossary-style) lists.
.
.IP
The
.I width
specifies the indent for the body of each list item.
.
Once specified, the indent remains the same for all list items in the
document until specified again.
.\" =====
.br
.ne 15
.
.
.\" ====================================================================
.SS "Tab stops"
.\" ====================================================================
.
Use the
.B ta
request to set tab stops as needed.
.
Use the
.B TA
macro to reset tabs to the default (every 5n).
.
You can redefine the
.B TA
macro to create a different set of default tab stops.
.
.
.\" ====================================================================
.SS "Displays and keeps"
.\" ====================================================================
.
Use displays to show text-based examples or figures
(such as code listings).
.
Displays turn off filling, so lines of code can be displayed as-is
without inserting
.B br
requests in between each line.
.
Displays can be
.I kept
on a single page, or allowed to break across pages.
.
The following table shows the display types available.
.RS
.ne 11
.na
.TS
cb   s    cbt
cb   cb   ^
lfCW lfCW lx.
Display macro	Type of display
With keep	No keep
_
\&.DS L	\&.LD	Left-justified.
\&.DS I [\,\fIindent\/\fP]	\&.ID	T{
Indented (default indent in the \fBDI\fP register).
T}
\&.DS B	\&.BD	T{
Block-centered (left-justified, longest line centered).
T}
\&.DS C	\&.CD	Centered.
\&.DS R	\&.RD	Right-justified.
_
.TE
.RE
.ad
.
.LP
Use the
.B DE
macro to end any display type.
.
The macros
.B Ds
and
.B De
were formerly provided as aliases for
.B DS
and
.BR DE ,
respectively, but they have been removed, and should no longer be used.
.
X11 documents which actually use
.B Ds
and
.B De
always load a specific macro file from the X11 distribution (macros.t)
which provides proper definitions for the two macros.
.
.PP
To
.I keep
text together on a page,
such as
a paragraph that refers to a table (or list, or other item)
immediately following, use the
.B KS
and
.B KE
macros.
.
The
.B KS
macro begins a block of text to be kept on a single page,
and the
.B KE
macro ends the block.
.
.
.PP
You can specify a
.I "floating keep"
using the
.B KF
and
.B KE
macros.
.
If the keep cannot fit on the current page,
.I groff
holds the contents of the keep and allows text following
the keep (in the source file) to fill in the remainder of
the current page.
.
When the page breaks,
whether by an explicit
.B bp
request or by reaching the end of the page,
.I groff
prints the floating keep at the top of the new page.
.
This is useful for printing large graphics or tables
that do not need to appear exactly where specified.
.
.
.PP
The macros
.B B1
and
.B B2
can be used to enclose a text within a box;
.B .B1
begins the box, and
.B .B2
ends it.
.
Text in the box is automatically placed in a diversion
(keep).
.
.
.\" ====================================================================
.SS "Tables, figures, equations, and references"
.\" ====================================================================
.
The
.I ms
macros support the standard
.I groff
preprocessors:
.IR tbl ,
.IR pic ,
.IR eqn ,
and
.IR refer .
.
Mark text meant for preprocessors by enclosing it
in pairs of tags as follows:
.
.TP
.BR .TS " [" H "] and " .TE
Denote a table to be processed by the
.I tbl
preprocessor.
.
The optional
.BR H "\~argument"
instructs
.I groff
to create a running header with the information
up to the
.B TH
macro.
.
.I Groff
prints the header at the beginning of the table;
if the table runs onto another page,
.I groff
prints the header on the next page as well.
.
.TP
.BR .PS " and " .PE
Denote a graphic to be processed by the
.I pic
preprocessor.
.
You can create a
.I pic
file by hand, using the
AT&T
.I pic
manual available on the Web as a reference,
or by using a graphics program such as
.IR xfig .
.
.TP
.B .EQ\c
.RI " [" align "] and "\c
.B .EN
Denote an equation to be processed by the
.I eqn
preprocessor.
.
The optional
.I align
argument can be
.BR C ,
.BR L ,
or\~\c
.B I
to center (the default), left-justify, or indent
the equation, respectively.
.
.TP
.BR .[ " and " .]
Denote a reference to be processed by the
.I refer
preprocessor.
.
The GNU
.IR @g@refer (@MAN1EXT@)
manual page provides a comprehensive reference
to the preprocessor and the format of the
bibliographic database.
.
.
.\" ====================================================================
.SS Footnotes
.\" ====================================================================
.
The
.I ms
macros provide a flexible footnote system.
.
You can specify a numbered footnote by using the
.B \[rs]**
escape, followed by the text of the footnote
enclosed by
.B FS
and
.B FE
macros.
.
.
.PP
You can specify symbolic footnotes
by placing the mark character (such as
.B \[rs](dg
for the dagger character) in the body text,
followed by the text of the footnote
enclosed by
.B FS\ \[rs](dg
and
.B FE
macros.
.
.
.PP
You can control how
.I groff
prints footnote numbers by changing the value of the
.B FF
register as follows:
.RS
.ne 7
.
.TP
0
Prints the footnote number as a superscript; indents the footnote
(default).
.
.TP
1
Prints the number followed by a period (that is,\~\(lq1.\(rq\&)
and indents the footnote.
.
.TP
2
Like\~1, without an indent.
.
.TP
3
Like\~1, but prints the footnote number as a paragraph with a hanging
indent.
.
.RE
.LP
You can use footnotes safely within keeps and displays,
but avoid using numbered footnotes within floating keeps.
.
You can set a second
.B \[rs]**
between a
.B \[rs]**
and its corresponding
.BR .FS ;
as long as each
.B .FS
occurs
.I after
the corresponding
.B \[rs]**
and the occurrences of
.B .FS
are in the same order as the corresponding occurrences of
.BR \[rs]** .
.
.
.\" ====================================================================
.SS "Headers and footers"
.\" ====================================================================
.
There are three ways to define headers and footers:
.
.IP \(bu 3n
Use the strings
.BR LH ,
.BR CH ,
and
.B RH
to set the left, center, and right headers.
Use
.BR LF ,
.BR CF ,
and
.B RF
to set the left, center, and right footers.
.
The string-setting approach works best for documents that do not
distinguish between odd and even pages.
.
.IP \(bu
Use the
.B OH
and
.B EH
macros to define headers for the odd and even pages,
and
.B OF
and
.B EF
macros to define footers for the odd and even pages.
.
This is more flexible than defining the individual strings.
.
The syntax for these macros is as follows:
.RS
.
.IP
.BI . XX " \[aq]" left \[aq] center \[aq] right \[aq]
.RE
.
.IP
where
.I XX
is one of the foregoing four macros and each of
.IR left ,
.IR center ,
and
.I right
is text of your choice.
.
You can replace the quote (\[aq]) marks with any character not
appearing in the header or footer text.
.
.
.IP \(bu
You can redefine the
.B PT
and
.B BT
macros to change the behavior of
the header and footer, respectively.
.
The header process also calls the (undefined)
.B HD
macro after
.BR PT ;
you can define this macro if you need additional processing
after printing the header
(for example, to draw a line below the header).
.
.
.\" ====================================================================
.SS Margins
.\" ====================================================================
.
You control margins using a set of number registers.
.
The following table lists the register names and defaults:
.RS
.ne 8
.na
.TS
cb   cb cb cb
lfCW l  l  l.
Reg.	Definition	Effective	Default
_
PO	Page offset (left margin)	next page	1i
LL	Line length	next paragraph	6i
LT	Header/footer length	next paragraph	6i
HM	Top (header) margin	next page	1i
FM	Bottom (footer) margin	next page	1i
_
.TE
.RE
.ad
.
.PP
Note that there is no right margin setting.
The combination of page offset and line length
provide the information necessary to
derive the right margin.
.
.
.\" ====================================================================
.SS "Multiple columns"
.\" ====================================================================
.
The
.I ms
macros can set text in as many columns as will reasonably
fit on the page.
.
The following macros are available.
.
All of them force a page break if a multi-column mode is already set.
.
However, if the current mode is single-column, starting a multi-column
mode does
.I not
force a page break.
.
.TP
.B .1C
Single-column mode.
.
.TP
.B .2C
Two-column mode.
.
.TP
.B .MC\c
.RI " [" column-width " [" gutter-width ]]
Multi-column mode.
.
If you specify no arguments, it is equivalent to the
.B 2C
macro.
.
Otherwise,
.I column-width
is the width of each column and
.I gutter-width
is the space between columns.
.
The
.B MINGW
number register is the default gutter width.
.
.
.\" ====================================================================
.SS "Creating a table of contents"
.\" ====================================================================
.
Wrap text that you want to appear in the table of contents in
.B XS
and
.B XE
macros.
.
Use the
.B TC
macro to print the table of contents at the end of the document,
resetting the page number to\~\c
.B i
(Roman numeral\~1).
.
.
.PP
You can manually create a table of contents
by specifying a page number as the first argument to
.BR XS .
.
Add subsequent entries using the
.B XA
macro.
.
For example:
.RS
.
.PP
.ne 8
.nf
\&.XS 1
Introduction
\&.XA 2
A Brief History of the Universe
\&.XA 729
Details of Galactic Formation
\&.\|.\|.
\&.XE
.fi
.RE
.
.LP
Use the
.B PX
macro to print a manually-generated table of contents
without resetting the page number.
.
.
.PP
If you give the argument
.B no
to either
.B PX
or
.BR TC ,
.I groff
suppresses printing the title
specified by the
.B \[rs]*[TOC]
string.
.
.
.\" ====================================================================
.SS "Fractional point sizes"
.\" ====================================================================
.
Traditionally, the
.I ms
macros only support integer values for the document's font size
and vertical spacing.
.
To overcome this restriction, values larger than or equal to 1000 are
taken as fractional values, multiplied by 1000.
.
For example, \[oq].nr\~PS\~10250\[cq] sets the font size to 10.25
points.
.
.
.LP
The following four registers accept fractional point sizes:
.BR PS ,
.BR VS ,
.BR FPS ,
and
.BR FVS .
.
.
.LP
Due to backwards compatibility, the value of
.B VS
must be smaller than 40000 (this is 40.0 points).
.
.
.\" ====================================================================
.SH "DIFFERENCES FROM troff ms"
.\" ====================================================================
.
The
.I "groff ms"
macros are a complete re-implementation,
using no original AT&T code.
.
Since they take advantage of the extended features in
.IR groff ,
they cannot be used with AT&T
.IR troff .
.
Other differences include:
.
.IP \(bu 3n
The internals of
.I "groff ms"
differ from the internals of Unix
.IR ms .
.
Documents that depend upon implementation details of Unix
.I ms
may not format properly with
.IR "groff ms" .
.
.IP \(bu
The error-handling policy of
.I "groff ms"
is to detect and report errors,
rather than silently to ignore them.
.
.IP \(bu
Some Bell Labs localisms are not implemented by default.
.
However, if you call the otherwise undocumented
.BR SC
section-header macro, you will enable implementations of three other
archaic Bell Labs macros:
.BR UC ,
.BR P1 ,
and
.BR P2 .
.
These are not enabled by default because (a)\~they were not documented,
in the original
.IR "ms manual" ,
and (b)\~the
.B P1
and
.B UC
macros both collide with different macros in the Berkeley version of
.IR ms .
.
.IP
These emulations are sufficient to give back the 1976 Kernighan\~&
Cherry paper
.I "Typesetting Mathematics \(en User's Guide"
its section headings, and restore some text that had gone missing as
arguments of undefined macros.
.
No warranty express or implied is given as to how well the typographic
details these produce match the original Bell Labs macros.
.
.IP \(bu
Berkeley localisms, in particular the
.B TM
and
.B CT
macros,
are not implemented.
.
.IP \(bu
.I "Groff ms"
does not work in compatibility mode (e.g., with the
.B \-C
option).
.
.IP \(bu
There is no support for typewriter-like devices.
.
.IP \(bu
.I "Groff ms"
does not provide cut marks.
.
.IP \(bu
Multiple line spacing is not supported
(use a larger vertical spacing instead).
.
.IP \(bu
Some Unix
.I ms
documentation says that the
.B CW
and
.B GW
number registers can be used to control the column width and
gutter width, respectively.
.
These number registers are not used in
.IR "groff ms" .
.
.IP \(bu
Macros that cause a reset
(paragraphs, headings, etc.\&)
may change the indent.
.
Macros that change the indent do not increment or decrement the
indent, but rather set it absolutely.
.
This can cause problems for documents that define additional macros of
their own.
.
The solution is to use not the
.B in
request but instead the
.B RS
and
.B RE
macros.
.
.IP \(bu
The number register
.B GS
is set to\~1 by the
.I "groff ms"
macros,
but is not used by the Unix
.I ms
macros.
.
Documents that need to determine whether they are being formatted with
Unix
.I ms
or
.I "groff ms"
should use this number register.
.
.IP \(bu
To make
.I "groff ms"
use the default page offset (which also specifies the left margin),
the
.B PO
number register must stay undefined until the first
.B ms
macro is evaluated.
.
This implies that
.B PO
should not be used early in the document, unless it is changed also:
remember that accessing an undefined register automatically defines it.
.br
.ne 23
.
.
.\" ====================================================================
.SS Strings
.\" ====================================================================
.
You can redefine the following strings to adapt the
.I "groff ms"
macros to languages other than English:
.RS
.TS
cb   cb
lfCW l.
String	Default Value
_
REFERENCES	References
ABSTRACT	ABSTRACT
TOC	Table of Contents
MONTH1	January
MONTH2	February
MONTH3	March
MONTH4	April
MONTH5	May
MONTH6	June
MONTH7	July
MONTH8	August
MONTH9	September
MONTH10	October
MONTH11	November
MONTH12	December
_
.TE
.RE
.
.
.PP
The
.B \[rs]*\-
string produces an em dash\[em]like this.
.
.
.PP
Use
.B \[rs]*Q
and
.B \[rs]*U
to get a left and right typographer's quote,
respectively, in
.I troff
(and plain quotes in
.IR nroff ).
.
.
.\" ====================================================================
.SS Text Settings
.\" ====================================================================
.
The
.B FAM
string sets the default font family.
.
If this string is undefined at initialization,
it is set to Times.
.
.
.LP
The point size, vertical spacing, and inter-paragraph spacing for
footnotes are controlled by the number registers
.BR FPS ,
.BR FVS ,
and
.BR FPD ;
at initialization these are set to
.BR \[rs]n(PS\-2 ,
.BR \[rs]n[FPS]+2 ,
and
.BR \[rs]n(PD/2 ,
respectively.
.
If any of these registers are defined before initialization,
the initialization macro does not change them.
.
.
.LP
The hyphenation flags (as set by the
.B hy
request) are set from the
.B HY
register;
the default is\~6.
.
.
.PP
Improved accent marks
(as originally defined in Berkeley's
.I ms
version)
are available by specifying the
.B AM
macro at the beginning of your document.
.
You can place an accent over most characters by specifying the string
defining the accent directly after the character.
.
For example,
.B n\[rs]*\[ti]
produces an n with a tilde over it.
.
.
.\" ====================================================================
.SH "NAMING CONVENTIONS"
.\" ====================================================================
.
The following conventions are used for names of macros, strings, and
number registers.
.
External names available to documents that use the
.I "groff ms"
macros contain only uppercase letters and digits.
.
.
.LP
Internally the macros are divided into modules;
naming conventions are as follows:
.
.IP \(bu 3n
Names used only within one module are of the form
.IB \%module * name\fR.
.
.IP \(bu
Names used outside the module in which they are defined are of the form
.IB \%module @ name\fR.
.
.IP \(bu
Names associated with a particular environment are of the form
.IB \%environment : name\fR;
these are used only within the
.B par
module.
.
.IP \(bu
.I name
does not have a module prefix.
.
.IP \(bu
Constructed names used to implement arrays are of the form
.IB \%array ! index\fR.
.
.
.PP
Thus the groff ms macros reserve the following names:
.
.IP \(bu 3n
Names containing the characters
.BR * ,
.BR @ ,
and\~\c
.BR : .
.
.IP \(bu
Names containing only uppercase letters and digits.
.
.
.\" ====================================================================
.SH FILES
.\" ====================================================================
.
.B @MACRODIR@/ms.tmac
(a wrapper file for
.BR s.tmac )
.br
.B @MACRODIR@/s.tmac
.
.
.
.\" ====================================================================
.SH AUTHORS
.\" ====================================================================
The GNU version of the
.I ms
macro package was written by James Clark and contributors.
.
This document was (re-)written by
.MT lkollar@\:despammed.com
Larry Kollar
.ME .
.
.
.\" ====================================================================
.SH "SEE ALSO"
.\" ====================================================================
.
.BR groff (@MAN1EXT@),
.BR @g@troff (@MAN1EXT@),
.BR @g@tbl (@MAN1EXT@),
.BR @g@pic (@MAN1EXT@),
.BR @g@eqn (@MAN1EXT@),
.BR @g@refer (@MAN1EXT@)
.
.
.PP
.IR "Groff: The GNU Implementation of troff" ,
by Trent A.\& Fisher and Werner Lemberg
.
.
.\" Restore compatibility mode (for, e.g., Solaris 10/11).
.cp \n[groff_ms_C]
.
.
.\" Local Variables:
.\" mode: nroff
.\" End:
.\" vim: set filetype=groff:
