.TH PDFMOM @MAN1EXT@ "@MDATE@" "groff @VERSION@"
.SH NAME
pdfmom \- produce PDF documents using the mom macro package for groff
.
.
.\" ====================================================================
.\" Legalese
.\" ====================================================================
.\"
.\" Copyright (C) 2012-2018 Free Software Foundation, Inc.
.\"
.\" Permission is granted to make and distribute verbatim copies of this
.\" manual provided the copyright notice and this permission notice are
.\" preserved on all copies.
.\"
.\" Permission is granted to copy and distribute modified versions of
.\" this manual under the conditions for verbatim copying, provided that
.\" the entire resulting derived work is distributed under the terms of
.\" a permission notice identical to this one.
.\"
.\" Permission is granted to copy and distribute translations of this
.\" manual into another language, under the above conditions for
.\" modified versions, except that this permission notice may be
.\" included in translations approved by the Free Software Foundation
.\" instead of in the original English.
.
.
.\" ====================================================================
.SH SYNOPSIS
.\" ====================================================================
.
.SY pdfmom
.OP \-Tpdf
.RI [ groff-options ]
.I file
\&.\|.\|.\&
.YS
.
.SY pdfmom
.B \-Tps
.RI [ pdfroff-options ]
.RI [ groff-options ]
.I file
\&.\|.\|.\&
.YS
.
.SY pdfmom
.B \-v
.YS
.
.
.\" ====================================================================
.SH DESCRIPTION
.\" ====================================================================
.
.B pdfmom
is a wrapper around
.B groff
that facilitates the production of PDF documents from files
formatted with the mom macros.
.
.
.P
.B pdfmom
prints to the standard output,
so output must usually be redirected to a destination file.
The size of the final PDF can be reduced by piping the output
through
.BR ps2pdf .
.
.
.P
If called with the
.B \-Tpdf
option (which is the default),
.B pdfmom
processes files using groff's native PDF driver,
.BR gropdf .
.
If
.B \-Tps
is given, processing is passed over to
.BR pdfroff ,
which uses
.BR groff 's
PostScript driver.
.
In either case, multiple runs of the source file are performed in
order to satisfy any forward references in the document.
.
.
.P
.B pdfmom
accepts all the same options as
.BR groff .
If
.B \-Tps
is given, the options associated with
.B pdfroff
are accepted as well.
.
Please note that when
.B pdfmom
calls
.BR pdfroff ,
the
.
.
.P
.RS
.B \-mpdfmark \-mom \-\-no-toc
.RE
.
.
.P
options are implied and should not be given on the
command line.
.
Equally, it is not necessary to supply the
.B \-mom
or
.B "\-m\~mom"
options when
.B \-Tps
is absent.
.
.
.P
PDF integration with the
.B mom
macros is discussed in full in the PDF manual,
.IR "Producing PDFs with groff and mom" .
.
.
.P
If called with the
.B \-v
option,
.B pdfmom
simply prints its version information and exits.
.
.
.\" ====================================================================
.SH BUGS
.\" ====================================================================
.
.B pdfmom
sometimes issues warnings of the type
.
.
.P
.RS 2
\&.\|.\|.:
.B can't transparently output node at top level
.RE
.
.
.P
This is more of an annoyance than a bug, and may safely be ignored.
.
.
.\" ====================================================================
.SH AUTHORS
.\" ====================================================================
.B pfdmom
was written by
.MT deri@\:chuzzlewit.demon.co.uk
Deri James
.ME
and
.MT peter@\:schaffter.ca
Peter Schaffter
.ME .
.
.
.\" ====================================================================
.SH "SEE ALSO"
.\" ====================================================================
.
.BR groff (@MAN1EXT@),
.BR pdfroff (@MAN1EXT@),
.BR ps2pdf (@MAN1EXT@)
.
.
.\" Local Variables:
.\" mode: nroff
.\" End:
.\" vim: set filetype=groff:
