.TH glilypond @MAN1EXT@ "@MDATE@" "groff @VERSION@"
.SH NAME
glilypond \- integrate lilypond parts into groff
.
.\" This .SH was moved to this place in order to appease 'apropos'.
.
.\" glilypond - integrate 'lilypond' parts into 'groff' files
.\" Source file position:  <groff_source_top>/contrib/glilypond.man
.\" Installed position:    <prefix>/share/man/man1/glilypond.1
.
.\" TODO: This page needs a thorough edit by a native English speaker.
.
.\" ====================================================================
.\" Legalese
.\" ====================================================================
.\"
.\" Copyright (C) 2013-2018 Free Software Foundation, Inc.
.\"
.\" Last update: 10 Sep 2015
.\"
.\" This file is part of glilypond, which is part of GNU groff, a free
.\" software project.
.\"
.\" You can redistribute it and/or modify it under the terms of the GNU
.\" General Public License version 2 (GPL2) as published by the Free
.\" Software Foundation.
.\"
.\" The license text is available in the internet at
.\" <http://www.gnu.org/licenses/gpl-2.0.html>.
.
.
.\" ====================================================================
.\" Characters
.\" ====================================================================
.
.\" Ellipsis ...
.ie t .ds EL \fS\N'188'\fP\"
.el .ds EL \&.\|.\|.\&\"
.\" called with \*(EL
.
.
.\" ====================================================================
.SH SYNOPSIS
.\" ====================================================================
.
.SY glilypond
.RB [{ \-\-ly2eps | \-\-pdf2eps }]
.RB [ \-e
.IR directory ]
.OP \-k
.RB [ \-o
.IR output-file ]
.RB [ \-p
.IR filename-prefix ]
.RB [ \-t
.IR tdir ]
.RB [{ \-v | \-V }]
.OP \-
.OP \-\-
.RI [ filespec
\*(EL]
.SY glilypond
.RB [{ \-\-ly2eps | \-\-pdf2eps }]
.RB [ \-\-eps_dir
.IR directory ]
.OP \-\-keep_all
.RB [ \-\-output
.IR output-file ]
.RB [ \-\-prefix
.IR filename-prefix ]
.RB [ \-\-temp_dir
.IR tdir ]
.OP \-\-verbose
.OP \-
.OP \-\-
.RI [ filespec
\*(EL]
.YS
.
.SY glilypond
.B \-?
.SY glilypond
.B \-h
.SY glilypond
.B \-\-help
.SY glilypond
.B \-\-usage
.YS
.
.SY glilypond
.B \-l
.SY glilypond
.B \-\-license
.YS
.
.SY glilypond
.B \-\-version
.YS
.
.\" ====================================================================
.SH DESCRIPTION
.\" ====================================================================
.
.B glilypond
transforms sheet music written in the
.I lilypond
language into the
.BR groff (@MAN7EXT@)
language using the
.B .PSPIC
request, such that
.BR groff (@MAN1EXT@)
can transform it into a format that can be displayed directly.
.
.B .PDFPIC
is available, but does on yet work with lilypond.
.
.
.P
Files in
.I groff
language and
.I "standard input"
can be provided as arguments.
.
.
.\" ====================================================================
.SH "WORKING GLILYPOND"
.\" ====================================================================
.
Together with
.BR .PSPIC ,
.B glilypond can work only for
.I troff
devices without
.I PDF
and
.I X
devices.
.
.
.P
I.e., the following
.B groff
devices work,
.BR \-Tps ,
.BR \-Tdvi ,
.BR \-Thtml ,
and
.BR \-Txhtml .
.
.
.P
I'm not sure about the
.B ldp
and
.B lj4
devices.
.
.
.P
In
.BR groffer ,
it is easier to use the following device options, either
.
.BR \-\-ps ,
.BR \-\-div ,
.BR \-\-html,
or
.BR \-\-xhtml .
.
.
.P
Unfortunately, the
.B groff
option
.B \-Tpdf
does not work and the
.B groffer
default
.I PDF
works neither.
.
.
.P
But
.B groffer
has an additional
.IR "pdf mode" ,
not available in
.BR groff .
.
It is based on the
.I ps mode
in
.B groff
and is called through
.B groffer \-\-pdf2
.IR roff-file-with-lilypond .
.
.
.\" ====================================================================
.SH "OPTION OVERVIEW"
.\" ====================================================================
.
.\" ====================================================================
.SS "Breaking Options"
.\" ====================================================================
.
.nh
.nf
.TP
.BR \-? | \-h | \-\-help | \-\-usage
Print help or usage information, then leave the program.
.
.TP
.B \-\-version
Print version information.
.
.TP
.BR \-l | \-\-license
Print license information.
.fi
.hy
.
.
.\" ====================================================================
.SS "Options for building EPS Files"
.\" ====================================================================
.
.TP
.OP \-\-ly2eps
Here the
.B lilypond
program creates
.I eps
files directly.
.
This is the default.
.
.
.TP
.OP \-\-pdf2eps
The program
.B glilypond
generates a
.I PDF
file using
.BR lilypond .
.
Then the
.I eps
file is generated by
.B pdf2ps
and
.BR ps2eps R .
.
.
.\" ====================================================================
.SS "Directories and Files"
.\" ====================================================================
.
.TP
.BR \-e | \-\-eps_dir "\fI directory_name\fP"
Normally all
.I EPS
files are sent to the temporary directory.
.
With this option, you can generate your own directory, in which all useful
.I EPS
files are send.
.
So at last, the temporary directory can be removed.
.
.
.TP
.BR \-p | \-\-prefix "\fI begin_of_name\fP"
Normally all temporary files get names that start with the
.BI ly \*(EL
prefix.
.
With this option, you can freely change this prefix.
.
.
.TP
.BR \-k | \-\-keep_all
Normally all temporary files without the
.I eps
files are deleted.
.
With this option, all generated files either by the
.B lilypond
program or other format transposers are kept.
.
.
.TP
.BR \-t | \-\-temp_dir "\fI dir\fP"
With this option, you call a directory that is the base for the
temporary directory.
.
This directory name is used as is without any extensions.
.
If this directory does not exist it is be created.
.
The temporary directory is created by Perl's security operations
directly under this directory.
.
In this temporary directory, the temporary files are stored.
.
.
.\" ====================================================================
.SS "Output"
.\" ====================================================================
.
.TP
.BR \-o | \-\-output "\fI file_name\fP"
Normally all
.I groff
output of this program is sent to
.BR STDOUT .
.
With this option, that can be changed, such that the output is stored
into a file named in the option argument
.IR file_name .
.
.
.TP
.BR \-v | \-V | \-\-verbose
A lot more of information is sent to STDERR.
.
.
.\" ====================================================================
.SS "Short Option Collections"
.\" ====================================================================
.
The argument handling of options
.
.
.P
.I "Short options"
are arguments that start with a single dash
.BR \- .
.
Such an argument can consist of arbitrary many options without option
argument, composed as a collection of option characters following the
single dash.
.
.
.P
Such a collection can be terminated by an option character that
expects an option argument.
.
If this option character is not the last character of the argument,
the following final part of the argument is the option argument.
.
If it is the last character of the argument, the next argument is
taken as the option argument.
.
.
.P
This is the standard for
.I POSIX
and
.I GNU
option management.
.
.
.P
For example,
.
.TP
.BI \-kVe " some_dir"
is a collection of the short options
.B \-k
and
.B \-V
without option argument, followed by the short option
.B \-e
with option argument that is the following part of the argument
.IR some_dir .
.
So this argument could also be written as several arguments
.B \-k \-V \-e
.IR some_dir .
.
.
.\" ====================================================================
.SS "Handling of Long Options"
.\" ====================================================================
.
Arguments that start with a double dash
.B \-\-
are so-called
.I "long options" R .
.
Each double dash argument can only have a single long option.
.
.
.P
.I "Long options"
have or have not an option argument.
.
An option argument can be the next argument or can be appended with an
equal sign
.B =
to the same argument as the long option.
.
.
.TP
.B \-\-help
is a long option without an option argument.
.
.TP
.BI \-\-eps_dir " some_dir"
.TQ
.BI \-\-eps_dir= some_dir
is the long option
.B \-\-eps_dir
with the option argument
.IR some_dir .
.
.
.P
Moreover the program allows abbreviations of long options, as much as
possible.
.
.
.P
The
.I "long option"
.B \-\-keep_all
can be abbreviated from
.B \-\-keep_al
up to
.B \-\-k
because the program does not have another
.I "long option"
whose name starts with the character
.BR k .
.
.
.P
On the other hand, the option
.B \-\-version
cannot be abbreviated further than
.B \-\-vers
because there is also the
.I long option
.B \-\-verbose
that can be abbreviated up to
.BR \-\-verb .
.
.
.P
An option argument can also be appended to an abbreviation.
.
So is
.BI \-\-e= some_dir
the same as
.B \-\-eps_dir
.IR some_dir .
.
.
.P
Moreover the program allows an arbitrary usage of upper and lower case
in the option name.
.
This is
.I Perl
style.
.
.
.P
For example, the
.I "long option"
.B \-\-keep_all
can as well be written as
.B \-\-Keep_All
or even as an abbreviation like
.BR \-\-KeE .
.
.
.\" ====================================================================
.SH FILESPEC ARGUMENTS
.\" ====================================================================
.
An argument that is not an option or an option argument is called a
.I filespec
argument.
.
.
.P
Without any
.I filespec
argument,
.I "standard input"
is read.
.
.
.P
Each
.I filespec
argument must either be the name of a readable file or a dash
.B \-
for
.IR "standard input" .
.
Each input must be written in the
.I roff
or
.I groff
language and can include
.I lilypond
parts.
.
.
.P
Normally arguments starting with a dash
.B \-
are interpreted as an option.
.
But if you use an argument that consists only of a doubled dash
.B \-\- R ,
all following arguments are taken as
.I filespec
argument, even if such an argument starts with a dash.
.
This is handled according to the
.I GNU
standard.
.
.
.\" ====================================================================
.SH "THE LILYPOND PARTS IN ROFF INPUT"
.\" ====================================================================
.
.\" ====================================================================
.SS "Integrated Lilypond Codes"
.\" ====================================================================
.
A
.I lilypond
part within a structure written in the
.I groff
language is the whole part between the marks
.RS
.EX
.B ".lilypond start"
.EE
.RE
and
.RS
.EX
.B ".lilypond end"
.EE
.RE
.
.
.P
A
.I groff
input can have several of these
.I lilypond
parts.
.
.
.P
When processing such a
.I lilypond
part between
.B ".lilypond start"
and
.B ".lilypond end"
we say that the
.B glilypond
program is in
.IR "lilypond mode" .
.
.
.P
These
.I lilypond
parts are sent into temporary
.I lilypond
files with the file name extension
.BR .ly .
.
These files are transformed later on into
.I EPS
files.
.
.
.\" ====================================================================
.SS "Inclusion of ly-Files"
.\" ====================================================================
.
An additional command line for file inclusion of
.I lilypond
files is given by
.EX
.BI ".lilypond include" " file_name"
.EE
in
.I groff
input.
.
For each such
.I include
command, one file of
.I lilypond
code can be included into the
.I groff
code.
.
Arbitrarily many of these commands can be included in the
.I groff
input.
.
.
.P
These include commands can only be used outside the
.I lilypond
parts.
.
Within the
.IR "lilypond mode" ,
this inclusion is not possible.
.
So
.B ".lilypond include"
may not be used in
.IR "lilypond mode" ,
i.e.\& between
.B ".lilypond start"
and
.BR ".lilypond end" .
.
.
These included
.IR ly -files
are also transformed into
.I EPS
files.
.
.
.\" ====================================================================
.SH "GENERATED FILES"
.\" ====================================================================
.
By the transformation process of
.I lilypond
parts into
.I EPS
files, there are many files generated.
.
By default, these files are regarded as temporary files and as such
stored in a temporary directory.
.
.
.P
This process can be changed by command-line options.
.
.
.\" ====================================================================
.SS "Command Line Options for Directories"
.\" ====================================================================
.
The temporary directory for this program is either created
automatically or can be named by the option
.BR \-t | \-\-temp_dir
.IR dir .
.
.
.P
Moreover, the
.I EPS
files that are later on referred by
.B .PSPIC
command in the final
.I groff
output can be stored in a different directory that can be set by the
command-line option
.BR \-e | \-\-eps_dir
.IR directory_name .
.
With this option, the temporary directory can be removed completely at
the end of the program.
.
.
.P
The beginning of the names of the temporary files can be set by the
command-line option
.OP \-p | \-\-prefix
.IR begin_of_name .
.
.
.P
All of the temporary files except the
.I EPS
files are deleted finally.
.
This can be changed by setting the command-line option
.OP \-k | \-\-keep_files .
.
With this, all temporary files and directories are kept, not deleted.
.
.
.P
These
.I EPS
files are stored in a temporary or
.I EPS
directory.
.
But they cannot be deleted by the transformation process because they
are needed for the display which can take a long time.
.
.
.\" ====================================================================
.SH "TRANSFORMATION PROCESSES FOR GENERATING EPS FILES"
.\" ====================================================================
.
.\" ====================================================================
.SS "Mode pdf2eps"
.\" ====================================================================
.
This mode is the actual default and can also be chosen by the option
.BR \-\-pdf2eps .
.
.
.P
In this mode, the
.B .ly
files are transformed by the
.BR lilypond (1)
program into
.I PDF
files, using
.RS
.EX
.BI "lilypond \-\-pdf \-\-output=" file-name
.EE
.RE
for each
.B .ly
file.
.
The
.I file-name
must be provided without the extension
.BR .pdf .
.
By this process, a file
.IB file-name .pdf
is generated.
.
.
.P
The next step is to transform these
.I PDF
files into a
.I PS
file.
.
This is done by the
.BR pdf2ps (1)
program using
.RS
.EX
\fR$ \fP \fBpdf2ps\fP \fIfile-name\fP \fB.pdf\fP \fIfile-name\fP \fB.ps\fP
.EE
.RE
.
.
The next step creates an
.I EPS
file from the
.I PS
file.
.
This is done by the
.BR ps2eps (1)
program using
.RS
.EX
.RB "$ " "ps2eps " \fIfile-name\fP ".ps"
.EE
.RE
.
.
.P
By that, a file
.IB file-name .eps
is created for each
.I lilypond
part in the
.I groff
file or standard input.
.
.
.P
The last step to be done is replacing all
.I lilypond
parts by the
.I groff
command
.RS
.EX
.BI ".PSPIC " file-name .eps
.EE
.RE
.
.
.\" ====================================================================
.SS "Mode ly2eps"
.\" ====================================================================
.
In earlier time, this mode was the default.
.
But now it does not work any more, so accept the new default
.BR pdf2eps .
.
For testing, this mode can also be chosen by the
.B glilypond
option
.BR \-\-ly2eps .
.
.
.P
In this mode, the
.B .ly
files are transformed by the
.B lilypond
program into many files of different formats, including
.I eps
files, using
.RS
.EX
.BI "$ lilypond \-\-ps \-dbackend=eps \-dgs\-load\-fonts \-\-output=" file\-name
.EE
.RE
for each
.B .ly
file.
.
The output
.I file\-name
must be provided without an extension, its directory is temporary.
.
.
.P
There are many
.I EPS
files created.
.
One having the complete transformed
.B ly
file, named
.IB file\-name .eps \fR.\fP
.
.
.P
Moreover there are
.I EPS
files for each page, named
.IB file\-name \- digit .eps \fR.\fP
.
.
.P
The last step to be done is replacing all
.I lilypond
parts by the collection of the corresponding
.I EPS
page files.
.
This is done by
.I groff
commands
.EX
.BI ".PSPIC " file-name \- digit .eps
.EE
.
.
.\" ====================================================================
.SH "THE GENERATED NEW ROFF STRUCTURE"
.\" ====================================================================
.
The new
.BR groff (@MAN7EXT@)
structure generated by
.B glilypond
is either
.
.TP
1)
sent to standard output and can there be saved into a file or piped into
.BR groff (@MAN1EXT@)
or
.BR groffer (@MAN1EXT@)
or
.
.TP
2)
stored into a file by given the option
.BR \-o\ \~| \~\-\-output
.I file_name
.
.
.\" ====================================================================
.SH AUTHORS
.\" ====================================================================
.B glilypond
was written by
.MT groff\-bernd.warken\-72@\:web.de
Bernd Warken
.ME .
.
.
.\" ====================================================================
.SH "SEE ALSO"
.\" ====================================================================
.
.TP
.BR groff (@MAN1EXT@)
the usage of the groff program and pointers to the documentation and
availability of the
.I groff
system.
.
The main source of information for the
.I groff
system is the
.I groff
.BR info (1)
file.
.
.
.TP
.BR groff (@MAN7EXT@)
documents the
.I groff
language.
.
.
.TP
.BR groff_tmac (@MAN5EXT@)
contains documentation of the
.B .PSPIC
request.
.
.
.TP
.BR lilypond (1)
The documentation of the
.B lilypond
program.
.
The main source of information for the
.I lilypond
language is the
.I lilypond
.BR info (1)
file.
.
.
.TP
.BR pdf2ps (1)
transform a
.I PDF
file into a
.I PostScript
format.
.
.
.TP
.BR ps2eps (1)
transform a
.I PS
file into an
.I EPS
format.
.
.
.\" ====================================================================
.\" Emacs settings
.\" ====================================================================
.
.\" Local Variables:
.\" mode: nroff
.\" End:
.\" vim: set filetype=groff:
