.TH GRODVI @MAN1EXT@ "@MDATE@" "Groff Version @VERSION@"
.SH NAME
grodvi \- convert groff output to TeX DVI format
.
.\" copying (license)
.\"
.\" Copyright (C) 1989-2014 Free Software Foundation, Inc.
.\"
.\" Permission is granted to make and distribute verbatim copies of this
.\" manual provided the copyright notice and this permission notice are
.\" preserved on all copies.
.\"
.\" Permission is granted to copy and distribute modified versions of
.\" this manual under the conditions for verbatim copying, provided that
.\" the entire resulting derived work is distributed under the terms of
.\" a permission notice identical to this one.
.\"
.\" Permission is granted to copy and distribute translations of this
.\" manual into another language, under the above conditions for
.\" modified versions, except that this permission notice may be
.\" included in translations approved by the Free Software Foundation
.\" instead of in the original English.
.
.
.\" Save and disable compatibility mode (for, e.g., Solaris 10/11).
.do nr grodvi_C \n[.C]
.cp 0
.
.ie t .ds tx T\h'-.1667m'\v'.224m'E\v'-.224m'\h'-.125m'X
.el .ds tx TeX
.
.\" Like TP, but if specified indent is more than half
.\" the current line-length - indent, use the default indent.
.de Tp
.  ie \\n(.$=0:((0\\$1)*2u>(\\n(.lu-\\n(.iu)) .TP
.  el .TP "\\$1"
..
.
.de FT
.  if '\\*(.T'dvi' .ft \\$1
..
.
.
.\" ====================================================================
.SH SYNOPSIS
.\" ====================================================================
.
.B grodvi
[
.B \-dlv
] [
.BI \-F dir
] [
.BI \-p papersize
] [
.BI \-w n
] [
.IR files \|.\|.\|.\&
]
.PP
It is possible to have whitespace between a command-line option and its
parameter.
.
.
.\" ====================================================================
.SH DESCRIPTION
.\" ====================================================================
.
.B grodvi
is a driver for
.B groff
that produces \*(tx DVI format.
.
Normally it should be run by
.BR groff\ \-Tdvi .
.
This will run
.BR @g@troff\ \-Tdvi ;
it will also input the macros in
.BR @MACRODIR@/\:dvi.tmac .
.
.LP
The DVI file generated by
.B grodvi
can be printed by any correctly-written DVI driver.
.
The troff drawing primitives are implemented
using the tpic version\~2 specials.
.
If the driver does not support these, the
.B \[rs]D
commands will not produce any output.
.
.LP
There is an additional drawing command available:
.
.TP
.BI \[rs]D'R\  dh\ dv '
Draw a rule (solid black rectangle), with one corner
at the current position, and the diagonally opposite corner
at the current position
.RI +( dh , dv ).
.
Afterwards the current position will be at the opposite corner.
.
This produces a rule in the DVI file and so can be printed even with a
driver that does not support the tpic specials unlike the other
.B \[rs]D
commands.
.
.LP
The groff command
.BI \[rs]X' anything '
is translated into the same command in the DVI file as would be
produced by
.BI \[rs]special{ anything }
in \*(tx;
.I anything
may not contain a newline.
.
.LP
For inclusion of EPS image files,
.B \-Tdvi
loads
.B pspic.tmac
automatically, providing the
.B PSPIC
macro.
.
Please check
.BR groff_tmac (@MAN5EXT@)
for a detailed description.
.
.LP
Font files for
.B grodvi
can be created from tfm files using
.BR tfmtodit (@MAN1EXT@).
.
The font description file should contain the following
additional commands:
.
.Tp \w'\fBinternalname'u+2n
.BI internalname\   name
The name of the tfm file (without the
.B .tfm
extension) is
.IR name .
.
.TP
.BI checksum\  n
The checksum in the tfm file is
.IR n .
.
.TP
.BI designsize\  n
The designsize in the tfm file is
.IR n .
.
.LP
These are automatically generated by
.B tfmtodit.
.
.LP
The default color for
.B \[rs]m
and
.B \[rs]M
is black.
.
Currently, the drawing color for
.B \[rs]D
commands is always black, and fill color values are translated to gray.
.
.LP
In
.B troff
the
.B \[rs]N
escape sequence can be used to access characters by their position
in the corresponding tfm file;
all characters in the tfm file can be accessed this way.
.
.LP
By design, the DVI format doesn't care about physical dimensions of the
output medium.
.
Instead,
.B grodvi
emits the equivalent to \*[tx]'s
.BI \[rs]special{papersize= width , length }
on the first page;
.B dvips
(and possibly other DVI drivers) then sets the page size accordingly.
.
If either the page width or length is not positive, no papersize special
is output.
.
.
.\" ====================================================================
.SH OPTIONS
.\" ====================================================================
.
.TP
.B \-d
Do not use tpic specials to implement drawing commands.
.
Horizontal and vertical lines will be implemented by rules.
.
Other drawing commands will be ignored.
.
.TP
.BI \-F dir
Prepend directory
.IB dir /dev name
to the search path for font and device description files;
.I name
is the name of the device, usually
.BR dvi .
.
.TP
.B \-l
Specify landscape orientation.
.
.TP
.BI \-p papersize
Specify paper dimensions.
.
This overrides the
.BR papersize ,
.BR paperlength ,
and
.B paperwidth
commands in the
.B DESC
file; it accepts the same arguments as the
.B papersize
command (see
.BR groff_font (@MAN5EXT@)
for details).
.
.TP
.B \-v
Print the version number.
.
.TP
.BI \-w n
Set the default line thickness to
.I n
thousandths of an em.
.
If this option isn't specified, the line thickness defaults to
0.04\~em.
.
.
.\" ====================================================================
.SH USAGE
.\" ====================================================================
.
There are styles called
.BR R ,
.BR I ,
.BR B ,
and
.B BI
mounted at font positions 1 to\ 4.
The fonts are grouped into families
.B T
and
.B H
having members in each of these styles:
.
.RS
.TP
.B TR
.FT TR
CM Roman (cmr10)
.FT
.
.TQ
.B TI
.FT TI
CM Text Italic (cmti10)
.FT
.
.TQ
.B TB
.FT TB
CM Bold Extended Roman (cmbx10)
.FT
.
.TQ
.B TBI
.FT TBI
CM Bold Extended Text Italic (cmbxti10)
.FT
.
.TQ
.B HR
.FT HR
CM Sans Serif (cmss10)
.FT
.
.TQ
.B HI
.FT HI
CM Slanted Sans Serif (cmssi10)
.FT
.
.TQ
.B HB
.FT HB
CM Sans Serif Bold Extended (cmssbx10)
.FT
.
.TQ
.B HBI
.FT HBI
CM Slanted Sans Serif Bold Extended (cmssbxo10)
.FT
.RE
.
.LP
There are also the following fonts which are not members of a family:
.
.RS
.TP
.B CW
CM Typewriter Text (cmtt10)
.FT CW
.FT
.
.TQ
.B CWI
CM Italic Typewriter Text (cmitt10)
.FT CWI
.FT
.RE
.
.LP
Special fonts are
.B MI
(cmmi10),
.B S
(cmsy10),
.B EX
(cmex10),
.B SC
(cmtex10, only for
.BR CW ),
and, perhaps surprisingly,
.BR TR ,
.BR TI ,
and
.BR CW ,
due to the different font encodings of text fonts.
.
For italic fonts,
.B CWI
is used instead of
.BR CW .
.
.LP
Finally, the symbol fonts of the American Mathematical Society are available
as special fonts
.B SA
(msam10) and
.B SB
(msbm10).
.
These two fonts are not mounted by default.
.
.LP
Using the option
.B \-mec
(which loads the file
.BR ec.tmac )
provides the EC and TC fonts.
.
The design of the EC family is very similar to that of the CM fonts;
additionally, they give a much better coverage of groff symbols.
.
Note that
.B ec.tmac
must be called before any language-specific files; it doesn't take
care of hcode values.
.
.
.SH ENVIRONMENT
.TP
.SM
.B GROFF_FONT_PATH
A list of directories in which to search for the
.BI dev name
directory in addition to the default ones.
.
See
.BR @g@troff (@MAN1EXT@)
and
.BR \%groff_font (@MAN5EXT@)
for more details.
.
.
.\" ====================================================================
.SH FILES
.\" ====================================================================
.
.TP
.B @FONTDIR@/devdvi/DESC
Device description file.
.
.TP
.BI @FONTDIR@/devdvi/ F
Font description file for font
.IR F .
.
.TP
.B @MACRODIR@/dvi.tmac
Macros for use with
.BR grodvi .
.
.TP
.B @MACRODIR@/ec.tmac
Macros to switch to EC fonts.
.
.
.\" ====================================================================
.SH BUGS
.\" ====================================================================
.
Dvi files produced by
.B grodvi
use a different resolution (57816 units per inch) to those produced by
\*(tx.
.
Incorrectly written drivers which assume the resolution used by \*(tx,
rather than using the resolution specified in the DVI file will not
work with
.BR grodvi .
.
.LP
When using the
.B \-d
option with boxed tables,
vertical and horizontal lines can sometimes protrude by one pixel.
.
This is a consequence of the way \*(tx requires that the heights
and widths of rules be rounded.
.
.
.\" ====================================================================
.SH "SEE ALSO"
.\" ====================================================================
.
.BR tfmtodit (@MAN1EXT@),
.BR groff (@MAN1EXT@),
.BR @g@troff (@MAN1EXT@),
.BR groff_out (@MAN5EXT@),
.BR groff_font (@MAN5EXT@),
.BR groff_char (@MAN7EXT@),
.BR groff_tmac (@MAN5EXT@)
.
.
.\" Restore compatibility mode (for, e.g., Solaris 10/11).
.cp \n[grodvi_C]
.\" Local Variables:
.\" mode: nroff
.\" End:
.\" vim: set filetype=groff:
