.TH GROFF_HDTBL @MAN7EXT@ "@MDATE@" "Groff Version @VERSION@"
.SH NAME
groff_hdtbl \- Heidelberger table macros for GNU roff
.
.
.\" Save and disable compatibility mode (for, e.g., Solaris 10/11).
.do nr groff_hdtbl_C \n[.C]
.cp 0
.
.
.\" ====================================================================
.\" Legalese
.\" ====================================================================
.\"
.\" Copyright (C) 2005-2014 Free Software Foundation, Inc.
.\"
.\" This file is part of groff, the GNU roff type-setting system.
.\"
.\" Permission is granted to copy, distribute and/or modify this
.\" document under the terms of the GNU Free Documentation License,
.\" Version 1.3 or any later version published by the Free Software
.\" Foundation; with the Invariant Sections being this .ig-section and
.\" AUTHORS, with no Front-Cover Texts, and with no Back-Cover Texts.
.\"
.\" A copy of the Free Documentation License is included as a file
.\" called FDL in the main directory of the groff source package.
.
.
.ig
  Some simple formatting macros.  Note that we use '.ig' here and not a
  comment to make 'mandb' 2.4.1 (and probably more recent versions also)
  happy; otherwise the '.char' lines and the stuff which follows is included
  in the 'whatis' database.
..
.
.
.char \[lB] \F[\n[.fam]]\f[R][
.char \[rB] \F[\n[.fam]]\f[R]]
.
.char \[or] \F[\n[.fam]]\f[R]\||\|
.char \[ell] \F[\n[.fam]]\f[R].\|.\|.
.
.char \[oq] \F[\n[.fam]]\f[R]\[oq]
.char \[cq] \F[\n[.fam]]\f[R]\[cq]
.
.
.ie F CR \{\
.
.  \" We have to solve the following problem.  In this code
.  \"
.  \"   foo
.  \"   .CR bar
.  \"   foo
.  \"
.  \" the space immediately after 'bar' should not be taken from the 'C'
.  \" family.  At the same time, this
.  \"
.  \"   foo
.  \"   .CR bar\c
.  \"   foo
.  \"
.  \" should work also.  To fulfill both constraints we emit the
.  \" family changing commands both as escapes and macro calls.
.
.  de make-C-macro
.    de C\\$1
.      ds old-fam \\\\n[.fam]
.      fam C
.      \\$2 \&\\\\$*\F[]\F[\\\\*[old-fam]]
.      fam
\\..
.  .
.
.  make-C-macro R nop
.  make-C-macro B B
.  make-C-macro I I
.
.  de make-C-macro
.    de C\\$1
.      ds old-fam \\\\n[.fam]
.      fam C
.      \\$1 \\\\$@ \F[]\F[\\\\*[old-fam]]
.      fam
\\..
.  .
.
.  make-C-macro BI
.  make-C-macro IB
.  make-C-macro RI
.  make-C-macro IR
.  make-C-macro BR
.  make-C-macro RB
.\}
.el \{\
.  ftr CR R
.  ftr CI I
.  ftr CB B
.  ftr CBI BI
.
.  de CR
.    nop \&\\$*
.  .
.  als CB B
.  als CI I
.
.  als CBI BI
.  als CIB IB
.  als CRI RI
.  als CIR IR
.  als CBR BR
.  als CRB RB
.\}
.
.
.
.de XB
.  B "\\$1"
.  shift
.  CR "\\$1\c"
.  shift
.  while \\n[.$] \{\
.    nop ,
.    CR "\\$1\c"
.    shift
.  \}
.  br
..
.
.
.de XAA
.  TQ
.  CRI \\$@
..
.
.
.de XDEF
.  br
.  B Default:
.  if !\\n[.$] \
.    return
.  CRI "\\$1" "\\$2"
..
.
.
.de XDEFR
.  br
.  B Default:
.  CR "\[oq]\\$1\[cq]"
.  nop (register
.  CR "\[oq]\\$2\[cq]\c"
.  nop ).
..
.
.
.de XDEFS
.  br
.  B Default:
.  CR "\[oq]\\$1\[cq]"
.  nop (string
.  CR "\[oq]\\$2\[cq]\c"
.  nop ).
..
.
.\" ====================================================================
.SH DESCRIPTION
.\" ====================================================================
.
The
.B hdtbl
macros consist of four base and three optional macros, controlled by about
twenty arguments.
.
The syntax is simple and similar to the
.B HTML
table model and nearly as flexible: You can write sequences of tokens (macro
calls with their arguments and content data), separated by blanks and
beginning with a macro call, into the same line to get compact and cleanly
arrranged input.
.
An advantage of
.B hdtbl
is that the tables are constructed without calling a preprocessor; this
means that
.BR groff 's
full macro capabilities are available.
.
On the other hand, table processing with
.B hdtbl
is much slower than using the
.BR tbl (@MAN1EXT@)
preprocessor.
.
A further advantage is that the HTML-like syntax of
.B hdtbl
will be easily converted to HTML; this is not implemented yet.
.
.
.\" ====================================================================
.SH USAGE
.\" ====================================================================
.
In this and the next section, we present examples to help users
understand the basic workflow of
.BR hdtbl .
.
First of all, you must load the
.I hdtbl.tmac
file.
.
As with nearly all other groff macro packages, there are two possibilities
to do so:
.
Either add the line
.
.PP
.nf
.nh
.RS
.CR .mso hdtbl.tmac
.fi
.hy
.RE
.
.PP
to your
.I roff
file before using any macros of the
.B hdtbl
package, or add the option
.
.PP
.nf
.nh
.RS
.CR \-m hdtbl
.fi
.hy
.RE
.
.PP
to the command line of groff (before the document file which contains
.B hdtbl
macros).
.
Then you can include on or more tables in your document, where each one
must be started and ended with the
.CR .TBL
and
.CR .ETB
macros, respectively.
.
.
.PP
In this man page, we approximate the result of each example in the
.I tty
format to be as generic as possible since
.B hdtbl
currently only supports the PS and PDF output devices.
.
.
.PP
The simplest well-formed table consists of just single calls to the
four base table macros in the right order.
.
Here we construct a table with only one cell.
.
.PP
.RS
.nf
.nh
.CR .TBL
.CR .TR
.CR .TD
.CI contents of the table cell
.CR .ETB
.fi
.hy
.RE
.
.
.PP
A
.I tty
representation is
.
.PP
.nf
.nh
.ft CR
.RS
+------------------------------------------------------+
| contents-of-the-table-cell                           |
+------------------------------------------------------+
.RE
.ft
.hy
.fi
.
.
.PP
Equivalent to the above is the following notation.
.
.PP
.RS
.nh
.nf
.CRI ".TBL .TR .TD \[dq]" "contents of the table cell" "\[dq] .ETB"
.fi
.hy
.RE
.
.
.PP
By default, the formatted table is inserted into the surrounding text
at the place of its definition.
.
If the vertical space isn't sufficient, it is placed at the top of
the next page.
.
Tables can also be stored for later insertion.
.
.
.PP
Using
.CIR \[oq]row-number * column-number\[cq]
as the data for the table cells, a table with two rows and two columns
can be written as
.
.
.PP
.RS
.nf
.nh
.CR ".TBL cols=2"
.CR ".  TR .TD 1*1 .TD 1*2"
.CR ".  TR .TD 2*1 .TD 2*2"
.CR ".ETB"
.fi
.hy
.RE
.
.
.PP
A
.I tty
representation is
.
.
.PP
.nf
.nh
.ft CR
.RS
+--------------------------+---------------------------+
| 1*1                      | 1*2                       |
+--------------------------+---------------------------+
| 2*1                      | 2*2                       |
+--------------------------+---------------------------+
.RE
.ft
.hy
.fi
.
.
.PP
Here we see a difference to HTML tables: The number of columns must be
explicitly specified using the
.CRI \[oq]cols= m\[cq]
argument (or indirectly via the
.CR \[oq]width\[cq]
argument, see below).
.
.
.PP
The contents of a table cell is arbitrary; for example, it can be another
table, without restriction to the nesting depth.
.
A given table layout can be either constructed with suitably nested tables
or with proper arguments to
.CR .TD
and
.CR .TH\c
, controlling column and row spanning.
.
Note, however, that this table
.
.PP
.RS
.nf
.nh
.CR ".TBL"
.CR ".  TR"
.CR ".    TD"
.CR ".      nop 1*1 1*2"
.CR ".  TR"
.CR ".    TD"
.CR ".      TBL cols=2 border="
.CR ".        TR"
.CR ".          TD"
.CR ".            nop 2*1"
.CR ".          TD"
.CR ".            nop 2*2"
.CR ".      ETB"
.CR ".ETB"
.fi
.hy
.RE
.
.PP
and this table
.
.PP
.RS
.nf
.nh
.CR ".TBL cols=2"
.CR ".  TR"
.CR ".    TD colspan=2"
.CR ".      nop 1*1 1*2"
.CR ".  TR"
.CR ".    TD"
.CR ".      nop 2*1"
.CR ".    TD"
.CR ".      nop 2*2"
.CR ".ETB"
.fi
.hy
.RE
.
.PP
are similar but not identical (the use of
.CR .nop
is purely cosmetic to get proper indentation).
.
.
.PP
The first table looks like
.
.PP
.nf
.nh
.ft CR
.RS
+------------------------------------------------------+
| 1*1 1*2                                              |
+------------------------------------------------------+
|                                                      |
| 2*1                         2*2                      |
|                                                      |
+------------------------------------------------------+
.RE
.ft
.hy
.fi
.
.PP
and the second one like
.
.PP
.nf
.nh
.ft CR
.RS
+------------------------------------------------------+
| 1*1 1*2                                              |
+---------------------------+--------------------------+
| 2*1                       | 2*2                      |
+---------------------------+--------------------------+
.RE
.ft
.hy
.fi
.
.PP
Here the latter table in a more compact form.
.
.PP
.RS
.nf
.nh
.CR ".TBL cols=2 .TR \[dq].TD colspan=2\[dq] 1*1 1*2"
.CR ".            TR .TD 2*1 .TD 2*2 .ETB"
.fi
.hy
.RE
.
.
.PP
If a macro has one or more arguments (see below), and it is not starting a
line, everything belonging to this macro including the macro itself must be
enclosed in double quotes.
.
.
.\" ====================================================================
.SH MACROS AND ARGUMENTS
.\" ====================================================================
.
The order of macro calls and other tokens follows the HTML model.
.
In the following list, valid predecessors and successors of all
.B hdtbl
macros are given, together with the possible arguments.
.
.PP
Macro arguments are separated by blanks.
.
The order of arguments is arbitrary; they are of the form
.
.PP
.RS
.CRI key= value
.RE
.
.PP
or
.
.PP
.RS
.CRI key=\[aq] "value1 \[lB]value2 \[lB]\[ell]\[rB]\[rB]" \[aq]
.RE
.
.PP
with the only exception of the optional argument of the macro
.CR .ETB\c
, which is the string
.CR \[oq]hold\[cq]\c
\&.
.
Another possible form is
.
.PP
.RS
.CRI \[dq]key= "value1 \[lB]value2 \[lB]\[ell]\[rB]\[rB]" \[dq]
.RE
.
.
.PP
However, this is limited to the case where the macro is the first one in the
line and not already enclosed in double quotes.
.
.
.PP
Argument values specified below as\~\c
.CI c
are colors predefined by
.B groff
or colors defined by the user with the
.CR .defcolor
request.
.
Argument values\~\c
.CI d
are decimal numbers with or without decimal point.
.
Argument values\~\c
.CI m
are natural numbers.
.
Argument values\~\c
.CI n
are numerical values with the usual
.B groff
scaling indicators.
.
Some of the arguments are specific to one or two macros, but most of
them can be specified with
.CR .TBL\c
,
.CR .TR\c
,
.CR .TD\c
, and
.CR .TH\
\&.
.
These common arguments are explained in the next subsection.
.
.
.PP
Most of the argument default values can be changed by the user by
setting corresponding default registers or strings, as listed below.
.
.\"==================================================================
.
.TP
.CBI ".TBL " \[lB]args\[rB]
Begin a new table.
.
.IP
.RS
.XB predecessor: .TD .TH .ETB "cell contents"
.XB successor: .CPTN .TR
.XB arguments:
.
.RS
.XAA border= \[lB]n\[rB]
Thickness of the surrounding box border.
.
.CR \%\[oq]border=\[cq]
(no value) means neither a surrounding box border nor any horizontal or
vertical separator lines between the table rows and cells.
.
.CR \%\[oq]border=0\[cq]
suppresses the surrounding box border, but still allows separator lines
between cells and rows.
.
.XDEFR border=.1n t*b
.
.XAA bc= c
Border color.
.
.XDEFS bc=red4 t*bc
.
.XAA cols= m
Number of table columns.
.
This argument is necessary if more than one column is in the table and no
.CR \[oq]width\[cq]
arguments are present.
.
.XDEFR cols=1 t*cols
.
.XAA cpd= n
Cell padding, i.e., the extra space between the cell space border and
the cell contents.
.
.XDEFR cpd=.5n t*cpd
.
.XAA csp= n
Cell spacing, i.e., the extra space between the table border or
vertical or horizontal lines between cells and the cellspace.
.
.XDEFR csp=.5n t*csp
.
.XAA tal=l\[or]c\[or]r
Horizontal alignment of the table, if it is smaller than the line width.
.
.CR \[oq]tal=l\[cq]\c
: left alignment.
.
.CR \[oq]tal=c\[cq]\c
: centered alignment.
.
.CR \[oq]tal=r\[cq]\c
: right alignment.
.
.XDEFR tal=l t*tal
.
.XAA "width=\[aq]" "w1 \[lB]w2 \[lB]\[ell]\[rB]\[rB]" \[aq]
Widths of table cells.
.
.CI w1\c
.RI , ""
.CI w2\c
.RI , ""
\[ell] are either numbers of type\~\c
.CI n
or natural numbers with the pseudo-scaling indicator
.CR \[oq]%\[cq]\c
, with the meaning \[lq]percent of the actual line length (or column length
for inner tables, respectively)\[rq].
.
If there are less width values than table columns, the last width value is
used for the remaining cells.
.
The argument
.
.RS
.IP
.CR width=\[aq]1.5i 10%\[aq]
.RE
.
.IP
for example indicates that the first column is 1.5\~inches wide; the
remaining columns take 1/10 of the column length each.
.
.XDEF
The table width equals the outer line length or column length; the columns
have equal widths.
.
.XAA height= n
Height of the table.
.
If the table with its contents is lower than\~\c
.CI n\c
.RI , ""
the last row is stretched to this value.
.RE
.RE
.
.\"==================================================================
.
.TP
.CBI ".CPTN " \[lB]args\[rB]
Text of caption.
.
.IP
The (optionally numbered) table caption.
.
.CR .CPTN
is optional.
.
.IP
.RS
.XB predecessor: .TBL
.XB successor: .TR
.XB arguments:
.
.RS
.XAA val=t\[or]b
Vertical alignment of the table caption.
.
.CR \[oq]val=t\[cq]\c
: The caption is placed above the table.
.
.CR \[oq]val=b\[cq]\c
: The caption is placed below the table.
.
.XDEFS val=t t*cptn
.RE
.RE
.
.\"==================================================================
.
.TP
.CBI ".TR " \[lB]args\[rB]
Begin a new table row.
.
.IP
.RS
.XB predecessor: .TBL .CPTN .TD .TH .ETB "cell contents"
.XB successor: .TD .TH
.XB arguments:
.
.RS
.XAA height= n
The height of the row.
.
If a cell in the row is higher than\~\c
.CI n\c
.RI , ""
this value is ignored;
otherwise the row height is stretched to\~\c
.CI n\c
.RI . ""
.RE
.RE
.
.\"==================================================================
.
.TP
.CBI ".TD " "\[lB]args \[lB]cell contents\[rB]\[rB]"
Begin a table data cell.
.TQ
.CBI ".TH " "\[lB]args \[lB]cell contents\[rB]\[rB]"
Begin a table header cell.
.
.IP
Arguments and cell contents can be mixed.
.
The macro
.CR .TH
is not really necessary and differs from
.CR .TD
only in three default settings, similar to the
.CR <TH>
and
.CR <TD>
HTML tags: The contents of
.CR .TH
is horizontally and vertically centered and typeset in boldface.
.
.IP
.RS
.XB predecessor: .TR .TD .TH .ETB "cell contents"
.XB successor: .TD .TH .TR .ETB "cell contents"
.XB arguments:
.
.RS
.XAA colspan= m
The width of this cell is the sum of the widths of the\~\c
.CI m
cells above and below this row.
.
.XAA rowspan= m
The height of this cell is the sum of the heights of the
.CI m
cells left and right of this column.
.
.IP
.B Remark:
Overlapping of column and row spanning, as in the following table fragment
(the overlapping happens in the second cell in the second row), is invalid
and causes incorrect results.
.
.RS
.IP
.nh
.nf
.CR ".TR .TD 1*1 \[dq].TD 1*2 rowspan=2\[dq] .TD 1*3"
.CR ".TR \[dq].TD 2*1 colspan=2\[dq]         .TD 2*3"
.fi
.hy
.RE
.
.PP
A working example for headers and cells with
.B colspan
is
.
.PP
.RS
.nf
.nh
.CR .TBL cols=3
.CR ".  TR" \[dq].TH colspan=2\[dq] header1+2 .TH header3
.CR ".  TR" .TD 1*1 .TD 1*2 .TD 1*3
.CR ".  TR" .TD 2*1 \[dq].TD colspan=2\[dq] 2*2+3
.CR .ETB
.fi
.hy
.RE
.
.PP
This looks like
.
.PP
.ft CR
.if t \{\
.  ne 7v
.\}
.RS
.nf
.nh
+------------------------------+---------------+
|          header1+2           |    header3    |
+--------------+---------------+---------------+
| 1*1          | 1*2           | 1*3           |
+--------------+---------------+---------------+
| 2*1          | 2*2+3                         |
+--------------+-------------------------------+
.RE
.ft
.hy
.fi
.
.PP
A working example with
.B rowspan
is
.
.PP
.RS
.nf
.nh
.CR .TBL cols=3
.CR ".  TR"
.CR ".  TD" 1*1
.CR ".  TD" rowspan=2 1+2*2
.CR ".  TD" 1*3
.CR .
.CR ".  TR"
.CR ".  TD" 2*1
.CR ".  TD" 2*3
.CR .ETB
.fi
.hy
.RE
.
.PP
which looks like
.
.PP
.ft CR
.RS
.nf
.nh
+--------------+---------------+---------------+
| 1*1          | 1+2*2         | 1*3           |
+--------------+               +---------------+
| 2*1          |               | 2*3           |
+--------------+---------------+---------------+
.hy
.fi
.RE
.ft CR
.
.RE
.RE
.
.\"==================================================================
.
.TP
.CB ".ETB \[lB]hold\[rB]"
End of the table.
.
.IP
This macro finishes a table.
.
It causes one of the following actions.
.
.RS
.IP \[bu] 3
If the argument
.CR \[oq]hold\[cq]
is given, the table is held until it is freed by calling the macro
.CR .t*free\c
, which in turn prints the table immediately, either at the current position
or at the top of the next page if its height is larger than the remaining
space on the page.
.
.IP \[bu] 3
Otherwise, if the table is higher than the remaining space on the page,
it is printed at the top of the next page.
.
.IP \[bu] 3
If neither of the two above constraints hold, the table is printed
immediately at the place of its definition.
.RE
.
.IP
.RS
.XB predecessor: .TD .TH .ETB "cell contents"
.XB successor: .TBL .TR .TD .TH .ETB "cell contents"
.XB arguments:
.
.RS
.XAA hold
Prevent the table from being printed until it is freed by calling the
macro
.CR .t*free\c
\&.
.
This argument is ignored for inner (nested) tables.
.RE
.RE
.
.\"==================================================================
.
.TP
.CBI ".t*free " \[lB]n\[rB]
Free the next held table or
.CI n\~\c
.RI held ""
tables.
.
Call this utility macro to print tables which are held by using the
.CR \[oq]hold\[cq]
argument of the
.CR .ETB
macro.
.
.
.\" ====================================================================
.SS "Arguments common to \f[CB].TBL\f[], \f[CB].TR\f[], \f[CB].TD\f[], and \f[CB].TH\f[]"
.\" ====================================================================
.
The arguments described in this section can be specified with the
.CR .TBL
and
.CR .TR
macros, but they are eventually passed on to the table cells.
.
If omitted, the defaults take place, which the user can change by setting
the corresponding default registers or strings, as documented below.
.
Setting an argument with the
.CR .TBL
macro has the same effect as setting it for all rows in the table.
.
Setting an argument with a
.CR .TR
macro has the same effect as setting it for all the
.CR .TH
or
.CR .TD
macro in this row.
.
.IP
.XAA bgc= \[lB]c\[rB]
The background color of the table cells.
.
This includes the area specified with the
.CR \[oq]csp\[cq]
argument.
.
The argument
.CR \[oq]bgc=\[cq]
(no value) suppresses a background color; this makes the background
transparent.
.
.XDEFS bgc=bisque t*bgc
.
.XAA fgc= c
The foreground color of the cell contents.
.
.XDEFS fgc=red4 t*fgc
.
.XAA ff= name
The font family for the table.
.
.CI name
is one of the groff font families, for example
.CR A
for the AvantGarde fonts or
.CR HN
for Helvetica-Narrow.
.
.XDEF
The font family found before the table (string
.CR \[oq]t*ff\[cq]\c
).
.
.XAA fst= style
The font style for the table.
.
One of
.CR R\c
,
.CR B\c
,
.CR I\c
, or
.CR BI
for roman,
.BR bold ,
.IR italic ,
or \f[BI]bold italic\f[], respectively.
.
As with
.BR roff 's
.CR .ft
request the
.CR \[oq]fst\[cq]
argument can be used to specify the font family and font style together, for
example
.CR \[oq]fst=HNBI\[cq]
instead of
.CR \[oq]ff=HN\[cq]
and
.CR \[oq]fst=BI\[cq]\c
\&.
.
.XDEF
The font style in use right before the table (string
.CR \[oq]t*fst\[cq]\c
).
.
.XAA "fsz=\[aq]" "d1 \[lB]d2\[rB]" \[aq]
A decimal or fractional factor
.CI d1\c
.RI , ""
by which the point size for the table is changed, and
.CI d2\c
.RI , ""
by which the vertical line spacing is changed.
.
If
.CI d2
is omitted, value
.CI d1
is taken for both.
.
.XDEFS "fsz=\[aq]1.0 1.0\[aq]" t*fsz
.
.XAA hal=l\[or]c\[or]b\[or]r
Horizontal alignment of the cell contents in the table.
.
.CR \[oq]hal=l\[cq]\c
: left alignment.
.
.CR \[oq]hal=c\[cq]\c
: centered alignment.
.
.CR \[oq]hal=b\[cq]\c
: both (left and right) alignment.
.
.CR \[oq]hal=r\[cq]\c
: right alignment.
.
.XDEFS hal=b t*hal
.
.XAA val=t\[or]m\[or]b
Vertical alignment of the cell contents in the table for cells lower
than the current row.
.
.CR \[oq]val=t\[cq]\c
: alignment below the top of the cell.
.
.CR \[oq]val=m\[cq]\c
: alignment in the middle of the cell.
.
.CR \[oq]val=b\[cq]\c
: alignment above the cell bottom.
.
.XDEFS val=t t*val
.
.XAA hl=\[lB]s\[or]d\[rB]
Horizontal line between the rows.
.
If specified with
.CR .TD
or
.CR .TH
this is a separator line to the cell below.
.
.CR \[oq]hl=\[cq]
(no value): no separator line.
.
.CR \[oq]hl=s\[cq]\c
: a single separator line between the rows.
.
.CR \[oq]hl=d\[cq]\c
: a double separator line.
.
.IP
The thickness of the separator lines is the half of the border thickness,
but at least 0.1\~inches.
.
The distance between the double lines is equal to the line thickness.
.
.IP
.B Remark:
Together with
.CR \[oq]border=0\[cq]
for proper formatting the value of
.CR \[oq]csp\[cq]
must be at least .05\~inches for single separator lines and .15\~inches for
double separator lines.
.
.XDEFS hl=s t*hl
.
.XAA vl=\[lB]s\[or]d\[rB]
Vertical separator line between the cells.
.
If specified with
.CR .TD
or
.CR .TH
this is a separator line to the cell on the right.
.
.CR \[oq]vl=s\[cq]\c
: a single separator line between the cells.
.
.CR \[oq]vl=d\[cq]\c
: a double separator line.
.
.CR \[oq]vl=\[cq]
(no value): no vertical cell separator lines.
.
For more information see the documentation of the
.CR \[oq]hl\[cq]
argument above.
.
.XDEFS vl=s t*vl
.
.
.\" ====================================================================
.SH HDTBL CUSTOMIZATION
.\" ====================================================================
.
.PP
Before creating the first table, you should configure default values
to minimize the markup needed in each table.
.
The following example sets up defaults suitable for typical papers:
.PP
.RS
.nf
.CR ".ds t*bgc white\e\[dq] background color
.CR ".ds t*fgc black\e\[dq] foreground color
.CR ".ds t*bc black\e\[dq]  border color
.CR ".nr t*cpd 0.1n\e\[dq]  cell padding
.fi
.RE
.
.
.PP
The file
.B examples/common.roff
provides another example setup
in the \[lq]minimal Page setup\[rq] section.
.
.
.PP
A table which does not fit on a partially filled page is printed
automatically on the top of the next page if you append the little
utility macro
.CR t*hm
to the page header macro of your document's main macro package.
.
For example, say
.
.PP
.RS
.nf
.CR ".am pg@top"
.CR ".  t*hm"
.CR ".."
.fi
.RE
.
.
.PP
if you use the
.B ms
macro package.
.
.
.PP
The macro
.CR t*EM
checks for held or kept tables,
and for missing
.CR ETB
macros (table not closed).
.
You can append this macro
to the \[lq]end\[rq] macro of your document's main macro package.
.
For example:
.
.PP
.RS
.nf
.nh
.CR ".am pg@end-text"
.CR ".  t*EM"
.CR ".."
.fi
.hy
.RE
.
.PP
If you use the
.B ms
macro package.
.
.
.\" ====================================================================
.SH BUGS AND SUGGESTIONS
.\" ====================================================================
.
Please send your commments to the
.MT groff@\:gnu.org
groff mailing list
.ME
or directly to the author.
.
.
.\" ====================================================================
.SH AUTHORS
.\" ====================================================================
The
.B hdtbl
macro package was written by
.MT Joachim.Walsdorff@\:urz.uni\-heidelberg.de
Joachim Walsdorff
.ME .
.
.
.\" ====================================================================
.SH SEE ALSO
.\" ====================================================================
.TP
.BR groff (1)
provides an overview of GNU
.I roff
and details how to invoke
.I groff
at the command line.
.TP
.BR groff (7)
summarizes the
.I roff
language and GNU extensions to it.
.TP
.BR tbl (1)
describes the traditional
.I roff
preprocessor for tables.
.
.
.\" Restore compatibility mode (for, e.g., Solaris 10/11).
.cp \n[groff_hdtbl_C]
.
.
.\" ====================================================================
.\" Emacs settings
.\" ====================================================================
.
.\" Local Variables:
.\" mode: nroff
.\" End:
.\" vim: filetype=groff:
