/* vsprintf with automatic memory allocation.
   Copyright (C) 2002-2003, 2012-2026 Free Software Foundation, Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU Lesser General Public License as published by
   the Free Software Foundation; either version 2.1 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public License
   along with this program.  If not, see <https://www.gnu.org/licenses/>.  */

#ifndef _VASPRINTF_H
#define _VASPRINTF_H

/* Get va_list.  */
#include <stdarg.h>

#ifndef __attribute__
/* This feature is available in gcc versions 2.5 and later and in clang.  */
# if !((__GNUC__ >= 2 || (__GNUC__ == 2 && __GNUC_MINOR__ >= 5) || defined __clang__) && !__STRICT_ANSI__)
#  define __attribute__(Spec) /* empty */
# endif
/* The __-protected variants of 'format' and 'printf' attributes are
   accepted by gcc versions 2.6.4 (effectively 2.7) and later and in clang.  */
# if !(__GNUC__ > 2 || (__GNUC__ == 2 && __GNUC_MINOR__ >= 7) || defined __clang__)
#  define __format__ format
#  define __printf__ printf
# endif
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* Write formatted output to a string dynamically allocated with malloc().
   If the memory allocation succeeds, store the address of the string in
   *RESULT and return the number of resulting bytes, excluding the trailing
   NUL.  Upon memory allocation error, or some other error, return -1.  */
extern int asprintf (char **result, const char *format, ...)
       __attribute__ ((__format__ (__printf__, 2, 3)));
extern int vasprintf (char **result, const char *format, va_list args)
       __attribute__ ((__format__ (__printf__, 2, 0)));

#ifdef __cplusplus
}
#endif

#endif /* _VASPRINTF_H */
