/*++
/* NAME
/*	syslog 3
/* SUMMARY
/*	surrogate BSD4.3 syslog facility
/* PROJECT
/*	pc-mail
/* PACKAGE
/*	nfs
/* SYNOPSIS
/*	include "syslog.h"
/*
/*	openlog(name, logopt, facility)
/*	char *name;
/*	int logopt;
/*	int facility;
/*
/*	syslog(priority, format, arguments)
/*	int priority;
/*	char *format;
/*
/*	closelog()
/* DESCRIPTION
/*	These functions emulate the BSD4.3 syslog(3) facility. Output is
/*	written to a system logfile (default /usr/spool/mqueue/syslog).
/*	That file should have mode 666 (i.e. read/write access permitted
/*	for everyone).
/*
/*	syslog() tries to output the log entry as one big chunk.
/* FILES
/*	/usr/spool/mqueue/syslog, system logfile
/* SEE ALSO
/*	percentm(3), interprets "%m" sequences in syslog format strings.
/* BUGS
/*	The functions use the stdio package. This may cause the program to
/*	grow unexpectedly.
/* AUTHOR(S)
/*	Wietse Z. Venema
/*	Eindhoven University of Technology
/*	Department of Mathematics and Computer Science
/*	Den Dolech 2, P.O. Box 513, 5600 MB Eindhoven, The Netherlands
/* CREATION DATE
/*	Sun Oct 29 15:12:57 MET 1989
/* LAST MODIFICATION
/*	10/29/89 22:58:33
/* VERSION/RELEASE
/*	1.2
/*--*/

#ifndef SYSLOG

#ifndef lint
static char sccsid[] = "@(#) syslog.c 1.2 10/29/89 22:58:33";

#endif

#include <stdio.h>
#include <varargs.h>
#include <time.h>
#include "percentm.h"

extern struct tm *localtime();
extern char *asctime();
extern long time();
extern int errno;

#ifndef SYSLOGFILE
#define	SYSLOGFILE	"/usr/spool/mqueue/syslog"
#endif

static char *logname;

/* openlog - initialize syslog facility; ignores all but the "name" argument */

/* ARGSUSED */

openlog(name, logopt, facility)
char   *name;
int     logopt;
int     facility;
{
    logname = name;				/* ignore rest */
}

/* syslog - append entry to system log */

/* VARARGS */

syslog(va_alist)
va_dcl
{
    va_list ap;
    char   *fmt;
    char   *percentm();
    long    secs;
    char   *date;
    FILE   *fp;
    int     err = errno;
    static char buf[BUFSIZ];

    if (fp = fopen(SYSLOGFILE, "a")) {

	/* Format the time stamp */

	secs = time((long *) 0);
	date = asctime(localtime(&secs));
	(void) sprintf(buf, "%2.2s %3.3s %2.2s %8.8s %s: ",
		       date + 8, date + 4, date + 22, date + 11, logname);

	/* Format the actual message */

	va_start(ap);
	(void) va_arg(ap, int);			/* skip priority */
	fmt = va_arg(ap, char *);
	(void) vsprintf(buf + strlen(buf), percentm(fmt, err), ap);
	va_end(ap);

	/* Try to output the log entry as one big chunk */

	(void) fprintf(fp, "%s\n", buf);
	(void) fclose(fp);
    }
}

/* closelog - a real dummy */

closelog()
{
    /* no-op */
}

#endif					/* SYSLOG */

