/*++
/* NAME
/*	percentm 3
/* SUMMARY
/*	convert %m to system error message
/* PROJECT
/*	pc-mail
/* PACKAGE
/*	nfs
/* SYNOPSIS
/*	#include percentm.h
/*
/*	char *percentm(string, err)
/*	char *string;
/*	int err;
/* DESCRIPTION
/*	percentm() interprets %m format specificiers in \fIstring\fR
/*	In the output, %m will be replaced by the error message that
/*	corresponds with the error value \fIerr\fR (see <errno.h>.
/* BUGS
/*	The result is stored in static memory that is overwritten with
/*	each call.
/* AUTHOR(S)
/*	Wietse Z. Venema
/*	Eindhoven University of Technology
/*	Department of Mathematics and Computer Science
/*	Den Dolech 2, P.O. Box 513, 5600 MB Eindhoven, The Netherlands
/* CREATION DATE
/*	Sun Oct 29 15:29:37 MET 1989
/* LAST MODIFICATION
/*	12/5/89 22:03:27
/* VERSION/RELEASE
/*	1.2
/*--*/

#ifndef lint
static char sccsid[] = "@(#) percentm.c 1.2 12/5/89 22:03:27";

#endif

#include <stdio.h>
#include "percentm.h"

extern int errno;
extern char *sys_errlist[];
extern int sys_nerr;
extern char *strcpy();

/* percentm - replace %m by error message associated with value in err */

char   *percentm(str, err)
char   *str;
int     err;
{
    static char buf[BUFSIZ];
    register char *ip = str;
    register char *op = buf;

    while (*ip) {
	switch (*ip) {
	case '%':
	    switch (ip[1]) {
	    case '\0':				/* don't fall off end */
		*op++ = *ip++;
		break;
	    case 'm':				/* replace %m */
		(void) strcpy(op,
			sys_errlist[(err < sys_nerr && err > 0) ? err : 0]);
		op += strlen(op);
		ip += 2;
		break;
	    default:				/* leave %<any> alone */
		*op++ = *ip++, *op++ = *ip++;
		break;
	    }
	default:
	    *op++ = *ip++;
	}
    }
    *op = '\0';
    return (buf);
}

