/*------------------------------------------------------------------------

      File:  utility.c
   Project:  Tcl Modules
   Created:  Tue Oct 22 23:45:57 1991
    Author:  John L. Furlani<john.furlani@East.Sun.COM>
  Revision:  1.4
  Last Mod:  20:20:00, 1/19/92

  Description of File:
		
	
	
	
	
	
	
	
------------------------------------------------------------------------*/
/***********************************************************************
* Copyright 1991 by John L. Furlani.  All rights reserved.
* 
* This material was written by John L. Furlani.
*
* Redistribution and use in source and binary forms are permitted
* provided that this entire copyright notice is duplicated in all such
* copies, and that any documentation, announcements, and other
* materials related to such distribution and use acknowledge that the
* software was developed by John Furlani.  No charge, other than an 
* "at-cost" distribution fee, may be charged for copies, derivations, 
* or distributions of this material without the express written 
* consent of the copyright holder.  The name of the author may not
* be used to endorse or promote products derived from this material 
* without specific prior written permission
*
* THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
* WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
* MERCHANTIBILITY AND FITNESS FOR ANY PARTICULAR PURPOSE.
************************************************************************/
static char SccsId[] = "@(#)utility.c	1.4\t1/19/92";

#include "global.h"
#include <regexp.h>

char cmd_separator = ';';

/*
  This function simply marks that the variable has been
  changed by adding it to the hash table and then exit.
*/
int
set_shell_variable(const char* var,
		   const char* val)
{
  int   new;

  Tcl_CreateHashEntry(set_environ_changes, (char*) var, &new);

  return 0;
}

int
unset_shell_variable(const char* var)
{
  int new;

  Tcl_CreateHashEntry(unset_environ_changes, (char*) var, &new);
  
  return 0;
}

int
Flush_Shell_Changes(void)
{
  Tcl_HashSearch   searchPtr;
  Tcl_HashEntry*   hashEntry;
  Tcl_HashTable*   table[2];
  char*            var, *eq;
  int              i;


  table[0] = set_environ_changes;
  table[1] = unset_environ_changes;

  for(i = 0; i < 2; i++) {
    
    if((hashEntry = Tcl_FirstHashEntry(table[i], &searchPtr)) == NULL) {
      return TCL_OK;
    }

    do 
      {
	eq = var = (char*) Tcl_GetHashKey(table[i], hashEntry);

	if(i == 1)
	  output_unset_shell_info((char*) var);
	else
	  output_set_shell_info((char*) var, getenv(var));
      } 
    while(hashEntry = Tcl_NextHashEntry(&searchPtr));
  }

  return TCL_OK;
}  

int
output_set_shell_info(const char* var,
		      const char* val)
{
  if(!strcmp((char*) shell_derelict, "csh"))
      fprintf(stdout, "setenv %s %s%c", var, val, cmd_separator);
  else if(!strcmp((char*) shell_derelict, "sh"))
    fprintf(stdout, "%s=%s%cexport %s%c", var, val, cmd_separator,
	    var, cmd_separator);
  else {
    fprintf(stderr, 
	    "ERROR in set_shell_variable():  Unrecognized shell derelict\n");
    return -1;
  }
  return 0;
}

int
output_unset_shell_info(const char* var)
{
  if(!strcmp(shell_derelict, "csh"))
    fprintf(stdout, "unsetenv %s%c", var, cmd_separator);
  else if(!strcmp(shell_derelict, "sh"))
    fprintf(stdout, "unset %s%c", var, cmd_separator);
  else {
    fprintf(stderr, 
	    "ERROR in unset_shell_variable():  Unrecognized shell derelict\n");
    return -1;
  }
  
  return 0;
}

char*
set_derelict(const char* name) {
  if(!strcmp((char*) name, "sh") || 
     !strcmp((char*) name, "bash") || 
     !strcmp((char*) name, "ksh"))
    return strcpy(shell_derelict, "sh");
  else if(!strcmp((char*) name, "csh") || 
	  !strcmp((char*) name, "tcsh"))
    return strcpy(shell_derelict, "csh");
  else
    return NULL;
}

int
set_shell_alias(const char* var,
		const char* val)
{
  if(!strcmp(shell_derelict, "csh")) {
    /* need to switch $* to \!* */
    regexp* dollarstar;
    char*   newval = (char*) val;

    fprintf(stdout, "alias %s '", var);

    dollarstar = regcomp("\\$\\*");    
    if(regexec(dollarstar, newval)) {
      do {
	*dollarstar->startp[0] = '\0';
	fprintf(stdout, "%s\\!*", newval);
	newval = dollarstar->endp[0];
      }
      while(regexec(dollarstar, newval));
      fprintf(stdout, "%s", newval);
    } else
      fprintf(stdout, "%s", val);

    fprintf(stdout, "'%c", cmd_separator);
  }
  else if(!strcmp(shell_name, "bash") ||
          !strcmp(shell_name, "ksh"))
    fprintf(stdout, "alias %s='%s'%c", var, val, cmd_separator);

  return 0;
}

int
unset_shell_alias(const char* var)
{
  if(!strcmp(shell_derelict, "csh") ||
     !strcmp(shell_name, "bash") ||
     !strcmp(shell_name, "ksh"))
    fprintf(stdout, "unalias %s%c", var, cmd_separator);

  return 0;
}

/*
int
store_env(void)
{
  int   i, new;
  char* eq;
  char* tmpkey;

  Tcl_DeleteHashTable(environ_changes);
  Tcl_InitHashTable(environ_changes, TCL_STRING_KEYS);

  for(i = 0; environ[i]; i++) {
    if((tmpkey = (char*) malloc(strlen(environ[i]) + 1)) == NULL) {
      fprintf(stderr, "Couldn't malloc string of char in store_env()\n");
      return -1;
    }

    strcpy(tmpkey, environ[i]);

    eq = tmpkey;
    while(*eq++ != '=' && *eq);
    *(eq - 1) = '\0';
    Tcl_CreateHashEntry(environ_changes, tmpkey, &new);
  }

  return 0;
}
*/

char*
get_backup(Tcl_HashTable* table, char* var)
{
  Tcl_HashEntry* hentry;
  char* retval;

  hentry = Tcl_FindHashEntry(table, var);

  if((hentry) != NULL) {
    retval = (char*) Tcl_GetHashValue(hentry);
    return retval;
  }
  return NULL;
}

char*
set_backup(Tcl_HashTable* table, char* var, char* val)
{
  Tcl_HashEntry* hentry;
  char*  newenv;
  char*  eq;
  int    new;

  newenv = (char*) malloc(strlen(var) + strlen(val) + 2);
  sprintf(newenv, "%s=%s", var, val);
  eq = newenv;
  while(*eq++ != '=' && *eq);
  *(eq - 1)= '\0';

  if((hentry = Tcl_CreateHashEntry(table, newenv, &new)) != NULL) {
    Tcl_SetHashValue(hentry, eq);
  }
}

/*
int
store_env(void)
{
  int i;

  for(i = 0; environ[i]; i++);

  if((backup_envp = (char**) calloc(i, sizeof(char*))) == NULL) {
    fprintf(stderr, "Couldn't calloc array of %d char*\n", i);
    return -1;
  }

  for(i = 0; environ[i]; i++) {
    if((backup_envp[i] = (char*) malloc(strlen(environ[i]) + 1)) == NULL) {
      fprintf(stderr, "Couldn't malloc string of char\n");
      return -1;
    }

    strcpy(backup_envp[i], environ[i]);
  }
}

int
free_stored_env(void)
{
  int i;

  for(i = 0; backup_envp[i]; i++) {
    free(backup_envp[i]);
  }
  free(backup_envp);
}


char*
set_backup_env(char* var,
	       char* val)
{
  int i;
  char* eq;
  char* newenv;

  for(i = 0; backup_envp[i]; i++) {
    eq = backup_envp[i];
    while(*eq++ != '=' && *eq); 
    *(eq - 1)= '\0';
    if(!strcmp(backup_envp[i], var)) {
      newenv = (char*) malloc(strlen(var) + strlen(val) + 2);
      sprintf(newenv, "%s=%s", var, val);
      free(backup_envp[i]);
      backup_envp[i] = newenv;
      return newenv;
    }
    *(eq - 1) = '=';
  }

  return 0;
}

char*
get_backup_env(char* var)
{
  int   i;
  char* eq;

  for(i = 0; backup_envp[i]; i++) {
    eq = backup_envp[i];
    while(*eq++ != '=' && *eq); 
    *(eq - 1)= '\0';
    if(!strcmp(backup_envp[i], var)) {
      *(eq - 1) = '=';
      return eq;
    }
    *(eq - 1) = '=';
  }

  return NULL;
}
*/
