/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#include <stdarg.h>
#include "ooglutil.h"


char	*_GFILE;	/* Name of file where error is found */
int	_GLINE;		/* Line number in file where error is found */
int	OOGL_Errorcode;	/* Unique integer error code */

void _OOGLError(int errorcode,char* fmt,...)
{
   va_list args;
   va_start(args, fmt);
   fprintf(stderr, "Error <%d>: ",errorcode);
   if (fmt != NULL) vfprintf(stderr, fmt, args);
   fprintf(stderr, "\n");
   fprintf(stderr, "File: %s, Line: %d\n",_GFILE,_GLINE);
   fprintf(stderr, "\n");
   OOGL_Errorcode = errorcode;
   va_end(args);
}

GeomWarn(fmt, p1, p2, p3, p4, p5)
	register char *fmt;
	long p1, p2, p3, p4, p5;
{
	int level = 2;

	if(fmt[0] < ' ' && fmt[0] != '\0')
		level = *fmt++;
	/* Maybe we have a current warning level below which we don't print */

	fprintf(stderr, fmt, p1, p2, p3, p4, p5);
	fputc('\n', stderr);
	fflush(stderr);
}

char *
sperrno(err)
	unsigned int err;
{
	extern int sys_nerr;
	extern char *sys_errlist[];
	static char errstr[16];

	if(err < sys_nerr)
		return(sys_errlist[err]);
	sprintf(errstr, "Error %d", err & 0xffff);
	return(errstr);
}

char *
sperror()
{
	extern int errno;

	return sperrno(errno);
}
