/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */
static char *copyright = "Copyright (C) 1992 The Geometry Center";

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

/*
 * Routines for operating on References -- pretty trivial, huh.
 */

#include "reference.h"
#include "ooglutil.h"

#ifndef NULL
# define NULL 0
#endif

void
RefInit(register Ref *ref, long magic)
{
    ref->ref_count = 1;
    ref->magic = magic;
    ref->handle = NULL;
}

RefCount(Ref *ref)
{
    return ref ? ref->ref_count : 0;
}

RefIncr(Ref *ref)
{
    return ref ? ++ref->ref_count : 0;
}

RefDecr(Ref *ref)
{
    if(ref == NULL) return 0;
    if(--ref->ref_count < 0) {
	OOGLError(1, "RefDecr: ref %x count %d < 0!", ref, ref->ref_count);
    }
    return ref->ref_count;
}

RefMagic(Ref *ref) { return ref->magic; }

