/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#ifndef _HANDLEPOOLP_
#define _HANDLEPOOLP_
/*
 * Communications -- Private definitions for Pools and Handles.
 */
#include "ooglutil.h"
#include "streampool.h"
/*#include "sm.h"*/

#define	HANDLEMAGIC	OOGLMagic('h',1)

typedef struct HRef {
	Handle	**hp;
	Ref	*parentobj;
	void	*info;
	void	(*update)();
} HRef;

struct Handle {
	REFERENCEFIELDS
	HandleOps *ops;		/* Comm-related operations on our datatype */
	char	*name;		/* Char-string name */
	Ref	*object;	/* Current object value if any */
	Handle	*next;		/* Link in list of all handles */
	Pool	*whence;	/* Where did this handle's value come from? */

	int	maxrefs;	/* Resizable array of references */
	int	nrefs;		/*  to this Handle, which we update */
	HRef	*refs;		/*  when the Handle's object changes. */

	/*
	 * Pool-type-specific state
	 */
#if 0
    	SMSym	*sym;		/* Address of our SM symbol */
    	int	version;	/* Version number of shared-memory symbol */
    	Pool	*smpool;	/* Pool in which our symbol lies */
    	Handle	*samepool;	/* Link in list of handles on this pool */
#endif
};

#define	P_SM	1
#define	P_STREAM 2

struct Pool {
	int	type;		/* P_SM or P_STREAM */
	Pool	*next;		/* Link in list of all Pools */
	char	*poolname;	/* Name of this pool: typically a filename */
	Handle	*handles;	/* All handles using this Pool */
	HandleOps *ops;		/* I/O operations */

	long	await;		/* Unix time until which we should wait */
	int	(*resyncing)();	/* We're resyncing, call this ... if non-NULL */

	/*
	 * State for P_STREAM pools.
	 */

	char	otype;		/* PO_HANDLES, PO_DATA, PO_ALL */
	char	mode;		/* read/write status: 0, 1, 2 as with open() */
	char	seekable;	/* 1 for plain file, 0 for pipe/socket */
	char	softEOF;	/* Can we hope to read more after EOF?
				 * 1 for tty or named pipe, 0 otherwise.
				 */
	FILE	*inf;
	FILE	*outf;

	short	flags;		/* Miscellaneous internal flags: */
#define	  PF_TEMP	1	/*   "Temporary pool" -- not in AllPools list */
#define	  PF_ANY	2	/*   any objects read from this Pool? */
#define	  PF_REREAD	4	/*   actually re-read on "<" */

	short	level;		/* {} Bracket counter */

	long	inf_mtime;	/* modification time of p->inf file */
				/* A second explicit reference to the same
				 * file can cause it to be re-read if it's
				 * been changed since last time, or if it's
				 * a stream (not seekable).
				 */

	/*
	 * State for P_SM pools.
	 */
#if 0
    	SMRegion *sm;		/* for shared-memory Pools */
#endif
};

#endif /*_HANDLEPOOLP_*/
