#include "mg_xglP.h"
#include "polylistP.h"

/*
 * Draw an OOGL PolyList in XGL.
 */

#define MAXPOLYS 32	/* Max number of polygons we ship to XGL in one lump */

void
mgxgl_polylist(int npolys, Poly *p, int nverts, Vertex *v, register int plflags)
{ 
    register Poly *poly;
    int facetflag;
    int alltri = 1;
    int allquad = 1;
    int perfacet, perpoint;		/* Bytes per facet and per point */
    int pt_type;			/* Xgl_pt_type : per-vertex data type */
    Xgl_facet_list fl, *flp;
    long ifacets[MAXPOLYS * sizeof(Xgl_color_normal_facet) / sizeof(long) + 1];
    Xgl_pt_list pls[MAXPOLYS];
    Xgl_pt_list *plp;
    char *facetp;
    int pno, ptbytes, polysleft, polysnow;

    /*
     * Determine format of points and facets based on available & relevant data.
     * Strip irrelevant bits off plflags; set "perfacet" and "perpoint" sizes.
     */
    perfacet = 0;
    switch(MGC->astk->ap.shading) {
    case APF_FLAT: plflags &= ~(PL_HASVN|PL_HASVCOL); break;
    case APF_CONSTANT: plflags &= ~(PL_HASVN|PL_HASVCOL|PL_HASPN); break;
    case APF_SMOOTH: plflags &= ~PL_HASPN; break;
    default:
	OOGLError(1, /*Warn*/"Unknown shading style %d",
		MGC->astk->ap.shading);
    }


    if((MGC->astk->ap.flag & APF_FACEDRAW) == 0)
	plflags = 0;

    /*
     * Determine size and datatype of vertices
     */
    switch(plflags & (PL_HASVCOL|PL_HASVN)) {
    case 0:
	perpoint = sizeof(Xgl_pt_f3d); pt_type = XGL_PT_F3D; break;
    case PL_HASVCOL:
	perpoint = sizeof(Xgl_pt_color_f3d); pt_type = XGL_PT_COLOR_F3D; break;
    case PL_HASVN:
	perpoint = sizeof(Xgl_pt_normal_f3d); pt_type = XGL_PT_NORMAL_F3D; break;
    default:
	perpoint = sizeof(Xgl_pt_color_normal_f3d); pt_type = XGL_PT_COLOR_NORMAL_F3D;
    }

 

    /*
     * Determine size and datatype of facets, if any needed.
     */
    flp = &fl;
    fl.facets.color_facets = (Xgl_color_facet *)ifacets;
    switch(plflags & (PL_HASPCOL|PL_HASPN)) {
    case 0:
	flp = NULL;
	perfacet = 0;
	break;
    case PL_HASPCOL:
	fl.facet_type = XGL_FACET_COLOR;
	perfacet = sizeof(Xgl_color_facet);
	break;
    case PL_HASPN:
	fl.facet_type = XGL_FACET_NORMAL;
	perfacet = sizeof(Xgl_normal_facet);
	break;
    default:
	fl.facet_type = XGL_FACET_COLOR_NORMAL;
	perfacet = sizeof(Xgl_color_normal_facet);
    }

    /* if(MGXGL->bufused && MGXGL->flushfunc) (*MGXGL->flushfunc)(); */

    polysleft = MAXPOLYS;
    facetp = (char *)ifacets;	/* List of Xgl_facet's (1 per poly) */
    ptbytes = 0;
    polysnow = 0;
    plp = pls;			/* List of Xgl_pt_list's (1 per poly) */
    alltri = 1;
    allquad = 1;

    for(pno = npolys, poly = p; pno > 0; ) {
	register char *pointp;
	register Vertex **vp;
	int k;

	k = ptbytes + poly->n_vertices * perpoint;

	if(k > MGXGL->bufsiz) {
	    /*
	     * We'll make an extra tour through the loop.
	     * Go dump polygons now; next time, we'll call mgxgl_wantbuf().
	     */
	    if(polysnow > 0)
		goto dump;
	    mgxgl_wantbuf(ptbytes + (MGXGL->bufsiz >> 1));
	}

	pointp = MGXGL->xbuf + ptbytes;
	ptbytes = k;
	k = poly->n_vertices;

	if(k != 3) alltri = 0;
	if(k != 4) allquad = 0;

	vp = poly->v;

	/*
	 * Set per-point-list fields
	 */
	plp->num_pts = k;
	plp->pt_type = pt_type;
	plp->bbox = NULL;
	plp->pts.f3d = (Xgl_pt_f3d *)pointp;
	/*
	 * Set per-facet fields
	 */
	if(plflags & PL_HASPCOL) {
	    /* XXX assumes Xgl_color_rgb fields match format of ColorA */
	    *(Xgl_color_rgb *)facetp = *(Xgl_color_rgb *)&poly->pcol;
	    facetp += sizeof(Xgl_color_rgb);
	}
	if(plflags & PL_HASPN) {
	    /* XXX assumes Point3 ~= Xgl_pt_f3d */
	    *(Point3 *)facetp = poly->pn;
	    facetp += sizeof(Xgl_pt_f3d);
	}

	/*
	 * Loop over vertices in this polygon
	 */
	do {
	    /*
	     * Copy relevant vertex information
	     */
	    *(Point3 *)pointp = *(Point3 *)&(*vp)->pt;
	    if((*vp)->pt.w != 1.0) {
		((float *)pointp)[0] /= (*vp)->pt.w;
		((float *)pointp)[1] /= (*vp)->pt.w;
		((float *)pointp)[2] /= (*vp)->pt.w;
	    }
	    pointp += sizeof(Point3);
	    if(plflags & PL_HASVCOL) {
		*(Xgl_color_rgb *)pointp = *(Xgl_color_rgb *)&((*vp)->vcol);
		pointp += sizeof(Xgl_color_rgb);
	    }
	    if(plflags & PL_HASVN) {
		*(Point3 *)pointp = (*vp)->vn;
		pointp += sizeof(Point3);
	    }
	    vp++;
	} while(--k > 0);
	polysnow++;
	plp++;
	poly++;

	/*
	 * Filled buffer, or done with PolyList?
	 */

	if(--pno == 0 || polysnow >= MAXPOLYS) {
	    /* Draw something */
	  dump:
	    fl.num_facets = polysnow;
	    xgl_multi_simple_polygon(
			MGXGL->xglctx, 
			   alltri ? XGL_FACET_FLAG_SIDES_ARE_3 :
			  allquad ? XGL_FACET_FLAG_SIDES_ARE_4 :
				    XGL_FACET_FLAG_SIDES_UNSPECIFIED,
			flp,
			NULL,
			polysnow,
			pls);
	    polysleft = MAXPOLYS;
	    polysnow = 0;
	    ptbytes = 0;
	    alltri = allquad = 1;
	    plp = pls;
	    facetp = (char *)ifacets;
	}
    }
    if(MGC->astk->ap.flag & APF_NORMSCALE) {
	if(MGC->astk->ap.shading == APF_SMOOTH) {
	    mgxgl_normals(nverts, &v->pt, &v->vn, sizeof(Vertex), sizeof(Vertex));
	} else {
	    Xgl_pt_f3d  pts[MAXPOLYS*2];
	    register Xgl_pt_f3d *ptp;
	    float scl;
	    int k, j;
	    register Vertex *vp;
	    Point3 pn;

	    xgl_object_set(MGXGL->xglctx,
		XGL_CTX_LINE_COLOR, &MGC->astk->mat.normalcolor, 0);
	    scl = MGC->astk->ap.nscale;
	    plp = pls;
	    ptp = pts;
	    for(k = npolys, poly = p;  --k >= 0; poly++) {
		pn.x = scl * poly->pn.x;
		pn.y = scl * poly->pn.y;
		pn.z = scl * poly->pn.z;
		j = poly->n_vertices;
		
		do {
		    vp = poly->v[--j];

		    plp->pts.f3d = ptp;
		    plp->bbox = NULL;
		    plp->pt_type = XGL_PT_F3D;
		    plp->num_pts = 2;
		    *ptp++ = *(Xgl_pt_f3d *)&vp->pt;
		    ptp->x = vp->pt.x + pn.x;
		    ptp->y = vp->pt.y + pn.y;
		    ptp->z = vp->pt.z + pn.z;
		    ptp++;
		    if(++plp >= &pls[MAXPOLYS]) {
			xgl_multipolyline(MGXGL->xglctx, NULL, MAXPOLYS, pls);
			plp = pls;
			ptp = pts;
		    }
		} while(j > 0);
	    }
	    if(plp > pls)
		xgl_multipolyline(MGXGL->xglctx, NULL, plp - pls, pls);
	}
    }
}
