/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */


/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#include "mg_xglP.h"

/*
mgxgl_line(HPoint3 *p1, p2)
 * Some geometric primitives in XGL
 */
void
mgxgl_line(HPoint3 *p0, HPoint3 *p1)
{ 
	Xgl_pt_list   	xgl_3d[1];
	Xgl_pt_f3h	xgl_f3h[2]; 

    
	xgl_3d[0].pt_type=XGL_PT_F3H;
	xgl_3d[0].bbox= NULL;
	xgl_3d[0].num_pts=2;
	xgl_3d[0].pts.f3h=xgl_f3h;

	(HPoint3 *)xgl_f3d[0] = *p0;
	(HPoint3 *)xgl_f3d[1] = *p1;
	xgl_multipolyline( MGXGL->xglctx, NULL, 1, xgl_3d );
}

void
mgxgl_polyline(int nv, HPoint3 *v, int nc, ColorA *c, int wrapped)
{
    register int k;
    Xgl_pt_list pl[2];
    Xgl_pt_f3h  wp[2];

    pl[0].pt_type = XGL_PT_F3H;
    pl[0].bbox = NULL;
    pl[0].num_pts = nv;
    pl[0].pts.f3h = (Xgl_pt_f3h *)v;

    /*
     * For mere colorless points, our format matches XGL's, so use directly.
     * Is it safe to leave the line color set this way, or must we restore it?
     */
    if(nc > 0)
	xgl_object_set(MGXGL->xglctx, XGL_CTX_LINE_COLOR, c, NULL);

    /* XXX should handle multi-colored polylines here */

    if(wrapped) {
	pl[1].pts.f3h = wp;
	pl[1].bbox = NULL;
	pl[1].num_pts = 2;
	pl[1].pt_type = XGL_PT_F3H;
	wp[0] = *(Xgl_pt_f3h *)v;
	wp[1] = *(Xgl_pt_f3h *)(v + nv - 1);
    }
    xgl_multipolyline( MGXGL->xglctx, NULL, wrapped ? 2 : 1, pl);
}

#define	MAXPL	32

void
mgxgl_normals( int np, Point3 *p, Point3 *n, int pstep, int nstep )
{
    Xgl_pt_list pl[MAXPL];
    Xgl_pt_f3h  pts[MAXPL*2];
    register Xgl_pt_list *pp;
    register Xgl_pt_f3h *ptp;
    float scl;
    int k;


    xgl_object_set(MGXGL->xglctx,
	XGL_CTX_LINE_COLOR, &MGC->astk->mat.normalcolor, 0);
    scl = MGC->astk->ap.nscale;
    for(k = np, pp = pl, ptp = pts;  --k >= 0; ) {
	pp->pts.f3d = ptp;
	pp->bbox = NULL;
	pp->pt_type = XGL_PT_F3D;
	pp->num_pts = 2;
	*ptp++ = *(Xgl_pt_f3d *)p;
	ptp->x = p->x + scl*n->x;
	ptp->y = p->y + scl*n->y;
	ptp->z = p->z + scl*n->z;
	ptp++;
	if(++pp >= &pl[MAXPL]) {
	    xgl_multipolyline(MGXGL->xglctx, NULL, MAXPL, pl);
	    pp = pl;
	    ptp = pts;
	}
	n = (Point3 *)(((char *)n) + nstep);
	p = (Point3 *)(((char *)p) + pstep);
    }
    if(pp > pl)
	xgl_multipolyline(MGXGL->xglctx, NULL, pp - pl, pl);
}
void
mgxgl_polygon( int nv, Point3 *v, int nn, Point3 *n, int nc, ColorA *c )
{
    Xgl_pt_list	 pl;
    int ptsz;
    int facetflag;
    Xgl_facet_list fl;
    Xgl_facet	f;
    Xgl_facet_list *flp = NULL;

    if(nv < 2)
	return;

    switch(nv) {
    case 3: facetflag = XGL_FACET_FLAG_SIDES_ARE_3 | XGL_FACET_FLAG_SHAPE_CONVEX;
	break;
    case 4: facetflag = XGL_FACET_FLAG_SIDES_ARE_4 | XGL_FACET_FLAG_SHAPE_CONVEX;
	break;
    default: facetflag = XGL_FACET_FLAG_SIDES_UNSPECIFIED | XGL_FACET_FLAG_SHAPE_CONVEX;
    }

    /*
     * XXX Take advantage: Xgl_color_rgb ~= ColorA (floats in RGB order)
     * XXX Take advantage: Xgl_normal_facet normal == Xgl_pt_f3d ~= Point3.
     */
    if(nn == 1 || nc == 1) {
	flp = &fl;
	fl.num_facets = 1;
	fl.facet_type = XGL_FACET_NONE;
	fl.facets.color_facets = &f.color_facet;
	if(nc == 1) {
	    f.color_facet.color.rgb = *(Xgl_color_rgb *)c;
	    fl.facet_type = XGL_FACET_COLOR;
	    if(nn == 1) {
		f.color_normal_facet.normal = *(Xgl_pt_f3d *)n;
		fl.facet_type = XGL_FACET_COLOR_NORMAL;
	    }
	} else if(nn == 1) {
	    f.normal_facet.normal = *(Xgl_pt_f3d *)n;
	    fl.facet_type = XGL_FACET_NORMAL;
	}
    }

    pl.bbox = NULL;
    pl.num_pts = nv;
    if(nc == nv) {
	pl.pt_type = XGL_PT_COLOR_F3D, ptsz = sizeof(Xgl_pt_color_f3d);
	if(nn == nv) {
	    pl.pt_type = XGL_PT_COLOR_NORMAL_F3D,
	    ptsz = sizeof(Xgl_pt_color_normal_f3d);
	}
    } else if(nn == nv) {
	pl.pt_type = XGL_PT_NORMAL_F3D, ptsz = sizeof(Xgl_pt_normal_f3d);
    } else {
	/* Easy case: no need to reformat points, just use by reference */
	/* XXX assert Point3 === Xgl_pt_f3d */

	pl.pt_type = XGL_PT_F3D;
	pl.pts.f3d = (Xgl_pt_f3d *)v;
	xgl_multi_simple_polygon(MGXGL->xglctx, facetflag, flp, NULL, 1, &pl);
	return;
    }



    /* Harder; must copy interleaved points and {colors or normals} */

    if(MGXGL->bufsiz < nv*ptsz)
	mgxgl_wantbuf(nv * ptsz);
    {
	register char *ip, *op, *basep;
	register int k;

	basep = (char *)MGXGL->xbuf;
	pl.pts.f3d = (Xgl_pt_f3d *)basep;
	k = nv;
	op = basep;
	ip = (char *)v;
	do {
	    *(Xgl_pt_f3d *)op = *(Xgl_pt_f3d *)ip;
	    op += ptsz;			/* assert Point3 == Xgl_pt_f3d */
	    ip += sizeof(Point3);
	} while(--k > 0);
	basep += sizeof(Xgl_pt_f3d);
	if(nc == nv) {
	    k = nv;
	    op = basep;
	    ip = (char *)c;
	    do {
		*(Xgl_color_rgb *)op = *(Xgl_color_rgb *)ip;
		op += ptsz;		/* assert Xgl_color_rgb <= ColorA */
		ip += sizeof(ColorA);
	    } while(--k > 0);
	    basep += sizeof(Xgl_color_rgb);
	}
	if(nn == nv) {
	    k = nv;
	    op = basep;
	    ip = (char *)n;
	    do {
		*(Xgl_pt_f3d *)op = *(Xgl_pt_f3d *)ip;
		op += ptsz;
		ip += sizeof(Point3);
	    } while(--k > 0);
	}
    }
    /* Whew. */
    xgl_multi_simple_polygon(MGXGL->xglctx, facetflag, flp, NULL, 1, &pl);

    if(MGC->astk->ap.flag & APF_NORMSCALE && nn > 0)
	mgxgl_normals(nv, v, n, sizeof(Point3), nn>1 ? sizeof(Point3) : 0);
}
